/**
{file:
    {name: LmiMemoryTracker.h}
    {description: The memory tracker interface.}
    {copyright:
        (c) 2005-2023 Vidyo, Inc.,
        433 Hackensack Avenue,
        Hackensack, NJ  07601.

        All rights reserved.

        The information contained herein is proprietary to Vidyo, Inc.
        and shall not be reproduced, copied (in whole or in part), adapted,
        modified, disseminated, transmitted, transcribed, stored in a retrieval
        system, or translated into any language in any form by any means
        without the express written consent of Vidyo, Inc.
    }
}
*/
#ifdef LMI_HAVE_MEMORY_TRACKER

#ifndef LMI_MEMORY_TRACKER_H_
#define LMI_MEMORY_TRACKER_H_

#include <Lmi/Os/LmiMemory.h>

LMI_BEGIN_EXTERN_C

/**
{function visibility="private":
    {name: LmiMemoryTrackerTrackAddress}
    {parent: Memory}
    {description: Tracks allocated memory block by address.}
    {prototype: void LmiMemoryTrackerTrackAddress(LmiVoidPtr address, LmiSizeT size)}
    {parameter: {name: address} {description: The address of the newly allocated memory.}}
    {parameter: {name: size} {description: The size of the allocated memory.}}
}
*/
void LmiMemoryTrackerTrackAddress(LmiVoidPtr address, LmiSizeT size);

/**
{function visibility="private":
    {name: LmiMemoryTrackerUntrackAddress}
    {parent: Memory}
    {description: Untracks a previously allocated memory block by address.}
    {prototype: void LmiMemoryTrackerUntrackAddress(LmiVoidPtr address)}
    {parameter: {name: address} {description: The address of the allocated memory.}}
}
*/
void LmiMemoryTrackerUntrackAddress(LmiVoidPtr address);

/**
{function visibility="private":
    {name: LmiMemoryTrackerInitialize}
    {parent: Memory}
    {description: Initialize the memory tracker.}
    {prototype: void LmiMemoryTrackerInitialize()}
}
*/
void LmiMemoryTrackerInitialize();

/**
{function visibility="private":
    {name: LmiMemoryTrackerUninitialize}
    {parent: Memory}
    {description: Uninitialize the memory tracker.}
    {prototype: void LmiMemoryTrackerUninitialize()}
}
*/
void LmiMemoryTrackerUninitialize();

LMI_END_EXTERN_C

#endif /* LMI_MEMORY_TRACKER_H_ */
#endif /* LMI_HAVE_MEMORY_TRACKER */