/**
{file:
    {name: LmiUpdatableLabelInline.h}
    {description: Inline functions for LmiUpdatableLabel.}
    {copyright:
    	(c) 2018 Vidyo, Inc.,
    	433 Hackensack Avenue,
    	Hackensack, NJ  07601.

    	All rights reserved.

    	The information contained herein is proprietary to Vidyo, Inc.
    	and shall not be reproduced, copied (in whole or in part), adapted,
    	modified, disseminated, transmitted, transcribed, stored in a retrieval
    	system, or translated into any language in any form by any means
    	without the express written consent of Vidyo, Inc.
    	                  ***** CONFIDENTIAL *****
    }
}
*/

LMI_INLINE const char* LmiUpdatableLabelGetCStr(const LmiUpdatableLabel* l)
{
	const char* ret;
	LmiMutexLock((LmiMutex*)&l->mutex);

	ret = LmiStringCStr(LmiListFrontConst(LmiString)(&l->labels));

	LmiMutexUnlock((LmiMutex*)&l->mutex);
	return ret;
}

LMI_INLINE const LmiString* LmiUpdatableLabelGetStr(const LmiUpdatableLabel* l)
{
	const LmiString* ret;
	LmiMutexLock((LmiMutex*)&l->mutex);

	ret = LmiListFrontConst(LmiString)(&l->labels);

	LmiMutexUnlock((LmiMutex*)&l->mutex);
	return ret;
}

LMI_INLINE LmiAllocator* LmiUpdatableLabelGetAllocator(const LmiUpdatableLabel* l)
{
	return LmiListGetAllocator(LmiString)(&l->labels);
}
