/**
{file:
	{name: LmiCameraControlInline.h}
	{description: }
	{copyright:
		(c) 2006-2019 Vidyo, Inc.,
		433 Hackensack Avenue,
		Hackensack, NJ  07601.

		All rights reserved.

		The information contained herein is proprietary to Vidyo, Inc.
		and shall not be reproduced, copied (in whole or in part), adapted,
		modified, disseminated, transmitted, transcribed, stored in a retrieval
		system, or translated into any language in any form by any means
		without the express written consent of Vidyo, Inc.
		                  ***** CONFIDENTIAL *****
	}
}
*/

LMI_INLINE LmiUint LmiCameraPresetGetIndex(const LmiCameraPreset* preset)
{
	return preset->index;
}

LMI_INLINE const LmiString *LmiCameraPresetGetName(const LmiCameraPreset *preset)
{
	return &preset->name;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetAbsolutePanTilt(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasAbsolutePanTilt = supported;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetAbsoluteZoom(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasAbsoluteZoom = supported;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetRelativePanTilt(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasRelativePanTilt = supported;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetRelativeZoom(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasRelativeZoom = supported;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetPhotoCapture(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasPhotoCapture = supported;
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasAbsolutePanTilt(const LmiCameraControlCapabilities *caps)
{
	return caps->hasAbsolutePanTilt;
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasAbsoluteZoom(const LmiCameraControlCapabilities *caps)
{
	return caps->hasAbsoluteZoom;
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasRelativePanTilt(const LmiCameraControlCapabilities *caps)
{
	return caps->hasRelativePanTilt;
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasRelativeZoom(const LmiCameraControlCapabilities *caps)
{
	return caps->hasRelativeZoom;
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasPhotoCapture(const LmiCameraControlCapabilities *caps)
{
	return caps->hasPhotoCapture;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetPanRange(LmiCameraControlCapabilities *caps, const LmiRange(LmiFloat64) *range)
{
	LmiAssign(LmiRange(LmiFloat64))(&caps->panDegreeRange, range);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetPanRangeValues(LmiCameraControlCapabilities *caps, LmiFloat64 minValue, LmiFloat64 maxValue)
{
	LmiRangeSetMin(LmiFloat64)(&caps->panDegreeRange, minValue);
	LmiRangeSetMax(LmiFloat64)(&caps->panDegreeRange, maxValue);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetTiltRange(LmiCameraControlCapabilities *caps, const LmiRange(LmiFloat64) *range)
{
	LmiAssign(LmiRange(LmiFloat64))(&caps->tiltDegreeRange, range);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetTiltRangeValues(LmiCameraControlCapabilities *caps, LmiFloat64 minValue, LmiFloat64 maxValue)
{
	LmiRangeSetMin(LmiFloat64)(&caps->tiltDegreeRange, minValue);
	LmiRangeSetMax(LmiFloat64)(&caps->tiltDegreeRange, maxValue);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetZoomRange(LmiCameraControlCapabilities *caps, const LmiRange(LmiFloat64) *range)
{
	LmiAssign(LmiRange(LmiFloat64))(&caps->zoomMagnificationRange, range);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetZoomRangeValues(LmiCameraControlCapabilities *caps, LmiFloat64 minValue, LmiFloat64 maxValue)
{
	LmiRangeSetMin(LmiFloat64)(&caps->zoomMagnificationRange, minValue);
	LmiRangeSetMax(LmiFloat64)(&caps->zoomMagnificationRange, maxValue);
}

LMI_INLINE const LmiRange(LmiFloat64) *LmiCameraControlCapabilitiesGetPanRange(const LmiCameraControlCapabilities *caps)
{
	return &caps->panDegreeRange;
}

LMI_INLINE LmiFloat64 LmiCameraControlCapabilitiesGetMinPanValue(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMin(LmiFloat64)(&caps->panDegreeRange);
}

LMI_INLINE LmiFloat64 LmiCameraControlCapabilitiesGetMaxPanValue(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMax(LmiFloat64)(&caps->panDegreeRange);
}

LMI_INLINE const LmiRange(LmiFloat64) *LmiCameraControlCapabilitiesGetTiltRange(const LmiCameraControlCapabilities *caps)
{
	return &caps->tiltDegreeRange;
}

LMI_INLINE LmiFloat64 LmiCameraControlCapabilitiesGetMinTiltValue(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMin(LmiFloat64)(&caps->tiltDegreeRange);
}

LMI_INLINE LmiFloat64 LmiCameraControlCapabilitiesGetMaxTiltValue(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMax(LmiFloat64)(&caps->tiltDegreeRange);
}

LMI_INLINE const LmiRange(LmiFloat64) *LmiCameraControlCapabilitiesGetZoomRange(const LmiCameraControlCapabilities *caps)
{
	return &caps->zoomMagnificationRange;
}

LMI_INLINE LmiFloat64 LmiCameraControlCapabilitiesGetMinZoomValue(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMin(LmiFloat64)(&caps->zoomMagnificationRange);
}

LMI_INLINE LmiFloat64 LmiCameraControlCapabilitiesGetMaxZoomValue(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMax(LmiFloat64)(&caps->zoomMagnificationRange);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetPanSpeedRange(LmiCameraControlCapabilities *caps, const LmiRange(LmiInt) *range)
{
	LmiAssign(LmiRange(LmiInt))(&caps->panSpeedRange, range);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetPanSpeedRangeValues(LmiCameraControlCapabilities *caps, LmiInt minValue, LmiInt maxValue)
{
	LmiRangeSetMin(LmiInt)(&caps->panSpeedRange, minValue);
	LmiRangeSetMax(LmiInt)(&caps->panSpeedRange, maxValue);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetTiltSpeedRange(LmiCameraControlCapabilities *caps, const LmiRange(LmiInt) *range)
{
	LmiAssign(LmiRange(LmiInt))(&caps->tiltSpeedRange, range);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetTiltSpeedRangeValues(LmiCameraControlCapabilities *caps, LmiInt minValue, LmiInt maxValue)
{
	LmiRangeSetMin(LmiInt)(&caps->tiltSpeedRange, minValue);
	LmiRangeSetMax(LmiInt)(&caps->tiltSpeedRange, maxValue);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetZoomSpeedRange(LmiCameraControlCapabilities *caps, const LmiRange(LmiInt) *range)
{
	LmiAssign(LmiRange(LmiInt))(&caps->zoomSpeedRange, range);
}

LMI_INLINE void LmiCameraControlCapabilitiesSetZoomSpeedRangeValues(LmiCameraControlCapabilities *caps, LmiInt minValue, LmiInt maxValue)
{
	LmiRangeSetMin(LmiInt)(&caps->zoomSpeedRange, minValue);
	LmiRangeSetMax(LmiInt)(&caps->zoomSpeedRange, maxValue);
}

LMI_INLINE const LmiRange(LmiInt) *LmiCameraControlCapabilitiesGetPanSpeedRange(const LmiCameraControlCapabilities *caps)
{
	return &caps->panSpeedRange;
}

LMI_INLINE LmiInt LmiCameraControlCapabilitiesGetMinPanSpeed(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMin(LmiInt)(&caps->panSpeedRange);
}

LMI_INLINE LmiInt LmiCameraControlCapabilitiesGetMaxPanSpeed(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMax(LmiInt)(&caps->panSpeedRange);
}

LMI_INLINE const LmiRange(LmiInt) *LmiCameraControlCapabilitiesGetTiltSpeedRange(const LmiCameraControlCapabilities *caps)
{
	return &caps->tiltSpeedRange;
}

LMI_INLINE LmiInt LmiCameraControlCapabilitiesGetMinTiltSpeed(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMin(LmiInt)(&caps->tiltSpeedRange);
}

LMI_INLINE LmiInt LmiCameraControlCapabilitiesGetMaxTiltSpeed(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMax(LmiInt)(&caps->tiltSpeedRange);
}

LMI_INLINE const LmiRange(LmiInt) *LmiCameraControlCapabilitiesGetZoomSpeedRange(const LmiCameraControlCapabilities *caps)
{
	return &caps->zoomSpeedRange;
}

LMI_INLINE LmiInt LmiCameraControlCapabilitiesGetMinZoomSpeed(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMin(LmiInt)(&caps->zoomSpeedRange);
}

LMI_INLINE LmiInt LmiCameraControlCapabilitiesGetMaxZoomSpeed(const LmiCameraControlCapabilities *caps)
{
	return LmiRangeGetMax(LmiInt)(&caps->zoomSpeedRange);
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasOldEndpoint(const LmiCameraControlCapabilities *caps)
{
	return caps->hasOldEndpoint;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetOldEndpoint(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasOldEndpoint = supported;
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasViscaSupport(const LmiCameraControlCapabilities *caps)
{
	return caps->hasViscaSupport;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetViscaSupport(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasViscaSupport = supported;
}

LMI_INLINE LmiBool LmiCameraControlCapabilitiesHasPresetSupport(const LmiCameraControlCapabilities *caps)
{
	return caps->hasPresetSupport;
}

LMI_INLINE void LmiCameraControlCapabilitiesSetPresetSupport(LmiCameraControlCapabilities *caps, LmiBool supported)
{
	caps->hasPresetSupport = supported;
}

LMI_INLINE const LmiString *LmiCameraNudgeCommandGetParameter(const LmiCameraNudgeCommand *c)
{
	return &c->parameter;
}

LMI_INLINE LmiInt LmiCameraNudgeCommandGetNudges(const LmiCameraNudgeCommand *c)
{
	return c->nudges;
}

LMI_INLINE const LmiString *LmiCameraSetCommandGetParameter(const LmiCameraSetCommand *c)
{
	return &c->parameter;
}

LMI_INLINE LmiFloat64 LmiCameraSetCommandGetValue(const LmiCameraSetCommand *c)
{
	return c->value;
}

LMI_INLINE LmiFloat64 LmiCameraMoveCommandGetPan(const LmiCameraMoveCommand *c)
{
	return c->pan;
}

LMI_INLINE LmiFloat64 LmiCameraMoveCommandGetTilt(const LmiCameraMoveCommand *c)
{
	return c->tilt;
}

LMI_INLINE LmiTime LmiCameraMoveCommandGetTimeout(const LmiCameraMoveCommand *c)
{
	return c->timeout;
}

LMI_INLINE LmiFloat64 LmiCameraMagnifyCommandGetZoom(const LmiCameraMagnifyCommand *c)
{
	return c->zoom;
}

LMI_INLINE LmiTime LmiCameraMagnifyCommandGetTimeout(const LmiCameraMagnifyCommand *c)
{
	return c->timeout;
}

LMI_INLINE LmiInt LmiCameraRelativePanTiltCommandGetPan(const LmiCameraRelativePanTiltCommand *c)
{
	return c->pan;
}

LMI_INLINE LmiInt LmiCameraRelativePanTiltCommandGetTilt(const LmiCameraRelativePanTiltCommand *c)
{
	return c->tilt;
}

LMI_INLINE LmiTime LmiCameraRelativePanTiltCommandGetTimeout(const LmiCameraRelativePanTiltCommand* c)
{
	return c->timeout;
}

LMI_INLINE LmiInt LmiCameraRelativeZoomCommandGetZoom(const LmiCameraRelativeZoomCommand *c)
{
	return c->zoom;
}

LMI_INLINE LmiTime LmiCameraRelativeZoomCommandGetTimeout(const LmiCameraRelativeZoomCommand* c)
{
	return c->timeout;
}

LMI_INLINE LmiUint LmiCameraActivatePresetCommandGetIndex(const LmiCameraActivatePresetCommand *c)
{
	return c->index;
}

LMI_INLINE const LmiDataBuffer* LmiCameraViscaControlCommandGetViscaMessage(const LmiCameraViscaControlCommand *c)
{
	return &c->viscaMessage;
}

LMI_INLINE LmiCameraCommandType LmiCameraCommandGetType(const LmiCameraCommand *fc)
{
	return fc->type;
}

LMI_INLINE const LmiCameraNudgeCommand *LmiCameraCommandGetNudge(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_Nudge ? &fc->command.nudge : NULL;
}

LMI_INLINE const LmiCameraSetCommand *LmiCameraCommandGetSet(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_Set ? &fc->command.set : NULL;
}

LMI_INLINE const LmiCameraMoveCommand *LmiCameraCommandGetMove(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_Move ? &fc->command.move : NULL;
}

LMI_INLINE const LmiCameraMagnifyCommand *LmiCameraCommandGetMagnify(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_Magnify ? &fc->command.magnify : NULL;
}

LMI_INLINE const LmiCameraRelativePanTiltCommand *LmiCameraCommandGetRelativePanTilt(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_RelativePanTilt ? &fc->command.relativePanTilt : NULL;
}

LMI_INLINE const LmiCameraRelativeZoomCommand *LmiCameraCommandGetRelativeZoom(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_RelativeZoom ? &fc->command.relativeZoom : NULL;
}

LMI_INLINE const LmiCameraActivatePresetCommand *LmiCameraCommandGetActivatePreset(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_ActivatePreset ? &fc->command.activatePreset : NULL;
}

LMI_INLINE const LmiCameraViscaControlCommand *LmiCameraCommandGetViscaControl(const LmiCameraCommand *fc)
{
	return fc->type == LMI_CAMERACOMMANDTYPE_ViscaControl ? &fc->command.viscaControl : NULL;
}
