//
//	VidyoCalendarManager_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoCalendar_Objc.h"
#import "VidyoFormField_Objc.h"
@class VCCalendarManager;
@class VCCalendarManagerFeedback;
@class VCFormFieldOption;
/*!
 * @enum Indicates the result code for the creation of the calendar instance .
 * @constant VCCalendarConnectResultOk Connected to calendar resource .
 * @constant VCCalendarConnectResultNoService Service plugin for the calendar could not attach or commect to the underlying application.
 * @constant VCCalendarConnectResultConnectionFailed 
 * @constant VCCalendarConnectResultConnectionLost 
 * @constant VCCalendarConnectResultConnectionTimeout 
 * @constant VCCalendarConnectResultInvalidCredentials 
 * @constant VCCalendarConnectResultInvalidCalendarId 
 * @constant VCCalendarConnectResultDisconnected 
 * @constant VCCalendarConnectResultGeneralError 
 */
typedef NS_ENUM(NSInteger, VCCalendarConnectResult) {
	VCCalendarConnectResultOk,
	VCCalendarConnectResultNoService,
	VCCalendarConnectResultConnectionFailed,
	VCCalendarConnectResultConnectionLost,
	VCCalendarConnectResultConnectionTimeout,
	VCCalendarConnectResultInvalidCredentials,
	VCCalendarConnectResultInvalidCalendarId,
	VCCalendarConnectResultDisconnected,
	VCCalendarConnectResultGeneralError
};
/*!
 * @enum Result of getting the calendar services.
 * @constant VCCalendarManagerGetServicesResultSUCCESS Calendar services was got successfully.
 * @constant VCCalendarManagerGetServicesResultMiscError Getting the calendar services failed some miscellaneous reason.
 */
typedef NS_ENUM(NSInteger, VCCalendarManagerGetServicesResult) {
	VCCalendarManagerGetServicesResultSUCCESS,
	VCCalendarManagerGetServicesResultMiscError
};
/*!
 * @enum Indicates the state of the calendar plugin library module, regarding its availability . This includes finding the library, loading the exported interface methods, and then verifying that the version of the library is compatible with the VidyoClient version of the interface it was built against.
 * @constant VCCalendarServiceStatusInit The initial state of the library for a service - ready to be located and loaded.
 * @constant VCCalendarServiceStatusLoaded Library was loaded and the API function required for registering the interface was found.
 * @constant VCCalendarServiceStatusLoadError Error occurred while trying to load the library.
 * @constant VCCalendarServiceStatusInvalidVersion Library was loaded, but version number does not match the interface that VidyoClient was built against.
 * @constant VCCalendarServiceStatusDllNotFound Vidyo DLL or static library for specified calendar service could not be found in the installation directory.
 * @constant VCCalendarServiceStatusApiProcError Unable to retrieve the API function from the Vidyo DLL or static library for specified calendar service.
 * @constant VCCalendarServiceStatusPluginSvcNotInstalled Calendar service was loaded, but the 3rd party service it was referencing was not started or was not installed.
 * @constant VCCalendarServiceStatusPluginSvcNotActive Calendar service was loaded, and the local 3rd party service is available but not connected to it's resources for event notifications.
 * @constant VCCalendarServiceStatusPluginSvcAuthRequired Calendar service was loaded, and the local 3rd party service is available but user is not logged in.
 * @constant VCCalendarServiceStatusUnloaded Calendar service has been uninitialized with all internal resources freed.
 */
typedef NS_ENUM(NSInteger, VCCalendarServiceStatus) {
	VCCalendarServiceStatusInit,
	VCCalendarServiceStatusLoaded,
	VCCalendarServiceStatusLoadError,
	VCCalendarServiceStatusInvalidVersion,
	VCCalendarServiceStatusDllNotFound,
	VCCalendarServiceStatusApiProcError,
	VCCalendarServiceStatusPluginSvcNotInstalled,
	VCCalendarServiceStatusPluginSvcNotActive,
	VCCalendarServiceStatusPluginSvcAuthRequired,
	VCCalendarServiceStatusUnloaded
};
/*!
 * @enum This enum is used to represent the wrapping modes defined for a textarea HTML form input field.
 * @constant VCFormFieldTextWrapModeOff No wrapping
 * @constant VCFormFieldTextWrapModeVirtual Shows linebreaks, but sends text as entered
 * @constant VCFormFieldTextWrapModePhysical Inserts linebreaks as needed and sends text with them.
 */
typedef NS_ENUM(NSInteger, VCFormFieldTextWrapMode) {
	VCFormFieldTextWrapModeOff,
	VCFormFieldTextWrapModeVirtual,
	VCFormFieldTextWrapModePhysical
};
@protocol VCICalendarManagerFeedback
@optional

	/*!
	 * Returns the created VidyoCalendar that was initiated through VidyoCalendarManagerCreateCalendarInstance.
	 */
	-(void) calendarCreated:(VCCalendarManager*)cm Calendar:(VCCalendar*)calendar ResultCode:(VCCalendarCreateCode)resultCode CreateToken:(NSMutableString*)createToken;
	/*!
	 * Returns the result for deletion of a VidyoCalendar based on the deleteToken. Initiated through the method call VidyoCalendarMestroyDestructCalendarInstance
	 */
	-(void) calendarDestroyed:(VCCalendarManager*)cm ResultCode:(VCCalendarCreateCode)resultCode PluginServiceId:(NSMutableString*)pluginServiceId CalendarName:(NSMutableString*)calendarName;
@end
@interface VCCalendarManagerFeedback : NSObject<VCICalendarManagerFeedback>
{
	void* objPtr;
}
	-(id) init;
	-(void) dealloc;
	-(void*)getObjectPtr;
@end
@protocol VCCalendarManagerIGetCalendarRegisteredServicesAsync
	/*!
	 * Callback that is triggered when getting the calendar services completes.
	 */
	-(void) onGetServicesComplete:(NSMutableArray*)svcNames Result:(VCCalendarManagerGetServicesResult)result;
@end
/*!
 * <p>This type will be used to retrieve and manage the creation of the various calendar service types. </p> <p/> <p>General concepts: </p> <p>- Presents a set of API's that allow for the creation of a calendar service. </p> <p>- The types of calendar services offered will depend on the implementations that are built and packaged against these API's as plugins </p> <p>- The type of calendar service types defined may change as new implementations are added. </p> <p>- The service type will dicate how an application will construct the servce through this calendar service manager API </p> <p>=> A set of connection properties will be passed into the create service methods based on the service type. </p> <p>- The service manager will pass back a constructed calendar service type, which can then be used to connect to the service with and manage meeting setups and receive events for that service. </p> <p/> <p>Note that the availability of a service may come and go based on local applications or network events. </p>
 */
@interface VCCalendarManager : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Retrieves the list of calendar service strings that were successfully added to the calendar manager.
	 */
	id<VCCalendarManagerIGetCalendarRegisteredServicesAsync> calendarManagerIGetCalendarRegisteredServicesAsync;
}
	/*!
	 * <p>This type will be used to retrieve and manage the creation of the various calendar service types. </p> <p/> <p>General concepts: </p> <p>- Presents a set of API's that allow for the creation of a calendar service. </p> <p>- The types of calendar services offered will depend on the implementations that are built and packaged against these API's as plugins </p> <p>- The type of calendar service types defined may change as new implementations are added. </p> <p>- The service type will dicate how an application will construct the servce through this calendar service manager API </p> <p>=> A set of connection properties will be passed into the create service methods based on the service type. </p> <p>- The service manager will pass back a constructed calendar service type, which can then be used to connect to the service with and manage meeting setups and receive events for that service. </p> <p/> <p>Note that the availability of a service may come and go based on local applications or network events. </p>
	 */
	-(id) init:(VCCalendarManagerFeedback*)feedback;
	-(void) dealloc;
	/*!
	 * Creates a VidyoCalendar which is returned through VidyoCalendarManagerFeedbackCalendarCreated. Will be identifiable through the service ID and calendarName.
	 * @param feedback Calendar feeback handle
	 * @param pluginServiceId The plugin service Id string that was used to register the plugin dll using VidyoCalendarManagerRegisterCalendarService
	 * @param calendarName Name of the calendar or calendar folder that will be used to operate against for the service. An empty string indicates that the default calendar should be used.
	 */
	-(BOOL) createCalendarInstance:(VCCalendarFeedback*)feedback PluginServiceId:(NSMutableString*)pluginServiceId CalendarName:(NSMutableString*)calendarName CreateToken:(NSMutableString*)createToken;
	/*!
	 * Cleans up and removes the VidyoCalendar calendar instance passed in. NOTE.... IMPORTANT: This method must be called against any constructed instance of the cal endar instance before destructing the calendar manager. If the the instance is not destructed a memory leak will occur and-or side affects will appear from the underlying plugin not being destructed before a shutdown.
	 * @param cal Calendar handle
	 */
	-(BOOL) destroyCalendarInstance:(VCCalendar*)cal;
	/*!
	 * Retrieves the list of calendar service strings that were successfully added to the calendar manager.
	 * @param cm Instance of the calendar manager.
	 * @param svcNames Will be populated with the list of service name strings of the plug-in modules that were successfully added to the calendar manager.
	 */
	-(BOOL) getCalendarRegisteredServices:(NSMutableArray*)svcNames;
	/*!
	 * Retrieves the list of calendar service strings that were successfully added to the calendar manager.
	 * @param cm Instance of the calendar manager.
	 * @param onComplete The callback that is triggered when getting calendar service completes.
	 */
	-(BOOL) getCalendarRegisteredServicesAsync:(id<VCCalendarManagerIGetCalendarRegisteredServicesAsync>)calendarManagerIGetCalendarRegisteredServicesAsync;
	/*!
	 * Retreives the user data pointer that was previousely set by Calendaring VidyoCalendarManagerSetUserData.
	 * @param cm Pointer to the VidyoCalendarManager object.
	 * @param pluginServiceName Service name string that will be used for to reference the service that will be provided by the dll being loaded. This name will be used as an argument for creating the calendar instance in VidyoCalendarManagerCreateCalendarInstance.
	 * @param dllName Full file name for calendar plugin dll that needs to be loaded for the pluginServiceName
	 */
	-(BOOL) registerCalendarService:(NSMutableString*)pluginServiceName DllName:(NSMutableString*)dllName;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
/*!
 * Attributes related to an HTML form input field.
 */
@interface VCFormField : NSObject
{
}
	/*!
	 * For a textarea input field, the number of columns the field should show
	 */
	@property unsigned int cols;
	/*!
	 * Maximum number of characters allowed for the input field
	 */
	@property unsigned int maxlength;
	/*!
	 * For a select drop-down input field, whether multiple selections are allowed
	 */
	@property BOOL multiple;
	/*!
	 * Label used to uniquely identify the input field for this element
	 */
	@property NSMutableString* name;
	/*!
	 * For a select drop-down input field, a list of the options and their selection status
	 */
	@property NSMutableArray* options;
	/*!
	 * For a textarea input field, the number of rows the field should show
	 */
	@property unsigned int rows;
	/*!
	 * Number of characters for the value
	 */
	@property unsigned int size;
	/*!
	 * Type that corresponds to the HTML form input fields that can be used to display and collect user data
	 */
	@property VCFormFieldType type;
	/*!
	 * Default value to display in the input field if this struct is returned to the application, or a collected user input if this structure is passed back as a method argument
	 */
	@property NSMutableString* value;
	/*!
	 * For a textarea input field, how linebreaks should be handled
	 */
	@property VCFormFieldTextWrapMode wrap;
@end
/*!
 * Option properties for an HTML drop down select input field.
 */
@interface VCFormFieldOption : NSObject
{
}
	/*!
	 * Indicates whether the option was selected or not
	 */
	@property BOOL selected;
	/*!
	 * String value representing the option text label
	 */
	@property NSMutableString* value;
@end
