/**
{file:
	{name: VidyoCameraControlCapabilitiesInline.h}
	{description: The camera control capabilities module.}
	{copyright:
		(c) 2006-2021 Vidyo, Inc.,
		433 Hackensack Avenue,
		Hackensack, NJ  07601.

		All rights reserved.

		The information contained herein is proprietary to Vidyo, Inc.
		and shall not be reproduced, copied (in whole or in part), adapted,
		modified, disseminated, transmitted, transcribed, stored in a retrieval
		system, or translated into any language in any form by any means
		without the express written consent of Vidyo, Inc.}
}
*/

LMI_INLINE LmiUint VidyoCameraPresetGetIndex(const VidyoCameraPreset *preset)
{
	return preset->index;
}

LMI_INLINE const LmiString *VidyoCameraPresetGetName(const VidyoCameraPreset *preset)
{
	return &preset->name;
}

LMI_INLINE void VidyoCameraControlCapabilitiesDestruct(VidyoCameraControlCapabilities *caps)
{
    
}

LMI_INLINE VidyoCameraControlCapabilities *VidyoCameraControlCapabilitiesAssign(VidyoCameraControlCapabilities *caps, const VidyoCameraControlCapabilities *other)
{
    *caps = *other;
    return caps;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetPanTiltRubberBand(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->panTiltHasRubberBand = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetPanTiltContinuousMove(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->panTiltHasContinuousMove = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetPanTiltNudge(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->panTiltHasNudge = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetZoomRubberBand(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->zoomHasRubberBand = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetZoomContinuousMove(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->zooomHasContinuousMove = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetZoomNudge(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->zoomHasNudge = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetPhotoCapture(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->hasPhotoCapture = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetViscaSupport(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->hasViscaSupport = enable;
}

LMI_INLINE void VidyoCameraControlCapabilitiesSetPresetSupport(VidyoCameraControlCapabilities *caps, LmiBool enable)
{
    caps->hasPresetSupport = enable;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasPanTiltRubberBand(const VidyoCameraControlCapabilities *caps)
{
    return caps->panTiltHasRubberBand;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasPanTiltContinuousMove(const VidyoCameraControlCapabilities *caps)
{
    return caps->panTiltHasContinuousMove;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasPanTiltNudge(const VidyoCameraControlCapabilities *caps)
{
    return caps->panTiltHasNudge;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasZoomRubberBand(const VidyoCameraControlCapabilities *caps)
{
    return caps->zoomHasRubberBand;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasZoomContinuousMove(const VidyoCameraControlCapabilities *caps)
{
    return caps->zooomHasContinuousMove;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasZoomNudge(const VidyoCameraControlCapabilities *caps)
{
    return caps->zoomHasNudge;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasPhotoCapture(const VidyoCameraControlCapabilities *caps)
{
    return caps->hasPhotoCapture;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasViscaSupport(const VidyoCameraControlCapabilities *caps)
{
    return caps->hasViscaSupport;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasPresetSupport(const VidyoCameraControlCapabilities *caps)
{
    return caps->hasPresetSupport;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasPanTilt(const VidyoCameraControlCapabilities *caps)
{
    return caps->panTiltHasContinuousMove || caps->panTiltHasNudge;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasZoom(const VidyoCameraControlCapabilities *caps)
{
    return caps->zooomHasContinuousMove || caps->zoomHasNudge;
}

LMI_INLINE LmiBool VidyoCameraControlCapabilitiesHasAny(const VidyoCameraControlCapabilities *caps)
{
    return VidyoCameraControlCapabilitiesHasPanTilt(caps) || VidyoCameraControlCapabilitiesHasZoom(caps) || caps->hasPhotoCapture;
}
