//
//	VidyoLocalMonitor_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoLocalRenderer_Objc.h"
#import "VidyoLocalWindowShare_Objc.h"
#import "VidyoRemoteRenderer_Objc.h"
/*!
 * @enum State of the monitor.
 * @constant VCLocalMonitorStateOk The monitor is visible and has been fully captured.
 * @constant VCLocalMonitorStateNotVisible The monitor exists but is not "visible".
 * @constant VCLocalMonitorStateMiscError Miscellaneous error has occured trying to capture the frame.
 */
typedef NS_ENUM(NSInteger, VCLocalMonitorState) {
	VCLocalMonitorStateOk,
	VCLocalMonitorStateNotVisible,
	VCLocalMonitorStateMiscError
};
@protocol VCLocalMonitorIGetPreviewFrameDataUriAsync
	-(void) onPreviewDataUriComplete:(NSString*)videoFrame State:(VCLocalMonitorState)state;
@end
@protocol VCLocalMonitorIeGetCapabilities
	/*!
	 * The callback which will be triggered with the most optimal capabilities for the device.
	 */
	-(void) onGetCapabilities:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
@end
/*!
 * This object represents a monitor on the local endpoint.
 */
@interface VCLocalMonitor : NSObject
{
	void* objPtr;
	@public
	id<VCLocalMonitorIGetPreviewFrameDataUriAsync> localMonitorIGetPreviewFrameDataUriAsync;
	/*!
	 * Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
	 */
	id<VCLocalMonitorIeGetCapabilities> localMonitorIeGetCapabilities;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 */
	-(long) addToLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 */
	-(BOOL) addToRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Clears existing constraints and set them to default values 3840x2160@3fps.
	 * @param m The VidyoLocalMonitor object.
	 */
	-(BOOL) clearConstraints;
	/*!
	 * Enable/disable window exclude. Only top-level window related to the current process can be excluded.
	 * @param monitor The VidyoLocalMonitor object.
	 * @param window The VidyoLocalWindowShare object.
	 * @param exclude The variable indicates whether the window will be excluded or not.
	 */
	-(BOOL) excludeWindow:(VCLocalWindowShare*)window Exclude:(BOOL)exclude;
	/*!
	 * Gets the unique ID of the monitor.
	 * @param m The VidyoLocalMonitor object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the monitor.
	 * @param m The VidyoLocalMonitor object.
	 */
	-(NSString*) getName;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 * @param maxWidth Maximum width of the preview image.
	 * @param maxHeight Maximum height of the preview image.
	 * @param videoFrame Video Frame to which the image will be assigned.
	 */
	-(VCLocalMonitorState) getPreviewFrameDataUri:(size_t)maxWidth MaxHeight:(size_t)maxHeight VideoFrame:(NSMutableString*)videoFrame;
	/*!
	 * @param maxWidth Maximum width of the preview image.
	 * @param maxHeight Maximum height of the preview image.
	 * @param onComplete Callback that is triggered when a preview frame is captured.
	 */
	-(BOOL) getPreviewFrameDataUriAsync:(size_t)maxWidth MaxHeight:(size_t)maxHeight LocalMonitorIGetPreviewFrameDataUriAsync:(id<VCLocalMonitorIGetPreviewFrameDataUriAsync>)localMonitorIGetPreviewFrameDataUriAsync;
	/*!
	 */
	-(BOOL) isPrimary;
	/*!
	 */
	-(void) precludeApplication:(VCLocalWindowShare*)w;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 */
	-(void) precludeWindow:(VCLocalWindowShare*)w;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 */
	-(BOOL) removeFromLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 */
	-(BOOL) removeFromRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions
	 * @param m The VidyoLocalMonitor object.
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param maxWidth Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit
	 * @param minWidth Unused
	 * @param maxHeight Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit
	 * @param minHeight Unusued
	 */
	-(BOOL) setBoundsConstraints:(long)maxFrameInterval MinFrameInterval:(long)minFrameInterval MaxWidth:(unsigned int)maxWidth MinWidth:(unsigned int)minWidth MaxHeight:(unsigned int)maxHeight MinHeight:(unsigned int)minHeight;
	/*!
	 * Set frame interval(fps) for capturer.
	 * @param m The VidyoLocalMonitor object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. By default will be calculated based on encoder configuration.
	 */
	-(BOOL) setCaptureInterval:(long)frameInterval;
	/*!
	 * Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used
	 * @param m The VidyoLocalMonitor object.
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param width The width of the stream after the stream is reconfigured
	 * @param height The height of the stream after the stream is reconfigured
	 * @param scaleFactor This should be 1
	 */
	-(BOOL) setDiscreteConstraints:(long)maxFrameInterval MinFrameInterval:(long)minFrameInterval Width:(unsigned int)width Height:(unsigned int)height ScaleFactor:(float)scaleFactor;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. Default is 333333333 which is 3 frames per second.
	 */
	-(BOOL) setFrameInterval:(long)frameInterval;
	/*!
	 * Sets the low latency profile of the monitor which treats the stream as a regular video source. This prioritizes latency over quality.
	 * @param m The VidyoLocalMonitor object.
	 * @param profile Low latency profile toggle. Default is LMI_FALSE.
	 */
	-(BOOL) setLowLatencyProfile:(BOOL)profile;
	/*!
	 * Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the monitor is in landscape mode width and height will be applied as max constraints, if the monitor is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
	 * @param m The VidyoLocalMonitor object
	 * @param width Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.
	 * @param height Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
	 */
	-(BOOL) setMaxConstraints:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Set a minimum frame interval(maximum fps) for the encoded stream.
	 * @param m The VidyoLocalMonitor object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
	 */
	-(BOOL) setMinFrameInterval:(long)frameInterval;
	/*!
	 * @param m The VidyoLocalMonitor object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames.
	 */
	-(BOOL) setPositionInLocalRenderer:(VCLocalRenderer*)localRenderer X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
	 * @param monitor The VidyoLocalMonitor object.
	 * @param onGetCapabilities The callback to which we will pass the most optimal capabilities.
	 */
	-(BOOL) eGetCapabilities:(id<VCLocalMonitorIeGetCapabilities>)localMonitorIeGetCapabilities;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
