//
//	VidyoLocalSpeaker_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoAudioFrame_Objc.h"
/*!
 * @enum The type of the speaker stream. Will determine the speaker audio volume control and default route policy. Supporten on Android only.
 * @constant VCLocalSpeakerStreamTypeVoice Used to identify the volume of audio streams for phone calls.
 * @constant VCLocalSpeakerStreamTypeSystem Used to identify the volume of audio streams for system sounds.
 * @constant VCLocalSpeakerStreamTypeRing Used to identify the volume of audio streams for the phone ring.
 * @constant VCLocalSpeakerStreamTypeMedia Used to identify the volume of audio streams for music playback.
 * @constant VCLocalSpeakerStreamTypeAlarm Used to identify the volume of audio streams for alarms.
 * @constant VCLocalSpeakerStreamTypeNotification Used to identify the volume of audio streams for notifications.
 */
typedef NS_ENUM(NSInteger, VCLocalSpeakerStreamType) {
	VCLocalSpeakerStreamTypeVoice,
	VCLocalSpeakerStreamTypeSystem,
	VCLocalSpeakerStreamTypeRing,
	VCLocalSpeakerStreamTypeMedia,
	VCLocalSpeakerStreamTypeAlarm,
	VCLocalSpeakerStreamTypeNotification
};
/*!
 * This object represents a speaker on the local endpoint.
 */
@interface VCLocalSpeaker : NSObject
{
	void* objPtr;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 * Disables recording of speaker output to the files.
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(BOOL) disableDebugRecordings;
	/*!
	 * Enables recording of speaker output to the files at the specified location.
	 * @param s The VidyoLocalSpeaker object.
	 * @param dir The directory where recordings will be stored.
	 */
	-(BOOL) enableDebugRecordings:(NSString*)dir;
	/*!
	 * Gets the unique ID of the speaker.
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the speaker.
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets the current speaker stream type. Supported on Android only.
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(VCLocalSpeakerStreamType) getStreamType;
	/*!
	 * Gets the type of the speaker.
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(NSString*) getType;
	/*!
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(unsigned int) getVolume;
	/*!
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(BOOL) isPaused;
	/*!
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(void) pause;
	/*!
	 * Plays the provided audio frame on the local speaker.
	 * @param s The VidyoLocalSpeaker object.
	 * @param sound The VidyoAudioFrame object to be played.
	 * @param loop Determine whether the audio frame should be repeatedly played.
	 */
	-(BOOL) playSound:(VCAudioFrame*)sound Loop:(BOOL)loop;
	/*!
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(void) playTone:(char)dtmfTone;
	/*!
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(void) resume;
	/*!
	 * Sets the current speaker stream type for the device.
	 * @param s The VidyoLocalSpeaker object.
	 * @param streamType Speaker stream type to be set.
	 */
	-(BOOL) setStreamType:(VCLocalSpeakerStreamType)streamType;
	/*!
	 * @param s The VidyoLocalSpeaker object.
	 * @param volumePercent The volume percent to be set. (0 for silence 500 for loudest.)
	 */
	-(void) setVolume:(unsigned int)volumePercent;
	/*!
	 * @param s The VidyoLocalSpeaker object.
	 */
	-(void) stopSound;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
