#include <stdio.h>

/**
{file:
    {name: VidyoNGRManager.h}
    {description: Manager of NGRs.}
    {copyright:
        (c) 20023-2023 Vidyo, Inc.,
        433 Hackensack Avenue,
        Hackensack, NJ  07601.

        All rights reserved.

        The information contained herein is proprietary to Vidyo, Inc.
        and shall not be reproduced, copied (in whole or in part), adapted,
        modified, disseminated, transmitted, transcribed, stored in a retrieval
        system, or translated into any language in any form by any means
        without the express written consent of Vidyo, Inc.
                          ***** CONFIDENTIAL *****
    }
}
*/

#ifndef VidyoNGRManager_h
#define VidyoNGRManager_h

#include <Lmi/Os/LmiSharedPtr.h>

struct VidyoNGRManagerImpl_;
typedef struct VidyoNGRManagerImpl_ VidyoNGRManagerImpl;
Declare_LmiSharedPtr(VidyoNGRManagerImpl)
Declare_LmiSharedPtrWrapper(VidyoNGRManager, VidyoNGRManagerImpl)
Declare_LmiWeakPtrWrapper(VidyoNGRManagerHandle, VidyoNGRManager, VidyoNGRManagerImpl)

#include "VidyoNGRWrapper.h"
#include "VidyoEndpoint.h"

typedef enum {
    VIDYO_NGRMANAGERLAYOUTTYPE_Grid,
    VIDYO_NGRMANAGERLAYOUTTYPE_Speaker,
    VIDYO_NGRMANAGERLAYOUTTYPE_Preview,
    VIDYO_NGRMANAGERLAYOUTTYPE_None
} VidyoNGRManagerLayoutType;

typedef enum
{
    VIDYO_NGRMANAGERACTIONTYPE_SetLayout,
    VIDYO_NGRMANAGERACTIONTYPE_SetViewSize,
    VIDYO_NGRMANAGERACTIONTYPE_SetDebugInfoVisible,
    VIDYO_NGRMANAGERACTIONTYPE_SetLabelVisible,
    VIDYO_NGRMANAGERACTIONTYPE_SetAudioMeterVisible,
    VIDYO_NGRMANAGERACTIONTYPE_SetBackgroundColor,
    VIDYO_NGRMANAGERACTIONTYPE_SetDensity,
    VIDYO_NGRMANAGERACTIONTYPE_SetMaxRemoteParticipants,
    VIDYO_NGRMANAGERACTIONTYPE_PinParticipant,
    VIDYO_NGRMANAGERACTIONTYPE_ShowAudioTiles,
    VIDYO_NGRMANAGERACTIONTYPE_Invalid
} VidyoNGRManagerActionType;

typedef enum
{
    VIDYO_NGRMANAGERPIPPOSITION_Min,
    VIDYO_NGRMANAGERPIPPOSITION_Center,
    VIDYO_NGRMANAGERPIPPOSITION_Max,
    VIDYO_NGRMANAGERPIPPOSITION_Invalid
} VidyoNGRManagerPipPosition;

typedef enum {
    VIDYO_NGRMANAGERINPUTMETHOD_Mouse,
    VIDYO_NGRMANAGERINPUTMETHOD_Touch,
    VIDYO_NGRMANAGERINPUTMETHOD_Invalid
} VidyoNGRManagerInputMethod;

typedef enum {
    VIDYO_NGRMANAGERBORDERSTYLE_Same,
    VIDYO_NGRMANAGERBORDERSTYLE_Highlight,
    VIDYO_NGRMANAGERBORDERSTYLE_Flash,
    VIDYO_NGRMANAGERBORDERSTYLE_None
} VidyoNGRManagerBorderStyle;

typedef enum
{
    VIDYO_NGRMANAGERMODE_Default,
    VIDYO_NGRMANAGERMODE_Foreground,
    VIDYO_NGRMANAGERMODE_Background
} VidyoNGRManagerMode;

typedef void (*VidyoNGRManagerPlugInRequestCompleted)(VidyoNGRManager* ngrm, VidyoNGRManagerActionType type, LmiBool success, const char *error, LmiVoidPtr userData);

typedef struct VidyoNGRManagerPlugIn_
{
    VidyoNGRManagerPlugInRequestCompleted requestCompleted;
} VidyoNGRManagerPlugIn;

VidyoNGRManager* VidyoNGRManagerConstruct(VidyoNGRManager* ngrm, VidyoEndpointHandle* e, VidyoNGRManagerPlugIn* ngrmPlugin, LmiBool isNGR, LmiAllocator* alloc);
LmiBool VidyoNGRManagerCreateRenderer(VidyoNGRManager* ngrm, LmiViewId* viewId, VidyoNGRManagerLayoutType layout);
void VidyoNGRManagerDestroyRenderer(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerHasRenderers(VidyoNGRManager* ngrm);
LmiBool VidyoNGRManagerIsSupportedAndActive(void);

void VidyoNGRManagerSetViewSize(VidyoNGRManager* ngrm, LmiViewId* viewId, const LmiRectangle* rect);
void VidyoNGRManagerSetLabelVisible(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool visible);
void VidyoNGRManagerSetAudioMeterVisible(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool visible);
void VidyoNGRManagerSetBackgroundColor(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiUint8 red, LmiUint8 green, LmiUint8 blue);
void VidyoNGRManagerSetDebugInfoVisible(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool visible);
void VidyoNGRManagerSetMaxRemoteParticipants(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiUint remoteParticipants);

void VidyoNGRManagerSetDensity(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiFloat32 density);
LmiFloat32 VidyoNGRManagerGetDensity(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerSetViewingDistance(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiFloat32 viewingDistance);
LmiFloat32 VidyoNGRManagerGetViewingDistance(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerEnablePreviewMirroring(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool enable);
LmiBool VidyoNGRManagerSetBorderStyle(VidyoNGRManager* ngrm, LmiViewId* viewId, VidyoNGRManagerBorderStyle style);

LmiBool VidyoNGRManagerEnableTouchInputDevice(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool enable);
LmiBool VidyoNGRManagerIsTouchInputDeviceEnabled(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerSetPreviewPosition(VidyoNGRManager* ngrm, VidyoNGRManagerPipPosition x, VidyoNGRManagerPipPosition y, LmiBool lock);
void VidyoNGRManagerPinParticipant(VidyoNGRManager* ngrm, LmiViewId* viewId, const char *participantID);

LmiBool VidyoNGRManagerEnableFECCIconCustomLayout(VidyoNGRManager* ngrm, LmiBool enable);
LmiBool VidyoNGRManagerIsFECCIconCustomLayoutEnabled(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerSetRendererOptions(VidyoNGRManager* ngrm, LmiViewId* viewId, const char *options);
LmiString* VidyoNGRManagerGetRendererOptions(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerSetMode(VidyoNGRManager* ngrm, VidyoNGRManagerMode mode);

const VidyoNGRManagerHandle *VidyoNGRManagerGetHandleConst(const VidyoNGRManager* ngrm);

LmiBool VidyoNGRManagerEnableVerticalVideoCentering(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool enable);
LmiBool VidyoNGRManagerIsVerticalVideoCenteringEnabled(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerEnableShowAudioTiles(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool enable);
LmiBool VidyoNGRManagerIsShowAudioTilesEnabled(VidyoNGRManager* ngrm, LmiViewId* viewId);

LmiBool VidyoNGRManagerEnableExpandedCameraControl(VidyoNGRManager* ngrm, LmiViewId* viewId, LmiBool enable);
LmiBool VidyoNGRManagerIsExpandedCameraControlEnabled(VidyoNGRManager* ngrm, LmiViewId* viewId);

#if LMI_INLINE_NEED_HEADER_FILE_DEFINITIONS
Define_LmiSharedPtrWrapper_NoCompare(VidyoNGRManager, VidyoNGRManagerImpl)
Define_LmiWeakPtrWrapper(VidyoNGRManagerHandle, VidyoNGRManager, VidyoNGRManagerImpl)
#endif

#endif /* VidyoNGRManager_h */
