//
//	VidyoParticipant_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoContact_Objc.h"
/*!
 * @enum This type indicates the trust status of a participant.
 * @constant PARTICIPANT_APPLICATIONTYPE_None default application type.
 * @constant PARTICIPANT_APPLICATIONTYPE_Recorder Recorder application type
 * @constant PARTICIPANT_APPLICATIONTYPE_Gateway Gateway application type
 * @constant PARTICIPANT_APPLICATIONTYPE_Bot Bot application type
 */
typedef NS_ENUM(NSInteger, VCParticipantApplicationType) {
	PARTICIPANT_APPLICATIONTYPE_None,
	PARTICIPANT_APPLICATIONTYPE_Recorder,
	PARTICIPANT_APPLICATIONTYPE_Gateway,
	PARTICIPANT_APPLICATIONTYPE_Bot
};
/*!
 * @enum Clearance of an participant. This is used to determine what the participant is allowed to do.
 * @constant PARTICIPANT_CLEARANCETYPE_None Guest participant with no privileges.
 * @constant PARTICIPANT_CLEARANCETYPE_Member Normal participant with normal privileges.
 * @constant PARTICIPANT_CLEARANCETYPE_Owner Owner of the conference room, has full privileges.
 * @constant PARTICIPANT_CLEARANCETYPE_Admin Administrator of the conference room, has full privileges except it can not promote other participants to Admin clearance.
 * @constant PARTICIPANT_CLEARANCETYPE_Moderator Moderator of the conference, has ability to control all aspects of the conference.
 */
typedef NS_ENUM(NSInteger, VCParticipantClearanceType) {
	PARTICIPANT_CLEARANCETYPE_None,
	PARTICIPANT_CLEARANCETYPE_Member,
	PARTICIPANT_CLEARANCETYPE_Owner,
	PARTICIPANT_CLEARANCETYPE_Admin,
	PARTICIPANT_CLEARANCETYPE_Moderator
};
/*!
 * @enum Result of getting the contact.
 * @constant VCParticipantGetContactResultSUCCESS Contact was got successfully.
 * @constant VCParticipantGetContactResultMiscError Getting the contact failed some miscellaneous reason.
 */
typedef NS_ENUM(NSInteger, VCParticipantGetContactResult) {
	VCParticipantGetContactResultSUCCESS,
	VCParticipantGetContactResultMiscError
};
/*!
 * @enum Structure that will contain a different hand state for a particular participant.
 * @constant VCParticipantHandStateUNRAISED UnRaised State.
 * @constant VCParticipantHandStateRAISED when participate raise hand.
 * @constant VCParticipantHandStateAPPROVED Participant request is approved.
 * @constant VCParticipantHandStateDISMISSED Participant request is dismissed.
 */
typedef NS_ENUM(NSInteger, VCParticipantHandState) {
	VCParticipantHandStateUNRAISED,
	VCParticipantHandStateRAISED,
	VCParticipantHandStateAPPROVED,
	VCParticipantHandStateDISMISSED
};
/*!
 * @enum This type indicates the trust status of a participant.
 * @constant VCParticipantTrustLocal Locally authenticated user.
 * @constant VCParticipantTrustFederated Federated from another trusted server.
 * @constant VCParticipantTrustAnonymous Untrusted guest user.
 */
typedef NS_ENUM(NSInteger, VCParticipantTrust) {
	VCParticipantTrustLocal,
	VCParticipantTrustFederated,
	VCParticipantTrustAnonymous
};
@protocol VCParticipantIGetContactAsync
	/*!
	 * Callback that is triggered when getting the contact completes.
	 */
	-(void) onGetContactComplete:(VCContact*)contact Result:(VCParticipantGetContactResult)result;
@end
/*!
 * This object represents a participant in the room or call.
 */
@interface VCParticipant : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Gets conntact.
	 */
	id<VCParticipantIGetContactAsync> participantIGetContactAsync;
}
	/*!
	 * ID that is globally unique such as user@domain.
	 */
	@property NSMutableString* id;
	/*!
	 * Display name of the participant.
	 */
	@property NSMutableString* name;
	/*!
	 * SCIP ID unique to the room or call only.
	 */
	@property NSMutableString* scipId;
	@property VCParticipantTrust trust;
	/*!
	 * ID that is globally unique such as user@domain.
	 */
	@property NSMutableString* userId;
	-(void) dealloc;
	/*!
	 * @param p The VidyoParticipant object.
	 */
	-(VCParticipantApplicationType) getApplicationType;
	/*!
	 * Gets the clearance type of the participant.
	 * @param p The VidyoParticipant object.
	 */
	-(VCParticipantClearanceType) getClearanceType;
	/*!
	 * @param p The VidyoParticipant object.
	 */
	-(VCContact*) getContact:(VCContact*)contact;
	/*!
	 * Gets conntact.
	 * @param p The VidyoParticipant object.
	 * @param onComplete The callback that is triggered when getting contact completes.
	 */
	-(BOOL) getContactAsync:(id<VCParticipantIGetContactAsync>)participantIGetContactAsync;
	/*!
	 * Gets the ID that is globally unique such as user@domain.
	 * @param p The VidyoParticipant object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the display name of the participant.
	 * @param p The VidyoParticipant object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets the SCIP ID unique to the room or call only.
	 * @param p The VidyoParticipant object.
	 */
	-(NSString*) getScipId;
	/*!
	 */
	-(VCParticipantTrust) getTrust;
	/*!
	 * Gets the ID that is globally unique such as user@domain.
	 * @param p The VidyoParticipant object.
	 */
	-(NSString*) getUserId;
	/*!
	 * Gets the hidden state of the participant.
	 * @param p The VidyoParticipant object.
	 */
	-(BOOL) isHidden;
	/*!
	 * @param p The VidyoParticipant object.
	 */
	-(BOOL) isLocal;
	/*!
	 * Gets the recording state of the participant.
	 * @param p The VidyoParticipant object.
	 */
	-(BOOL) isRecording;
	/*!
	 * Gets the selectable state of the participant.
	 * @param p The VidyoParticipant object.
	 */
	-(BOOL) isSelectable;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
