//
//	VidyoStatistics_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoMediaFormats_Objc.h"
@class VCBandwidthSummaryStats;
@class VCCameraEffectStats;
@class VCLatencyTestDataStats;
@class VCLatencyTestStats;
@class VCLocalMicrophoneStats;
@class VCLocalRendererStats;
@class VCLocalRendererStreamStats;
@class VCLocalSpeakerStats;
@class VCLocalSpeakerStreamStats;
@class VCLocalVideoSourceStats;
@class VCLogDataStats;
@class VCLogStats;
@class VCMediaConnectionTransportInfo;
@class VCNetworkInterfaceStats;
@class VCParticipantGenerationStats;
@class VCParticipantStats;
@class VCRateShaperStats;
@class VCRemoteMicrophoneStats;
@class VCRemoteRendererStreamStats;
@class VCRemoteSpeakerStreamStats;
@class VCRemoteVideoSourceStats;
@class VCRoomStats;
@class VCUserStats;
/*!
 * Staticstics for an endpoint rate shaper.
 */
@interface VCBandwidthSummaryStats : NSObject
{
}
	/*!
	 * Actual encoder bitrate.
	 */
	@property size_t actualEncoderBitRate;
	/*!
	 * Available bandwidth.
	 */
	@property size_t availableBandwidth;
	/*!
	 * Leaky bucket delay.
	 */
	@property size_t leakyBucketDelay;
	/*!
	 * Bitrate used for retransmission.
	 */
	@property size_t retransmitBitRate;
	/*!
	 * Target encoder bitrate.
	 */
	@property size_t targetEncoderBitRate;
	/*!
	 * Total transmit bitrate.
	 */
	@property size_t totalTransmitBitRate;
@end
/*!
 * Statistics for a camera effect.
 */
@interface VCCameraEffectStats : NSObject
{
}
	/*!
	 * Represents the average processing banuba time.
	 */
	@property double averageBanubaProcessingTime;
	/*!
	 * Represents the average buffer reading time.
	 */
	@property double averageBufferReadingTime;
	/*!
	 * Represents the average processing time.
	 */
	@property double averageFrameProcessingTime;
	/*!
	 * Represents the number of frames were dropped.
	 */
	@property unsigned int framesDropped;
	/*!
	 * Represents the maximum processing banuba time.
	 */
	@property double maxBanubaProcessingTime;
	/*!
	 * Represents the maximum buffer reading time.
	 */
	@property double maxBufferReadingTime;
	/*!
	 * Represents the maximum processing time.
	 */
	@property double maxFrameProcessingTime;
@end
/*!
 * Statistics for an endpoint.
 */
@interface VCEndpointStats : NSObject
{
}
	/*!
	 * Application name which is set by application through SetProductInfo. Unless set, it remains empty.
	 */
	@property NSMutableString* applicationName;
	/*!
	 * Tag set by the application using public API. Unless set, it remains empty.
	 */
	@property NSMutableString* applicationTag;
	/*!
	 * Application version which is set by application through SetProductInfo. Unless set, it remains empty.
	 */
	@property NSMutableString* applicationVersion;
	/*!
	 * Tag from the build system.
	 */
	@property NSMutableString* buildTag;
	/*!
	 * Total number of bytes received over TCP.
	 */
	@property unsigned long long bytesReceivedTcp;
	/*!
	 * Total number of bytes received over UDP.
	 */
	@property unsigned long long bytesReceivedUdp;
	/*!
	 * Total number of bytes sent over TCP.
	 */
	@property unsigned long long bytesSentTcp;
	/*!
	 * Total number of bytes sent over UDP.
	 */
	@property unsigned long long bytesSentUdp;
	/*!
	 * Gregorian Time stamp when user calls the Connect API.
	 */
	@property NSMutableString* connectTime;
	/*!
	 * Endpoint ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Version of the library.
	 */
	@property NSMutableString* libraryVersion;
	/*!
	 * Vector of stats of cameras.
	 */
	@property NSMutableArray* localCameraStats;
	/*!
	 * Vector of stats of microphones.
	 */
	@property NSMutableArray* localMicrophoneStats;
	/*!
	 * Vector of stats of monitors.
	 */
	@property NSMutableArray* localMonitorStats;
	/*!
	 * Vector of stats of renderers.
	 */
	@property NSMutableArray* localRendererStats;
	/*!
	 * Vector of stats of speakers.
	 */
	@property NSMutableArray* localSpeakerStats;
	/*!
	 * Vector of stats of window shares.
	 */
	@property NSMutableArray* localWindowShareStats;
	/*!
	 * Stats of the log.
	 */
	@property VCLogStats* logStats;
	/*!
	 * Time taken up to login Complete callback.
	 */
	@property unsigned long long loginTimeConsumedMs;
	/*!
	 * Max send bit rate for all srouces.
	 */
	@property unsigned long long maxBitRate;
	/*!
	 * Calculated according to CPU profile, CPU cores etc. Remains same through-out the call for stats perspective.
	 */
	@property unsigned long long maxEncodePixelRateInitial;
	/*!
	 * Time between media enable request and media route acquired.
	 */
	@property unsigned long long mediaEnableTimeConsumedMs;
	/*!
	 * Time between room entered callback and media route acquired callback.
	 */
	@property unsigned long long mediaRouteAcquireTimeConsumedMs;
	/*!
	 * Network interfaces on the endpoint.
	 */
	@property NSMutableArray* networkInterfaceStats;
	/*!
	 * Name of the operating system.
	 */
	@property NSMutableString* osName;
	/*!
	 * Version of the operating system.
	 */
	@property NSMutableString* osVersion;
	/*!
	 * CPU brand.
	 */
	@property NSMutableString* processorBrand;
	/*!
	 * Number of logical cores in the CPU (including hyperthreading).
	 */
	@property unsigned int processorLogicalCores;
	/*!
	 * CPU Model.
	 */
	@property NSMutableString* processorModel;
	/*!
	 * Number of physical cores in the CPU (ignoring hyperthreading).
	 */
	@property unsigned int processorPhysicalCores;
	/*!
	 * CPU frequency, in MHz.
	 */
	@property unsigned int processorSpeed;
	/*!
	 * Number of milliseconds consumed in room entering process.
	 */
	@property unsigned long long roomEnterTimeConsumedMs;
	/*!
	 * Gregorian Timestamp when the stats were measured.
	 */
	@property NSMutableString* timeStamp;
	/*!
	 * Vector of stats of users.
	 */
	@property NSMutableArray* userStats;
	/*!
	 * Vector of stats of the virtual microphones.
	 */
	@property NSMutableArray* virtualAudioSourceStats;
	/*!
	 * Vector of stats of virtual window shares.
	 */
	@property NSMutableArray* virtualVideoSourceStats;
@end
/*!
 * Staticstics for a latency test.
 */
@interface VCLatencyTestDataStats : NSObject
{
}
	/*!
	 * Address of the latency test host.
	 */
	@property NSMutableString* address;
	/*!
	 * Latency to the host in milliseconds.
	 */
	@property unsigned int latencyMs;
	/*!
	 * Latitude of the host.
	 */
	@property double latitude;
	/*!
	 * Longitude of the host.
	 */
	@property double longitude;
	/*!
	 * Name of the latency test host.
	 */
	@property NSMutableString* name;
	/*!
	 * Response has been received from the host.
	 */
	@property BOOL responseReceived;
@end
/*!
 * Staticstics for a latency test.
 */
@interface VCLatencyTestStats : NSObject
{
}
	/*!
	 * Vector of stats data of latency test.
	 */
	@property NSMutableArray* latencyTestDataStats;
@end
/*!
 * Staticstics for a local microphone.
 */
@interface VCLocalMicrophoneStats : NSObject
{
}
	/*!
	 * AEC echo coupling.
	 */
	@property unsigned int aecEchoCoupling;
	/*!
	 * AGC average gain.
	 */
	@property unsigned int agcAverageGain;
	/*!
	 * Bits per sample.
	 */
	@property unsigned int bitsPerSample;
	/*!
	 * Format.
	 */
	@property VCMediaFormat format;
	/*!
	 * Id.
	 */
	@property NSMutableString* id;
	/*!
	 * Vector of stats of local speaker streams.
	 */
	@property NSMutableArray* localSpeakerStreams;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Noise suppression SNR.
	 */
	@property unsigned int noiseSuppressionSnr;
	/*!
	 * Number of channels.
	 */
	@property unsigned int numberOfChannels;
	/*!
	 * Vector of stats of remote speaker streams.
	 */
	@property NSMutableArray* remoteSpeakerStreams;
	/*!
	 * Measured sample rate.
	 */
	@property unsigned int sampleRateMeasured;
	/*!
	 * Sample rate setting.
	 */
	@property unsigned int sampleRateSet;
@end
/*!
 * Statistics for a local renderer.
 */
@interface VCLocalRendererStats : NSObject
{
}
	/*!
	 * Format.
	 */
	@property VCMediaFormat format;
	/*!
	 * Frame interval measured by the renderer.
	 */
	@property long frameIntervalMeasured;
	/*!
	 * Frame interval setting.
	 */
	@property long frameIntervalSet;
	/*!
	 * Height.
	 */
	@property size_t height;
	/*!
	 * Id.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Total frames rendered.
	 */
	@property unsigned int totalFrames;
	/*!
	 * Total pixels rendered.
	 */
	@property unsigned int totalPixels;
	/*!
	 * Width.
	 */
	@property size_t width;
@end
/*!
 * Statistics for a local renderer.
 */
@interface VCLocalRendererStreamStats : NSObject
{
}
	/*!
	 * Active spatial layers.
	 */
	@property size_t activeSpatialLayers;
	/*!
	 * Dropped frames from video buffer.
	 */
	@property unsigned int bufferDropped;
	/*!
	 * Size of video buffer.
	 */
	@property unsigned int bufferSize;
	/*!
	 * Height.
	 */
	@property size_t height;
	/*!
	 * Id.
	 */
	@property NSMutableString* id;
	/*!
	 * Maximum spatial layers.
	 */
	@property size_t maxSpatialLayers;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Width.
	 */
	@property size_t width;
@end
/*!
 * Staticstics for a local speaker.
 */
@interface VCLocalSpeakerStats : NSObject
{
}
	/*!
	 * Bits per sample.
	 */
	@property unsigned int bitsPerSample;
	/*!
	 * Audio format.
	 */
	@property VCMediaFormat format;
	/*!
	 * Id.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Number of channels.
	 */
	@property unsigned int numberOfChannels;
	/*!
	 * Sample rate measured.
	 */
	@property unsigned int sampleRateMeasured;
	/*!
	 * Sample rate setting.
	 */
	@property unsigned int sampleRateSet;
@end
/*!
 * Staticstics for a local speaker.
 */
@interface VCLocalSpeakerStreamStats : NSObject
{
}
	/*!
	 * Bits per sample.
	 */
	@property unsigned int bitsPerSample;
	/*!
	 * Audio delay in the stream jitter buffer.
	 */
	@property long delay;
	/*!
	 * Audio format.
	 */
	@property VCMediaFormat format;
	/*!
	 * High threshold of stream jitter buffer over which the stream will be gently pared down to get into the proper range.
	 */
	@property long highThreshold;
	/*!
	 * Highest threshold of stream jitter buffer over which the stream will be agressively pared down to get into the proper range.
	 */
	@property long highestThreshold;
	/*!
	 * Active stream status.
	 */
	@property BOOL isActive;
	/*!
	 * Last energy in dBFS of the stream.
	 */
	@property int lastEnergy;
	/*!
	 * Last time audio was played from the stream.
	 */
	@property long lastPlayed;
	/*!
	 * Low threshold of stream jitter buffer under which the stream will be gently padded to get into the proper range.
	 */
	@property long lowThreshold;
	/*!
	 * Lowest threshold of stream jitter buffer under which the stream will be agressively padded to get into the proper range.
	 */
	@property long lowestThreshold;
	/*!
	 * Maximum threshold of stream jitter buffer over which the stream will be agressively pared down by dropping non-speech frames to get into the proper range.
	 */
	@property long maxThreshold;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Number of channels.
	 */
	@property unsigned int numberOfChannels;
	/*!
	 * Ammount of time stream was over the maxThreshold.
	 */
	@property long overrun;
	/*!
	 * Ammount of audio played by the stream.
	 */
	@property long played;
	/*!
	 * Sample rate.
	 */
	@property unsigned int sampleRate;
	/*!
	 * Ammount of time stream was in the empty but active state.
	 */
	@property long underrun;
@end
/*!
 * Statistics for a local video source.
 */
@interface VCLocalVideoSourceStats : NSObject
{
}
	/*!
	 * Camera effect statistics.
	 */
	@property VCCameraEffectStats* cameraEffect;
	/*!
	 * Format.
	 */
	@property VCMediaFormat format;
	/*!
	 * Frame interval measured between last 2 frames.
	 */
	@property long frameIntervalMeasured;
	/*!
	 * Frame interval setting.
	 */
	@property long frameIntervalSet;
	/*!
	 * Height.
	 */
	@property size_t height;
	/*!
	 * Id.
	 */
	@property NSMutableString* id;
	/*!
	 * Vector of stats of local renderer streams.
	 */
	@property NSMutableArray* localRendererStreams;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Vector of stats of remote renderer streams.
	 */
	@property NSMutableArray* remoteRendererStreams;
	/*!
	 * Target bit rate.
	 */
	@property unsigned long long targetBitRate;
	/*!
	 * Total frames.
	 */
	@property unsigned int totalFrames;
	/*!
	 * Width.
	 */
	@property size_t width;
@end
/*!
 * Staticstics for a log function:line number.
 */
@interface VCLogDataStats : NSObject
{
}
	/*!
	 * Function name and line number of the log record.
	 */
	@property NSMutableString* name;
	/*!
	 * Number of occurances of this log record.
	 */
	@property unsigned int occurances;
@end
/*!
 * Staticstics of the endpoint logs.
 */
@interface VCLogStats : NSObject
{
}
	/*!
	 * Vector of error stats data of logs.
	 */
	@property NSMutableArray* logErrorDataStats;
	/*!
	 * Vector of warning stats data of logs.
	 */
	@property NSMutableArray* logWarningDataStats;
@end
/*!
 * Information about media connection transport.
 */
@interface VCMediaConnectionTransportInfo : NSObject
{
}
	/*!
	 * Address type.
	 */
	@property NSMutableString* addressType;
	/*!
	 * Transport component type.
	 */
	@property NSMutableString* componentType;
	/*!
	 * Connection ID.
	 */
	@property unsigned int connectionId;
	/*!
	 * Transport connection type.
	 */
	@property NSMutableString* connectionType;
	/*!
	 * External local address.
	 */
	@property NSMutableString* externalLocalAddr;
	/*!
	 * External remote address.
	 */
	@property NSMutableString* externalRemoteAddr;
	/*!
	 * Interface name.
	 */
	@property NSMutableString* interfaceName;
	/*!
	 * Interface type.
	 */
	@property NSMutableString* interfaceType;
	/*!
	 * Internal local address.
	 */
	@property NSMutableString* internalLocalAddr;
	/*!
	 * Internal remote address.
	 */
	@property NSMutableString* internalRemoteAddr;
	/*!
	 * Transport plugin.
	 */
	@property NSMutableString* transportPlugIn;
@end
/*!
 * Staticstics for a network interface.
 */
@interface VCNetworkInterfaceStats : NSObject
{
}
	/*!
	 * State of the interface.
	 */
	@property BOOL isUp;
	/*!
	 * Interface name.
	 */
	@property NSMutableString* name;
	/*!
	 * Interface type such as wifi or wired.
	 */
	@property NSMutableString* type;
@end
/*!
 * Staticstics for a participnat generation, ordered list of dynamic participants.
 */
@interface VCParticipantGenerationStats : NSObject
{
}
	/*!
	 * Camera id.
	 */
	@property NSMutableString* cameraId;
	/*!
	 * Camera name.
	 */
	@property NSMutableString* cameraName;
	/*!
	 * State of the generation.
	 */
	@property BOOL enabled;
	/*!
	 * Frame interval setting.
	 */
	@property long frameInterval;
	/*!
	 * Height.
	 */
	@property size_t height;
	/*!
	 * Participant id.
	 */
	@property NSMutableString* id;
	/*!
	 * Participant name.
	 */
	@property NSMutableString* name;
	/*!
	 * Pixel rate to ask for.
	 */
	@property unsigned long long pixelRate;
	/*!
	 * Width.
	 */
	@property size_t width;
@end
/*!
 * Staticstics for a room.
 */
@interface VCParticipantStats : NSObject
{
}
	/*!
	 * Participant ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Current CPU usage.
	 */
	@property NSMutableString* name;
	/*!
	 * Vector of stats of cameras.
	 */
	@property NSMutableArray* remoteCameraStats;
	/*!
	 * Vector of stats of microphones.
	 */
	@property NSMutableArray* remoteMicrophoneStats;
	/*!
	 * Vector of stats of speakers.
	 */
	@property NSMutableArray* remoteWindowShareStats;
	/*!
	 * SCIP ID unique to the room or call only.
	 */
	@property NSMutableString* scipId;
	/*!
	 * ID assosicated with the VidyoUser of that participant.
	 */
	@property NSMutableString* userId;
@end
/*!
 * Staticstics for an endpoint rate shaper.
 */
@interface VCRateShaperStats : NSObject
{
}
	/*!
	 * Normal delay.
	 */
	@property unsigned int delayNormal;
	/*!
	 * Retransmit delay.
	 */
	@property unsigned int delayRetransmit;
	/*!
	 * Dropped normal.
	 */
	@property unsigned int dropNormal;
	/*!
	 * Normal packets.
	 */
	@property unsigned int packetsNormal;
	/*!
	 * Retransmitted packets.
	 */
	@property unsigned int packetsRetransmit;
@end
/*!
 * Staticstics for a remote microphone.
 */
@interface VCRemoteMicrophoneStats : NSObject
{
}
	/*!
	 * Bits per sample.
	 */
	@property unsigned int bitsPerSample;
	/*!
	 * Codec DTX.
	 */
	@property unsigned int codecDtx;
	/*!
	 * Codec name.
	 */
	@property NSMutableString* codecName;
	/*!
	 * Codec quality setting.
	 */
	@property unsigned int codecQualitySetting;
	/*!
	 * Id.
	 */
	@property NSMutableString* id;
	/*!
	 * Milliseconds since last received frame.
	 */
	@property int lastFrameMs;
	/*!
	 * Vector of stats of local speaker streams.
	 */
	@property NSMutableArray* localSpeakerStreams;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Number of channels.
	 */
	@property unsigned int numberOfChannels;
	/*!
	 * Bandwidth of receive network.
	 */
	@property size_t receiveNetworkBitRate;
	/*!
	 * Delay in receive network.
	 */
	@property long receiveNetworkDelay;
	/*!
	 * Dropped packets in receive network.
	 */
	@property size_t receiveNetworkDroppedPackets;
	/*!
	 * Jitter in receive network.
	 */
	@property unsigned int receiveNetworkJitter;
	/*!
	 * Concealed packets in receive network.
	 */
	@property size_t receiveNetworkPacketsConcealed;
	/*!
	 * Lost packets in receive network.
	 */
	@property size_t receiveNetworkPacketsLost;
	/*!
	 * Measured sample rate.
	 */
	@property unsigned int sampleRateMeasured;
	/*!
	 * Sample rate setting.
	 */
	@property unsigned int sampleRateSet;
@end
/*!
 * Statistics for a remote renderer.
 */
@interface VCRemoteRendererStreamStats : NSObject
{
}
	/*!
	 * Codec FIR.
	 */
	@property unsigned int codecFir;
	/*!
	 * Codec I frames.
	 */
	@property unsigned int codecIFrames;
	/*!
	 * Codec layers.
	 */
	@property unsigned int codecLayers;
	/*!
	 * Codec nacks.
	 */
	@property unsigned int codecNacks;
	/*!
	 * Codec name.
	 */
	@property NSMutableString* codecName;
	/*!
	 * Frame rate determined by the operating point.
	 */
	@property unsigned int fps;
	/*!
	 * Frame rate at encoder input.
	 */
	@property unsigned int fpsInput;
	/*!
	 * Frame rate at the encoder output.
	 */
	@property unsigned int fpsSent;
	/*!
	 * Number of frames dropped due to overconstraint or resizing errors.
	 */
	@property size_t framesDropped;
	/*!
	 * Height determined by the operating point.
	 */
	@property size_t height;
	/*!
	 * Height of the last frame received from the capturing device.
	 */
	@property size_t lastHeight;
	/*!
	 * Width of the last frame received from the capturing device.
	 */
	@property size_t lastWidth;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Send bitrate.
	 */
	@property unsigned int sendNetworkBitRate;
	/*!
	 * Round trip time of send network.
	 */
	@property long sendNetworkRtt;
	/*!
	 * Width determined by the operating point.
	 */
	@property size_t width;
@end
/*!
 * Staticstics for a remote speaker.
 */
@interface VCRemoteSpeakerStreamStats : NSObject
{
}
	/*!
	 * Bits per sample.
	 */
	@property unsigned int bitsPerSample;
	/*!
	 * Codec DTX.
	 */
	@property unsigned int codecDtx;
	/*!
	 * Codec name.
	 */
	@property NSMutableString* codecName;
	/*!
	 * Codec quality setting.
	 */
	@property unsigned int codecQualitySetting;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Number of channels.
	 */
	@property unsigned int numberOfChannels;
	/*!
	 * Sample rate.
	 */
	@property unsigned int sampleRate;
	/*!
	 * Send bitrate.
	 */
	@property unsigned int sendNetworkBitRate;
	/*!
	 * Round trip time of send network.
	 */
	@property long sendNetworkRtt;
@end
/*!
 * Statistics for a remote video source.
 */
@interface VCRemoteVideoSourceStats : NSObject
{
}
	/*!
	 * Codec FIR.
	 */
	@property size_t codecFir;
	/*!
	 * Codec I frames.
	 */
	@property size_t codecIFrames;
	/*!
	 * Codec layers.
	 */
	@property size_t codecLayers;
	/*!
	 * Codec nacks.
	 */
	@property size_t codecNacks;
	/*!
	 * Codec name.
	 */
	@property NSMutableString* codecName;
	/*!
	 * Milliseconds since add video source to renderer and receive first frame.
	 */
	@property int firstFrameDelay;
	/*!
	 * Frame rate of decoder output.
	 */
	@property size_t fpsDecoded;
	/*!
	 * Frame rate at decoder input.
	 */
	@property size_t fpsDecoderInput;
	/*!
	 * Frame rate of renderer.
	 */
	@property size_t fpsRendered;
	/*!
	 * Height.
	 */
	@property size_t height;
	/*!
	 * Id.
	 */
	@property NSMutableString* id;
	/*!
	 * Milliseconds since last received frame.
	 */
	@property int lastFrameMs;
	/*!
	 * Vector of stats of local renderer streams.
	 */
	@property NSMutableArray* localRendererStreams;
	/*!
	 * Width.
	 */
	@property unsigned int maxStreamFrameRate;
	/*!
	 * Width.
	 */
	@property size_t maxStreamHeight;
	/*!
	 * Width.
	 */
	@property size_t maxStreamWidth;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Source bitrate.
	 */
	@property size_t receiveNetworkBitRate;
	/*!
	 * Number of packets concealed.
	 */
	@property size_t receiveNetworkPacketsConcealed;
	/*!
	 * Number of lost packets.
	 */
	@property size_t receiveNetworkPacketsLost;
	/*!
	 * Number of packets reordered.
	 */
	@property size_t receiveNetworkPacketsReordered;
	/*!
	 * Number of packets recovered with FEC.
	 */
	@property size_t receiveNetworkRecoveredWithFec;
	/*!
	 * Width.
	 */
	@property unsigned int showFrameRate;
	/*!
	 * Width.
	 */
	@property size_t showHeight;
	/*!
	 * Width.
	 */
	@property unsigned long long showPixelRate;
	/*!
	 * State of how the source is received from the server (on/off/auto).
	 */
	@property NSMutableString* showState;
	/*!
	 * Width.
	 */
	@property size_t showWidth;
	/*!
	 * Last known delta between audio and video before de-jittering in milliseconds. Negative number means audio is behind video.
	 */
	@property int videoDeltaFromAudioMs;
	/*!
	 * Width.
	 */
	@property size_t width;
@end
/*!
 * Staticstics for a room.
 */
@interface VCRoomStats : NSObject
{
}
	/*!
	 * Available Percent of the Bandwidth for the decoder.
	 */
	@property unsigned int availableDecodeBwPercent;
	/*!
	 * Available Percent of the CPU for the decoder.
	 */
	@property unsigned int availableDecodeCpuPercent;
	/*!
	 * Available Percent of the Bandwidth for the encoder.
	 */
	@property unsigned int availableEncodeBwPercent;
	/*!
	 * Available Percent of the CPU for the encoder.
	 */
	@property unsigned int availableEncodeCpuPercent;
	/*!
	 * Bandwidth summary statistics of application content.
	 */
	@property VCBandwidthSummaryStats* bandwidthApp;
	/*!
	 * Bandwidth summary statistics of audio content.
	 */
	@property VCBandwidthSummaryStats* bandwidthAudio;
	/*!
	 * Bandwidth summary statistics of video content.
	 */
	@property VCBandwidthSummaryStats* bandwidthVideo;
	/*!
	 * Unique ID every time media is started and stopped.
	 */
	@property NSMutableString* callId;
	/*!
	 * ID conference on the reflector associated with this VidyoRoom.
	 */
	@property NSMutableString* conferenceId;
	/*!
	 * Current CPU usage.
	 */
	@property unsigned int cpuUsage;
	/*!
	 * Current Bandwidth decode pixel rate.
	 */
	@property unsigned long long currentBandwidthDecodePixelRate;
	/*!
	 * Current Bandwidth encode pixel rate.
	 */
	@property unsigned long long currentBandwidthEncodePixelRate;
	/*!
	 * Current CPU decode pixel rate.
	 */
	@property unsigned long long currentCpuDecodePixelRate;
	/*!
	 * Current CPU encode pixel rate.
	 */
	@property unsigned long long currentCpuEncodePixelRate;
	/*!
	 * Room ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Max decode pixel rate.
	 */
	@property unsigned long long maxDecodePixelRate;
	/*!
	 * Max encode pixel rate.
	 */
	@property unsigned long long maxEncodePixelRate;
	/*!
	 * Maximum video sources allowed based on the minimum of configured and constrained by resource manager.
	 */
	@property unsigned int maxVideoSources;
	/*!
	 * Ordered list of generations (selected participants).
	 */
	@property NSMutableArray* participantGenerationStats;
	/*!
	 * Vector of stats of participants.
	 */
	@property NSMutableArray* participantStats;
	/*!
	 * Rate shaper statistics of application content.
	 */
	@property VCRateShaperStats* rateShaperApp;
	/*!
	 * Rate shaper statistics of audio content.
	 */
	@property VCRateShaperStats* rateShaperAudio;
	/*!
	 * Rate shaper statistics of video content.
	 */
	@property VCRateShaperStats* rateShaperVideo;
	/*!
	 * Estimated available receive bandwidth in bps as detected by the automatic bandwidth detection algorithm.
	 */
	@property unsigned long long receiveBitRateAvailable;
	/*!
	 * Estimate of the current receive bit rate on the entire media session.
	 */
	@property unsigned long long receiveBitRateTotal;
	/*!
	 * ID of the refector to which the media conneciton is established.
	 */
	@property NSMutableString* reflectorId;
	/*!
	 * Unordered list of stats for all selected participants.
	 */
	@property NSMutableArray* selectedParticipantsStats;
	/*!
	 * Estimated available send bandwidth in bps as detected by the automatic bandwidth detection algorithm.
	 */
	@property unsigned long long sendBitRateAvailable;
	/*!
	 * Estimate of the current send bit rate for the entire media session.
	 */
	@property unsigned long long sendBitRateTotal;
	/*!
	 * Current ammount of static sources shown.
	 */
	@property unsigned int staticSources;
	/*!
	 * Vector of media transport information.
	 */
	@property NSMutableArray* transportInformation;
@end
/*!
 * Statistics for an user.
 */
@interface VCUserStats : NSObject
{
}
	/*!
	 * Login host.
	 */
	@property NSMutableString* host;
	/*!
	 * User ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Stats of latency test.
	 */
	@property VCLatencyTestStats* latencyTestStats;
	/*!
	 * Login Port.
	 */
	@property unsigned int port;
	/*!
	 * Vector of stats of rooms.
	 */
	@property NSMutableArray* roomStats;
	/*!
	 * Login service type.
	 */
	@property NSMutableString* serviceType;
@end
