// This file is NOT autogenerated.
// This file contains helper functions for internal ByteArray usage betwen CSharp and native code.

//	Copyright (c) 2016 Vidyo, Inc. All rights reserved.

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace VidyoClient
{
    public class ByteArrayHelperSingleton
    {
        private static Dictionary<IntPtr, GCHandle> GCHandleMap = new Dictionary<IntPtr, GCHandle>();
        private static Dictionary<IntPtr, byte[]> ByteArrayMap = new Dictionary<IntPtr, byte[]>();
        public static IntPtr ByteArrayToRawPointer(byte[] byteArray)
        {
            GCHandle pinnedHandle = GCHandle.Alloc(byteArray, GCHandleType.Pinned);
            IntPtr pointer = pinnedHandle.AddrOfPinnedObject();

            GCHandleMap[pointer] = pinnedHandle;
            ByteArrayMap[pointer] = byteArray;

            return pointer;
        }

        public static byte[] RawPointerToByteArray(IntPtr pointer)
        {
            byte[] byteArray = null;
            if (GCHandleMap[pointer] != null)
            {
                GCHandle pinnedHandle = GCHandleMap[pointer];
                pinnedHandle.Free();
                GCHandleMap.Remove(pointer);

                byteArray = ByteArrayMap[pointer];
                ByteArrayMap.Remove(pointer);
            }

            return byteArray;
        }
    };
}