// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class CalendarConnPropsFactory
	{
		public static CalendarConnProps Create()
		{
			return new CalendarConnProps(IntPtr.Zero);
		}
		public static void Destroy(CalendarConnProps obj)
		{
		}
	}
	/// <summary>
	/// Properties for connecting to a calendar service.
	/// </summary>
	public class CalendarConnProps {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoCalendarConnProps reference.
		public IntPtr GetObjectPtr() {
			IntPtr nPropValue = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(propValue ?? string.Empty);

			VidyoCalendarConnPropsSetpropTypeNative(objPtr, propType);
			VidyoCalendarConnPropsSetpropValueNative(objPtr, nPropValue);

			Marshal.FreeHGlobal(nPropValue);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern CalendarConnectParamType VidyoCalendarConnPropsGetpropTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCalendarConnPropsSetpropTypeNative(IntPtr obj, CalendarConnectParamType propType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarConnPropsGetpropValueNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCalendarConnPropsSetpropValueNative(IntPtr obj, IntPtr propValue);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoCalendarConnPropsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoCalendarConnPropsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoCalendarConnPropsDestructNative(IntPtr obj);

		/// <summary>
		/// This type indicates the connection parameter types that would be required for connecting to a specific calendar service.
		/// </summary>
		public enum CalendarConnectParamType {
			/// <summary>Undefined type.</summary>
			CalendarconnectparamtypeUnknown,
			/// <summary>Parameter type that specifies a user ID string.</summary>
			CalendarconnectparamtypeUserId,
			/// <summary>Parameter type that specifies a password or token string.</summary>
			CalendarconnectparamtypePasswordToken,
			/// <summary>Parameter type that specifies a mailbox name string.</summary>
			CalendarconnectparamtypeMailbox,
			/// <summary>Parameter type that specifies a server address string.</summary>
			CalendarconnectparamtypeServerAddress
		}
		/// <summary>
		/// 
		/// </summary>
		public CalendarConnectParamType propType;
		/// <summary>
		/// 
		/// </summary>
		public String propValue;
		public CalendarConnProps(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoCalendarConnPropsConstructDefaultNative();
			}
			else {
				objPtr = VidyoCalendarConnPropsConstructCopyNative(obj);
			}

			propType = VidyoCalendarConnPropsGetpropTypeNative(objPtr);
			propValue = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoCalendarConnPropsGetpropValueNative(objPtr));
		}
		~CalendarConnProps() {
			VidyoCalendarConnPropsDestructNative(objPtr);
		 }
	};
}
