// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class CameraControlCommandFactory
	{
		public static CameraControlCommand Create()
		{
			return new CameraControlCommand(IntPtr.Zero);
		}
		public static void Destroy(CameraControlCommand obj)
		{
		}
	}
	/// <summary>
	/// Represents the camera control structure.
	/// </summary>
	public class CameraControlCommand {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoCameraControlCommand reference.
		public IntPtr GetObjectPtr() {
			IntPtr nViscaCmd = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(viscaCmd ?? string.Empty);

			VidyoCameraControlCommandSetactionNative(objPtr, action);
			VidyoCameraControlCommandSetdirectionNative(objPtr, direction);
			VidyoCameraControlCommandSetpresetIdNative(objPtr, presetId);
			VidyoCameraControlCommandSetviscaCmdNative(objPtr, nViscaCmd);

			Marshal.FreeHGlobal(nViscaCmd);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern CameraControlCapabilities.CameraControlAction VidyoCameraControlCommandGetactionNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCommandSetactionNative(IntPtr obj, CameraControlCapabilities.CameraControlAction action);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern CameraControlCapabilities.CameraControlDirection VidyoCameraControlCommandGetdirectionNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCommandSetdirectionNative(IntPtr obj, CameraControlCapabilities.CameraControlDirection direction);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoCameraControlCommandGetpresetIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCommandSetpresetIdNative(IntPtr obj, uint presetId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCameraControlCommandGetviscaCmdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCommandSetviscaCmdNative(IntPtr obj, IntPtr viscaCmd);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoCameraControlCommandConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoCameraControlCommandConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoCameraControlCommandDestructNative(IntPtr obj);

		/// <summary>
		/// Represents the camera control action, refer VidyoCameraControlAction.
		/// </summary>
		public CameraControlCapabilities.CameraControlAction action;
		/// <summary>
		/// Represents the direction of camera control, refer VidyoCameraControlDirection.
		/// </summary>
		public CameraControlCapabilities.CameraControlDirection direction;
		/// <summary>
		/// Represents the preset id.
		/// </summary>
		public uint presetId;
		/// <summary>
		/// Represents the visca command.
		/// </summary>
		public String viscaCmd;
		public CameraControlCommand(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoCameraControlCommandConstructDefaultNative();
			}
			else {
				objPtr = VidyoCameraControlCommandConstructCopyNative(obj);
			}

			action = VidyoCameraControlCommandGetactionNative(objPtr);
			direction = VidyoCameraControlCommandGetdirectionNative(objPtr);
			presetId = VidyoCameraControlCommandGetpresetIdNative(objPtr);
			viscaCmd = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoCameraControlCommandGetviscaCmdNative(objPtr));
		}
		~CameraControlCommand() {
			VidyoCameraControlCommandDestructNative(objPtr);
		 }
	};
}
