// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class ChatMessageFactory
	{
		public static ChatMessage Create()
		{
			return new ChatMessage(IntPtr.Zero);
		}
		public static void Destroy(ChatMessage obj)
		{
		}
	}
	/// <summary>
	/// Contains the text message and additional information about who sent it and when.
	/// </summary>
	public class ChatMessage {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoChatMessage reference.
		public IntPtr GetObjectPtr() {
			IntPtr nBody = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(body ?? string.Empty);
			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nUserName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userName ?? string.Empty);

			VidyoChatMessageSetbodyNative(objPtr, nBody);
			VidyoChatMessageSetidNative(objPtr, id);
			VidyoChatMessageSetsenderTypeNative(objPtr, senderType);
			VidyoChatMessageSettimestampNative(objPtr, timestamp);
			VidyoChatMessageSettypeNative(objPtr, type);
			VidyoChatMessageSetuserIdNative(objPtr, nUserId);
			VidyoChatMessageSetuserNameNative(objPtr, nUserName);

			Marshal.FreeHGlobal(nUserName);
			Marshal.FreeHGlobal(nUserId);
			Marshal.FreeHGlobal(nBody);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoChatMessageGetbodyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoChatMessageSetbodyNative(IntPtr obj, IntPtr body);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern long VidyoChatMessageGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoChatMessageSetidNative(IntPtr obj, long id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ChatMessageSenderType VidyoChatMessageGetsenderTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoChatMessageSetsenderTypeNative(IntPtr obj, ChatMessageSenderType senderType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoChatMessageGettimestampNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoChatMessageSettimestampNative(IntPtr obj, ulong timestamp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ChatMessageType VidyoChatMessageGettypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoChatMessageSettypeNative(IntPtr obj, ChatMessageType type);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoChatMessageGetuserIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoChatMessageSetuserIdNative(IntPtr obj, IntPtr userId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoChatMessageGetuserNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoChatMessageSetuserNameNative(IntPtr obj, IntPtr userName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoChatMessageConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoChatMessageConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoChatMessageDestructNative(IntPtr obj);

		/// <summary>
		/// Type of the VidyoChatMessage sender.
		/// </summary>
		public enum ChatMessageSenderType {
			/// <summary>VidyoChatMessage is from a VidyoUser represented by VidyoParticipant in VidyoRoom/VidyoCall.</summary>
			ChatmessagesendertypeUser,
			/// <summary>VidyoChatMessage is from a VidyoRoom.</summary>
			ChatmessagesendertypeRoom,
			/// <summary>VidyoChatMessage is from the system.</summary>
			ChatmessagesendertypeSystem,
			/// <summary>Sender type is not set.</summary>
			ChatmessagesendertypeNone
		}
		/// <summary>
		/// Type of a message. This type will depend on the content of the message or where it originated.
		/// </summary>
		public enum ChatMessageType {
			/// <summary>Text chat message from another VidyoParticipant.</summary>
			ChatmessagetypeChat,
			/// <summary>Media was enabled in the room. This indicates that someone enabled their camera/microphone/etc and would like to escalate the VidyoRoom to audio/video.</summary>
			ChatmessagetypeMediaStart,
			/// <summary>Media was disabled in the room. This indicates that there are no more audio/video in the VidyoRoom.</summary>
			ChatmessagetypeMediaStop,
			/// <summary>Private text chat message from another VidyoParticipant.</summary>
			ChatmessagetypePrivateChat
		}
		/// <summary>
		/// Typing indicator of VidyoParticipant state in the VidyoRoom.
		/// </summary>
		public enum ChatMessageTypingIndication {
			/// <summary>Active and responsive.</summary>
			ChatmessagetypingindicationActive,
			/// <summary>Composing a text message.</summary>
			ChatmessagetypingindicationComposing,
			/// <summary>Closed the chat window.</summary>
			ChatmessagetypingindicationGone,
			/// <summary>Inactive for reasons such as the chat is out of focus.</summary>
			ChatmessagetypingindicationInactive,
			/// <summary>Paused composing a message.</summary>
			ChatmessagetypingindicationPaused,
			/// <summary>Not set.</summary>
			ChatmessagetypingindicationNone
		}
		/// <summary>
		/// The body of the VidyoChatMessage.
		/// </summary>
		public String body;
		/// <summary>
		/// Unique ID of the VidyoChatMessage.
		/// </summary>
		public long id;
		/// <summary>
		/// The type of the sender.
		/// </summary>
		public ChatMessageSenderType senderType;
		/// <summary>
		/// The time when the message was created.
		/// </summary>
		public ulong timestamp;
		/// <summary>
		/// The type of VidyoChatMessage.
		/// </summary>
		public ChatMessageType type;
		/// <summary>
		/// Unique ID of a VidyoParticipant who sent the message or NULL depending on the VidyoChatMessageSenderType.
		/// </summary>
		public String userId;
		/// <summary>
		/// Name of a VidyoParticipant who sent the message.
		/// </summary>
		public String userName;
		public ChatMessage(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoChatMessageConstructDefaultNative();
			}
			else {
				objPtr = VidyoChatMessageConstructCopyNative(obj);
			}

			body = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoChatMessageGetbodyNative(objPtr));
			id = VidyoChatMessageGetidNative(objPtr);
			senderType = VidyoChatMessageGetsenderTypeNative(objPtr);
			timestamp = VidyoChatMessageGettimestampNative(objPtr);
			type = VidyoChatMessageGettypeNative(objPtr);
			userId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoChatMessageGetuserIdNative(objPtr));
			userName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoChatMessageGetuserNameNative(objPtr));
		}
		~ChatMessage() {
			VidyoChatMessageDestructNative(objPtr);
		 }
	};
}
