// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class ConnectorConnectionPropertiesFactory
	{
		public static ConnectorConnectionProperties Create()
		{
			return new ConnectorConnectionProperties(IntPtr.Zero);
		}
		public static void Destroy(ConnectorConnectionProperties obj)
		{
		}
	}
	/// <summary>
	/// Represents the connection properties structure, which are based on information from the portal.
	/// </summary>
	public class ConnectorConnectionProperties {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoConnectorConnectionProperties reference.
		public IntPtr GetObjectPtr() {
			IntPtr nRoomName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomName ?? string.Empty);

			VidyoConnectorConnectionPropertiesSethasModeratorPinNative(objPtr, hasModeratorPin);
			VidyoConnectorConnectionPropertiesSethasRoomPinNative(objPtr, hasRoomPin);
			VidyoConnectorConnectionPropertiesSetisRoomLockedNative(objPtr, isRoomLocked);
			VidyoConnectorConnectionPropertiesSetisVp9EnabledNative(objPtr, isVp9Enabled);
			VidyoConnectorConnectionPropertiesSetmaxReceiveBandWidthNative(objPtr, maxReceiveBandWidth);
			VidyoConnectorConnectionPropertiesSetmaxSendBandWidthNative(objPtr, maxSendBandWidth);
			VidyoConnectorConnectionPropertiesSetmaximumRoomPinLengthNative(objPtr, maximumRoomPinLength);
			VidyoConnectorConnectionPropertiesSetminimumRoomPinLengthNative(objPtr, minimumRoomPinLength);
			VidyoConnectorConnectionPropertiesSetrecordingStateNative(objPtr, recordingState);
			VidyoConnectorConnectionPropertiesSetroomNameNative(objPtr, nRoomName);
			VidyoConnectorConnectionPropertiesSetwebcastingStateNative(objPtr, webcastingState);

			Marshal.FreeHGlobal(nRoomName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectionPropertiesGethasModeratorPinNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSethasModeratorPinNative(IntPtr obj, Boolean hasModeratorPin);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectionPropertiesGethasRoomPinNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSethasRoomPinNative(IntPtr obj, Boolean hasRoomPin);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectionPropertiesGetisRoomLockedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetisRoomLockedNative(IntPtr obj, Boolean isRoomLocked);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectionPropertiesGetisVp9EnabledNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetisVp9EnabledNative(IntPtr obj, Boolean isVp9Enabled);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorConnectionPropertiesGetmaxReceiveBandWidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetmaxReceiveBandWidthNative(IntPtr obj, uint maxReceiveBandWidth);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorConnectionPropertiesGetmaxSendBandWidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetmaxSendBandWidthNative(IntPtr obj, uint maxSendBandWidth);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoConnectorConnectionPropertiesGetmaximumRoomPinLengthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetmaximumRoomPinLengthNative(IntPtr obj, int maximumRoomPinLength);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoConnectorConnectionPropertiesGetminimumRoomPinLengthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetminimumRoomPinLengthNative(IntPtr obj, int minimumRoomPinLength);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Connector.ConnectorRecordingState VidyoConnectorConnectionPropertiesGetrecordingStateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetrecordingStateNative(IntPtr obj, Connector.ConnectorRecordingState recordingState);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorConnectionPropertiesGetroomNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetroomNameNative(IntPtr obj, IntPtr roomName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Connector.ConnectorWebcastingState VidyoConnectorConnectionPropertiesGetwebcastingStateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorConnectionPropertiesSetwebcastingStateNative(IntPtr obj, Connector.ConnectorWebcastingState webcastingState);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoConnectorConnectionPropertiesConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoConnectorConnectionPropertiesConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoConnectorConnectionPropertiesDestructNative(IntPtr obj);

		/// <summary>
		/// Return LMI_TRUE if moderation pin is set otherwise LMI_FALSE.
		/// </summary>
		public Boolean hasModeratorPin;
		/// <summary>
		/// Return LMI_TRUE if room pin is set otherwise LMI_FALSE.
		/// </summary>
		public Boolean hasRoomPin;
		/// <summary>
		/// Return LMI_TRUE if room is lock otherwise LMI_FALSE.
		/// </summary>
		public Boolean isRoomLocked;
		/// <summary>
		/// Return LMI_TRUE if VP9 is enabled otherwise LMI_FALSE.
		/// </summary>
		public Boolean isVp9Enabled;
		/// <summary>
		/// Represents the maximum receive bandwidth.
		/// </summary>
		public uint maxReceiveBandWidth;
		/// <summary>
		/// Represents the maximum send bandwidth.
		/// </summary>
		public uint maxSendBandWidth;
		/// <summary>
		/// Return the maximum room pin length if maximumRoomPinLength is set by default.
		/// </summary>
		public int maximumRoomPinLength;
		/// <summary>
		/// Return the minimum room pin length if minimumRoomPinLength is set by default.
		/// </summary>
		public int minimumRoomPinLength;
		/// <summary>
		/// State of Recording. See enum VidyoConnectorRecordingState.
		/// </summary>
		public Connector.ConnectorRecordingState recordingState;
		/// <summary>
		/// Name of the room.
		/// </summary>
		public String roomName;
		/// <summary>
		/// State of Webcasting. See enum VidyoConnectorWebcastingState.
		/// </summary>
		public Connector.ConnectorWebcastingState webcastingState;
		public ConnectorConnectionProperties(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoConnectorConnectionPropertiesConstructDefaultNative();
			}
			else {
				objPtr = VidyoConnectorConnectionPropertiesConstructCopyNative(obj);
			}

			hasModeratorPin = VidyoConnectorConnectionPropertiesGethasModeratorPinNative(objPtr);
			hasRoomPin = VidyoConnectorConnectionPropertiesGethasRoomPinNative(objPtr);
			isRoomLocked = VidyoConnectorConnectionPropertiesGetisRoomLockedNative(objPtr);
			isVp9Enabled = VidyoConnectorConnectionPropertiesGetisVp9EnabledNative(objPtr);
			maxReceiveBandWidth = VidyoConnectorConnectionPropertiesGetmaxReceiveBandWidthNative(objPtr);
			maxSendBandWidth = VidyoConnectorConnectionPropertiesGetmaxSendBandWidthNative(objPtr);
			maximumRoomPinLength = VidyoConnectorConnectionPropertiesGetmaximumRoomPinLengthNative(objPtr);
			minimumRoomPinLength = VidyoConnectorConnectionPropertiesGetminimumRoomPinLengthNative(objPtr);
			recordingState = VidyoConnectorConnectionPropertiesGetrecordingStateNative(objPtr);
			roomName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorConnectionPropertiesGetroomNameNative(objPtr));
			webcastingState = VidyoConnectorConnectionPropertiesGetwebcastingStateNative(objPtr);
		}
		~ConnectorConnectionProperties() {
			VidyoConnectorConnectionPropertiesDestructNative(objPtr);
		 }
	};
}
