// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class EndpointCameraEffectInfoFactory
	{
		public static EndpointCameraEffectInfo Create()
		{
			return new EndpointCameraEffectInfo(IntPtr.Zero);
		}
		public static void Destroy(EndpointCameraEffectInfo obj)
		{
		}
	}
	/// <summary>
	/// Represent the configuration of camera background effect.
	/// </summary>
	public class EndpointCameraEffectInfo {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoEndpointCameraEffectInfo reference.
		public IntPtr GetObjectPtr() {
			IntPtr nPathToEffect = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(pathToEffect ?? string.Empty);
			IntPtr nPathToResources = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(pathToResources ?? string.Empty);
			IntPtr nToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(token ?? string.Empty);
			IntPtr nVirtualBackgroundPicture = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(virtualBackgroundPicture ?? string.Empty);

			VidyoEndpointCameraEffectInfoSetblurIntensityNative(objPtr, blurIntensity);
			VidyoEndpointCameraEffectInfoSeteffectTypeNative(objPtr, effectType);
			VidyoEndpointCameraEffectInfoSetpathToEffectNative(objPtr, nPathToEffect);
			VidyoEndpointCameraEffectInfoSetpathToResourcesNative(objPtr, nPathToResources);
			VidyoEndpointCameraEffectInfoSettokenNative(objPtr, nToken);
			VidyoEndpointCameraEffectInfoSetvirtualBackgroundPictureNative(objPtr, nVirtualBackgroundPicture);

			Marshal.FreeHGlobal(nVirtualBackgroundPicture);
			Marshal.FreeHGlobal(nToken);
			Marshal.FreeHGlobal(nPathToResources);
			Marshal.FreeHGlobal(nPathToEffect);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoEndpointCameraEffectInfoGetblurIntensityNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointCameraEffectInfoSetblurIntensityNative(IntPtr obj, uint blurIntensity);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Endpoint.EndpointCameraEffectType VidyoEndpointCameraEffectInfoGeteffectTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointCameraEffectInfoSeteffectTypeNative(IntPtr obj, Endpoint.EndpointCameraEffectType effectType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointCameraEffectInfoGetpathToEffectNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointCameraEffectInfoSetpathToEffectNative(IntPtr obj, IntPtr pathToEffect);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointCameraEffectInfoGetpathToResourcesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointCameraEffectInfoSetpathToResourcesNative(IntPtr obj, IntPtr pathToResources);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointCameraEffectInfoGettokenNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointCameraEffectInfoSettokenNative(IntPtr obj, IntPtr token);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointCameraEffectInfoGetvirtualBackgroundPictureNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointCameraEffectInfoSetvirtualBackgroundPictureNative(IntPtr obj, IntPtr virtualBackgroundPicture);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoEndpointCameraEffectInfoConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoEndpointCameraEffectInfoConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoEndpointCameraEffectInfoDestructNative(IntPtr obj);

		/// <summary>
		/// Blur intensity. Valid valies is [3-8]. Default value is 5. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_Blur
		/// </summary>
		public uint blurIntensity;
		/// <summary>
		/// Type of the camera background effect. In case VIDYO_CONNECTORCAMERAEFFECTTYPE_None is set no need to set other fields.
		/// </summary>
		public Endpoint.EndpointCameraEffectType effectType;
		/// <summary>
		/// The path to effect. A directory with supported effect is packaged with VidyoClient library.
		/// </summary>
		public String pathToEffect;
		/// <summary>
		/// The path to resources like a model and its configuration. A directory with supported resources is packaged with VidyoClient library.
		/// </summary>
		public String pathToResources;
		/// <summary>
		/// The token for enabling the camera background effect. The blank string is NOT allowed. In case the token is not valid or expired enabling of camera background effect will fail.
		/// </summary>
		public String token;
		/// <summary>
		/// The path to the picture that will be used for the virtual background. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_VirtualBackground.
		/// </summary>
		public String virtualBackgroundPicture;
		public EndpointCameraEffectInfo(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoEndpointCameraEffectInfoConstructDefaultNative();
			}
			else {
				objPtr = VidyoEndpointCameraEffectInfoConstructCopyNative(obj);
			}

			blurIntensity = VidyoEndpointCameraEffectInfoGetblurIntensityNative(objPtr);
			effectType = VidyoEndpointCameraEffectInfoGeteffectTypeNative(objPtr);
			pathToEffect = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointCameraEffectInfoGetpathToEffectNative(objPtr));
			pathToResources = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointCameraEffectInfoGetpathToResourcesNative(objPtr));
			token = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointCameraEffectInfoGettokenNative(objPtr));
			virtualBackgroundPicture = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointCameraEffectInfoGetvirtualBackgroundPictureNative(objPtr));
		}
		~EndpointCameraEffectInfo() {
			VidyoEndpointCameraEffectInfoDestructNative(objPtr);
		 }
	};
}
