// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class FormFieldFactory
	{
		public static FormField Create()
		{
			return new FormField(IntPtr.Zero);
		}
		public static void Destroy(FormField obj)
		{
		}
	}
	/// <summary>
	/// Attributes related to an HTML form input field.
	/// </summary>
	public class FormField {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoFormField reference.
		public IntPtr GetObjectPtr() {
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nOptions = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * options.Count);
			int nOptionsSize = 0;
			IntPtr nValue = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(value ?? string.Empty);

			foreach (FormFieldOption iter in options) {
				Marshal.WriteIntPtr(nOptions + (nOptionsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nOptionsSize++;
			}

			VidyoFormFieldSetcolsNative(objPtr, cols);
			VidyoFormFieldSetmaxlengthNative(objPtr, maxlength);
			VidyoFormFieldSetmultipleNative(objPtr, multiple);
			VidyoFormFieldSetnameNative(objPtr, nName);
			VidyoFormFieldSetoptionsNative(objPtr, nOptions, nOptionsSize);
			VidyoFormFieldSetrowsNative(objPtr, rows);
			VidyoFormFieldSetsizeNative(objPtr, size);
			VidyoFormFieldSettypeNative(objPtr, type);
			VidyoFormFieldSetvalueNative(objPtr, nValue);
			VidyoFormFieldSetwrapNative(objPtr, wrap);

			Marshal.FreeHGlobal(nValue);
			Marshal.FreeHGlobal(nOptions);
			Marshal.FreeHGlobal(nName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoFormFieldGetcolsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetcolsNative(IntPtr obj, uint cols);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoFormFieldGetmaxlengthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetmaxlengthNative(IntPtr obj, uint maxlength);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoFormFieldGetmultipleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetmultipleNative(IntPtr obj, Boolean multiple);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoFormFieldGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoFormFieldGetoptionsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetoptionsNative(IntPtr obj, IntPtr options, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoFormFieldGetoptionsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldFreeoptionsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoFormFieldGetrowsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetrowsNative(IntPtr obj, uint rows);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoFormFieldGetsizeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetsizeNative(IntPtr obj, uint size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern FormFieldType VidyoFormFieldGettypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSettypeNative(IntPtr obj, FormFieldType type);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoFormFieldGetvalueNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetvalueNative(IntPtr obj, IntPtr value);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern FormFieldTextWrapMode VidyoFormFieldGetwrapNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoFormFieldSetwrapNative(IntPtr obj, FormFieldTextWrapMode wrap);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoFormFieldConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoFormFieldConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoFormFieldDestructNative(IntPtr obj);

		/// <summary>
		/// For a textarea input field, the number of columns the field should show
		/// </summary>
		public uint cols;
		/// <summary>
		/// Maximum number of characters allowed for the input field
		/// </summary>
		public uint maxlength;
		/// <summary>
		/// For a select drop-down input field, whether multiple selections are allowed
		/// </summary>
		public Boolean multiple;
		/// <summary>
		/// Label used to uniquely identify the input field for this element
		/// </summary>
		public String name;
		/// <summary>
		/// For a select drop-down input field, a list of the options and their selection status
		/// </summary>
		public List<FormFieldOption> options;
		/// <summary>
		/// For a textarea input field, the number of rows the field should show
		/// </summary>
		public uint rows;
		/// <summary>
		/// Number of characters for the value
		/// </summary>
		public uint size;
		/// <summary>
		/// Type that corresponds to the HTML form input fields that can be used to display and collect user data
		/// </summary>
		public FormFieldType type;
		/// <summary>
		/// Default value to display in the input field if this struct is returned to the application, or a collected user input if this structure is passed back as a method argument
		/// </summary>
		public String value;
		/// <summary>
		/// For a textarea input field, how linebreaks should be handled
		/// </summary>
		public FormFieldTextWrapMode wrap;
		public FormField(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoFormFieldConstructDefaultNative();
			}
			else {
				objPtr = VidyoFormFieldConstructCopyNative(obj);
			}

			List<FormFieldOption> csOptions = new List<FormFieldOption>();
			var nOptionsSize = 0;
			var nOptions = VidyoFormFieldGetoptionsArrayNative(VidyoFormFieldGetoptionsNative(objPtr), ref nOptionsSize);
			var nOptionsIndex = 0;
			while (nOptionsIndex < nOptionsSize) {
				FormFieldOption csToptions = new FormFieldOption(Marshal.ReadIntPtr(nOptions + (nOptionsIndex * Marshal.SizeOf(nOptions))));
				csOptions.Add(csToptions);
				nOptionsIndex++;
			}

			cols = VidyoFormFieldGetcolsNative(objPtr);
			maxlength = VidyoFormFieldGetmaxlengthNative(objPtr);
			multiple = VidyoFormFieldGetmultipleNative(objPtr);
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoFormFieldGetnameNative(objPtr));
			options = csOptions;
			rows = VidyoFormFieldGetrowsNative(objPtr);
			size = VidyoFormFieldGetsizeNative(objPtr);
			type = VidyoFormFieldGettypeNative(objPtr);
			value = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoFormFieldGetvalueNative(objPtr));
			wrap = VidyoFormFieldGetwrapNative(objPtr);
			VidyoFormFieldFreeoptionsArrayNative(nOptions, nOptionsSize);
		}
		~FormField() {
			VidyoFormFieldDestructNative(objPtr);
		 }
	};
}
