// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LatencyTestDataStatsFactory
	{
		public static LatencyTestDataStats Create()
		{
			return new LatencyTestDataStats(IntPtr.Zero);
		}
		public static void Destroy(LatencyTestDataStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a latency test.
	/// </summary>
	public class LatencyTestDataStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLatencyTestDataStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nAddress = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(address ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoLatencyTestDataStatsSetaddressNative(objPtr, nAddress);
			VidyoLatencyTestDataStatsSetlatencyMsNative(objPtr, latencyMs);
			VidyoLatencyTestDataStatsSetlatitudeNative(objPtr, latitude);
			VidyoLatencyTestDataStatsSetlongitudeNative(objPtr, longitude);
			VidyoLatencyTestDataStatsSetnameNative(objPtr, nName);
			VidyoLatencyTestDataStatsSetresponseReceivedNative(objPtr, responseReceived);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nAddress);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLatencyTestDataStatsGetaddressNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestDataStatsSetaddressNative(IntPtr obj, IntPtr address);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLatencyTestDataStatsGetlatencyMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestDataStatsSetlatencyMsNative(IntPtr obj, uint latencyMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern double VidyoLatencyTestDataStatsGetlatitudeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestDataStatsSetlatitudeNative(IntPtr obj, double latitude);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern double VidyoLatencyTestDataStatsGetlongitudeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestDataStatsSetlongitudeNative(IntPtr obj, double longitude);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLatencyTestDataStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestDataStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLatencyTestDataStatsGetresponseReceivedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestDataStatsSetresponseReceivedNative(IntPtr obj, Boolean responseReceived);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLatencyTestDataStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLatencyTestDataStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLatencyTestDataStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Address of the latency test host.
		/// </summary>
		public String address;
		/// <summary>
		/// Latency to the host in milliseconds.
		/// </summary>
		public uint latencyMs;
		/// <summary>
		/// Latitude of the host.
		/// </summary>
		public double latitude;
		/// <summary>
		/// Longitude of the host.
		/// </summary>
		public double longitude;
		/// <summary>
		/// Name of the latency test host.
		/// </summary>
		public String name;
		/// <summary>
		/// Response has been received from the host.
		/// </summary>
		public Boolean responseReceived;
		public LatencyTestDataStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLatencyTestDataStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLatencyTestDataStatsConstructCopyNative(obj);
			}

			address = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLatencyTestDataStatsGetaddressNative(objPtr));
			latencyMs = VidyoLatencyTestDataStatsGetlatencyMsNative(objPtr);
			latitude = VidyoLatencyTestDataStatsGetlatitudeNative(objPtr);
			longitude = VidyoLatencyTestDataStatsGetlongitudeNative(objPtr);
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLatencyTestDataStatsGetnameNative(objPtr));
			responseReceived = VidyoLatencyTestDataStatsGetresponseReceivedNative(objPtr);
		}
		~LatencyTestDataStats() {
			VidyoLatencyTestDataStatsDestructNative(objPtr);
		 }
	};
}
