// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// 
	/// </summary>
	public class LocalRenderer: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalRenderer reference.
		private GCHandle objHandle; // weak VidyoLocalRenderer reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalRendererConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererDisableNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererEnableExpandedCameraControlNative(IntPtr r, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererEnableFECCIconCustomLayoutNative(IntPtr r, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererEnablePreviewMirroringNative(IntPtr r, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererEnableSelfViewCustomLayoutNative(IntPtr renderer, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererEnableShowAudioTilesNative(IntPtr r, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererEnableTouchInputDeviceNative(IntPtr r, Boolean isTouchInputDevice);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererEnableVerticalVideoCenteringNative(IntPtr r, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalRendererGetIdNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalRendererGetNameNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern double VidyoLocalRendererGetPixelDensityNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern double VidyoLocalRendererGetViewingDistanceNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsExpandedCameraControlEnabledNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsFECCIconCustomLayoutEnabledNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsPausedNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsPreviewMirroringEnabledNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsSelectedTileControllingRemoteCameraNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsShowAudioTilesEnabledNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsTouchInputDeviceEnabledNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererIsVerticalVideoCenteringEnabledNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererPauseNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererPinParticipantNative(IntPtr r, IntPtr p, Boolean pin);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererRegisterPipEventListenerNative(IntPtr r, OnPipLocationChanged onPipLocationChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererResumeNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetAllowContentMultiScreenNative(IntPtr r, Boolean allow, uint displayIndex);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetAllowPreviewMultiScreenNative(IntPtr r, Boolean allow, uint displayIndex);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetAnimationSpeedNative(IntPtr renderer, uint speedPercentage);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetBackgroundColorNative(IntPtr renderer, byte red, byte green, byte blue);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererSetBorderStyleNative(IntPtr ct, [MarshalAs(UnmanagedType.I4)]LocalRendererBorderStyle style);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetCroppedNative(IntPtr renderer, Boolean cropped);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetMaxCroppingNative(IntPtr r, uint maxCropPct);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetMaxStreamsNative(IntPtr r, uint numStreams);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetMaxStreamsMultiScreenNative(IntPtr r, uint numStreams, uint displayIndex);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetNumPreferredNative(IntPtr r, uint numPreferred);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetParametersForHighDPIDeviceNative(IntPtr r, double pixelsPerInch, double viewingDistance, Boolean isTouchInputDevice);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetPipPositionNative(IntPtr r, [MarshalAs(UnmanagedType.I4)]LocalRendererPipPosition x, [MarshalAs(UnmanagedType.I4)]LocalRendererPipPosition y, Boolean lockPip);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetPixelDensityNative(IntPtr r, double pixelsPerInch);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetPositionNative(IntPtr r, int x, int y, uint width, uint height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetPriorityMultiScreenNative(IntPtr r, uint priority, uint displayIndex);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetRemoteWindowSharePinModeNative(IntPtr r, Boolean autoPin);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetTilesBackgroundColorNative(IntPtr renderer, byte red, byte green, byte blue);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererSetViewingDistanceNative(IntPtr r, double viewingDistanceFt);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererShowAudioMetersNative(IntPtr renderer, Boolean showMeters);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererShowDebugStatsNative(IntPtr renderer, Boolean showStats);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererShowLabelNative(IntPtr renderer, Boolean showLabel);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalRendererUnregisterPipEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalRendererGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalRendererSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnPipLocationChanged(IntPtr renderer, int x, int y, uint width, uint height, Boolean isExpanded);
		private OnPipLocationChanged _mOnPipLocationChanged = OnPipLocationChangedDelegate;
		/// <summary>
		/// Controls the use of tile borders in the scene.
		/// </summary>
		public enum LocalRendererBorderStyle {
			/// <summary>Do not put a border on any tiles.</summary>
			LocalrendererborderstyleNone,
			/// <summary>Put the same colored border on each tile.</summary>
			LocalrendererborderstyleSame,
			/// <summary>Put a border on each tile, but tiles associated with the highest ranked participant (as told to LmiConferenceSceneSetPreference) will have a different colored border than the others.</summary>
			LocalrendererborderstyleHighlight,
			/// <summary>Tiles associated with the highest ranked participant have a different colored border than the others. When the highest ranked participant changes, the border of the new highest ranked participant flashes momentarily.</summary>
			LocalrendererborderstyleFlash
		}
		/// <summary>
		/// Indicates the position of the preview with respect to one dimension.
		/// </summary>
		public enum LocalRendererPipPosition {
			/// <summary>The preview is at its minimum value along this dimension. This means to the left for the horizontal position and down for the vertical position.</summary>
			LocalrendererpippositionMIN,
			/// <summary>The preview is centered with respect to this dimension.</summary>
			LocalrendererpippositionCENTER,
			/// <summary>The preview is at its maximum value along this dimension. This means to the right for the horizontal position and up for the vertical position.</summary>
			LocalrendererpippositionMAX,
			/// <summary>The preview type is not valid.</summary>
			LocalrendererpippositionINVALID
		}
		/// <summary>
		/// Styles of the composite renderer, which apply to its layout and behaviour.
		/// </summary>
		public enum LocalRendererViewStyle {
			/// <summary>The default style.</summary>
			LocalrendererviewstyleDefault,
			/// <summary>Participants are shown in sizes that best reflect their order of importance.</summary>
			LocalrendererviewstyleTiles,
			/// <summary>Participants are shown in sizes that best reflect their order of importance, with large Remote Camera Control buttons if applicable.</summary>
			LocalrendererviewstyleTilesWithRemoteCameraControlV2,
			/// <summary>The next generation renderer with grid layout.</summary>
			LocalrendererviewstyleNGRGrid,
			/// <summary>The next generation renderer with speaker layout.</summary>
			LocalrendererviewstyleNGRSpeaker
		}
		public interface IRegisterPipEventListener{

			void OnPipLocationChanged(int x, int y, uint width, uint height, Boolean isExpanded);
		}
		private IRegisterPipEventListener _mIRegisterPipEventListener;
		public LocalRenderer(IntPtr other){
			objPtr = VidyoLocalRendererConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoLocalRendererSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~LocalRenderer(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoLocalRendererSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoLocalRendererDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public Boolean Disable() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererDisableNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Enable or disable the expanded camera control to composite renderer.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="enable">LMI_TRUE to enable the expanded camera control to composite renderer, LMI_FALSE to disable expanded camera control to composite renderer.</param>
		public Boolean EnableExpandedCameraControl(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererEnableExpandedCameraControlNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// Enable or disable the displaying of custom FECC icon in the right bottom corner.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="enable">LMI_TRUE to show custom FECC icon in the right bottom corner, LMI_FALSE to show default FECC icon in the right top corner.</param>
		public Boolean EnableFECCIconCustomLayout(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererEnableFECCIconCustomLayoutNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// Enable or disable the preview mirroring to composite renderer.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="enable">LMI_TRUE to enable the preview mirroring to composite renderer, LMI_FALSE to disable preview mirroring to composite renderer.</param>
		public Boolean EnablePreviewMirroring(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererEnablePreviewMirroringNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// Enable or disable the displaying of picture-in-picture in a custom way.
		/// </summary>
		/// <param name="renderer">The local renderer object.</param>
		/// <param name="enable">LMI_TRUE to always show picture-in-picture, LMI_FALSE to show picture-in-picture with two tiles.</param>
		public void EnableSelfViewCustomLayout(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalRendererEnableSelfViewCustomLayoutNative(objPtr, enable);
		}
		/// <summary>
		/// Enable or disable the show audio tiles to composite renderer.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="enable">LMI_TRUE to enable the audio tiles to composite renderer, LMI_FALSE to disable audio tiles to composite renderer.</param>
		public Boolean EnableShowAudioTiles(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererEnableShowAudioTilesNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// Enable or disable touch as a input device.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="isTouchInputDevice">To indicate input method of this device is TOUCH (vs default MOUSE input).</param>
		public Boolean EnableTouchInputDevice(Boolean isTouchInputDevice) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererEnableTouchInputDeviceNative(objPtr, isTouchInputDevice);

			return ret;
		}
		/// <summary>
		/// Enable or disable the vertical centering of the video screen.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="enable">LMI_TRUE to show the center of video screen vertically if it's bigger than tile, LMI_FALSE to show the top of video screen vertically.</param>
		public Boolean EnableVerticalVideoCentering(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererEnableVerticalVideoCenteringNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalRendererGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalRendererGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the rendering environment's pixel density.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public double GetPixelDensity() {
			if (objPtr == IntPtr.Zero) { return default; }

			double ret = VidyoLocalRendererGetPixelDensityNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Get the viewing distance. This is the distance from the viewer's eye to the screen.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public double GetViewingDistance() {
			if (objPtr == IntPtr.Zero) { return default; }

			double ret = VidyoLocalRendererGetViewingDistanceNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Retrieves the status of the expanded camera control on composite renderer.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean IsExpandedCameraControlEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsExpandedCameraControlEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Get state of custom FECC icon.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean IsFECCIconCustomLayoutEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsFECCIconCustomLayoutEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public Boolean IsPaused() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsPausedNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Retrieves the status of the preview mirroring on composite renderer.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean IsPreviewMirroringEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsPreviewMirroringEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Query whether the currently-selected tile, if any, is in far-end camera-control (FECC) mode.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean IsSelectedTileControllingRemoteCamera() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsSelectedTileControllingRemoteCameraNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Retrieves the status of the show audio tiles on composite renderer.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean IsShowAudioTilesEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsShowAudioTilesEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Retrieves the status of the touch input device.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean IsTouchInputDeviceEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsTouchInputDeviceEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Get if the video screen is vertically centered.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean IsVerticalVideoCenteringEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererIsVerticalVideoCenteringEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public void Pause() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalRendererPauseNative(objPtr);
		}
		/// <summary>
		/// Pin or un-pin target participant camera. Pinned participant camera stream is always displayed unless muted. A single participant can be pinned at a time; subsequent pin will unpin previously pinned participant.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="p">The target participant.</param>
		/// <param name="pin">LMI_TRUE enable, LMI_FALSE for disable participant pin.</param>
		public Boolean PinParticipant(Participant p, Boolean pin) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererPinParticipantNative(objPtr, (p != null) ? p.GetObjectPtr():IntPtr.Zero, pin);

			return ret;
		}
		/// <summary>
		/// Registers to get notified when a a call is being recorded.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="onPipLocationChanged">.</param>
		public Boolean RegisterPipEventListener(IRegisterPipEventListener _iIRegisterPipEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterPipEventListener = _iIRegisterPipEventListener;

			Boolean ret = VidyoLocalRendererRegisterPipEventListenerNative(objPtr, _mOnPipLocationChanged);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public void Resume() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalRendererResumeNative(objPtr);
		}
		/// <summary>
		/// Set whether content tiles are allowed on the screen.
		/// </summary>
		/// <param name="r"></param>
		/// <param name="allow"></param>
		/// <param name="displayIndex"></param>
		public Boolean SetAllowContentMultiScreen(Boolean allow, uint displayIndex) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetAllowContentMultiScreenNative(objPtr, allow, displayIndex);

			return ret;
		}
		/// <summary>
		/// Set whether preview tiles are allowed on the screen.
		/// </summary>
		/// <param name="r"></param>
		/// <param name="allow"></param>
		/// <param name="displayIndex"></param>
		public Boolean SetAllowPreviewMultiScreen(Boolean allow, uint displayIndex) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetAllowPreviewMultiScreenNative(objPtr, allow, displayIndex);

			return ret;
		}
		/// <summary>
		/// If supported, sets the speed of transition animaiton 100 for slow, 0 for instant transition.
		/// </summary>
		/// <param name="renderer">The local renderer object to extract stats.</param>
		/// <param name="speedPercentage">Percentage of animation speed.</param>
		public Boolean SetAnimationSpeed(uint speedPercentage) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetAnimationSpeedNative(objPtr, speedPercentage);

			return ret;
		}
		/// <summary>
		/// Sets the background color of the renderer.
		/// </summary>
		/// <param name="renderer">The local renderer object to extract stats.</param>
		/// <param name="red">Red component of the color 0-255.</param>
		/// <param name="green">Green component of the color 0-255.</param>
		/// <param name="blue">Blue component of the color 0-255.</param>
		public Boolean SetBackgroundColor(byte red, byte green, byte blue) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetBackgroundColorNative(objPtr, red, green, blue);

			return ret;
		}
		/// <summary>
		/// Controls the use of tile borders in the scene. See VidyoLocalRendererBorderStyle.
		/// </summary>
		/// <param name="ct">The VidyoLocalRenderer object.</param>
		/// <param name="style">The new border style.</param>
		public void SetBorderStyle(LocalRendererBorderStyle style) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalRendererSetBorderStyleNative(objPtr, style);
		}
		/// <summary>
		/// Sets the video screams to be croped in the renderer.
		/// </summary>
		/// <param name="renderer">The local renderer object to extract stats.</param>
		/// <param name="cropped">Crop if LMI_TRUE, letter box if LMI_FALSE.</param>
		public Boolean SetCropped(Boolean cropped) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetCroppedNative(objPtr, cropped);

			return ret;
		}
		/// <summary>
		/// This function sets the maximum percentage of a dimension that can be cropped from a video.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="maxCropPct">When fitting a video into a tile, this sets the maximum percentage that can be cropped to achieve a better fit.</param>
		public Boolean SetMaxCropping(uint maxCropPct) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetMaxCroppingNative(objPtr, maxCropPct);

			return ret;
		}
		/// <summary>
		/// Sets the maximum number of streams that can be displayed in the renderer.
		/// </summary>
		/// <param name="r"></param>
		/// <param name="numStreams"></param>
		public Boolean SetMaxStreams(uint numStreams) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetMaxStreamsNative(objPtr, numStreams);

			return ret;
		}
		/// <summary>
		/// Sets the maximum number of streams that can be displayed in the renderer.
		/// </summary>
		/// <param name="r"></param>
		/// <param name="numStreams"></param>
		/// <param name="displayIndex"></param>
		public Boolean SetMaxStreamsMultiScreen(uint numStreams, uint displayIndex) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetMaxStreamsMultiScreenNative(objPtr, numStreams, displayIndex);

			return ret;
		}
		/// <summary>
		/// This function sets the number of preferred participants in the tile layout.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="numPreferred">number of preferred participants. Default is -1 which means auto. Otherwise value is 0 - 96.</param>
		public Boolean SetNumPreferred(uint numPreferred) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetNumPreferredNative(objPtr, numPreferred);

			return ret;
		}
		/// <summary>
		/// Set renderer parameters for high DPI devices.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="pixelsPerInch">The number of pixels per inch.</param>
		/// <param name="viewingDistance">The distance between user's eye to the device (in foot).</param>
		/// <param name="isTouchInputDevice">To indicate input method of this device is TOUCH (vs default MOUSE input).</param>
		public Boolean SetParametersForHighDPIDevice(double pixelsPerInch, double viewingDistance, Boolean isTouchInputDevice) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetParametersForHighDPIDeviceNative(objPtr, pixelsPerInch, viewingDistance, isTouchInputDevice);

			return ret;
		}
		/// <summary>
		/// Sets the position of the preview when it is displayed using picture-in-picture mode.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="x">The horizontal position of the preview.</param>
		/// <param name="y">The vertical position of the preview.</param>
		/// <param name="lockPip">A boolean indicating whether to lock the preview in this position. When false, the user may drag the preview to another location using the mouse or a touch.</param>
		public Boolean SetPipPosition(LocalRendererPipPosition x, LocalRendererPipPosition y, Boolean lockPip) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetPipPositionNative(objPtr, x, y, lockPip);

			return ret;
		}
		/// <summary>
		/// Sets the rendering environment's pixel density.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="pixelsPerInch">The pixel density in pixels per inch.</param>
		public Boolean SetPixelDensity(double pixelsPerInch) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetPixelDensityNative(objPtr, pixelsPerInch);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		public Boolean SetPosition(int x, int y, uint width, uint height) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetPositionNative(objPtr, x, y, width, height);

			return ret;
		}
		/// <summary>
		/// Sets the priority of one of the screens. Screens that have a smaller priority value will be considered higher priority, and will be given more important items to display.
		/// </summary>
		/// <param name="r"></param>
		/// <param name="priority"></param>
		/// <param name="displayIndex"></param>
		public Boolean SetPriorityMultiScreen(uint priority, uint displayIndex) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetPriorityMultiScreenNative(objPtr, priority, displayIndex);

			return ret;
		}
		/// <summary>
		/// Set if renderer will automatically pin the share when added and pin/unpin share if already exist.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="autoPin">LMI_TRUE to automatically pin the share when added and pin the first share from list if exist. LMI_FALSE to do not pin the share automatically when added and unpin the share if exist and already pinned.</param>
		public Boolean SetRemoteWindowSharePinMode(Boolean autoPin) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetRemoteWindowSharePinModeNative(objPtr, autoPin);

			return ret;
		}
		/// <summary>
		/// Sets the background color of the tiles.
		/// </summary>
		/// <param name="renderer">The local renderer object.</param>
		/// <param name="red">Red component of the color 0-255.</param>
		/// <param name="green">Green component of the color 0-255.</param>
		/// <param name="blue">Blue component of the color 0-255.</param>
		public Boolean SetTilesBackgroundColor(byte red, byte green, byte blue) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetTilesBackgroundColorNative(objPtr, red, green, blue);

			return ret;
		}
		/// <summary>
		/// Set the viewing distance. This is the distance from the viewer's eye to the screen.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		/// <param name="viewingDistanceFt">The viewing distance in feet.</param>
		public Boolean SetViewingDistance(double viewingDistanceFt) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererSetViewingDistanceNative(objPtr, viewingDistanceFt);

			return ret;
		}
		/// <summary>
		/// Shows or hides the audio meters.
		/// </summary>
		/// <param name="renderer">The local renderer object to show or hide the audio meters.</param>
		/// <param name="showMeters">Show or hide audio meters.</param>
		public Boolean ShowAudioMeters(Boolean showMeters) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererShowAudioMetersNative(objPtr, showMeters);

			return ret;
		}
		/// <summary>
		/// Shows debuggin statistics in the renderer window.
		/// </summary>
		/// <param name="renderer">The local renderer object to extract stats.</param>
		/// <param name="showStats">Show or hide statistics.</param>
		public Boolean ShowDebugStats(Boolean showStats) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererShowDebugStatsNative(objPtr, showStats);

			return ret;
		}
		/// <summary>
		/// Shows a label with the participant name.
		/// </summary>
		/// <param name="renderer">The local renderer object to show or hide the label.</param>
		/// <param name="showLabel">Show or hide participant label.</param>
		public Boolean ShowLabel(Boolean showLabel) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererShowLabelNative(objPtr, showLabel);

			return ret;
		}
		/// <summary>
		/// Unregisters recorder in call event notifications.
		/// </summary>
		/// <param name="r">The VidyoLocalRenderer object.</param>
		public Boolean UnregisterPipEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalRendererUnregisterPipEventListenerNative(objPtr);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnPipLocationChanged))]
#endif
		private static void OnPipLocationChangedDelegate(IntPtr renderer, int x, int y, uint width, uint height, Boolean isExpanded){
			var csRendererPtr = renderer != IntPtr.Zero ? VidyoLocalRendererGetUserDataNative(renderer) : IntPtr.Zero;
			if(csRendererPtr == IntPtr.Zero) return;
			var csRenderer = (LocalRenderer)GCHandle.FromIntPtr(csRendererPtr).Target;

			csRenderer?._mIRegisterPipEventListener?.OnPipLocationChanged(x, y, width, height, isExpanded);
		}
	};
}
