// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LocalRendererStreamStatsFactory
	{
		public static LocalRendererStreamStats Create()
		{
			return new LocalRendererStreamStats(IntPtr.Zero);
		}
		public static void Destroy(LocalRendererStreamStats obj)
		{
		}
	}
	/// <summary>
	/// Statistics for a local renderer.
	/// </summary>
	public class LocalRendererStreamStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalRendererStreamStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoLocalRendererStreamStatsSetactiveSpatialLayersNative(objPtr, activeSpatialLayers);
			VidyoLocalRendererStreamStatsSetbufferDroppedNative(objPtr, bufferDropped);
			VidyoLocalRendererStreamStatsSetbufferSizeNative(objPtr, bufferSize);
			VidyoLocalRendererStreamStatsSetheightNative(objPtr, height);
			VidyoLocalRendererStreamStatsSetidNative(objPtr, nId);
			VidyoLocalRendererStreamStatsSetmaxSpatialLayersNative(objPtr, maxSpatialLayers);
			VidyoLocalRendererStreamStatsSetnameNative(objPtr, nName);
			VidyoLocalRendererStreamStatsSetwidthNative(objPtr, width);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoLocalRendererStreamStatsGetactiveSpatialLayersNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetactiveSpatialLayersNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT activeSpatialLayers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalRendererStreamStatsGetbufferDroppedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetbufferDroppedNative(IntPtr obj, uint bufferDropped);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalRendererStreamStatsGetbufferSizeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetbufferSizeNative(IntPtr obj, uint bufferSize);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoLocalRendererStreamStatsGetheightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetheightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalRendererStreamStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoLocalRendererStreamStatsGetmaxSpatialLayersNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetmaxSpatialLayersNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxSpatialLayers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalRendererStreamStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoLocalRendererStreamStatsGetwidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStreamStatsSetwidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalRendererStreamStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalRendererStreamStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalRendererStreamStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Active spatial layers.
		/// </summary>
		public SizeT activeSpatialLayers;
		/// <summary>
		/// Dropped frames from video buffer.
		/// </summary>
		public uint bufferDropped;
		/// <summary>
		/// Size of video buffer.
		/// </summary>
		public uint bufferSize;
		/// <summary>
		/// Height.
		/// </summary>
		public SizeT height;
		/// <summary>
		/// Id.
		/// </summary>
		public String id;
		/// <summary>
		/// Maximum spatial layers.
		/// </summary>
		public SizeT maxSpatialLayers;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT width;
		public LocalRendererStreamStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLocalRendererStreamStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLocalRendererStreamStatsConstructCopyNative(obj);
			}

			activeSpatialLayers = VidyoLocalRendererStreamStatsGetactiveSpatialLayersNative(objPtr);
			bufferDropped = VidyoLocalRendererStreamStatsGetbufferDroppedNative(objPtr);
			bufferSize = VidyoLocalRendererStreamStatsGetbufferSizeNative(objPtr);
			height = VidyoLocalRendererStreamStatsGetheightNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalRendererStreamStatsGetidNative(objPtr));
			maxSpatialLayers = VidyoLocalRendererStreamStatsGetmaxSpatialLayersNative(objPtr);
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalRendererStreamStatsGetnameNative(objPtr));
			width = VidyoLocalRendererStreamStatsGetwidthNative(objPtr);
		}
		~LocalRendererStreamStats() {
			VidyoLocalRendererStreamStatsDestructNative(objPtr);
		 }
	};
}
