// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LocalSpeakerStatsFactory
	{
		public static LocalSpeakerStats Create()
		{
			return new LocalSpeakerStats(IntPtr.Zero);
		}
		public static void Destroy(LocalSpeakerStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a local speaker.
	/// </summary>
	public class LocalSpeakerStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalSpeakerStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoLocalSpeakerStatsSetbitsPerSampleNative(objPtr, bitsPerSample);
			VidyoLocalSpeakerStatsSetformatNative(objPtr, format);
			VidyoLocalSpeakerStatsSetidNative(objPtr, nId);
			VidyoLocalSpeakerStatsSetnameNative(objPtr, nName);
			VidyoLocalSpeakerStatsSetnumberOfChannelsNative(objPtr, numberOfChannels);
			VidyoLocalSpeakerStatsSetsampleRateMeasuredNative(objPtr, sampleRateMeasured);
			VidyoLocalSpeakerStatsSetsampleRateSetNative(objPtr, sampleRateSet);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalSpeakerStatsGetbitsPerSampleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStatsSetbitsPerSampleNative(IntPtr obj, uint bitsPerSample);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern MediaFormat VidyoLocalSpeakerStatsGetformatNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStatsSetformatNative(IntPtr obj, MediaFormat format);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalSpeakerStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalSpeakerStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalSpeakerStatsGetnumberOfChannelsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStatsSetnumberOfChannelsNative(IntPtr obj, uint numberOfChannels);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalSpeakerStatsGetsampleRateMeasuredNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStatsSetsampleRateMeasuredNative(IntPtr obj, uint sampleRateMeasured);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalSpeakerStatsGetsampleRateSetNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStatsSetsampleRateSetNative(IntPtr obj, uint sampleRateSet);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalSpeakerStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalSpeakerStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalSpeakerStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Bits per sample.
		/// </summary>
		public uint bitsPerSample;
		/// <summary>
		/// Audio format.
		/// </summary>
		public MediaFormat format;
		/// <summary>
		/// Id.
		/// </summary>
		public String id;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Number of channels.
		/// </summary>
		public uint numberOfChannels;
		/// <summary>
		/// Sample rate measured.
		/// </summary>
		public uint sampleRateMeasured;
		/// <summary>
		/// Sample rate setting.
		/// </summary>
		public uint sampleRateSet;
		public LocalSpeakerStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLocalSpeakerStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLocalSpeakerStatsConstructCopyNative(obj);
			}

			bitsPerSample = VidyoLocalSpeakerStatsGetbitsPerSampleNative(objPtr);
			format = VidyoLocalSpeakerStatsGetformatNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalSpeakerStatsGetidNative(objPtr));
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalSpeakerStatsGetnameNative(objPtr));
			numberOfChannels = VidyoLocalSpeakerStatsGetnumberOfChannelsNative(objPtr);
			sampleRateMeasured = VidyoLocalSpeakerStatsGetsampleRateMeasuredNative(objPtr);
			sampleRateSet = VidyoLocalSpeakerStatsGetsampleRateSetNative(objPtr);
		}
		~LocalSpeakerStats() {
			VidyoLocalSpeakerStatsDestructNative(objPtr);
		 }
	};
}
