// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LocalSpeakerStreamStatsFactory
	{
		public static LocalSpeakerStreamStats Create()
		{
			return new LocalSpeakerStreamStats(IntPtr.Zero);
		}
		public static void Destroy(LocalSpeakerStreamStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a local speaker.
	/// </summary>
	public class LocalSpeakerStreamStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalSpeakerStreamStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoLocalSpeakerStreamStatsSetbitsPerSampleNative(objPtr, bitsPerSample);
			VidyoLocalSpeakerStreamStatsSetdelayNative(objPtr, delay);
			VidyoLocalSpeakerStreamStatsSetformatNative(objPtr, format);
			VidyoLocalSpeakerStreamStatsSethighThresholdNative(objPtr, highThreshold);
			VidyoLocalSpeakerStreamStatsSethighestThresholdNative(objPtr, highestThreshold);
			VidyoLocalSpeakerStreamStatsSetisActiveNative(objPtr, isActive);
			VidyoLocalSpeakerStreamStatsSetlastEnergyNative(objPtr, lastEnergy);
			VidyoLocalSpeakerStreamStatsSetlastPlayedNative(objPtr, lastPlayed);
			VidyoLocalSpeakerStreamStatsSetlowThresholdNative(objPtr, lowThreshold);
			VidyoLocalSpeakerStreamStatsSetlowestThresholdNative(objPtr, lowestThreshold);
			VidyoLocalSpeakerStreamStatsSetmaxThresholdNative(objPtr, maxThreshold);
			VidyoLocalSpeakerStreamStatsSetnameNative(objPtr, nName);
			VidyoLocalSpeakerStreamStatsSetnumberOfChannelsNative(objPtr, numberOfChannels);
			VidyoLocalSpeakerStreamStatsSetoverrunNative(objPtr, overrun);
			VidyoLocalSpeakerStreamStatsSetplayedNative(objPtr, played);
			VidyoLocalSpeakerStreamStatsSetsampleRateNative(objPtr, sampleRate);
			VidyoLocalSpeakerStreamStatsSetunderrunNative(objPtr, underrun);

			Marshal.FreeHGlobal(nName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalSpeakerStreamStatsGetbitsPerSampleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetbitsPerSampleNative(IntPtr obj, uint bitsPerSample);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetdelayNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetdelayNative(IntPtr obj, ulong delay);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern MediaFormat VidyoLocalSpeakerStreamStatsGetformatNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetformatNative(IntPtr obj, MediaFormat format);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGethighThresholdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSethighThresholdNative(IntPtr obj, ulong highThreshold);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGethighestThresholdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSethighestThresholdNative(IntPtr obj, ulong highestThreshold);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalSpeakerStreamStatsGetisActiveNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetisActiveNative(IntPtr obj, Boolean isActive);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoLocalSpeakerStreamStatsGetlastEnergyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetlastEnergyNative(IntPtr obj, int lastEnergy);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetlastPlayedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetlastPlayedNative(IntPtr obj, ulong lastPlayed);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetlowThresholdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetlowThresholdNative(IntPtr obj, ulong lowThreshold);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetlowestThresholdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetlowestThresholdNative(IntPtr obj, ulong lowestThreshold);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetmaxThresholdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetmaxThresholdNative(IntPtr obj, ulong maxThreshold);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalSpeakerStreamStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalSpeakerStreamStatsGetnumberOfChannelsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetnumberOfChannelsNative(IntPtr obj, uint numberOfChannels);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetoverrunNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetoverrunNative(IntPtr obj, ulong overrun);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetplayedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetplayedNative(IntPtr obj, ulong played);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalSpeakerStreamStatsGetsampleRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetsampleRateNative(IntPtr obj, uint sampleRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalSpeakerStreamStatsGetunderrunNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalSpeakerStreamStatsSetunderrunNative(IntPtr obj, ulong underrun);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalSpeakerStreamStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalSpeakerStreamStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalSpeakerStreamStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Bits per sample.
		/// </summary>
		public uint bitsPerSample;
		/// <summary>
		/// Audio delay in the stream jitter buffer.
		/// </summary>
		public ulong delay;
		/// <summary>
		/// Audio format.
		/// </summary>
		public MediaFormat format;
		/// <summary>
		/// High threshold of stream jitter buffer over which the stream will be gently pared down to get into the proper range.
		/// </summary>
		public ulong highThreshold;
		/// <summary>
		/// Highest threshold of stream jitter buffer over which the stream will be agressively pared down to get into the proper range.
		/// </summary>
		public ulong highestThreshold;
		/// <summary>
		/// Active stream status.
		/// </summary>
		public Boolean isActive;
		/// <summary>
		/// Last energy in dBFS of the stream.
		/// </summary>
		public int lastEnergy;
		/// <summary>
		/// Last time audio was played from the stream.
		/// </summary>
		public ulong lastPlayed;
		/// <summary>
		/// Low threshold of stream jitter buffer under which the stream will be gently padded to get into the proper range.
		/// </summary>
		public ulong lowThreshold;
		/// <summary>
		/// Lowest threshold of stream jitter buffer under which the stream will be agressively padded to get into the proper range.
		/// </summary>
		public ulong lowestThreshold;
		/// <summary>
		/// Maximum threshold of stream jitter buffer over which the stream will be agressively pared down by dropping non-speech frames to get into the proper range.
		/// </summary>
		public ulong maxThreshold;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Number of channels.
		/// </summary>
		public uint numberOfChannels;
		/// <summary>
		/// Ammount of time stream was over the maxThreshold.
		/// </summary>
		public ulong overrun;
		/// <summary>
		/// Ammount of audio played by the stream.
		/// </summary>
		public ulong played;
		/// <summary>
		/// Sample rate.
		/// </summary>
		public uint sampleRate;
		/// <summary>
		/// Ammount of time stream was in the empty but active state.
		/// </summary>
		public ulong underrun;
		public LocalSpeakerStreamStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLocalSpeakerStreamStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLocalSpeakerStreamStatsConstructCopyNative(obj);
			}

			bitsPerSample = VidyoLocalSpeakerStreamStatsGetbitsPerSampleNative(objPtr);
			delay = VidyoLocalSpeakerStreamStatsGetdelayNative(objPtr);
			format = VidyoLocalSpeakerStreamStatsGetformatNative(objPtr);
			highThreshold = VidyoLocalSpeakerStreamStatsGethighThresholdNative(objPtr);
			highestThreshold = VidyoLocalSpeakerStreamStatsGethighestThresholdNative(objPtr);
			isActive = VidyoLocalSpeakerStreamStatsGetisActiveNative(objPtr);
			lastEnergy = VidyoLocalSpeakerStreamStatsGetlastEnergyNative(objPtr);
			lastPlayed = VidyoLocalSpeakerStreamStatsGetlastPlayedNative(objPtr);
			lowThreshold = VidyoLocalSpeakerStreamStatsGetlowThresholdNative(objPtr);
			lowestThreshold = VidyoLocalSpeakerStreamStatsGetlowestThresholdNative(objPtr);
			maxThreshold = VidyoLocalSpeakerStreamStatsGetmaxThresholdNative(objPtr);
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalSpeakerStreamStatsGetnameNative(objPtr));
			numberOfChannels = VidyoLocalSpeakerStreamStatsGetnumberOfChannelsNative(objPtr);
			overrun = VidyoLocalSpeakerStreamStatsGetoverrunNative(objPtr);
			played = VidyoLocalSpeakerStreamStatsGetplayedNative(objPtr);
			sampleRate = VidyoLocalSpeakerStreamStatsGetsampleRateNative(objPtr);
			underrun = VidyoLocalSpeakerStreamStatsGetunderrunNative(objPtr);
		}
		~LocalSpeakerStreamStats() {
			VidyoLocalSpeakerStreamStatsDestructNative(objPtr);
		 }
	};
}
