// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// This object represents a window share on the local endpoint.
	/// </summary>
	public class LocalWindowShare: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalWindowShare reference.
		private GCHandle objHandle; // weak VidyoLocalWindowShare reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalWindowShareAddToLocalRendererNative(IntPtr w, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareAddToRemoteRendererNative(IntPtr w, IntPtr remoteRenderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareClearConstraintsNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalWindowShareDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareGetApplicationIconFrameDataUriAsyncNative(IntPtr w, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxWidth, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxHeight, OnApplicationIconDataUriComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareGetApplicationNameNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareGetCapabilitiesNative(IntPtr windowShare, OnGetCapabilities onGetCapabilities);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareGetIdNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareGetNameNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareGetPreviewFrameDataUriAsyncNative(IntPtr w, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxWidth, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxHeight, OnPreviewDataUriComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareGetPreviewLabelNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalWindowShareGetProcessIdNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareGetProcessNameNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareGetUpdatedNameNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern LocalWindowShareState VidyoLocalWindowShareGetWindowStateNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareIsApplicationNameSetNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareIsNameSetNative(IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareRemoveFromLocalRendererNative(IntPtr w, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareRemoveFromRemoteRendererNative(IntPtr w, IntPtr remoteRenderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetBoundsConstraintsNative(IntPtr w, ulong maxFrameInterval, ulong minFrameInterval, uint maxWidth, uint minWidth, uint maxHeight, uint minHeight);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetCapabilityNative(IntPtr w, ulong frameInterval, Boolean showCursor, Boolean redactOccludedAreas);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetCaptureIntervalNative(IntPtr w, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetCursorVisibilityNative(IntPtr w, Boolean showCursor);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetDiscreteConstraintsNative(IntPtr w, ulong maxFrameInterval, ulong minFrameInterval, uint width, uint height, double scaleFactor);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetFrameIntervalNative(IntPtr w, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetLowLatencyProfileNative(IntPtr w, Boolean profile);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetMaxConstraintsNative(IntPtr w, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetMinFrameIntervalNative(IntPtr w, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetPositionInLocalRendererNative(IntPtr w, IntPtr localRenderer, int x, int y, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetPreviewLabelNative(IntPtr w, IntPtr previewLabel);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetRedactOccludedAreasNative(IntPtr w, Boolean redactOccludedAreas);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalWindowShareSetScaleFactorNative(IntPtr w, double scaleFactor);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalWindowShareGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalWindowShareSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnApplicationIconDataUriComplete(IntPtr w, IntPtr icon);
		private OnApplicationIconDataUriComplete _mOnApplicationIconDataUriComplete = OnApplicationIconDataUriCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareOnApplicationIconDataUriCompleteGeticonCStr(IntPtr icon);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetCapabilities(IntPtr w, uint width, uint height, ulong frameInterval);
		private OnGetCapabilities _mOnGetCapabilities = OnGetCapabilitiesDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnPreviewDataUriComplete(IntPtr w, IntPtr videoFrame, LocalWindowShareState state);
		private OnPreviewDataUriComplete _mOnPreviewDataUriComplete = OnPreviewDataUriCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalWindowShareOnPreviewDataUriCompleteGetvideoFrameCStr(IntPtr videoFrame);

		/// <summary>
		/// State of the window share.
		/// </summary>
		public enum LocalWindowShareState {
			/// <summary>The window is visible and has been fully captured.</summary>
			LocalwindowsharestateOk,
			/// <summary>The window exists but is not "visible".</summary>
			LocalwindowsharestateNotVisible,
			/// <summary>The window is minimized and "visible" but its content may not be accessible.</summary>
			LocalwindowsharestateMinimized,
			/// <summary>The window is closed and is no longer accessible.</summary>
			LocalwindowsharestateClosed,
			/// <summary>Miscellaneous error has occured trying to capture the frame.</summary>
			LocalwindowsharestateMiscError
		}
		public interface IGetApplicationIconFrameDataUriAsync{

			void OnApplicationIconDataUriComplete(String icon);
		}
		public interface IGetCapabilities{

			void OnGetCapabilities(uint width, uint height, ulong frameInterval);
		}
		public interface IGetPreviewFrameDataUriAsync{

			void OnPreviewDataUriComplete(String videoFrame, LocalWindowShareState state);
		}
		private IGetApplicationIconFrameDataUriAsync _mIGetApplicationIconFrameDataUriAsync;
		private IGetCapabilities _mIGetCapabilities;
		private IGetPreviewFrameDataUriAsync _mIGetPreviewFrameDataUriAsync;
		public LocalWindowShare(IntPtr other){
			objPtr = VidyoLocalWindowShareConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoLocalWindowShareSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~LocalWindowShare(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoLocalWindowShareSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoLocalWindowShareDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="renderer"></param>
		public ulong AddToLocalRenderer(LocalRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoLocalWindowShareAddToLocalRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="remoteRenderer"></param>
		public Boolean AddToRemoteRenderer(RemoteRenderer remoteRenderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareAddToRemoteRendererNative(objPtr, (remoteRenderer != null) ? remoteRenderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Clears existing constraints and set them to default values 3840x2160@3fps.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public Boolean ClearConstraints() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareClearConstraintsNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="maxWidth">Maximum width of the icon image.</param>
		/// <param name="maxHeight">Maximum height of the icon image.</param>
		/// <param name="onComplete">Callback that is triggered when a icon frame is captured.</param>
		public Boolean GetApplicationIconFrameDataUriAsync(SizeT maxWidth, SizeT maxHeight, IGetApplicationIconFrameDataUriAsync _iIGetApplicationIconFrameDataUriAsync) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetApplicationIconFrameDataUriAsync = _iIGetApplicationIconFrameDataUriAsync;

			Boolean ret = VidyoLocalWindowShareGetApplicationIconFrameDataUriAsyncNative(objPtr, maxWidth, maxHeight, _mOnApplicationIconDataUriComplete);

			return ret;
		}
		/// <summary>
		/// Gets the name of the application that owns the window.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public String GetApplicationName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalWindowShareGetApplicationNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
		/// </summary>
		/// <param name="windowShare">The VidyoLocalWindowShare object.</param>
		/// <param name="onGetCapabilities">The callback to which we will pass the most optimal capabilities.</param>
		public Boolean GetCapabilities(IGetCapabilities _iIGetCapabilities) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetCapabilities = _iIGetCapabilities;

			Boolean ret = VidyoLocalWindowShareGetCapabilitiesNative(objPtr, _mOnGetCapabilities);

			return ret;
		}
		/// <summary>
		/// Gets the unique ID of the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalWindowShareGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the name of the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalWindowShareGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="maxWidth">Maximum width of the preview image.</param>
		/// <param name="maxHeight">Maximum height of the preview image.</param>
		/// <param name="onComplete">Callback that is triggered when a preview frame is captured.</param>
		public Boolean GetPreviewFrameDataUriAsync(SizeT maxWidth, SizeT maxHeight, IGetPreviewFrameDataUriAsync _iIGetPreviewFrameDataUriAsync) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetPreviewFrameDataUriAsync = _iIGetPreviewFrameDataUriAsync;

			Boolean ret = VidyoLocalWindowShareGetPreviewFrameDataUriAsyncNative(objPtr, maxWidth, maxHeight, _mOnPreviewDataUriComplete);

			return ret;
		}
		/// <summary>
		/// Gets the preview label of the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public String GetPreviewLabel() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalWindowShareGetPreviewLabelNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the ID of the process that owns the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public uint GetProcessId() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoLocalWindowShareGetProcessIdNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w"></param>
		public String GetProcessName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalWindowShareGetProcessNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Retrieved the up to date name of the Window which might have changed since it was created.
		/// </summary>
		/// <param name="w"></param>
		public String GetUpdatedName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalWindowShareGetUpdatedNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets window state of the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public LocalWindowShareState GetWindowState() {
			if (objPtr == IntPtr.Zero) { return default; }

			LocalWindowShareState ret = VidyoLocalWindowShareGetWindowStateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Checks if the name of the application name is set.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public Boolean IsApplicationNameSet() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareIsApplicationNameSetNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Checks if the name of the window share is set.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		public Boolean IsNameSet() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareIsNameSetNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="renderer"></param>
		public Boolean RemoveFromLocalRenderer(LocalRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareRemoveFromLocalRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="remoteRenderer"></param>
		public Boolean RemoveFromRemoteRenderer(RemoteRenderer remoteRenderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareRemoveFromRemoteRendererNative(objPtr, (remoteRenderer != null) ? remoteRenderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions
		/// </summary>
		/// <param name="w"></param>
		/// <param name="maxFrameInterval">Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="minFrameInterval">Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="maxWidth">Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit</param>
		/// <param name="minWidth">Unused</param>
		/// <param name="maxHeight">Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit</param>
		/// <param name="minHeight">Unused</param>
		public Boolean SetBoundsConstraints(ulong maxFrameInterval, ulong minFrameInterval, uint maxWidth, uint minWidth, uint maxHeight, uint minHeight) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetBoundsConstraintsNative(objPtr, maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="frameInterval">Set as an override of minimum frame interval for discrete and bounds constraints</param>
		/// <param name="showCursor"></param>
		/// <param name="redactOccludedAreas"></param>
		public Boolean SetCapability(ulong frameInterval, Boolean showCursor, Boolean redactOccludedAreas) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetCapabilityNative(objPtr, frameInterval, showCursor, redactOccludedAreas);

			return ret;
		}
		/// <summary>
		/// Set frame interval(fps) for capturer.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. By default will be calculated based on encoder configuration.</param>
		public Boolean SetCaptureInterval(ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetCaptureIntervalNative(objPtr, frameInterval);

			return ret;
		}
		/// <summary>
		/// Sets the visibility of the cursor in the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="showCursor"></param>
		public Boolean SetCursorVisibility(Boolean showCursor) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetCursorVisibilityNative(objPtr, showCursor);

			return ret;
		}
		/// <summary>
		/// Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used
		/// </summary>
		/// <param name="w"></param>
		/// <param name="maxFrameInterval">Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="minFrameInterval">Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="width">The width of the stream after the stream is reconfigured</param>
		/// <param name="height">The height of the stream after the stream is reconfigured</param>
		/// <param name="scaleFactor">This should be 1</param>
		public Boolean SetDiscreteConstraints(ulong maxFrameInterval, ulong minFrameInterval, uint width, uint height, double scaleFactor) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetDiscreteConstraintsNative(objPtr, maxFrameInterval, minFrameInterval, width, height, scaleFactor);

			return ret;
		}
		/// <summary>
		/// Sets the maximum frame interval that will be used to scrapte the window share
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. Default is 333333333 which is 3 frames per second.</param>
		public Boolean SetFrameInterval(ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetFrameIntervalNative(objPtr, frameInterval);

			return ret;
		}
		/// <summary>
		/// Sets the low latency profile of the window share which treats the stream as a regular video source. This prioritizes latency over quality.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="profile">Low latency profile toggle. Default is LMI_FALSE.</param>
		public Boolean SetLowLatencyProfile(Boolean profile) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetLowLatencyProfileNative(objPtr, profile);

			return ret;
		}
		/// <summary>
		/// Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the window is in landscape mode width and height will be applied as max constraints, if the window is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object</param>
		/// <param name="width">Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.</param>
		/// <param name="height">Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).</param>
		public Boolean SetMaxConstraints(uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetMaxConstraintsNative(objPtr, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// Set a minimum frame interval(maximum fps) for the encoded stream.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).</param>
		public Boolean SetMinFrameInterval(ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetMinFrameIntervalNative(objPtr, frameInterval);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="localRenderer"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames.</param>
		public Boolean SetPositionInLocalRenderer(LocalRenderer localRenderer, int x, int y, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetPositionInLocalRendererNative(objPtr, (localRenderer != null) ? localRenderer.GetObjectPtr():IntPtr.Zero, x, y, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// Set the preview label of the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="previewLabel">Display name to set on the window share.</param>
		public Boolean SetPreviewLabel(String previewLabel) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nPreviewLabel = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(previewLabel ?? string.Empty);
			Boolean ret = VidyoLocalWindowShareSetPreviewLabelNative(objPtr, nPreviewLabel);
			Marshal.FreeHGlobal(nPreviewLabel);

			return ret;
		}
		/// <summary>
		/// Sets the flag which redacts the occluded areas from the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="redactOccludedAreas"></param>
		public Boolean SetRedactOccludedAreas(Boolean redactOccludedAreas) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetRedactOccludedAreasNative(objPtr, redactOccludedAreas);

			return ret;
		}
		/// <summary>
		/// Sets the scale factor by which to down-scale the window share.
		/// </summary>
		/// <param name="w">The VidyoLocalWindowShare object.</param>
		/// <param name="scaleFactor"></param>
		public Boolean SetScaleFactor(double scaleFactor) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalWindowShareSetScaleFactorNative(objPtr, scaleFactor);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnApplicationIconDataUriComplete))]
#endif
		private static void OnApplicationIconDataUriCompleteDelegate(IntPtr w, IntPtr icon){
			var csWPtr = w != IntPtr.Zero ? VidyoLocalWindowShareGetUserDataNative(w) : IntPtr.Zero;
			if(csWPtr == IntPtr.Zero) return;
			var csW = (LocalWindowShare)GCHandle.FromIntPtr(csWPtr).Target;

			var n_icon = VidyoLocalWindowShareOnApplicationIconDataUriCompleteGeticonCStr(icon);

			csW?._mIGetApplicationIconFrameDataUriAsync?.OnApplicationIconDataUriComplete((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_icon));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetCapabilities))]
#endif
		private static void OnGetCapabilitiesDelegate(IntPtr w, uint width, uint height, ulong frameInterval){
			var csWPtr = w != IntPtr.Zero ? VidyoLocalWindowShareGetUserDataNative(w) : IntPtr.Zero;
			if(csWPtr == IntPtr.Zero) return;
			var csW = (LocalWindowShare)GCHandle.FromIntPtr(csWPtr).Target;

			csW?._mIGetCapabilities?.OnGetCapabilities(width, height, frameInterval);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnPreviewDataUriComplete))]
#endif
		private static void OnPreviewDataUriCompleteDelegate(IntPtr w, IntPtr videoFrame, LocalWindowShareState state){
			var csWPtr = w != IntPtr.Zero ? VidyoLocalWindowShareGetUserDataNative(w) : IntPtr.Zero;
			if(csWPtr == IntPtr.Zero) return;
			var csW = (LocalWindowShare)GCHandle.FromIntPtr(csWPtr).Target;

			var n_videoFrame = VidyoLocalWindowShareOnPreviewDataUriCompleteGetvideoFrameCStr(videoFrame);

			csW?._mIGetPreviewFrameDataUriAsync?.OnPreviewDataUriComplete((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_videoFrame), state);
		}
	};
}
