// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class MediaConnectionTransportInfoFactory
	{
		public static MediaConnectionTransportInfo Create()
		{
			return new MediaConnectionTransportInfo(IntPtr.Zero);
		}
		public static void Destroy(MediaConnectionTransportInfo obj)
		{
		}
	}
	/// <summary>
	/// Information about media connection transport.
	/// </summary>
	public class MediaConnectionTransportInfo {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoMediaConnectionTransportInfo reference.
		public IntPtr GetObjectPtr() {
			IntPtr nAddressType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(addressType ?? string.Empty);
			IntPtr nComponentType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(componentType ?? string.Empty);
			IntPtr nConnectionType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(connectionType ?? string.Empty);
			IntPtr nExternalLocalAddr = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(externalLocalAddr ?? string.Empty);
			IntPtr nExternalRemoteAddr = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(externalRemoteAddr ?? string.Empty);
			IntPtr nInterfaceName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(interfaceName ?? string.Empty);
			IntPtr nInterfaceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(interfaceType ?? string.Empty);
			IntPtr nInternalLocalAddr = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(internalLocalAddr ?? string.Empty);
			IntPtr nInternalRemoteAddr = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(internalRemoteAddr ?? string.Empty);
			IntPtr nTransportPlugIn = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(transportPlugIn ?? string.Empty);

			VidyoMediaConnectionTransportInfoSetaddressTypeNative(objPtr, nAddressType);
			VidyoMediaConnectionTransportInfoSetcomponentTypeNative(objPtr, nComponentType);
			VidyoMediaConnectionTransportInfoSetconnectionIdNative(objPtr, connectionId);
			VidyoMediaConnectionTransportInfoSetconnectionTypeNative(objPtr, nConnectionType);
			VidyoMediaConnectionTransportInfoSetexternalLocalAddrNative(objPtr, nExternalLocalAddr);
			VidyoMediaConnectionTransportInfoSetexternalRemoteAddrNative(objPtr, nExternalRemoteAddr);
			VidyoMediaConnectionTransportInfoSetinterfaceNameNative(objPtr, nInterfaceName);
			VidyoMediaConnectionTransportInfoSetinterfaceTypeNative(objPtr, nInterfaceType);
			VidyoMediaConnectionTransportInfoSetinternalLocalAddrNative(objPtr, nInternalLocalAddr);
			VidyoMediaConnectionTransportInfoSetinternalRemoteAddrNative(objPtr, nInternalRemoteAddr);
			VidyoMediaConnectionTransportInfoSettransportPlugInNative(objPtr, nTransportPlugIn);

			Marshal.FreeHGlobal(nTransportPlugIn);
			Marshal.FreeHGlobal(nInternalRemoteAddr);
			Marshal.FreeHGlobal(nInternalLocalAddr);
			Marshal.FreeHGlobal(nInterfaceType);
			Marshal.FreeHGlobal(nInterfaceName);
			Marshal.FreeHGlobal(nExternalRemoteAddr);
			Marshal.FreeHGlobal(nExternalLocalAddr);
			Marshal.FreeHGlobal(nConnectionType);
			Marshal.FreeHGlobal(nComponentType);
			Marshal.FreeHGlobal(nAddressType);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetaddressTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetaddressTypeNative(IntPtr obj, IntPtr addressType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetcomponentTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetcomponentTypeNative(IntPtr obj, IntPtr componentType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoMediaConnectionTransportInfoGetconnectionIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetconnectionIdNative(IntPtr obj, uint connectionId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetconnectionTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetconnectionTypeNative(IntPtr obj, IntPtr connectionType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetexternalLocalAddrNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetexternalLocalAddrNative(IntPtr obj, IntPtr externalLocalAddr);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetexternalRemoteAddrNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetexternalRemoteAddrNative(IntPtr obj, IntPtr externalRemoteAddr);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetinterfaceNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetinterfaceNameNative(IntPtr obj, IntPtr interfaceName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetinterfaceTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetinterfaceTypeNative(IntPtr obj, IntPtr interfaceType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetinternalLocalAddrNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetinternalLocalAddrNative(IntPtr obj, IntPtr internalLocalAddr);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGetinternalRemoteAddrNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSetinternalRemoteAddrNative(IntPtr obj, IntPtr internalRemoteAddr);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMediaConnectionTransportInfoGettransportPlugInNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMediaConnectionTransportInfoSettransportPlugInNative(IntPtr obj, IntPtr transportPlugIn);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoMediaConnectionTransportInfoConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoMediaConnectionTransportInfoConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoMediaConnectionTransportInfoDestructNative(IntPtr obj);

		/// <summary>
		/// Address type.
		/// </summary>
		public String addressType;
		/// <summary>
		/// Transport component type.
		/// </summary>
		public String componentType;
		/// <summary>
		/// Connection ID.
		/// </summary>
		public uint connectionId;
		/// <summary>
		/// Transport connection type.
		/// </summary>
		public String connectionType;
		/// <summary>
		/// External local address.
		/// </summary>
		public String externalLocalAddr;
		/// <summary>
		/// External remote address.
		/// </summary>
		public String externalRemoteAddr;
		/// <summary>
		/// Interface name.
		/// </summary>
		public String interfaceName;
		/// <summary>
		/// Interface type.
		/// </summary>
		public String interfaceType;
		/// <summary>
		/// Internal local address.
		/// </summary>
		public String internalLocalAddr;
		/// <summary>
		/// Internal remote address.
		/// </summary>
		public String internalRemoteAddr;
		/// <summary>
		/// Transport plugin.
		/// </summary>
		public String transportPlugIn;
		public MediaConnectionTransportInfo(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoMediaConnectionTransportInfoConstructDefaultNative();
			}
			else {
				objPtr = VidyoMediaConnectionTransportInfoConstructCopyNative(obj);
			}

			addressType = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetaddressTypeNative(objPtr));
			componentType = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetcomponentTypeNative(objPtr));
			connectionId = VidyoMediaConnectionTransportInfoGetconnectionIdNative(objPtr);
			connectionType = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetconnectionTypeNative(objPtr));
			externalLocalAddr = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetexternalLocalAddrNative(objPtr));
			externalRemoteAddr = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetexternalRemoteAddrNative(objPtr));
			interfaceName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetinterfaceNameNative(objPtr));
			interfaceType = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetinterfaceTypeNative(objPtr));
			internalLocalAddr = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetinternalLocalAddrNative(objPtr));
			internalRemoteAddr = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGetinternalRemoteAddrNative(objPtr));
			transportPlugIn = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMediaConnectionTransportInfoGettransportPlugInNative(objPtr));
		}
		~MediaConnectionTransportInfo() {
			VidyoMediaConnectionTransportInfoDestructNative(objPtr);
		 }
	};
}
