// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// Represents a meeting and all the related attributes.
	/// </summary>
	public class Meeting: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoMeeting reference.
		private GCHandle objHandle; // weak VidyoMeeting reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoMeetingGetAttendeesNative(IntPtr m, uint index, uint pageSize);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetBodyNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetEndDateTimeNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetIdNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoMeetingGetIsVidyoMeetingNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetLocationNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoMeetingGetNumberOfAttendeesNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetOwnerEmailNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetOwnerNameNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetStartDateTimeNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetSubjectNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingGetVidyoMeetingRoomLinkNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingRetrieveBodyNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoMeetingGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoMeetingSetUserDataNative(IntPtr obj, IntPtr userData);

		public Meeting(IntPtr other){
			objPtr = VidyoMeetingConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoMeetingSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~Meeting(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoMeetingSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoMeetingDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// <p>Retrieve attendees for the meeting using an index and a page size </p> <p/> <p>Results will be returned through the feedback : </p> <p>- VidyoMeetingFeedbackGetMeetingAttendeeResults </p>
		/// </summary>
		/// <param name="m">Meeting to retrieve attendees from</param>
		/// <param name="index">Zero based index of the starting record in the retrieval results, to use when returning the callback data.</param>
		/// <param name="pageSize">Number of records to return in the callback results, based off of the starting record index argument. NOTE... A value of zero will return all records starting from the index</param>
		public Boolean GetAttendees(uint index, uint pageSize) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoMeetingGetAttendeesNative(objPtr, index, pageSize);

			return ret;
		}
		/// <summary>
		/// Retrieve up to 2K bytes of body data from a Vidyo meeting
		/// </summary>
		/// <param name="m"></param>
		public String GetBody() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetBodyNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetEndDateTime() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetEndDateTimeNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public Boolean GetIsVidyoMeeting() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoMeetingGetIsVidyoMeetingNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetLocation() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetLocationNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">VidyoMeeting object instance to retrieve value from</param>
		public int GetNumberOfAttendees() {
			if (objPtr == IntPtr.Zero) { return default; }

			int ret = VidyoMeetingGetNumberOfAttendeesNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetOwnerEmail() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetOwnerEmailNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetOwnerName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetOwnerNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetStartDateTime() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetStartDateTimeNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetSubject() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetSubjectNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public String GetVidyoMeetingRoomLink() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingGetVidyoMeetingRoomLinkNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// To retrieve entire body from a Vidyo meeting
		/// </summary>
		/// <param name="m"></param>
		public String RetrieveBody() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoMeetingRetrieveBodyNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
	};
}
