// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// Stores network interface information.
	/// </summary>
	public class NetworkInterface: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoNetworkInterface reference.
		private GCHandle objHandle; // weak VidyoNetworkInterface reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoNetworkInterfaceConstructCopyNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoNetworkInterfaceDestructNative(IntPtr n);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoNetworkInterfaceGetAddressNative(IntPtr n);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern NetworkInterfaceFamily VidyoNetworkInterfaceGetFamilyNative(IntPtr n);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoNetworkInterfaceGetNameNative(IntPtr n);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern NetworkInterfaceState VidyoNetworkInterfaceGetStateNative(IntPtr n);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern NetworkInterfaceType VidyoNetworkInterfaceGetTypeNative(IntPtr n);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoNetworkInterfaceGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoNetworkInterfaceSetUserDataNative(IntPtr obj, IntPtr userData);

		/// <summary>
		/// The family of a network interface.
		/// </summary>
		public enum NetworkInterfaceFamily {
			/// <summary>The interface state is unknown.</summary>
			NetworkinterfacefamilyUnspecified,
			/// <summary>The interface IPV4.</summary>
			NetworkinterfacefamilyIPV4,
			/// <summary>The interface is IPV6.</summary>
			NetworkinterfacefamilyIPV6
		}
		/// <summary>
		/// The state of a network interface.
		/// </summary>
		public enum NetworkInterfaceState {
			/// <summary>The interface state is unknown.</summary>
			NetworkinterfacestateUnknown,
			/// <summary>The interface is up.</summary>
			NetworkinterfacestateUp,
			/// <summary>The interface is down.</summary>
			NetworkinterfacestateDown
		}
		/// <summary>
		/// The trasport type used over the network interface.
		/// </summary>
		public enum NetworkInterfaceTransportType {
			/// <summary>The interface is used for signaling.</summary>
			NetworkinterfacetransporttypeSignaling,
			/// <summary>The interface is used fro Media.</summary>
			NetworkinterfacetransporttypeMedia,
			/// <summary>The interface is used fro Data.</summary>
			NetworkinterfacetransporttypeData
		}
		/// <summary>
		/// The connection type of a network interface.
		/// </summary>
		public enum NetworkInterfaceType {
			/// <summary>Some other type of interface.</summary>
			NetworkinterfacetypeOther,
			/// <summary>A wired interface.</summary>
			NetworkinterfacetypeWired,
			/// <summary>A Wi-Fi (802.11) interface.</summary>
			NetworkinterfacetypeWiFi,
			/// <summary>A WWAN (cellular data) interface.</summary>
			NetworkinterfacetypeWwan,
			/// <summary>A loopback interface.</summary>
			NetworkinterfacetypeLoopback,
			/// <summary>A tunneled interface.</summary>
			NetworkinterfacetypeTunneled,
			/// <summary>Network interface type is not applicable in this context.</summary>
			NetworkinterfacetypeNotApplicable
		}
		public NetworkInterface(IntPtr s){
			objPtr = VidyoNetworkInterfaceConstructCopyNative(s);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoNetworkInterfaceSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~NetworkInterface(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoNetworkInterfaceSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoNetworkInterfaceDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// Gets the address of the network interface.
		/// </summary>
		/// <param name="n">The VidyoNetworkInterface object.</param>
		public String GetAddress() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoNetworkInterfaceGetAddressNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the family of the network interface.
		/// </summary>
		/// <param name="n">The VidyoNetworkInterface object.</param>
		public NetworkInterfaceFamily GetFamily() {
			if (objPtr == IntPtr.Zero) { return default; }

			NetworkInterfaceFamily ret = VidyoNetworkInterfaceGetFamilyNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the name of the network interface.
		/// </summary>
		/// <param name="n">The VidyoNetworkInterface object.</param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoNetworkInterfaceGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the state of the network interface.
		/// </summary>
		/// <param name="n">The VidyoNetworkInterface object.</param>
		public NetworkInterfaceState GetState() {
			if (objPtr == IntPtr.Zero) { return default; }

			NetworkInterfaceState ret = VidyoNetworkInterfaceGetStateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the type of the network interface.
		/// </summary>
		/// <param name="n">The VidyoNetworkInterface object.</param>
		public NetworkInterfaceType GetType() {
			if (objPtr == IntPtr.Zero) { return default; }

			NetworkInterfaceType ret = VidyoNetworkInterfaceGetTypeNative(objPtr);

			return ret;
		}
	};
}
