// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// This object represents a participant in the room or call.
	/// </summary>
	public class Participant: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoParticipant reference.
		private GCHandle objHandle; // weak VidyoParticipant reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ParticipantApplicationType VidyoParticipantGetApplicationTypeNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ParticipantClearanceType VidyoParticipantGetClearanceTypeNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGetContactNative(IntPtr p, IntPtr contact);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoParticipantGetContactAsyncNative(IntPtr p, OnGetContactComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGetIdNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGetNameNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGetScipIdNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ParticipantTrust VidyoParticipantGetTrustNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGetUserIdNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoParticipantIsHiddenNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoParticipantIsLocalNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoParticipantIsRecordingNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoParticipantIsSelectableNative(IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoParticipantGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoParticipantSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetContactComplete(IntPtr p, IntPtr contact, ParticipantGetContactResult result);
		private OnGetContactComplete _mOnGetContactComplete = OnGetContactCompleteDelegate;
		/// <summary>
		/// This type indicates the trust status of a participant.
		/// </summary>
		public enum ParticipantApplicationType {
			/// <summary>default application type.</summary>
			ParticipantAPPLICATIONTYPE_None,
			/// <summary>Recorder application type</summary>
			ParticipantAPPLICATIONTYPE_Recorder,
			/// <summary>Gateway application type</summary>
			ParticipantAPPLICATIONTYPE_Gateway,
			/// <summary>Bot application type</summary>
			ParticipantAPPLICATIONTYPE_Bot
		}
		/// <summary>
		/// Clearance of an participant. This is used to determine what the participant is allowed to do.
		/// </summary>
		public enum ParticipantClearanceType {
			/// <summary>Guest participant with no privileges.</summary>
			ParticipantCLEARANCETYPE_None,
			/// <summary>Normal participant with normal privileges.</summary>
			ParticipantCLEARANCETYPE_Member,
			/// <summary>Owner of the conference room, has full privileges.</summary>
			ParticipantCLEARANCETYPE_Owner,
			/// <summary>Administrator of the conference room, has full privileges except it can not promote other participants to Admin clearance.</summary>
			ParticipantCLEARANCETYPE_Admin,
			/// <summary>Moderator of the conference, has ability to control all aspects of the conference.</summary>
			ParticipantCLEARANCETYPE_Moderator
		}
		/// <summary>
		/// Result of getting the contact.
		/// </summary>
		public enum ParticipantGetContactResult {
			/// <summary>Contact was got successfully.</summary>
			ParticipantgetcontactresultSUCCESS,
			/// <summary>Getting the contact failed some miscellaneous reason.</summary>
			ParticipantgetcontactresultMiscError
		}
		/// <summary>
		/// Structure that will contain a different hand state for a particular participant.
		/// </summary>
		public enum ParticipantHandState {
			/// <summary>UnRaised State.</summary>
			ParticipanthandstateUNRAISED,
			/// <summary>when participate raise hand.</summary>
			ParticipanthandstateRAISED,
			/// <summary>Participant request is approved.</summary>
			ParticipanthandstateAPPROVED,
			/// <summary>Participant request is dismissed.</summary>
			ParticipanthandstateDISMISSED
		}
		/// <summary>
		/// This type indicates the trust status of a participant.
		/// </summary>
		public enum ParticipantTrust {
			/// <summary>Locally authenticated user.</summary>
			ParticipanttrustLocal,
			/// <summary>Federated from another trusted server.</summary>
			ParticipanttrustFederated,
			/// <summary>Untrusted guest user.</summary>
			ParticipanttrustAnonymous
		}
		public interface IGetContactAsync{

			void OnGetContactComplete(Contact contact, ParticipantGetContactResult result);
		}
		private IGetContactAsync _mIGetContactAsync;
		public Participant(IntPtr other){
			objPtr = VidyoParticipantConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoParticipantSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~Participant(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoParticipantSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoParticipantDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public ParticipantApplicationType GetApplicationType() {
			if (objPtr == IntPtr.Zero) { return default; }

			ParticipantApplicationType ret = VidyoParticipantGetApplicationTypeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the clearance type of the participant.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public ParticipantClearanceType GetClearanceType() {
			if (objPtr == IntPtr.Zero) { return default; }

			ParticipantClearanceType ret = VidyoParticipantGetClearanceTypeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		/// <param name="contact"></param>
		public Contact GetContact(ref Contact contact) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoParticipantGetContactNative(objPtr, (contact != null) ? contact.GetObjectPtr():IntPtr.Zero);
			Contact csRet = new Contact(ret);

			contact = csRet;
			return csRet;
		}
		/// <summary>
		/// Gets conntact.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		/// <param name="onComplete">The callback that is triggered when getting contact completes.</param>
		public Boolean GetContactAsync(IGetContactAsync _iIGetContactAsync) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetContactAsync = _iIGetContactAsync;

			Boolean ret = VidyoParticipantGetContactAsyncNative(objPtr, _mOnGetContactComplete);

			return ret;
		}
		/// <summary>
		/// Gets the ID that is globally unique such as user@domain.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoParticipantGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the display name of the participant.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoParticipantGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the SCIP ID unique to the room or call only.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public String GetScipId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoParticipantGetScipIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="p"></param>
		public ParticipantTrust GetTrust() {
			if (objPtr == IntPtr.Zero) { return default; }

			ParticipantTrust ret = VidyoParticipantGetTrustNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the ID that is globally unique such as user@domain.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public String GetUserId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoParticipantGetUserIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the hidden state of the participant.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public Boolean IsHidden() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoParticipantIsHiddenNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public Boolean IsLocal() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoParticipantIsLocalNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the recording state of the participant.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public Boolean IsRecording() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoParticipantIsRecordingNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the selectable state of the participant.
		/// </summary>
		/// <param name="p">The VidyoParticipant object.</param>
		public Boolean IsSelectable() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoParticipantIsSelectableNative(objPtr);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetContactComplete))]
#endif
		private static void OnGetContactCompleteDelegate(IntPtr p, IntPtr contact, ParticipantGetContactResult result){
			var csPPtr = p != IntPtr.Zero ? VidyoParticipantGetUserDataNative(p) : IntPtr.Zero;
			if(csPPtr == IntPtr.Zero) return;
			var csP = (Participant)GCHandle.FromIntPtr(csPPtr).Target;

			Contact csContact = new Contact(contact);
			csP?._mIGetContactAsync?.OnGetContactComplete(csContact, result);
		}
	};
}
