// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class ParticipantGenerationStatsFactory
	{
		public static ParticipantGenerationStats Create()
		{
			return new ParticipantGenerationStats(IntPtr.Zero);
		}
		public static void Destroy(ParticipantGenerationStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a participnat generation, ordered list of dynamic participants.
	/// </summary>
	public class ParticipantGenerationStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoParticipantGenerationStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nCameraId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(cameraId ?? string.Empty);
			IntPtr nCameraName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(cameraName ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoParticipantGenerationStatsSetcameraIdNative(objPtr, nCameraId);
			VidyoParticipantGenerationStatsSetcameraNameNative(objPtr, nCameraName);
			VidyoParticipantGenerationStatsSetenabledNative(objPtr, enabled);
			VidyoParticipantGenerationStatsSetframeIntervalNative(objPtr, frameInterval);
			VidyoParticipantGenerationStatsSetheightNative(objPtr, height);
			VidyoParticipantGenerationStatsSetidNative(objPtr, nId);
			VidyoParticipantGenerationStatsSetnameNative(objPtr, nName);
			VidyoParticipantGenerationStatsSetpixelRateNative(objPtr, pixelRate);
			VidyoParticipantGenerationStatsSetwidthNative(objPtr, width);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nCameraName);
			Marshal.FreeHGlobal(nCameraId);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGenerationStatsGetcameraIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetcameraIdNative(IntPtr obj, IntPtr cameraId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGenerationStatsGetcameraNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetcameraNameNative(IntPtr obj, IntPtr cameraName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoParticipantGenerationStatsGetenabledNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetenabledNative(IntPtr obj, Boolean enabled);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoParticipantGenerationStatsGetframeIntervalNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetframeIntervalNative(IntPtr obj, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoParticipantGenerationStatsGetheightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetheightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGenerationStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantGenerationStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoParticipantGenerationStatsGetpixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetpixelRateNative(IntPtr obj, ulong pixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoParticipantGenerationStatsGetwidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantGenerationStatsSetwidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoParticipantGenerationStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoParticipantGenerationStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoParticipantGenerationStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Camera id.
		/// </summary>
		public String cameraId;
		/// <summary>
		/// Camera name.
		/// </summary>
		public String cameraName;
		/// <summary>
		/// State of the generation.
		/// </summary>
		public Boolean enabled;
		/// <summary>
		/// Frame interval setting.
		/// </summary>
		public ulong frameInterval;
		/// <summary>
		/// Height.
		/// </summary>
		public SizeT height;
		/// <summary>
		/// Participant id.
		/// </summary>
		public String id;
		/// <summary>
		/// Participant name.
		/// </summary>
		public String name;
		/// <summary>
		/// Pixel rate to ask for.
		/// </summary>
		public ulong pixelRate;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT width;
		public ParticipantGenerationStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoParticipantGenerationStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoParticipantGenerationStatsConstructCopyNative(obj);
			}

			cameraId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantGenerationStatsGetcameraIdNative(objPtr));
			cameraName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantGenerationStatsGetcameraNameNative(objPtr));
			enabled = VidyoParticipantGenerationStatsGetenabledNative(objPtr);
			frameInterval = VidyoParticipantGenerationStatsGetframeIntervalNative(objPtr);
			height = VidyoParticipantGenerationStatsGetheightNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantGenerationStatsGetidNative(objPtr));
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantGenerationStatsGetnameNative(objPtr));
			pixelRate = VidyoParticipantGenerationStatsGetpixelRateNative(objPtr);
			width = VidyoParticipantGenerationStatsGetwidthNative(objPtr);
		}
		~ParticipantGenerationStats() {
			VidyoParticipantGenerationStatsDestructNative(objPtr);
		 }
	};
}
