// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class RemoteMicrophoneStatsFactory
	{
		public static RemoteMicrophoneStats Create()
		{
			return new RemoteMicrophoneStats(IntPtr.Zero);
		}
		public static void Destroy(RemoteMicrophoneStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a remote microphone.
	/// </summary>
	public class RemoteMicrophoneStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRemoteMicrophoneStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nCodecName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(codecName ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nLocalSpeakerStreams = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localSpeakerStreams.Count);
			int nLocalSpeakerStreamsSize = 0;
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			foreach (LocalSpeakerStreamStats iter in localSpeakerStreams) {
				Marshal.WriteIntPtr(nLocalSpeakerStreams + (nLocalSpeakerStreamsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalSpeakerStreamsSize++;
			}

			VidyoRemoteMicrophoneStatsSetbitsPerSampleNative(objPtr, bitsPerSample);
			VidyoRemoteMicrophoneStatsSetcodecDtxNative(objPtr, codecDtx);
			VidyoRemoteMicrophoneStatsSetcodecNameNative(objPtr, nCodecName);
			VidyoRemoteMicrophoneStatsSetcodecQualitySettingNative(objPtr, codecQualitySetting);
			VidyoRemoteMicrophoneStatsSetidNative(objPtr, nId);
			VidyoRemoteMicrophoneStatsSetlastFrameMsNative(objPtr, lastFrameMs);
			VidyoRemoteMicrophoneStatsSetlocalSpeakerStreamsNative(objPtr, nLocalSpeakerStreams, nLocalSpeakerStreamsSize);
			VidyoRemoteMicrophoneStatsSetnameNative(objPtr, nName);
			VidyoRemoteMicrophoneStatsSetnumberOfChannelsNative(objPtr, numberOfChannels);
			VidyoRemoteMicrophoneStatsSetreceiveNetworkBitRateNative(objPtr, receiveNetworkBitRate);
			VidyoRemoteMicrophoneStatsSetreceiveNetworkDelayNative(objPtr, receiveNetworkDelay);
			VidyoRemoteMicrophoneStatsSetreceiveNetworkDroppedPacketsNative(objPtr, receiveNetworkDroppedPackets);
			VidyoRemoteMicrophoneStatsSetreceiveNetworkJitterNative(objPtr, receiveNetworkJitter);
			VidyoRemoteMicrophoneStatsSetreceiveNetworkPacketsConcealedNative(objPtr, receiveNetworkPacketsConcealed);
			VidyoRemoteMicrophoneStatsSetreceiveNetworkPacketsLostNative(objPtr, receiveNetworkPacketsLost);
			VidyoRemoteMicrophoneStatsSetsampleRateMeasuredNative(objPtr, sampleRateMeasured);
			VidyoRemoteMicrophoneStatsSetsampleRateSetNative(objPtr, sampleRateSet);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nLocalSpeakerStreams);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nCodecName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteMicrophoneStatsGetbitsPerSampleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetbitsPerSampleNative(IntPtr obj, uint bitsPerSample);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteMicrophoneStatsGetcodecDtxNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetcodecDtxNative(IntPtr obj, uint codecDtx);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneStatsGetcodecNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetcodecNameNative(IntPtr obj, IntPtr codecName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteMicrophoneStatsGetcodecQualitySettingNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetcodecQualitySettingNative(IntPtr obj, uint codecQualitySetting);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoRemoteMicrophoneStatsGetlastFrameMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetlastFrameMsNative(IntPtr obj, int lastFrameMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneStatsGetlocalSpeakerStreamsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetlocalSpeakerStreamsNative(IntPtr obj, IntPtr localSpeakerStreams, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneStatsGetlocalSpeakerStreamsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsFreelocalSpeakerStreamsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteMicrophoneStatsGetnumberOfChannelsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetnumberOfChannelsNative(IntPtr obj, uint numberOfChannels);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteMicrophoneStatsGetreceiveNetworkBitRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetreceiveNetworkBitRateNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkBitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRemoteMicrophoneStatsGetreceiveNetworkDelayNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetreceiveNetworkDelayNative(IntPtr obj, ulong receiveNetworkDelay);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteMicrophoneStatsGetreceiveNetworkDroppedPacketsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetreceiveNetworkDroppedPacketsNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkDroppedPackets);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteMicrophoneStatsGetreceiveNetworkJitterNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetreceiveNetworkJitterNative(IntPtr obj, uint receiveNetworkJitter);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteMicrophoneStatsGetreceiveNetworkPacketsConcealedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetreceiveNetworkPacketsConcealedNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkPacketsConcealed);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteMicrophoneStatsGetreceiveNetworkPacketsLostNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetreceiveNetworkPacketsLostNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkPacketsLost);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteMicrophoneStatsGetsampleRateMeasuredNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetsampleRateMeasuredNative(IntPtr obj, uint sampleRateMeasured);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteMicrophoneStatsGetsampleRateSetNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneStatsSetsampleRateSetNative(IntPtr obj, uint sampleRateSet);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteMicrophoneStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteMicrophoneStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRemoteMicrophoneStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Bits per sample.
		/// </summary>
		public uint bitsPerSample;
		/// <summary>
		/// Codec DTX.
		/// </summary>
		public uint codecDtx;
		/// <summary>
		/// Codec name.
		/// </summary>
		public String codecName;
		/// <summary>
		/// Codec quality setting.
		/// </summary>
		public uint codecQualitySetting;
		/// <summary>
		/// Id.
		/// </summary>
		public String id;
		/// <summary>
		/// Milliseconds since last received frame.
		/// </summary>
		public int lastFrameMs;
		/// <summary>
		/// Vector of stats of local speaker streams.
		/// </summary>
		public List<LocalSpeakerStreamStats> localSpeakerStreams;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Number of channels.
		/// </summary>
		public uint numberOfChannels;
		/// <summary>
		/// Bandwidth of receive network.
		/// </summary>
		public SizeT receiveNetworkBitRate;
		/// <summary>
		/// Delay in receive network.
		/// </summary>
		public ulong receiveNetworkDelay;
		/// <summary>
		/// Dropped packets in receive network.
		/// </summary>
		public SizeT receiveNetworkDroppedPackets;
		/// <summary>
		/// Jitter in receive network.
		/// </summary>
		public uint receiveNetworkJitter;
		/// <summary>
		/// Concealed packets in receive network.
		/// </summary>
		public SizeT receiveNetworkPacketsConcealed;
		/// <summary>
		/// Lost packets in receive network.
		/// </summary>
		public SizeT receiveNetworkPacketsLost;
		/// <summary>
		/// Measured sample rate.
		/// </summary>
		public uint sampleRateMeasured;
		/// <summary>
		/// Sample rate setting.
		/// </summary>
		public uint sampleRateSet;
		public RemoteMicrophoneStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoRemoteMicrophoneStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoRemoteMicrophoneStatsConstructCopyNative(obj);
			}

			List<LocalSpeakerStreamStats> csLocalSpeakerStreams = new List<LocalSpeakerStreamStats>();
			var nLocalSpeakerStreamsSize = 0;
			var nLocalSpeakerStreams = VidyoRemoteMicrophoneStatsGetlocalSpeakerStreamsArrayNative(VidyoRemoteMicrophoneStatsGetlocalSpeakerStreamsNative(objPtr), ref nLocalSpeakerStreamsSize);
			var nLocalSpeakerStreamsIndex = 0;
			while (nLocalSpeakerStreamsIndex < nLocalSpeakerStreamsSize) {
				LocalSpeakerStreamStats csTlocalSpeakerStreams = new LocalSpeakerStreamStats(Marshal.ReadIntPtr(nLocalSpeakerStreams + (nLocalSpeakerStreamsIndex * Marshal.SizeOf(nLocalSpeakerStreams))));
				csLocalSpeakerStreams.Add(csTlocalSpeakerStreams);
				nLocalSpeakerStreamsIndex++;
			}

			bitsPerSample = VidyoRemoteMicrophoneStatsGetbitsPerSampleNative(objPtr);
			codecDtx = VidyoRemoteMicrophoneStatsGetcodecDtxNative(objPtr);
			codecName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteMicrophoneStatsGetcodecNameNative(objPtr));
			codecQualitySetting = VidyoRemoteMicrophoneStatsGetcodecQualitySettingNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteMicrophoneStatsGetidNative(objPtr));
			lastFrameMs = VidyoRemoteMicrophoneStatsGetlastFrameMsNative(objPtr);
			localSpeakerStreams = csLocalSpeakerStreams;
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteMicrophoneStatsGetnameNative(objPtr));
			numberOfChannels = VidyoRemoteMicrophoneStatsGetnumberOfChannelsNative(objPtr);
			receiveNetworkBitRate = VidyoRemoteMicrophoneStatsGetreceiveNetworkBitRateNative(objPtr);
			receiveNetworkDelay = VidyoRemoteMicrophoneStatsGetreceiveNetworkDelayNative(objPtr);
			receiveNetworkDroppedPackets = VidyoRemoteMicrophoneStatsGetreceiveNetworkDroppedPacketsNative(objPtr);
			receiveNetworkJitter = VidyoRemoteMicrophoneStatsGetreceiveNetworkJitterNative(objPtr);
			receiveNetworkPacketsConcealed = VidyoRemoteMicrophoneStatsGetreceiveNetworkPacketsConcealedNative(objPtr);
			receiveNetworkPacketsLost = VidyoRemoteMicrophoneStatsGetreceiveNetworkPacketsLostNative(objPtr);
			sampleRateMeasured = VidyoRemoteMicrophoneStatsGetsampleRateMeasuredNative(objPtr);
			sampleRateSet = VidyoRemoteMicrophoneStatsGetsampleRateSetNative(objPtr);
			VidyoRemoteMicrophoneStatsFreelocalSpeakerStreamsArrayNative(nLocalSpeakerStreams, nLocalSpeakerStreamsSize);
		}
		~RemoteMicrophoneStats() {
			VidyoRemoteMicrophoneStatsDestructNative(objPtr);
		 }
	};
}
