// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class RemoteVideoSourceStatsFactory
	{
		public static RemoteVideoSourceStats Create()
		{
			return new RemoteVideoSourceStats(IntPtr.Zero);
		}
		public static void Destroy(RemoteVideoSourceStats obj)
		{
		}
	}
	/// <summary>
	/// Statistics for a remote video source.
	/// </summary>
	public class RemoteVideoSourceStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRemoteVideoSourceStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nCodecName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(codecName ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nLocalRendererStreams = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localRendererStreams.Count);
			int nLocalRendererStreamsSize = 0;
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nShowState = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(showState ?? string.Empty);

			foreach (LocalRendererStreamStats iter in localRendererStreams) {
				Marshal.WriteIntPtr(nLocalRendererStreams + (nLocalRendererStreamsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalRendererStreamsSize++;
			}

			VidyoRemoteVideoSourceStatsSetcodecFirNative(objPtr, codecFir);
			VidyoRemoteVideoSourceStatsSetcodecIFramesNative(objPtr, codecIFrames);
			VidyoRemoteVideoSourceStatsSetcodecLayersNative(objPtr, codecLayers);
			VidyoRemoteVideoSourceStatsSetcodecNacksNative(objPtr, codecNacks);
			VidyoRemoteVideoSourceStatsSetcodecNameNative(objPtr, nCodecName);
			VidyoRemoteVideoSourceStatsSetfirstFrameDelayNative(objPtr, firstFrameDelay);
			VidyoRemoteVideoSourceStatsSetfpsDecodedNative(objPtr, fpsDecoded);
			VidyoRemoteVideoSourceStatsSetfpsDecoderInputNative(objPtr, fpsDecoderInput);
			VidyoRemoteVideoSourceStatsSetfpsRenderedNative(objPtr, fpsRendered);
			VidyoRemoteVideoSourceStatsSetheightNative(objPtr, height);
			VidyoRemoteVideoSourceStatsSetidNative(objPtr, nId);
			VidyoRemoteVideoSourceStatsSetlastFrameMsNative(objPtr, lastFrameMs);
			VidyoRemoteVideoSourceStatsSetlocalRendererStreamsNative(objPtr, nLocalRendererStreams, nLocalRendererStreamsSize);
			VidyoRemoteVideoSourceStatsSetmaxStreamFrameRateNative(objPtr, maxStreamFrameRate);
			VidyoRemoteVideoSourceStatsSetmaxStreamHeightNative(objPtr, maxStreamHeight);
			VidyoRemoteVideoSourceStatsSetmaxStreamWidthNative(objPtr, maxStreamWidth);
			VidyoRemoteVideoSourceStatsSetnameNative(objPtr, nName);
			VidyoRemoteVideoSourceStatsSetreceiveNetworkBitRateNative(objPtr, receiveNetworkBitRate);
			VidyoRemoteVideoSourceStatsSetreceiveNetworkPacketsConcealedNative(objPtr, receiveNetworkPacketsConcealed);
			VidyoRemoteVideoSourceStatsSetreceiveNetworkPacketsLostNative(objPtr, receiveNetworkPacketsLost);
			VidyoRemoteVideoSourceStatsSetreceiveNetworkPacketsReorderedNative(objPtr, receiveNetworkPacketsReordered);
			VidyoRemoteVideoSourceStatsSetreceiveNetworkRecoveredWithFecNative(objPtr, receiveNetworkRecoveredWithFec);
			VidyoRemoteVideoSourceStatsSetshowFrameRateNative(objPtr, showFrameRate);
			VidyoRemoteVideoSourceStatsSetshowHeightNative(objPtr, showHeight);
			VidyoRemoteVideoSourceStatsSetshowPixelRateNative(objPtr, showPixelRate);
			VidyoRemoteVideoSourceStatsSetshowStateNative(objPtr, nShowState);
			VidyoRemoteVideoSourceStatsSetshowWidthNative(objPtr, showWidth);
			VidyoRemoteVideoSourceStatsSetvideoDeltaFromAudioMsNative(objPtr, videoDeltaFromAudioMs);
			VidyoRemoteVideoSourceStatsSetwidthNative(objPtr, width);

			Marshal.FreeHGlobal(nShowState);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nLocalRendererStreams);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nCodecName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetcodecFirNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetcodecFirNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT codecFir);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetcodecIFramesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetcodecIFramesNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT codecIFrames);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetcodecLayersNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetcodecLayersNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT codecLayers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetcodecNacksNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetcodecNacksNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT codecNacks);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteVideoSourceStatsGetcodecNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetcodecNameNative(IntPtr obj, IntPtr codecName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoRemoteVideoSourceStatsGetfirstFrameDelayNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetfirstFrameDelayNative(IntPtr obj, int firstFrameDelay);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetfpsDecodedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetfpsDecodedNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT fpsDecoded);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetfpsDecoderInputNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetfpsDecoderInputNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT fpsDecoderInput);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetfpsRenderedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetfpsRenderedNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT fpsRendered);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetheightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetheightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteVideoSourceStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoRemoteVideoSourceStatsGetlastFrameMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetlastFrameMsNative(IntPtr obj, int lastFrameMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteVideoSourceStatsGetlocalRendererStreamsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetlocalRendererStreamsNative(IntPtr obj, IntPtr localRendererStreams, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteVideoSourceStatsGetlocalRendererStreamsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsFreelocalRendererStreamsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteVideoSourceStatsGetmaxStreamFrameRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetmaxStreamFrameRateNative(IntPtr obj, uint maxStreamFrameRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetmaxStreamHeightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetmaxStreamHeightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxStreamHeight);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetmaxStreamWidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetmaxStreamWidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxStreamWidth);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteVideoSourceStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetreceiveNetworkBitRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetreceiveNetworkBitRateNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkBitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetreceiveNetworkPacketsConcealedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetreceiveNetworkPacketsConcealedNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkPacketsConcealed);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetreceiveNetworkPacketsLostNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetreceiveNetworkPacketsLostNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkPacketsLost);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetreceiveNetworkPacketsReorderedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetreceiveNetworkPacketsReorderedNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkPacketsReordered);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetreceiveNetworkRecoveredWithFecNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetreceiveNetworkRecoveredWithFecNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT receiveNetworkRecoveredWithFec);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteVideoSourceStatsGetshowFrameRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetshowFrameRateNative(IntPtr obj, uint showFrameRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetshowHeightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetshowHeightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT showHeight);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRemoteVideoSourceStatsGetshowPixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetshowPixelRateNative(IntPtr obj, ulong showPixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteVideoSourceStatsGetshowStateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetshowStateNative(IntPtr obj, IntPtr showState);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetshowWidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetshowWidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT showWidth);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoRemoteVideoSourceStatsGetvideoDeltaFromAudioMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetvideoDeltaFromAudioMsNative(IntPtr obj, int videoDeltaFromAudioMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteVideoSourceStatsGetwidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteVideoSourceStatsSetwidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteVideoSourceStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteVideoSourceStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRemoteVideoSourceStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Codec FIR.
		/// </summary>
		public SizeT codecFir;
		/// <summary>
		/// Codec I frames.
		/// </summary>
		public SizeT codecIFrames;
		/// <summary>
		/// Codec layers.
		/// </summary>
		public SizeT codecLayers;
		/// <summary>
		/// Codec nacks.
		/// </summary>
		public SizeT codecNacks;
		/// <summary>
		/// Codec name.
		/// </summary>
		public String codecName;
		/// <summary>
		/// Milliseconds since add video source to renderer and receive first frame.
		/// </summary>
		public int firstFrameDelay;
		/// <summary>
		/// Frame rate of decoder output.
		/// </summary>
		public SizeT fpsDecoded;
		/// <summary>
		/// Frame rate at decoder input.
		/// </summary>
		public SizeT fpsDecoderInput;
		/// <summary>
		/// Frame rate of renderer.
		/// </summary>
		public SizeT fpsRendered;
		/// <summary>
		/// Height.
		/// </summary>
		public SizeT height;
		/// <summary>
		/// Id.
		/// </summary>
		public String id;
		/// <summary>
		/// Milliseconds since last received frame.
		/// </summary>
		public int lastFrameMs;
		/// <summary>
		/// Vector of stats of local renderer streams.
		/// </summary>
		public List<LocalRendererStreamStats> localRendererStreams;
		/// <summary>
		/// Width.
		/// </summary>
		public uint maxStreamFrameRate;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT maxStreamHeight;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT maxStreamWidth;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Source bitrate.
		/// </summary>
		public SizeT receiveNetworkBitRate;
		/// <summary>
		/// Number of packets concealed.
		/// </summary>
		public SizeT receiveNetworkPacketsConcealed;
		/// <summary>
		/// Number of lost packets.
		/// </summary>
		public SizeT receiveNetworkPacketsLost;
		/// <summary>
		/// Number of packets reordered.
		/// </summary>
		public SizeT receiveNetworkPacketsReordered;
		/// <summary>
		/// Number of packets recovered with FEC.
		/// </summary>
		public SizeT receiveNetworkRecoveredWithFec;
		/// <summary>
		/// Width.
		/// </summary>
		public uint showFrameRate;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT showHeight;
		/// <summary>
		/// Width.
		/// </summary>
		public ulong showPixelRate;
		/// <summary>
		/// State of how the source is received from the server (on/off/auto).
		/// </summary>
		public String showState;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT showWidth;
		/// <summary>
		/// Last known delta between audio and video before de-jittering in milliseconds. Negative number means audio is behind video.
		/// </summary>
		public int videoDeltaFromAudioMs;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT width;
		public RemoteVideoSourceStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoRemoteVideoSourceStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoRemoteVideoSourceStatsConstructCopyNative(obj);
			}

			List<LocalRendererStreamStats> csLocalRendererStreams = new List<LocalRendererStreamStats>();
			var nLocalRendererStreamsSize = 0;
			var nLocalRendererStreams = VidyoRemoteVideoSourceStatsGetlocalRendererStreamsArrayNative(VidyoRemoteVideoSourceStatsGetlocalRendererStreamsNative(objPtr), ref nLocalRendererStreamsSize);
			var nLocalRendererStreamsIndex = 0;
			while (nLocalRendererStreamsIndex < nLocalRendererStreamsSize) {
				LocalRendererStreamStats csTlocalRendererStreams = new LocalRendererStreamStats(Marshal.ReadIntPtr(nLocalRendererStreams + (nLocalRendererStreamsIndex * Marshal.SizeOf(nLocalRendererStreams))));
				csLocalRendererStreams.Add(csTlocalRendererStreams);
				nLocalRendererStreamsIndex++;
			}

			codecFir = VidyoRemoteVideoSourceStatsGetcodecFirNative(objPtr);
			codecIFrames = VidyoRemoteVideoSourceStatsGetcodecIFramesNative(objPtr);
			codecLayers = VidyoRemoteVideoSourceStatsGetcodecLayersNative(objPtr);
			codecNacks = VidyoRemoteVideoSourceStatsGetcodecNacksNative(objPtr);
			codecName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteVideoSourceStatsGetcodecNameNative(objPtr));
			firstFrameDelay = VidyoRemoteVideoSourceStatsGetfirstFrameDelayNative(objPtr);
			fpsDecoded = VidyoRemoteVideoSourceStatsGetfpsDecodedNative(objPtr);
			fpsDecoderInput = VidyoRemoteVideoSourceStatsGetfpsDecoderInputNative(objPtr);
			fpsRendered = VidyoRemoteVideoSourceStatsGetfpsRenderedNative(objPtr);
			height = VidyoRemoteVideoSourceStatsGetheightNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteVideoSourceStatsGetidNative(objPtr));
			lastFrameMs = VidyoRemoteVideoSourceStatsGetlastFrameMsNative(objPtr);
			localRendererStreams = csLocalRendererStreams;
			maxStreamFrameRate = VidyoRemoteVideoSourceStatsGetmaxStreamFrameRateNative(objPtr);
			maxStreamHeight = VidyoRemoteVideoSourceStatsGetmaxStreamHeightNative(objPtr);
			maxStreamWidth = VidyoRemoteVideoSourceStatsGetmaxStreamWidthNative(objPtr);
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteVideoSourceStatsGetnameNative(objPtr));
			receiveNetworkBitRate = VidyoRemoteVideoSourceStatsGetreceiveNetworkBitRateNative(objPtr);
			receiveNetworkPacketsConcealed = VidyoRemoteVideoSourceStatsGetreceiveNetworkPacketsConcealedNative(objPtr);
			receiveNetworkPacketsLost = VidyoRemoteVideoSourceStatsGetreceiveNetworkPacketsLostNative(objPtr);
			receiveNetworkPacketsReordered = VidyoRemoteVideoSourceStatsGetreceiveNetworkPacketsReorderedNative(objPtr);
			receiveNetworkRecoveredWithFec = VidyoRemoteVideoSourceStatsGetreceiveNetworkRecoveredWithFecNative(objPtr);
			showFrameRate = VidyoRemoteVideoSourceStatsGetshowFrameRateNative(objPtr);
			showHeight = VidyoRemoteVideoSourceStatsGetshowHeightNative(objPtr);
			showPixelRate = VidyoRemoteVideoSourceStatsGetshowPixelRateNative(objPtr);
			showState = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteVideoSourceStatsGetshowStateNative(objPtr));
			showWidth = VidyoRemoteVideoSourceStatsGetshowWidthNative(objPtr);
			videoDeltaFromAudioMs = VidyoRemoteVideoSourceStatsGetvideoDeltaFromAudioMsNative(objPtr);
			width = VidyoRemoteVideoSourceStatsGetwidthNative(objPtr);
			VidyoRemoteVideoSourceStatsFreelocalRendererStreamsArrayNative(nLocalRendererStreams, nLocalRendererStreamsSize);
		}
		~RemoteVideoSourceStats() {
			VidyoRemoteVideoSourceStatsDestructNative(objPtr);
		 }
	};
}
