// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class VideoPlaneFactory
	{
		public static VideoPlane Create()
		{
			return new VideoPlane(IntPtr.Zero);
		}
		public static void Destroy(VideoPlane obj)
		{
		}
	}
	/// <summary>
	/// Describes a plane of a video frame.
	/// </summary>
	public class VideoPlane {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoVideoPlane reference.
		public IntPtr GetObjectPtr() {

			VidyoVideoPlaneSetbufferNative(objPtr, buffer);
			VidyoVideoPlaneSetheightNative(objPtr, height);
			VidyoVideoPlaneSetoffsetNative(objPtr, offset);
			VidyoVideoPlaneSetpitchNative(objPtr, pitch);
			VidyoVideoPlaneSetsizeNative(objPtr, size);
			VidyoVideoPlaneSetwidthNative(objPtr, width);

			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVideoPlaneGetbufferNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoPlaneSetbufferNative(IntPtr obj, IntPtr buffer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoVideoPlaneGetheightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoPlaneSetheightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoVideoPlaneGetoffsetNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoPlaneSetoffsetNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT offset);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoVideoPlaneGetpitchNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoPlaneSetpitchNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT pitch);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoVideoPlaneGetsizeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoPlaneSetsizeNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoVideoPlaneGetwidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoPlaneSetwidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoVideoPlaneConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoVideoPlaneConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoVideoPlaneDestructNative(IntPtr obj);

		/// <summary>
		/// pointer to the plane buffer.
		/// </summary>
		public IntPtr buffer;
		/// <summary>
		/// The number of pitch sized rows in the plane buffer.
		/// </summary>
		public SizeT height;
		/// <summary>
		/// The number of bytes of padding before any rows of the image.
		/// </summary>
		public SizeT offset;
		/// <summary>
		/// The number of bytes in each row of the plane buffer.
		/// </summary>
		public SizeT pitch;
		/// <summary>
		/// The size in bytes of the buffer.
		/// </summary>
		public SizeT size;
		/// <summary>
		/// The width in pixels of the plane.
		/// </summary>
		public SizeT width;
		public VideoPlane(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoVideoPlaneConstructDefaultNative();
			}
			else {
				objPtr = VidyoVideoPlaneConstructCopyNative(obj);
			}

			buffer = VidyoVideoPlaneGetbufferNative(objPtr);
			height = VidyoVideoPlaneGetheightNative(objPtr);
			offset = VidyoVideoPlaneGetoffsetNative(objPtr);
			pitch = VidyoVideoPlaneGetpitchNative(objPtr);
			size = VidyoVideoPlaneGetsizeNative(objPtr);
			width = VidyoVideoPlaneGetwidthNative(objPtr);
		}
		~VideoPlane() {
			VidyoVideoPlaneDestructNative(objPtr);
		 }
	};
}
