// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// 
	/// </summary>
	public class VirtualDeviceManager: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoVirtualDeviceManager reference.
		private GCHandle objHandle; // weak VidyoVirtualDeviceManager reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVirtualDeviceManagerConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVirtualDeviceManagerDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualDeviceManagerLocalCameraEventNative(IntPtr m, IntPtr endpoint, IntPtr camera, [MarshalAs(UnmanagedType.I4)]Device.DeviceState state);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualDeviceManagerLocalMicrophoneEventNative(IntPtr m, IntPtr endpoint, IntPtr microphone, [MarshalAs(UnmanagedType.I4)]Device.DeviceState state);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualDeviceManagerLocalSpeakerEventNative(IntPtr m, IntPtr endpoint, IntPtr speaker, [MarshalAs(UnmanagedType.I4)]Device.DeviceState state);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualDeviceManagerMediaFailedEventNative(IntPtr m, IntPtr endpoint);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoVirtualDeviceManagerGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoVirtualDeviceManagerSetUserDataNative(IntPtr obj, IntPtr userData);

		public VirtualDeviceManager(IntPtr other){
			objPtr = VidyoVirtualDeviceManagerConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoVirtualDeviceManagerSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~VirtualDeviceManager(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoVirtualDeviceManagerSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoVirtualDeviceManagerDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="endpoint"></param>
		/// <param name="camera"></param>
		/// <param name="state"></param>
		public Boolean LocalCameraEvent(Endpoint endpoint, LocalCamera camera, Device.DeviceState state) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualDeviceManagerLocalCameraEventNative(objPtr, (endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero, (camera != null) ? camera.GetObjectPtr():IntPtr.Zero, state);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="endpoint"></param>
		/// <param name="microphone"></param>
		/// <param name="state"></param>
		public Boolean LocalMicrophoneEvent(Endpoint endpoint, LocalMicrophone microphone, Device.DeviceState state) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualDeviceManagerLocalMicrophoneEventNative(objPtr, (endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero, (microphone != null) ? microphone.GetObjectPtr():IntPtr.Zero, state);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="endpoint"></param>
		/// <param name="speaker"></param>
		/// <param name="state"></param>
		public Boolean LocalSpeakerEvent(Endpoint endpoint, LocalSpeaker speaker, Device.DeviceState state) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualDeviceManagerLocalSpeakerEventNative(objPtr, (endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero, (speaker != null) ? speaker.GetObjectPtr():IntPtr.Zero, state);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="endpoint"></param>
		public Boolean MediaFailedEvent(Endpoint endpoint) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualDeviceManagerMediaFailedEventNative(objPtr, (endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
	};
}
