// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// 
	/// </summary>
	public class VirtualShareManager: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoVirtualShareManager reference.
		private GCHandle objHandle; // weak VidyoVirtualShareManager reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVirtualShareManagerConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVirtualShareManagerDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualShareManagerLocalMonitorEventNative(IntPtr m, IntPtr endpoint, IntPtr monitor, [MarshalAs(UnmanagedType.I4)]Device.DeviceState state);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualShareManagerLocalWindowShareEventNative(IntPtr m, IntPtr endpoint, IntPtr windowShare, [MarshalAs(UnmanagedType.I4)]Device.DeviceState state);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualShareManagerMediaFailedEventNative(IntPtr m, IntPtr endpoint);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoVirtualShareManagerGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoVirtualShareManagerSetUserDataNative(IntPtr obj, IntPtr userData);

		public VirtualShareManager(IntPtr other){
			objPtr = VidyoVirtualShareManagerConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoVirtualShareManagerSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~VirtualShareManager(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoVirtualShareManagerSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoVirtualShareManagerDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="endpoint"></param>
		/// <param name="monitor"></param>
		/// <param name="state"></param>
		public Boolean LocalMonitorEvent(Endpoint endpoint, LocalMonitor monitor, Device.DeviceState state) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualShareManagerLocalMonitorEventNative(objPtr, (endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero, (monitor != null) ? monitor.GetObjectPtr():IntPtr.Zero, state);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="endpoint"></param>
		/// <param name="windowShare"></param>
		/// <param name="state"></param>
		public Boolean LocalWindowShareEvent(Endpoint endpoint, LocalWindowShare windowShare, Device.DeviceState state) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualShareManagerLocalWindowShareEventNative(objPtr, (endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero, (windowShare != null) ? windowShare.GetObjectPtr():IntPtr.Zero, state);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="endpoint"></param>
		public Boolean MediaFailedEvent(Endpoint endpoint) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualShareManagerMediaFailedEventNative(objPtr, (endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
	};
}
