// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// This object represents a virtual video source on the local endpoint.
	/// </summary>
	public class VirtualVideoSource: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoVirtualVideoSource reference.
		private GCHandle objHandle; // weak VidyoVirtualVideoSource reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoVirtualVideoSourceAddToLocalRendererNative(IntPtr s, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceAddToRemoteRendererNative(IntPtr s, IntPtr remoteRenderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceClearConstraintsNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVirtualVideoSourceConstructNative(IntPtr endpoint, [MarshalAs(UnmanagedType.I4)]Endpoint.VirtualVideoSourceType type, IntPtr id, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVirtualVideoSourceConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVirtualVideoSourceDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoVirtualVideoSourceGetCurrentEncodeFrameIntervalNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVirtualVideoSourceGetIdNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern MediaFormat VidyoVirtualVideoSourceGetMediaTypeNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVirtualVideoSourceGetNameNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVirtualVideoSourceGetPreviewLabelNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Endpoint.VirtualVideoSourceType VidyoVirtualVideoSourceGetTypeNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceIsPreviewOnNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceIsSelectedNative(IntPtr s);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVirtualVideoSourceOnFrameNative(IntPtr s, IntPtr videoFrame, [MarshalAs(UnmanagedType.I4)]MediaFormat mediaFormat);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceRegisterEventListenerNative(IntPtr s, StartCallback onStart, ReconfigureCallback onReconfigure, StopCallback onStop, ExternalMediaBufferReleaseCallback onBufferRelease);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceRemoveFromLocalRendererNative(IntPtr s, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceRemoveFromRemoteRendererNative(IntPtr s, IntPtr remoteRenderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSendFrameWithExternalDataNative(IntPtr s, [MarshalAs(UnmanagedType.I4)]MediaFormat format, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSetBoundsConstraintsNative(IntPtr s, ulong maxFrameInterval, ulong minFrameInterval, uint maxWidth, uint minWidth, uint maxHeight, uint minHeight);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSetDiscreteConstraintsNative(IntPtr s, ulong maxFrameInterval, ulong minFrameInterval, uint width, uint height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSetLowLatencyProfileNative(IntPtr s, Boolean profile);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSetMaxConstraintsNative(IntPtr s, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSetMinFrameIntervalNative(IntPtr s, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSetPreviewLabelNative(IntPtr s, IntPtr previewLabel);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoVirtualVideoSourceSetStreamParametersInLocalRendererNative(IntPtr s, IntPtr localRenderer, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoVirtualVideoSourceGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoVirtualVideoSourceSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void ExternalMediaBufferReleaseCallback(IntPtr s, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size, ulong userData);
		private ExternalMediaBufferReleaseCallback _mExternalMediaBufferReleaseCallback = ExternalMediaBufferReleaseCallbackDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void ReconfigureCallback(IntPtr s, ulong frameInterval, MediaFormat mediaFormat, ulong userData);
		private ReconfigureCallback _mReconfigureCallback = ReconfigureCallbackDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void StartCallback(IntPtr s, ulong frameInterval, MediaFormat mediaFormat, ulong userData);
		private StartCallback _mStartCallback = StartCallbackDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void StopCallback(IntPtr s, ulong userData);
		private StopCallback _mStopCallback = StopCallbackDelegate;
		public interface IRegisterEventListener{

			void StartCallback(ulong frameInterval, MediaFormat mediaFormat, ulong userData);
			void ReconfigureCallback(ulong frameInterval, MediaFormat mediaFormat, ulong userData);
			void StopCallback(ulong userData);
			void ExternalMediaBufferReleaseCallback(byte[] buffer, SizeT size, ulong userData);
		}
		private IRegisterEventListener _mIRegisterEventListener;
		/// <summary>
		/// Constructs a virtual video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="endpoint">The VidyoEndpoint object.</param>
		/// <param name="type">Type of the virtual video source.</param>
		/// <param name="id">Unique ID.</param>
		/// <param name="name">Name of the virtual video source.</param>
		/// <param name="alloc">The allocator used to allocate the buffer.</param>
		public VirtualVideoSource(Endpoint endpoint, Endpoint.VirtualVideoSourceType type, String id, String name) {

			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			objPtr = VidyoVirtualVideoSourceConstructNative((endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero, type, nId, nName);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);
			VidyoVirtualVideoSourceSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		public VirtualVideoSource(IntPtr other){
			objPtr = VidyoVirtualVideoSourceConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoVirtualVideoSourceSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~VirtualVideoSource(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoVirtualVideoSourceSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoVirtualVideoSourceDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="renderer"></param>
		public ulong AddToLocalRenderer(LocalRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoVirtualVideoSourceAddToLocalRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="remoteRenderer"></param>
		public Boolean AddToRemoteRenderer(RemoteRenderer remoteRenderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceAddToRemoteRendererNative(objPtr, (remoteRenderer != null) ? remoteRenderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Clears existing constraints and set them to default values 3840x2160@3fps for share and 1280x720@30fps for camera.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public Boolean ClearConstraints() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceClearConstraintsNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the current encode frame interval of the video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public ulong GetCurrentEncodeFrameInterval() {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoVirtualVideoSourceGetCurrentEncodeFrameIntervalNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the unique ID of the video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoVirtualVideoSourceGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the media format of the video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public MediaFormat GetMediaType() {
			if (objPtr == IntPtr.Zero) { return default; }

			MediaFormat ret = VidyoVirtualVideoSourceGetMediaTypeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the name of the video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoVirtualVideoSourceGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the preview label of the video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public String GetPreviewLabel() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoVirtualVideoSourceGetPreviewLabelNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the type of the video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public Endpoint.VirtualVideoSourceType GetType() {
			if (objPtr == IntPtr.Zero) { return default; }

			Endpoint.VirtualVideoSourceType ret = VidyoVirtualVideoSourceGetTypeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Check if source added to the local renderer.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public Boolean IsPreviewOn() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceIsPreviewOnNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Check if source added to the remote renderer.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		public Boolean IsSelected() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceIsSelectedNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="s"></param>
		/// <param name="videoFrame"></param>
		/// <param name="mediaFormat">The media format of video frame</param>
		public void OnFrame(VideoFrame videoFrame, MediaFormat mediaFormat) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoVirtualVideoSourceOnFrameNative(objPtr, (videoFrame != null) ? videoFrame.GetObjectPtr():IntPtr.Zero, mediaFormat);
		}
		/// <summary>
		/// Constructs a virtual video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="onStart">A callback invoked to notify that video source started after reconfiguration.</param>
		/// <param name="onReconfigure">A callback invoked if configuration changed.</param>
		/// <param name="onStop">A callback invoked to notify that video source stoped after reconfiguration.</param>
		/// <param name="onBufferRelease">Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw video frame.</param>
		public Boolean RegisterEventListener(IRegisterEventListener _iIRegisterEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterEventListener = _iIRegisterEventListener;

			Boolean ret = VidyoVirtualVideoSourceRegisterEventListenerNative(objPtr, _mStartCallback, _mReconfigureCallback, _mStopCallback, _mExternalMediaBufferReleaseCallback);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="renderer"></param>
		public Boolean RemoveFromLocalRenderer(LocalRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceRemoveFromLocalRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="remoteRenderer"></param>
		public Boolean RemoveFromRemoteRenderer(RemoteRenderer remoteRenderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceRemoveFromRemoteRendererNative(objPtr, (remoteRenderer != null) ? remoteRenderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="format">The media format of the video frame.</param>
		/// <param name="buffer">A pointer to externally allocated memory that holds the pixel data.</param>
		/// <param name="size">The size, in bytes, of the frame data.</param>
		/// <param name="width">The width of the video media frame in pixels.</param>
		/// <param name="height">The height of the video media frame in pixels.</param>
		public Boolean SendFrameWithExternalData(MediaFormat format, byte[] buffer, SizeT size, SizeT width, SizeT height) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr pointer = ByteArrayHelperSingleton.ByteArrayToRawPointer(buffer);
			Boolean ret = VidyoVirtualVideoSourceSendFrameWithExternalDataNative(objPtr, format, pointer, size, width, height);

			return ret;
		}
		/// <summary>
		/// Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="maxFrameInterval">Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="minFrameInterval">Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="maxWidth">Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit</param>
		/// <param name="minWidth">Unused</param>
		/// <param name="maxHeight">Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit</param>
		/// <param name="minHeight">Unused</param>
		public Boolean SetBoundsConstraints(ulong maxFrameInterval, ulong minFrameInterval, uint maxWidth, uint minWidth, uint maxHeight, uint minHeight) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceSetBoundsConstraintsNative(objPtr, maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight);

			return ret;
		}
		/// <summary>
		/// Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="maxFrameInterval">Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc).</param>
		/// <param name="minFrameInterval">Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="width">The width of the stream after the stream is reconfigured.</param>
		/// <param name="height">The height of the stream after the stream is reconfigured.</param>
		public Boolean SetDiscreteConstraints(ulong maxFrameInterval, ulong minFrameInterval, uint width, uint height) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceSetDiscreteConstraintsNative(objPtr, maxFrameInterval, minFrameInterval, width, height);

			return ret;
		}
		/// <summary>
		/// Sets the low latency profile of the video source which treats the stream as a regular video source. This prioritizes latency over quality.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="profile">Low latency profile toggle. Default is LMI_FALSE.</param>
		public Boolean SetLowLatencyProfile(Boolean profile) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceSetLowLatencyProfileNative(objPtr, profile);

			return ret;
		}
		/// <summary>
		/// Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the source is in landscape mode width and height will be applied as max constraints, if the monitor is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="width">Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.</param>
		/// <param name="height">Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).</param>
		public Boolean SetMaxConstraints(uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceSetMaxConstraintsNative(objPtr, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// Set a minimum frame interval(maximum fps) for the encoded stream.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps) for share type and 33333333 (30fps) for camera. To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).</param>
		public Boolean SetMinFrameInterval(ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceSetMinFrameIntervalNative(objPtr, frameInterval);

			return ret;
		}
		/// <summary>
		/// Set the preview label of the video source.
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="previewLabel">Display name to set on the video source.</param>
		public Boolean SetPreviewLabel(String previewLabel) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nPreviewLabel = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(previewLabel ?? string.Empty);
			Boolean ret = VidyoVirtualVideoSourceSetPreviewLabelNative(objPtr, nPreviewLabel);
			Marshal.FreeHGlobal(nPreviewLabel);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="s">The VidyoVirtualVideoSource object.</param>
		/// <param name="localRenderer"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames.</param>
		public Boolean SetStreamParametersInLocalRenderer(LocalRenderer localRenderer, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoVirtualVideoSourceSetStreamParametersInLocalRendererNative(objPtr, (localRenderer != null) ? localRenderer.GetObjectPtr():IntPtr.Zero, width, height, frameInterval);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(ExternalMediaBufferReleaseCallback))]
#endif
		private static void ExternalMediaBufferReleaseCallbackDelegate(IntPtr s, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size, ulong userData){
			var csSPtr = s != IntPtr.Zero ? VidyoVirtualVideoSourceGetUserDataNative(s) : IntPtr.Zero;
			if(csSPtr == IntPtr.Zero) return;
			var csS = (VirtualVideoSource)GCHandle.FromIntPtr(csSPtr).Target;

			var pointer = ByteArrayHelperSingleton.RawPointerToByteArray(buffer);
			csS?._mIRegisterEventListener?.ExternalMediaBufferReleaseCallback(pointer, size, userData);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(ReconfigureCallback))]
#endif
		private static void ReconfigureCallbackDelegate(IntPtr s, ulong frameInterval, MediaFormat mediaFormat, ulong userData){
			var csSPtr = s != IntPtr.Zero ? VidyoVirtualVideoSourceGetUserDataNative(s) : IntPtr.Zero;
			if(csSPtr == IntPtr.Zero) return;
			var csS = (VirtualVideoSource)GCHandle.FromIntPtr(csSPtr).Target;

			csS?._mIRegisterEventListener?.ReconfigureCallback(frameInterval, mediaFormat, userData);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(StartCallback))]
#endif
		private static void StartCallbackDelegate(IntPtr s, ulong frameInterval, MediaFormat mediaFormat, ulong userData){
			var csSPtr = s != IntPtr.Zero ? VidyoVirtualVideoSourceGetUserDataNative(s) : IntPtr.Zero;
			if(csSPtr == IntPtr.Zero) return;
			var csS = (VirtualVideoSource)GCHandle.FromIntPtr(csSPtr).Target;

			csS?._mIRegisterEventListener?.StartCallback(frameInterval, mediaFormat, userData);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(StopCallback))]
#endif
		private static void StopCallbackDelegate(IntPtr s, ulong userData){
			var csSPtr = s != IntPtr.Zero ? VidyoVirtualVideoSourceGetUserDataNative(s) : IntPtr.Zero;
			if(csSPtr == IntPtr.Zero) return;
			var csS = (VirtualVideoSource)GCHandle.FromIntPtr(csSPtr).Target;

			csS?._mIRegisterEventListener?.StopCallback(userData);
		}
	};
}
