#ifndef BNB_EFFECT_PLAYER_WRAP_LICENSE_MANAGER_H
#define BNB_EFFECT_PLAYER_WRAP_LICENSE_MANAGER_H

#include <stdbool.h>

#include <bnb/error.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * license_manager
 */
typedef struct license_manager_holder license_manager_holder_t;

/** Creates *new* `LicenceManager`. This metod won't change Banuba SDK internal state. */
license_manager_holder_t* bnb_license_manager_create(const char* client_token, bnb_error**);
/**
  * Returns the instance used by Banuba SDK to check licence.
  * This istance was created by `UtilityManager.initialize`.
  */
license_manager_holder_t* bnb_license_manager_get_instance(bnb_error**);
/** Destroys license_manager */
void bnb_license_manager_destroy(license_manager_holder_t* lm, bnb_error**);

/** Checks if Client Token is expired. */
bool bnb_license_manager_is_expired(license_manager_holder_t* lm, bnb_error**);

/**
 * Returns decoded content of Client Token
 * Returned string must be freed.
 */
void bnb_license_manager_get_json(license_manager_holder_t* lm, char** json, bnb_error**);

#ifdef __cplusplus
} //extern "C"
#endif

#endif /* BNB_EFFECT_PLAYER_WRAP_LICENSE_MANAGER_H */
