#ifndef BNB_C_API_COMMON_INTERFACES_BNB_COMMON_TYPES_H
#define BNB_C_API_COMMON_INTERFACES_BNB_COMMON_TYPES_H

#include <stdbool.h>
#include <stdint.h>

typedef enum
{
    BNB_RGB = 0,
    BNB_RGBA,
    BNB_BGR,
    BNB_BGRA,
    BNB_ARGB
} bnb_pixel_format_t;

typedef enum
{
    BNB_DEG_0 = 0,
    BNB_DEG_90,
    BNB_DEG_180,
    BNB_DEG_270
} bnb_image_orientation_t;

typedef struct
{
    unsigned int width;
    unsigned int height;
    bnb_image_orientation_t orientation;
    bool require_mirroring;
    int face_orientation;
} bnb_image_format_t;

typedef enum
{
    bnb_fast,
    bnb_good_for_first_face,
    bnb_good
} bnb_face_search_mode_t;

#endif /* BNB_C_API_COMMON_INTERFACES_BNB_COMMON_TYPES_H */
