#ifndef BNB_EFFECT_PLAYER_WRAP_UTILITY_MANAGER_H
#define BNB_EFFECT_PLAYER_WRAP_UTILITY_MANAGER_H

#include <stdint.h>

#include <bnb/error.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * utility_manager
 */
typedef struct utility_manager_holder utility_manager_holder_t;

/* @a resource_paths is NULL terminated array of strings, e.g. {"path1", "path2", NULL} */
utility_manager_holder_t* bnb_utility_manager_init(const char* const* resource_paths, const char* client_token, bnb_error**);
void bnb_utility_manager_release(utility_manager_holder_t*, bnb_error**);

typedef enum
{
    BNB_LOG_DEBUG,
    BNB_LOG_INFO,
    BNB_LOG_WARNING,
    BNB_LOG_ERROR,
} bnb_severity_level_t;

typedef void(*bnb_log_record_callback_t)(bnb_severity_level_t level, const char* domain, const char* message, void* user_data);

void bnb_utility_manager_set_log_level(utility_manager_holder_t*, bnb_severity_level_t level, bnb_error**);
void bnb_utility_manager_set_log_record_callback(utility_manager_holder_t*, bnb_log_record_callback_t cb, bnb_severity_level_t level, void* user_data, bnb_error**);

/*
 * version info
 */
/* returned string must be freed */
void bnb_get_banuba_sdk_version_string(char** version, bnb_error**);
int32_t bnb_get_banuba_sdk_version_int();

#ifdef __cplusplus
} //extern "C"
#endif

#endif /* BNB_EFFECT_PLAYER_WRAP_UTILITY_MANAGER_H */
