//
//	VidyoCalendar_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoCalendarConnProps_Objc.h"
#import "VidyoMeetingInfo_Objc.h"
#import "VidyoMeeting_Objc.h"
@class VCCalendar;
/*!
 * @enum These are keys that indicate plugin-specific capbilities. To keep things super simple, the standard capabilities have the EXACT SAME enum values as in CalendarPlugin.h.
 * @constant VCCalendarCapabilityKeyNULL The termination key. Has no associated value.
 * @constant VCCalendarCapabilityKeySSO The Calendar service supports authentication by SSO. Has no value.
 * @constant VCCalendarCapabilityKeyWebUrl The Calendar service supports web auth. Value is a predicted url based on the environment.
 * @constant VCCalendarCapabilityKeyWebUrlAutodiscovery The Calendar service supports discovering the web url based on the username. Has no value.
 * @constant VCCalendarCapabilityKeyUsername The Calendar service supports authentication with username. Value is a predicted username based on the environment.
 * @constant VCCalendarCapabilityKeyPassword The Calendar service supports authentication by password. Has no value.
 */
typedef NS_ENUM(NSInteger, VCCalendarCapabilityKey) {
	VCCalendarCapabilityKeyNULL,
	VCCalendarCapabilityKeySSO,
	VCCalendarCapabilityKeyWebUrl,
	VCCalendarCapabilityKeyWebUrlAutodiscovery,
	VCCalendarCapabilityKeyUsername,
	VCCalendarCapabilityKeyPassword
};
/*!
 * @enum This type indicates the result of an attempt to log in to some service.
 * @constant VCCalendarCreateCodeOk The calendar instance was created successfully.
 * @constant VCCalendarCreateCodeSvcNotRegistered Service name not found in the list of registered services. Must be added first using VidyoCalendarManagerRegisterCalendarService
 * @constant VCCalendarCreateCodeLibraryLoadFailed Problems occured trying to load the calendar plugin library module.
 * @constant VCCalendarCreateCodeInvalidLibraryVersion Problems occured trying to load the calendar plugin library module.
 * @constant VCCalendarCreateCodeExistingInstance Found an existing instance with the same calendar service ID (plugin library) and calendar name (folder).
 * @constant VCCalendarCreateCodeCalendarPluginConstructFailure Failure occured constructing the calendar plugin object.
 * @constant VCCalendarCreateCodeCalendarPluginInvalidCredentials The credentials required .
 * @constant VCCalendarCreateCodeCalendarPluginInvalidCalendarId The calendar Id provided was not known to the plugin service.
 * @constant VCCalendarCreateCodeVidyoCalendarConstructFailure Failure occured constructing the VidyoCalendar object.
 * @constant VCCalendarCreateCodeVidyoCalendarDestroyed VidyoCalendar instance was successfully destroyed.
 * @constant VCCalendarCreateCodeGeneralError The login failed for some other miscellaneous error.
 */
typedef NS_ENUM(NSInteger, VCCalendarCreateCode) {
	VCCalendarCreateCodeOk,
	VCCalendarCreateCodeSvcNotRegistered,
	VCCalendarCreateCodeLibraryLoadFailed,
	VCCalendarCreateCodeInvalidLibraryVersion,
	VCCalendarCreateCodeExistingInstance,
	VCCalendarCreateCodeCalendarPluginConstructFailure,
	VCCalendarCreateCodeCalendarPluginInvalidCredentials,
	VCCalendarCreateCodeCalendarPluginInvalidCalendarId,
	VCCalendarCreateCodeVidyoCalendarConstructFailure,
	VCCalendarCreateCodeVidyoCalendarDestroyed,
	VCCalendarCreateCodeGeneralError
};
/*!
 * @enum Types of services available to reference for calendar specific data and events.
 * @constant VCCalendarStateUnavailable Indicates that the service is not available in the environmemt due to either an unreachable server, or by lack of an installed product.
 * @constant VCCalendarStateInitialized Verified that the service is available to attempt a connection against.
 * @constant VCCalendarStateConnecting 
 * @constant VCCalendarStateConnected 
 * @constant VCCalendarStateDisconnecting 
 * @constant VCCalendarStateDisconnected 
 */
typedef NS_ENUM(NSInteger, VCCalendarState) {
	VCCalendarStateUnavailable,
	VCCalendarStateInitialized,
	VCCalendarStateConnecting,
	VCCalendarStateConnected,
	VCCalendarStateDisconnecting,
	VCCalendarStateDisconnected
};
/*!
 * @enum This type indicates the result of a search for a meeting(s).
 * @constant VCMeetingSearchResultOk The search operation was successful.
 * @constant VCMeetingSearchResultProcessing Request to perform search contains proper values and is being processed.
 * @constant VCMeetingSearchResultNoRecords No records found for the search.
 * @constant VCMeetingSearchResultInvalidIndex Index for search does not fall within total number of records of existing search set, based on page size.
 * @constant VCMeetingSearchResultInvalidDateTimeRange Date range has either, invalid begin or end date values, or end date is before begin date .
 * @constant VCMeetingSearchResultNoResponse The search result failed due to request timeout.
 * @constant VCMeetingSearchResultNotConnected Could not execute the search due to the calendar not being in a connected state.
 * @constant VCMeetingSearchResultPluginError Error returned by the plugin trying to initiate the search.
 * @constant VCMeetingSearchResultMiscLocalError The search result failed due to some miscellaneous local problem.
 * @constant VCMeetingSearchResultMiscRemoteError The search result failed due to some miscellaneous remote problem.
 */
typedef NS_ENUM(NSInteger, VCMeetingSearchResult) {
	VCMeetingSearchResultOk,
	VCMeetingSearchResultProcessing,
	VCMeetingSearchResultNoRecords,
	VCMeetingSearchResultInvalidIndex,
	VCMeetingSearchResultInvalidDateTimeRange,
	VCMeetingSearchResultNoResponse,
	VCMeetingSearchResultNotConnected,
	VCMeetingSearchResultPluginError,
	VCMeetingSearchResultMiscLocalError,
	VCMeetingSearchResultMiscRemoteError
};
@protocol VCICalendarFeedback
@optional

	/*!
	 * <p>Triggered when service is connected. </p> <p/> <p>Triggered through method(s): VidyoCalendarConnect </p>
	 */
	-(void) connectResult:(VCCalendar*)c Result:(VCCalendarCreateCode)result;
	/*!
	 * Callback that is triggered when service is disconnected. <p>Triggered when service is disconnected through VidyoCalendarDisconnect method. </p> <p/> <p>Triggered through event(s): user will be notified through this method when the connection to the calendar service becomes unavailable. </p>
	 */
	-(void) disconnected:(VCCalendar*)c Result:(VCCalendarCreateCode)result;
	/*!
	 * Callback that is triggered when calendar capabilities are gotten.
	 */
	-(void) getCapabilitiesResult:(VCCalendar*)c Capabilities:(NSMutableArray*)capabilities Values:(NSMutableArray*)values;
	/*!
	 * <p>Triggered from a meeting search request. </p> <p/> <p>Triggered through method(s): </p> <p>- VidyoCalendarSearchMeetingsByDay </p> <p>- VidyoCalendarSearchMeetings </p>
	 */
	-(void) getMeetingsResult:(VCCalendar*)c SearchResult:(VCMeetingSearchResult)searchResult Meetings:(NSMutableArray*)meetings CurrentIndex:(unsigned int)currentIndex NumRecords:(unsigned int)numRecords;
	/*!
	 * <p>Triggered when a meeting is created by the user using a known meeting ID. </p> <p/> <p>Triggered through method(s): VidyoCalendarCreateMeetingById </p>
	 */
	-(void) meetingCreatedById:(VCCalendar*)c M:(VCMeeting*)m R:(VCMeetingActionResult)r CreateToken:(NSMutableString*)createToken;
	/*!
	 * <p>Triggered when a meeting is created through the receipt of an invite by a remote user. </p> <p/> <p>Triggered by an event for creating a meeting that originated from the calendar service </p>
	 */
	-(void) meetingCreatedByService:(VCCalendar*)c M:(VCMeetingInfo*)m;
	/*!
	 * <p>Triggered when a meeting event occurs. </p> <p/> <p>Triggered through event(s): user will be notified through this method when the start time for a scheduled meeting occurs. </p>
	 */
	-(void) meetingReminder:(VCCalendar*)c M:(VCMeetingInfo*)m;
	/*!
	 * <p>Triggered when a meeting is removed from the calendar schedule by the service connected to. </p>
	 */
	-(void) meetingRemovedByService:(VCCalendar*)c M:(VCMeetingInfo*)m;
	/*!
	 * <p>Triggered when a meeting is updated from an event originating through the calendar service. </p>
	 */
	-(void) meetingUpdatedByService:(VCCalendar*)c M:(VCMeetingInfo*)m;
	/*!
	 * Triggered when the plugin has updated a meeting that was updated that was a part of a series. There are no guarantees that the plugin will be able to reconstruct the series from the master and attachments, so a new search should be performed when this is called.
	 */
	-(void) seriesUpdate:(VCCalendar*)c M:(VCMeetingInfo*)m;
@end
@interface VCCalendarFeedback : NSObject<VCICalendarFeedback>
{
	void* objPtr;
}
	-(id) init;
	-(void) dealloc;
	-(void*)getObjectPtr;
@end
/*!
 * <p>Represents an instance of a calendar service. </p> <p/> <p>General concepts: </p> <p>- Each instance is identifiable through the combination of the service type and the id </p> <p/> <p>Lifecycle of an calendar service instance: </p> <p>- Create/construct an instance of the service through the VidyoCalendarManager based on a VidyoCalendarManagerDefaultServices </p> <p>- Constructor will take a vector of connection parameters, the content of which will also be dictated by the VidyoCalendarManagerDefaultServices </p> <p>- Recieve the constructed instance back through the VidyoCalendarManager callback method VidyoCalendarManagerFeedbackCreateServiceResult. </p> <p>- Connect the service to it's resource using the VidyoCalendarConnect method </p> <p>- Receive the connect result through the calendar service callback for that service through VidyoCalendarFeedbackConnectResult </p> <p>- Upon successful connection result, the user will be able to create, update, read and delete meetings from the service </p> <p>as well as receive reminder events </p>
 */
@interface VCCalendar : NSObject
{
	void* objPtr;
}
	/*!
	 * Uniquely identifies the calendar service instance.
	 */
	@property NSMutableString* id;
	/*!
	 * Enumeration for the states that a calendar service can transition through.
	 */
	@property VCCalendarState serviceState;
	/*!
	 * Types of calendar services supported through this interface.
	 */
	@property NSMutableString* serviceType;
	-(void) dealloc;
	/*!
	 * <p>Initiates a connection of the calendar service to its resource for data. This can include both a local resource or a server based one. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackConnectResult </p>
	 * @param connProperties Property values
	 */
	-(BOOL) connect:(NSMutableArray*)connProperties;
	/*!
	 * Create a meeting using an id value returned in a VidyoMeetingInfo object. VidyoMeeting object is returned in the VidyoCalendarFeedbackMeetingCreated callback
	 * @param c Pointer to the VidyoCalendar object.
	 * @param id The id value given in the VidyoMeetingInfo structure that uniquely identifies the meeting
	 */
	-(BOOL) createMeetingWithId:(const char*)id Feedback:(VCMeetingFeedback*)feedback CreateToken:(const char*)createToken;
	/*!
	 * <p>Initiates a connection of the calendar service to its resource for data. This can include both a local resource or a server based one. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackDisconnected </p>
	 */
	-(BOOL) disconnect;
	/*!
	 * Gets capabilities from the CalendarPlugin. If requestedCapabilities is empty, this causes the feedback to just return a list of the plugin's capabilities with no values list. If requestedCapabilities is a list of capabilities, the plugin will respond with values it has for those capabilities.
	 * @param c The CalendarPlugin's calendar.
	 * @param requestedCapabilities Empty to get just the capability keys. Set with capability keys to get associated values.
	 */
	-(BOOL) getCapabilities:(NSMutableArray*)requestedCapabilities;
	/*!
	 * Retrieve unique calendar id value
	 * @param c VidyoCalendar object
	 */
	-(NSString*) getId;
	/*!
	 * Retreives the service state for the calendar.
	 * @param c Pointer to the VidyoCalendar object.
	 */
	-(VCCalendarState) getServiceState;
	/*!
	 * Retreives the service type for the calendar.
	 * @param c Pointer to the VidyoCalendar object.
	 */
	-(NSString*) getServiceType;
	/*!
	 * <p>Search a calendar for meetings based on a search string and a begin - end date.</p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackGetMeetingsResult </p>
	 * @param searchText If a string is supplied here, the resulting records will be filtered by this string if it is contained within any of the following meeting fields: - Subject - Location - Body - Meeting Owner email and name - Required attendees name and email - Optional attendees name and email
	 * @param beginDateTime Date and time to start search from
	 * @param endDateTime End date and time for search
	 * @param index Zero based index of the starting record in the search results, to use when returning the callback results.
	 * @param pageSize Number of records to return in the callback results, based off of the starting record index argument. NOTE... A value of zero will return all records starting from the index
	 */
	-(VCMeetingSearchResult) searchMeetings:(NSMutableString*)searchText BeginDateTime:(NSMutableString*)beginDateTime EndDateTime:(NSMutableString*)endDateTime Index:(unsigned int)index PageSize:(unsigned int)pageSize;
	/*!
	 * <p>Get a list of meetings by day. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackGetMeetingsResult </p>
	 * @param c Vidyo calendar service object.
	 * @param year 4 digit year to search for the meetings within - (yyyy).
	 * @param month 1-2 digit month to search for the meetings within - ((mm) - no zero padding required).
	 * @param day 1-2 digit day to search for meetings within - ((dd) - no zero padding required).
	 * @param createToken A unique string token to match this method call with the resulting asynchronous callback
	 */
	-(BOOL) searchMeetingsByDay:(unsigned int)year Month:(unsigned int)month Day:(unsigned int)day CreateToken:(NSMutableString*)createToken;
	/*!
	 * Enables SSO in the CalendarPlugin.
	 * @param c VidyoCalendar to enbale SSO on.
	 * @param setSingleSignOn Whether or not to sign on using SSO.
	 */
	-(BOOL) setSingleSignOn:(BOOL)setSingleSignOn;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
