//
//	VidyoContact_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

@class VCContactProperty;
/*!
 * @enum Presence status codes.
 * @constant VCContactPresenceStateUnavailable Unavailable
 * @constant VCContactPresenceStateDoNotDisturb Do not disturb
 * @constant VCContactPresenceStateExtendedAway Extended away
 * @constant VCContactPresenceStateAway Away
 * @constant VCContactPresenceStateAvailable Available
 * @constant VCContactPresenceStateInterestedInChat Interested in chat
 */
typedef NS_ENUM(NSInteger, VCContactPresenceState) {
	VCContactPresenceStateUnavailable,
	VCContactPresenceStateDoNotDisturb,
	VCContactPresenceStateExtendedAway,
	VCContactPresenceStateAway,
	VCContactPresenceStateAvailable,
	VCContactPresenceStateInterestedInChat
};
/*!
 * @enum Describes the relationship between a contact publishing its contact information and a contact subscribing to that information.
 * @constant VCContactSubscriptionStateUnavailable The subscriber's state is unknown.
 * @constant VCContactSubscriptionStateNotSubscribed The subscriber is not currently subscribed to the publisher's information. No action is pending on the subscription state.
 * @constant VCContactSubscriptionStatePreapproved The subscriber has not subscribed to the publisher's information, however, the publisher has already granted permission to the subscriber.
 * @constant VCContactSubscriptionStateAwaitingApproval The subscriber has subscribed to the publisher's information and is waiting for the publisher to grant permission for the subscription.
 * @constant VCContactSubscriptionStateSubscribed The subscriber is currently subscribed to the publisher's information.
 */
typedef NS_ENUM(NSInteger, VCContactSubscriptionState) {
	VCContactSubscriptionStateUnavailable,
	VCContactSubscriptionStateNotSubscribed,
	VCContactSubscriptionStatePreapproved,
	VCContactSubscriptionStateAwaitingApproval,
	VCContactSubscriptionStateSubscribed
};
/*!
 * Stores contact information and presence status.
 */
@interface VCContact : NSObject
{
}
	@property NSMutableString* department;
	@property NSMutableArray* emails;
	@property NSMutableArray* groups;
	@property NSMutableString* handle;
	@property NSMutableString* id;
	@property NSMutableString* name;
	@property NSMutableString* nickname;
	@property NSMutableString* photo;
	@property VCContactPresenceState presenceState;
	@property NSMutableString* presenceStatus;
	@property VCContactSubscriptionState publicationState;
	@property VCContactSubscriptionState subscriptionState;
	@property NSMutableArray* telephones;
	@property long timestamp;
	@property NSMutableString* title;
@end
/*!
 * Contact Property that has value and metadata for fields.
 */
@interface VCContactProperty : NSObject
{
}
	@property NSMutableArray* types;
	@property NSMutableString* value;
@end
