//
//	VidyoLocalRenderer_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoParticipant_Objc.h"
/*!
 * @enum Controls the use of tile borders in the scene.
 * @constant VCLocalRendererBorderStyleNone Do not put a border on any tiles.
 * @constant VCLocalRendererBorderStyleSame Put the same colored border on each tile.
 * @constant VCLocalRendererBorderStyleHighlight Put a border on each tile, but tiles associated with the highest ranked participant (as told to LmiConferenceSceneSetPreference) will have a different colored border than the others.
 * @constant VCLocalRendererBorderStyleFlash Tiles associated with the highest ranked participant have a different colored border than the others. When the highest ranked participant changes, the border of the new highest ranked participant flashes momentarily.
 */
typedef NS_ENUM(NSInteger, VCLocalRendererBorderStyle) {
	VCLocalRendererBorderStyleNone,
	VCLocalRendererBorderStyleSame,
	VCLocalRendererBorderStyleHighlight,
	VCLocalRendererBorderStyleFlash
};
/*!
 * @enum Indicates the position of the preview with respect to one dimension.
 * @constant VCLocalRendererPipPositionMIN The preview is at its minimum value along this dimension. This means to the left for the horizontal position and down for the vertical position.
 * @constant VCLocalRendererPipPositionCENTER The preview is centered with respect to this dimension.
 * @constant VCLocalRendererPipPositionMAX The preview is at its maximum value along this dimension. This means to the right for the horizontal position and up for the vertical position.
 * @constant VCLocalRendererPipPositionINVALID The preview type is not valid.
 */
typedef NS_ENUM(NSInteger, VCLocalRendererPipPosition) {
	VCLocalRendererPipPositionMIN,
	VCLocalRendererPipPositionCENTER,
	VCLocalRendererPipPositionMAX,
	VCLocalRendererPipPositionINVALID
};
/*!
 * @enum Styles of the composite renderer, which apply to its layout and behaviour.
 * @constant VCLocalRendererViewStyleDefault The default style.
 * @constant VCLocalRendererViewStyleTiles Participants are shown in sizes that best reflect their order of importance.
 * @constant VCLocalRendererViewStyleTilesWithRemoteCameraControlV2 Participants are shown in sizes that best reflect their order of importance, with large Remote Camera Control buttons if applicable.
 * @constant VCLocalRendererViewStyleNGRGrid The next generation renderer with grid layout.
 * @constant VCLocalRendererViewStyleNGRSpeaker The next generation renderer with speaker layout.
 */
typedef NS_ENUM(NSInteger, VCLocalRendererViewStyle) {
	VCLocalRendererViewStyleDefault,
	VCLocalRendererViewStyleTiles,
	VCLocalRendererViewStyleTilesWithRemoteCameraControlV2,
	VCLocalRendererViewStyleNGRGrid,
	VCLocalRendererViewStyleNGRSpeaker
};
@protocol VCLocalRendererIRegisterPipEventListener
	/*!
	 * Callback that is triggerred when picture-in-picture view size is changed.
	 */
	-(void) onPipLocationChanged:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height IsExpanded:(BOOL)isExpanded;
@end
@interface VCLocalRenderer : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Registers to get notified when a a call is being recorded.
	 */
	id<VCLocalRendererIRegisterPipEventListener> localRendererIRegisterPipEventListener;
}
	@property NSMutableString* id;
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 */
	-(BOOL) disable;
	/*!
	 * Enable or disable the expanded camera control to composite renderer.
	 * @param r The VidyoLocalRenderer object.
	 * @param enable LMI_TRUE to enable the expanded camera control to composite renderer, LMI_FALSE to disable expanded camera control to composite renderer.
	 */
	-(BOOL) enableExpandedCameraControl:(BOOL)enable;
	/*!
	 * Enable or disable the displaying of custom FECC icon in the right bottom corner.
	 * @param r The VidyoLocalRenderer object.
	 * @param enable LMI_TRUE to show custom FECC icon in the right bottom corner, LMI_FALSE to show default FECC icon in the right top corner.
	 */
	-(BOOL) enableFECCIconCustomLayout:(BOOL)enable;
	/*!
	 * Enable or disable the preview mirroring to composite renderer.
	 * @param r The VidyoLocalRenderer object.
	 * @param enable LMI_TRUE to enable the preview mirroring to composite renderer, LMI_FALSE to disable preview mirroring to composite renderer.
	 */
	-(BOOL) enablePreviewMirroring:(BOOL)enable;
	/*!
	 * Enable or disable the displaying of picture-in-picture in a custom way.
	 * @param renderer The local renderer object.
	 * @param enable LMI_TRUE to always show picture-in-picture, LMI_FALSE to show picture-in-picture with two tiles.
	 */
	-(void) enableSelfViewCustomLayout:(BOOL)enable;
	/*!
	 * Enable or disable the show audio tiles to composite renderer.
	 * @param r The VidyoLocalRenderer object.
	 * @param enable LMI_TRUE to enable the audio tiles to composite renderer, LMI_FALSE to disable audio tiles to composite renderer.
	 */
	-(BOOL) enableShowAudioTiles:(BOOL)enable;
	/*!
	 * Enable or disable touch as a input device.
	 * @param r The VidyoLocalRenderer object.
	 * @param isTouchInputDevice To indicate input method of this device is TOUCH (vs default MOUSE input).
	 */
	-(BOOL) enableTouchInputDevice:(BOOL)isTouchInputDevice;
	/*!
	 * Enable or disable the vertical centering of the video screen.
	 * @param r The VidyoLocalRenderer object.
	 * @param enable LMI_TRUE to show the center of video screen vertically if it's bigger than tile, LMI_FALSE to show the top of video screen vertically.
	 */
	-(BOOL) enableVerticalVideoCentering:(BOOL)enable;
	/*!
	 */
	-(NSString*) getId;
	/*!
	 */
	-(NSString*) getName;
	/*!
	 * Gets the rendering environment's pixel density.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(float) getPixelDensity;
	/*!
	 * Get the viewing distance. This is the distance from the viewer's eye to the screen.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(float) getViewingDistance;
	/*!
	 * Retrieves the status of the expanded camera control on composite renderer.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) isExpandedCameraControlEnabled;
	/*!
	 * Get state of custom FECC icon.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) isFECCIconCustomLayoutEnabled;
	/*!
	 */
	-(BOOL) isPaused;
	/*!
	 * Retrieves the status of the preview mirroring on composite renderer.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) isPreviewMirroringEnabled;
	/*!
	 * Query whether the currently-selected tile, if any, is in far-end camera-control (FECC) mode.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) isSelectedTileControllingRemoteCamera;
	/*!
	 * Retrieves the status of the show audio tiles on composite renderer.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) isShowAudioTilesEnabled;
	/*!
	 * Retrieves the status of the touch input device.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) isTouchInputDeviceEnabled;
	/*!
	 * Get if the video screen is vertically centered.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) isVerticalVideoCenteringEnabled;
	/*!
	 */
	-(void) pause;
	/*!
	 * Pin or un-pin target participant camera. Pinned participant camera stream is always displayed unless muted. A single participant can be pinned at a time; subsequent pin will unpin previously pinned participant.
	 * @param r The VidyoLocalRenderer object.
	 * @param p The target participant.
	 * @param pin LMI_TRUE enable, LMI_FALSE for disable participant pin.
	 */
	-(BOOL) pinParticipant:(VCParticipant*)p Pin:(BOOL)pin;
	/*!
	 * Registers to get notified when a a call is being recorded.
	 * @param r The VidyoLocalRenderer object.
	 * @param onPipLocationChanged .
	 */
	-(BOOL) registerPipEventListener:(id<VCLocalRendererIRegisterPipEventListener>)localRendererIRegisterPipEventListener;
	/*!
	 */
	-(void) resume;
	/*!
	 * Set whether content tiles are allowed on the screen.
	 */
	-(BOOL) setAllowContentMultiScreen:(BOOL)allow DisplayIndex:(unsigned int)displayIndex;
	/*!
	 * Set whether preview tiles are allowed on the screen.
	 */
	-(BOOL) setAllowPreviewMultiScreen:(BOOL)allow DisplayIndex:(unsigned int)displayIndex;
	/*!
	 * If supported, sets the speed of transition animaiton 100 for slow, 0 for instant transition.
	 * @param renderer The local renderer object to extract stats.
	 * @param speedPercentage Percentage of animation speed.
	 */
	-(BOOL) setAnimationSpeed:(unsigned int)speedPercentage;
	/*!
	 * Sets the background color of the renderer.
	 * @param renderer The local renderer object to extract stats.
	 * @param red Red component of the color 0-255.
	 * @param green Green component of the color 0-255.
	 * @param blue Blue component of the color 0-255.
	 */
	-(BOOL) setBackgroundColor:(unsigned char)red Green:(unsigned char)green Blue:(unsigned char)blue;
	/*!
	 * Controls the use of tile borders in the scene. See VidyoLocalRendererBorderStyle.
	 * @param ct The VidyoLocalRenderer object.
	 * @param style The new border style.
	 */
	-(void) setBorderStyle:(VCLocalRendererBorderStyle)style;
	/*!
	 * Sets the video screams to be croped in the renderer.
	 * @param renderer The local renderer object to extract stats.
	 * @param cropped Crop if LMI_TRUE, letter box if LMI_FALSE.
	 */
	-(BOOL) setCropped:(BOOL)cropped;
	/*!
	 * This function sets the maximum percentage of a dimension that can be cropped from a video.
	 * @param r The VidyoLocalRenderer object.
	 * @param maxCropPct When fitting a video into a tile, this sets the maximum percentage that can be cropped to achieve a better fit.
	 */
	-(BOOL) setMaxCropping:(unsigned int)maxCropPct;
	/*!
	 * Sets the maximum number of streams that can be displayed in the renderer.
	 */
	-(BOOL) setMaxStreams:(unsigned int)numStreams;
	/*!
	 * Sets the maximum number of streams that can be displayed in the renderer.
	 */
	-(BOOL) setMaxStreamsMultiScreen:(unsigned int)numStreams DisplayIndex:(unsigned int)displayIndex;
	/*!
	 * This function sets the number of preferred participants in the tile layout.
	 * @param r The VidyoLocalRenderer object.
	 * @param numPreferred number of preferred participants. Default is -1 which means auto. Otherwise value is 0 - 96.
	 */
	-(BOOL) setNumPreferred:(unsigned int)numPreferred;
	/*!
	 * Set renderer parameters for high DPI devices.
	 * @param r The VidyoLocalRenderer object.
	 * @param pixelsPerInch The number of pixels per inch.
	 * @param viewingDistance The distance between user's eye to the device (in foot).
	 * @param isTouchInputDevice To indicate input method of this device is TOUCH (vs default MOUSE input).
	 */
	-(BOOL) setParametersForHighDPIDevice:(float)pixelsPerInch ViewingDistance:(float)viewingDistance IsTouchInputDevice:(BOOL)isTouchInputDevice;
	/*!
	 * Sets the position of the preview when it is displayed using picture-in-picture mode.
	 * @param r The VidyoLocalRenderer object.
	 * @param x The horizontal position of the preview.
	 * @param y The vertical position of the preview.
	 * @param lockPip A boolean indicating whether to lock the preview in this position. When false, the user may drag the preview to another location using the mouse or a touch.
	 */
	-(BOOL) setPipPosition:(VCLocalRendererPipPosition)x Y:(VCLocalRendererPipPosition)y LockPip:(BOOL)lockPip;
	/*!
	 * Sets the rendering environment's pixel density.
	 * @param r The VidyoLocalRenderer object.
	 * @param pixelsPerInch The pixel density in pixels per inch.
	 */
	-(BOOL) setPixelDensity:(float)pixelsPerInch;
	/*!
	 */
	-(BOOL) setPosition:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 * Sets the priority of one of the screens. Screens that have a smaller priority value will be considered higher priority, and will be given more important items to display.
	 */
	-(BOOL) setPriorityMultiScreen:(unsigned int)priority DisplayIndex:(unsigned int)displayIndex;
	/*!
	 * Set if renderer will automatically pin the share when added and pin/unpin share if already exist.
	 * @param r The VidyoLocalRenderer object.
	 * @param autoPin LMI_TRUE to automatically pin the share when added and pin the first share from list if exist. LMI_FALSE to do not pin the share automatically when added and unpin the share if exist and already pinned.
	 */
	-(BOOL) setRemoteWindowSharePinMode:(BOOL)autoPin;
	/*!
	 * Sets the background color of the tiles.
	 * @param renderer The local renderer object.
	 * @param red Red component of the color 0-255.
	 * @param green Green component of the color 0-255.
	 * @param blue Blue component of the color 0-255.
	 */
	-(BOOL) setTilesBackgroundColor:(unsigned char)red Green:(unsigned char)green Blue:(unsigned char)blue;
	/*!
	 * Set the viewing distance. This is the distance from the viewer's eye to the screen.
	 * @param r The VidyoLocalRenderer object.
	 * @param viewingDistanceFt The viewing distance in feet.
	 */
	-(BOOL) setViewingDistance:(float)viewingDistanceFt;
	/*!
	 * Shows or hides the audio meters.
	 * @param renderer The local renderer object to show or hide the audio meters.
	 * @param showMeters Show or hide audio meters.
	 */
	-(BOOL) showAudioMeters:(BOOL)showMeters;
	/*!
	 * Shows debuggin statistics in the renderer window.
	 * @param renderer The local renderer object to extract stats.
	 * @param showStats Show or hide statistics.
	 */
	-(BOOL) showDebugStats:(BOOL)showStats;
	/*!
	 * Shows a label with the participant name.
	 * @param renderer The local renderer object to show or hide the label.
	 * @param showLabel Show or hide participant label.
	 */
	-(BOOL) showLabel:(BOOL)showLabel;
	/*!
	 * Unregisters recorder in call event notifications.
	 * @param r The VidyoLocalRenderer object.
	 */
	-(BOOL) unregisterPipEventListener;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
