//
//	VidyoLocalWindowShare_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoLocalRenderer_Objc.h"
#import "VidyoRemoteRenderer_Objc.h"
/*!
 * @enum State of the window share.
 * @constant VCLocalWindowShareStateOk The window is visible and has been fully captured.
 * @constant VCLocalWindowShareStateNotVisible The window exists but is not "visible".
 * @constant VCLocalWindowShareStateMinimized The window is minimized and "visible" but its content may not be accessible.
 * @constant VCLocalWindowShareStateClosed The window is closed and is no longer accessible.
 * @constant VCLocalWindowShareStateMiscError Miscellaneous error has occured trying to capture the frame.
 */
typedef NS_ENUM(NSInteger, VCLocalWindowShareState) {
	VCLocalWindowShareStateOk,
	VCLocalWindowShareStateNotVisible,
	VCLocalWindowShareStateMinimized,
	VCLocalWindowShareStateClosed,
	VCLocalWindowShareStateMiscError
};
@protocol VCLocalWindowShareIGetApplicationIconFrameDataUriAsync
	-(void) onApplicationIconDataUriComplete:(NSString*)icon;
@end
@protocol VCLocalWindowShareIGetCapabilities
	/*!
	 * The callback which will be triggered with the most optimal capabilities for the device.
	 */
	-(void) onGetCapabilities:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
@end
@protocol VCLocalWindowShareIGetPreviewFrameDataUriAsync
	-(void) onPreviewDataUriComplete:(NSString*)videoFrame State:(VCLocalWindowShareState)state;
@end
/*!
 * This object represents a window share on the local endpoint.
 */
@interface VCLocalWindowShare : NSObject
{
	void* objPtr;
	@public
	id<VCLocalWindowShareIGetApplicationIconFrameDataUriAsync> localWindowShareIGetApplicationIconFrameDataUriAsync;
	/*!
	 * Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
	 */
	id<VCLocalWindowShareIGetCapabilities> localWindowShareIGetCapabilities;
	id<VCLocalWindowShareIGetPreviewFrameDataUriAsync> localWindowShareIGetPreviewFrameDataUriAsync;
}
	/*!
	 * Name of the application that owns the window.
	 */
	@property NSMutableString* applicationName;
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name of the window share.
	 */
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(long) addToLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) addToRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Clears existing constraints and set them to default values 3840x2160@3fps.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) clearConstraints;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 * @param maxWidth Maximum width of the icon image.
	 * @param maxHeight Maximum height of the icon image.
	 * @param onComplete Callback that is triggered when a icon frame is captured.
	 */
	-(BOOL) getApplicationIconFrameDataUriAsync:(size_t)maxWidth MaxHeight:(size_t)maxHeight LocalWindowShareIGetApplicationIconFrameDataUriAsync:(id<VCLocalWindowShareIGetApplicationIconFrameDataUriAsync>)localWindowShareIGetApplicationIconFrameDataUriAsync;
	/*!
	 * Gets the name of the application that owns the window.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(NSString*) getApplicationName;
	/*!
	 * Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
	 * @param windowShare The VidyoLocalWindowShare object.
	 * @param onGetCapabilities The callback to which we will pass the most optimal capabilities.
	 */
	-(BOOL) getCapabilities:(id<VCLocalWindowShareIGetCapabilities>)localWindowShareIGetCapabilities;
	/*!
	 * Gets the unique ID of the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(NSString*) getName;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 * @param maxWidth Maximum width of the preview image.
	 * @param maxHeight Maximum height of the preview image.
	 * @param onComplete Callback that is triggered when a preview frame is captured.
	 */
	-(BOOL) getPreviewFrameDataUriAsync:(size_t)maxWidth MaxHeight:(size_t)maxHeight LocalWindowShareIGetPreviewFrameDataUriAsync:(id<VCLocalWindowShareIGetPreviewFrameDataUriAsync>)localWindowShareIGetPreviewFrameDataUriAsync;
	/*!
	 * Gets the preview label of the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(NSString*) getPreviewLabel;
	/*!
	 * Gets the ID of the process that owns the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(unsigned int) getProcessId;
	/*!
	 */
	-(NSString*) getProcessName;
	/*!
	 * Retrieved the up to date name of the Window which might have changed since it was created.
	 */
	-(NSString*) getUpdatedName;
	/*!
	 * Gets window state of the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(VCLocalWindowShareState) getWindowState;
	/*!
	 * Checks if the name of the application name is set.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) isApplicationNameSet;
	/*!
	 * Checks if the name of the window share is set.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) isNameSet;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) removeFromLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) removeFromRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param maxWidth Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit
	 * @param minWidth Unused
	 * @param maxHeight Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit
	 * @param minHeight Unused
	 */
	-(BOOL) setBoundsConstraints:(long)maxFrameInterval MinFrameInterval:(long)minFrameInterval MaxWidth:(unsigned int)maxWidth MinWidth:(unsigned int)minWidth MaxHeight:(unsigned int)maxHeight MinHeight:(unsigned int)minHeight;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 * @param frameInterval Set as an override of minimum frame interval for discrete and bounds constraints
	 */
	-(BOOL) setCapability:(long)frameInterval ShowCursor:(BOOL)showCursor RedactOccludedAreas:(BOOL)redactOccludedAreas;
	/*!
	 * Set frame interval(fps) for capturer.
	 * @param w The VidyoLocalWindowShare object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. By default will be calculated based on encoder configuration.
	 */
	-(BOOL) setCaptureInterval:(long)frameInterval;
	/*!
	 * Sets the visibility of the cursor in the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) setCursorVisibility:(BOOL)showCursor;
	/*!
	 * Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param width The width of the stream after the stream is reconfigured
	 * @param height The height of the stream after the stream is reconfigured
	 * @param scaleFactor This should be 1
	 */
	-(BOOL) setDiscreteConstraints:(long)maxFrameInterval MinFrameInterval:(long)minFrameInterval Width:(unsigned int)width Height:(unsigned int)height ScaleFactor:(float)scaleFactor;
	/*!
	 * Sets the maximum frame interval that will be used to scrapte the window share
	 * @param w The VidyoLocalWindowShare object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. Default is 333333333 which is 3 frames per second.
	 */
	-(BOOL) setFrameInterval:(long)frameInterval;
	/*!
	 * Sets the low latency profile of the window share which treats the stream as a regular video source. This prioritizes latency over quality.
	 * @param w The VidyoLocalWindowShare object.
	 * @param profile Low latency profile toggle. Default is LMI_FALSE.
	 */
	-(BOOL) setLowLatencyProfile:(BOOL)profile;
	/*!
	 * Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the window is in landscape mode width and height will be applied as max constraints, if the window is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
	 * @param w The VidyoLocalWindowShare object
	 * @param width Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.
	 * @param height Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
	 */
	-(BOOL) setMaxConstraints:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Set a minimum frame interval(maximum fps) for the encoded stream.
	 * @param w The VidyoLocalWindowShare object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
	 */
	-(BOOL) setMinFrameInterval:(long)frameInterval;
	/*!
	 * @param w The VidyoLocalWindowShare object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames.
	 */
	-(BOOL) setPositionInLocalRenderer:(VCLocalRenderer*)localRenderer X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Set the preview label of the window share.
	 * @param w The VidyoLocalWindowShare object.
	 * @param previewLabel Display name to set on the window share.
	 */
	-(BOOL) setPreviewLabel:(NSString*)previewLabel;
	/*!
	 * Sets the flag which redacts the occluded areas from the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) setRedactOccludedAreas:(BOOL)redactOccludedAreas;
	/*!
	 * Sets the scale factor by which to down-scale the window share.
	 * @param w The VidyoLocalWindowShare object.
	 */
	-(BOOL) setScaleFactor:(float)scaleFactor;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
