//
//	VidyoLogRecord_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

/*!
 * @enum An identifier for the level, or type, of a logged event. This indicates the degree of significance of the event.
 * @constant VCLogLevelFATAL The event being logged describes a fatal error. In all likelihood system execution will not be able to continue.
 * @constant VCLogLevelERROR The event being logged describes a continuable error. The system should be able to continue, but human intervention or diagnosis may be necessary.
 * @constant VCLogLevelWARNING The event being logged describes a warning. Something has occurred which may require attention or action, but which is not actually erroneous.
 * @constant VCLogLevelINFO The event being logged describes information which may be useful or informative to a user of the system. No problems are being reported.
 * @constant VCLogLevelDEBUG The event being logged describes information which may be useful to a developer to understand the code. The information is not expected to be useful to users of the system.
 * @constant VCLogLevelSENT The event being logged describes data that has been transmitted by the system.
 * @constant VCLogLevelRECEIVED The event being logged describes data that has been received by the system.
 * @constant VCLogLevelENTER The event being logged describes the system entering a function.
 * @constant VCLogLevelLEAVE The event being logged describes the system leaving from a function.
 * @constant VCLogLevelINVALID A value that does not represent a valid log level. This value is returned by LmiLogGetLevelByName and LmiLogGetLevelByIndex on invalid input.
 */
typedef NS_ENUM(NSInteger, VCLogLevel) {
	VCLogLevelFATAL,
	VCLogLevelERROR,
	VCLogLevelWARNING,
	VCLogLevelINFO,
	VCLogLevelDEBUG,
	VCLogLevelSENT,
	VCLogLevelRECEIVED,
	VCLogLevelENTER,
	VCLogLevelLEAVE,
	VCLogLevelINVALID
};
/*!
 * A record of one logged event.
 */
@interface VCLogRecord : NSObject
{
}
	@property size_t categoryName;
	@property long eventTime;
	@property const char * file;
	@property const char * functionName;
	@property VCLogLevel level;
	@property int line;
	@property const char * message;
	@property const char* name;
	@property const char * threadName;
@end
