//
//	VidyoMeetingInfo_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoMeetingAttendee_Objc.h"
/*!
 * descriptive details of a meeting.
 */
@interface VCMeetingInfo : NSObject
{
}
	/*!
	 * List of up to 20 attendees for the meeting. NOTE... This list will only hold up to 20 attendees If the user would like to retrieve all attendees for the meeting (above 20) they will need to independently construct a VidyoMeeting from this type to retrieve the entire set of attendees.
	 */
	@property NSMutableArray* attendees;
	/*!
	 * Body contents for the meeting (only up to 2K of string data).
	 */
	@property NSMutableString* body;
	/*!
	 * Date and time that the meeting is scheduled for
	 */
	@property NSMutableString* endDateTime;
	/*!
	 * Unique id that identifies a conference meeting at the service which the meeting is created through.
	 */
	@property NSMutableString* id;
	/*!
	 * Indicates whether the meeting contains Vidyo specific meeting information or not.
	 */
	@property BOOL isVidyoMeeting;
	/*!
	 * Subject for the meeting.
	 */
	@property NSMutableString* location;
	/*!
	 * Total number of attendees that exist for this meeting. IMPORTANT - This member reflects the *actual total* number of attendees that exist for the meeting . The attendee vector (below) will be limited to 20 attendees.
	 */
	@property unsigned int numOfAttendees;
	/*!
	 * Email for owner the meeting.
	 */
	@property NSMutableString* ownerEmail;
	/*!
	 * Owner name for the meeting.
	 */
	@property NSMutableString* ownerName;
	/*!
	 * Date and time that the meeting is scheduled for
	 */
	@property NSMutableString* startDateTime;
	/*!
	 * Subject for the meeting.
	 */
	@property NSMutableString* subject;
	/*!
	 * Total number of bytes in the body. Useful if the body is larger than 2K.
	 */
	@property size_t totalBodyLength;
	/*!
	 * Contains key information (URL, Meeting JID, etc) for the Vidyo Meeting that the meeting is being held in if the meeting type is VIDYO_MEETING_TYPE_VIDYO. Otherwise it contains an empty string.
	 */
	@property NSMutableString* vidyoMeetingRoomLink;
@end
