//
//	VidyoVirtualAudioSource_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoAudioFrame_Objc.h"
#import "VidyoDevice_Objc.h"
#import "VidyoEndpoint_Objc.h"
#import "VidyoLocalSpeaker_Objc.h"
#import "VidyoRemoteSpeaker_Objc.h"
@protocol VCVirtualAudioSourceIRegisterEventListener
	/*!
	 * Callback that is triggered each time a virtual audio source started.
	 */
	-(void) startCallback;
	/*!
	 * Callback that is triggered each time a virtual audio source stopped.
	 */
	-(void) stopCallback;
	/*!
	 * Callback that is triggered each time there is a change in the virtual audio device state.
	 */
	-(void) reconfigureCallback:(VCDeviceState)state;
	/*!
	 * Callback that is triggered to notify application that VidyoClient is done with the buffer that holds raw audio frame. This buffer is the same that was passed to VidyoClient via function VidyoVirtualAudioSourceSendFrameWithExternalData.
	 */
	-(void) externalMediaBufferReleaseCallback:(unsigned char*)buffer Size:(size_t)size;
@end
/*!
 * This object represents a virtual audio source on the local endpoint.
 */
@interface VCVirtualAudioSource : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Registers to get notified about virtual audio source events.
	 */
	id<VCVirtualAudioSourceIRegisterEventListener> virtualAudioSourceIRegisterEventListener;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name of the virtual audio source.
	 */
	@property NSMutableString* name;
	/*!
	 * This object represents a virtual audio source on the local endpoint.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param endpoint The VidyoEndpoint object.
	 * @param name The name for the virtual audio source.
	 * @param id The id for the virtual audio source.
	 * @param configuration The string in JSON format with virtual audio source configuration. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p>
	 * @param allocator The allocator object.
	 */
	-(id) init:(VCEndpoint*)endpoint Name:(NSString*)name Id:(NSString*)id Configuration:(NSString*)configuration;
	-(void) dealloc;
	/*!
	 * Add the virtual audio source to the local speaker stream. The VidyoVirtualAudioSourceStartCallback will trigger if needed.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param localSpeaker The VidyoLocalSpeaker object.
	 */
	-(BOOL) addToLocalSpeaker:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Add the virtual audio source to the remote speaker stream. The VidyoVirtualAudioSourceStartCallback will trigger if needed.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param remoteSpeaker The VidyoLocalSpeaker object.
	 */
	-(BOOL) addToRemoteSpeaker:(VCRemoteSpeaker*)remoteSpeaker;
	/*!
	 * Gets the audio configs for the virtual audio source.
	 * @param virtualAudioSource The VidyoVirtualVideoSource object.
	 */
	-(NSString*) getConfiguration;
	/*!
	 * Gets the virtual audio source id.
	 * @param virtualAudioSource The VidyoVirtualVideoSource object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the virtual audio source name.
	 * @param virtualAudioSource The VidyoVirtualVideoSource object.
	 */
	-(NSString*) getName;
	/*!
	 * Check if source is selected.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 */
	-(BOOL) isSelected;
	/*!
	 * Registers to get notified about virtual audio source events.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param onStart The callback invoked to notify that virtual audio source started.
	 * @param onStop The callback invoked to notify that virtual audio source stoped.
	 * @param onReconfigure The callback invoked if the virtual audio source configuration changed.
	 * @param onBufferRelease The callback invoked each time when VidyoClient is done with an application allocated buffer that holds raw audio frame.
	 */
	-(BOOL) registerEventListener:(id<VCVirtualAudioSourceIRegisterEventListener>)virtualAudioSourceIRegisterEventListener;
	/*!
	 * Remove the virtual audio source from the local speaker stream. The VidyoVirtualAudioSourceStopCallback will trigger if needed.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param localSpeaker The VidyoLocalSpeaker object.
	 */
	-(BOOL) removeFromLocalSpeaker:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Remove the virtual audio source from the remote speaker stream. The VidyoVirtualAudioSourceStopCallback will trigger if needed.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param remoteSpeaker The VidyoRemoteSpeaker object.
	 */
	-(BOOL) removeFromRemoteSpeaker:(VCRemoteSpeaker*)remoteSpeaker;
	/*!
	 * Sends already constructed audio frame to selected virtual audio source and then send it to local and/or remote streams.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param audioFrame The audio frame.
	 */
	-(BOOL) sendFrame:(VCAudioFrame*)audioFrame;
	/*!
	 * Pass raw buffer to selected virtual audio source, based on which the audio frame will be constructed and then send it to local and/or remote streams. The VidyoVirtualAudioSourceExternalMediaBufferReleaseCallback will trigger. This is an asynchronous interface.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param buffer The audio frame.
	 * @param nbSamples The number of samples.
	 * @param elapsedTime The elapsed time.
	 */
	-(BOOL) sendFrameWithExternalData:(unsigned char*)buffer NbSamples:(size_t)nbSamples ElapsedTime:(long)elapsedTime;
	/*!
	 * Enable or disable the content share.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param enable The audio content share status.
	 */
	-(BOOL) setAudioContentShare:(BOOL)enable;
	/*!
	 * Sets the audio configs for the virtual audio source. The VidyoVirtualAudioSourceReconfigureCallback will trigger.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param configuration The string in JSON format with virtual audio source configuration. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p>
	 */
	-(BOOL) setConfiguration:(NSString*)configuration;
	/*!
	 * Unregisters virtual audio source event notifications.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 */
	-(BOOL) unregisterEventListener;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
