/**
{file:
	{name: VidyoVirtualRendererParticipant.h}
	{description: Virtual renderer participant API.}
	{copyright:
		(c) 2013-2021 Vidyo, Inc.,
		433 Hackensack Avenue,
		Hackensack, NJ  07601.
		All rights reserved.
		The information contained herein is proprietary to Vidyo, Inc.
		and shall not be reproduced, copied (in whole or in part), adapted,
		modified, disseminated, transmitted, transcribed, stored in a retrieval
		system, or translated into any language in any form by any means
		without the express written consent of Vidyo, Inc.}
}
*/
#ifndef VIDYO_VIRTUAL_RENDERER_PARTICIPANT_H
#define VIDYO_VIRTUAL_RENDERER_PARTICIPANT_H

#include <Lmi/Utils/LmiString.h>
#include <Lmi/Utils/LmiUnordered.h>
#include <Lmi/Os/LmiSharedPtr.h>

LMI_BEGIN_EXTERN_C

#pragma mark - VidyoVirtualRendererParticipant types declaration

struct VidyoVirtualRendererParticipantImpl_;
typedef struct VidyoVirtualRendererParticipantImpl_ VidyoVirtualRendererParticipantImpl;
Declare_LmiSharedPtr(VidyoVirtualRendererParticipantImpl)
Declare_LmiSharedPtrWrapper(VidyoVirtualRendererParticipant, VidyoVirtualRendererParticipantImpl)
Declare_LmiWeakPtrWrapper(VidyoVirtualRendererParticipantHandle, VidyoVirtualRendererParticipant, VidyoVirtualRendererParticipantImpl)

/**
{type apigroup="connector,simple"  reference-counted="yes":
	{name: VidyoVirtualRendererParticipant}
	{parent: VidyoVirtualRenderer}
	{description: The participant information needed for renderer.}
	{member:
		{name: id}
		{type: LmiUint64}
		{description: The participant unique id.}
	}
}
*/

/**
{type visibility="private":
	{name: VidyoVirtualRendererParticipantHandle}
	{parent: VidyoVirtualRenderer}
	{description: Weak reference to VidyoVirtualRendererParticipant object.}
}
*/

#pragma mark - VidyoVirtualRendererParticipant map declaration

Declare_LmiUnorderedMap(LmiUint64, VidyoVirtualRendererParticipant)

#pragma mark - VidyoVirtualRendererParticipant vector definition

Declare_LmiVector(VidyoVirtualRendererParticipant)

LMI_END_EXTERN_C

#include "VidyoVirtualRendererStream.h"
#include "VidyoParticipant.h"

LMI_BEGIN_EXTERN_C

#pragma mark - VidyoVirtualRendererParticipant public APIs declaration

/**
{function visibility="private":
	{name: VidyoVirtualRendererParticipantConstruct}
	{parent: VidyoVirtualRendererParticipant}
	{description: Constructs VidyoVirtualRendererParticipant object.}
	{prototype: VidyoVirtualRendererParticipant* VidyoVirtualRendererParticipantConstruct(VidyoVirtualRendererParticipant* p, LmiUint64 id, const VidyoParticipant* vp, LmiAllocator* alloc)}
	{parameter:
		{name: p}
		{description: The VidyoVirtualRendererParticipant object.}
	}
	{parameter:
		{name: id}
		{description: The participant unique id.}
	}
	{parameter:
		{name: vp}
		{description: The VidyoParticipant object.}
	}
	{parameter:
		{name: alloc}
		{description: The LmiAllocator object.}
	}
	{return: Returns constructed VidyoVirtualRendererParticipant object.}
}
*/
VidyoVirtualRendererParticipant* VidyoVirtualRendererParticipantConstruct(VidyoVirtualRendererParticipant* p, LmiUint64 id, const VidyoParticipant* vp, LmiAllocator* alloc);

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantConstructCopy}
	{parent: VidyoVirtualRendererParticipant}
	{description: Constructs a VidyoVirtualRendererParticipant object as a copy of another.}
	{prototype: VidyoVirtualRendererParticipant *VidyoVirtualRendererParticipantConstructCopy(VidyoVirtualRendererParticipant *obj, const VidyoVirtualRendererParticipant *other)}
	{parameter: {name: obj} {description: The VidyoVirtualRendererParticipant object to construct.}}
	{parameter: {name: other} {description: The call object to make a copy of.}}
	{return: A pointer to a constructed object on success, or NULL on failure.}
}
*/

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantDestruct}
	{parent: VidyoVirtualRendererParticipant}
	{description: Destructs an VidyoVirtualRendererParticipant object.}
	{prototype: void VidyoVirtualRendererParticipantDestruct(VidyoVirtualRendererParticipant *obj)}
	{parameter: {name: obj} {description: The VidyoVirtualRendererParticipant object to destruct.}}
}
*/

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantAssign}
	{parent: VidyoVirtualRendererParticipant}
	{description: Assigns one VidyoVirtualRendererParticipant object the value of another. }
	{prototype: VidyoVirtualRendererParticipant *VidyoVirtualRendererParticipantAssign(VidyoVirtualRendererParticipant *obj, const VidyoVirtualRendererParticipant *other)}
	{parameter: {name: obj} {description: The VidyoVirtualRendererParticipant object.}}
	{parameter: {name: other} {description: The call object to make a copy of.}}
	{return: A pointer to the destination object on success, or NULL on failure.}
}
*/

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantGetId}
	{parent: VidyoVirtualRendererParticipant}
	{description: Gets participant id.}
	{prototype: LmiUint64 VidyoVirtualRendererParticipantGetId(const VidyoVirtualRendererParticipant* p)}
	{parameter:
		{name: p}
		{description: The VidyoVirtualRendererParticipant object.}
	}
	{return: Returns participant id.}
}
*/
LmiUint64 VidyoVirtualRendererParticipantGetId(const VidyoVirtualRendererParticipant* p);

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantGetName}
	{parent: VidyoVirtualRendererParticipant}
	{description: Gets participant name.}
	{prototype: const LmiString* VidyoVirtualRendererParticipantGetName(const VidyoVirtualRendererParticipant* p)}
	{parameter:
		{name: p}
		{description: The VidyoVirtualRendererParticipant object.}
	}
	{return: Returns participant name.}
}
*/
const LmiString* VidyoVirtualRendererParticipantGetName(const VidyoVirtualRendererParticipant* p);

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantGetParticipantId}
	{parent: VidyoVirtualRendererParticipant}
	{description: Gets participant unique id in the conference.}
	{prototype: const LmiString* VidyoVirtualRendererParticipantGetParticipantId(const VidyoVirtualRendererParticipant* p)}
	{parameter:
		{name: p}
		{description: The VidyoVirtualRendererParticipant object.}
	}
	{return: Returns participant unique id in the conference.}
}
*/
const LmiString* VidyoVirtualRendererParticipantGetParticipantId(const VidyoVirtualRendererParticipant* p);

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantGetInitial}
	{parent: VidyoVirtualRendererParticipant}
	{description: Gets participant initials.}
	{prototype: const LmiString* VidyoVirtualRendererParticipantGetInitial(const VidyoVirtualRendererParticipant* p)}
	{parameter:
		{name: p}
		{description: The VidyoVirtualRendererParticipant object.}
	}
	{return: Returns participant initials.}
}
*/
const LmiString* VidyoVirtualRendererParticipantGetInitial(const VidyoVirtualRendererParticipant* p);

/**
{function apigroup="connector,simple":
	{name: VidyoVirtualRendererParticipantIsRemote}
	{parent: VidyoVirtualRendererParticipant}
	{description: Checks whether participant is remote.}
	{prototype: LmiBool VidyoVirtualRendererParticipantIsRemote(const VidyoVirtualRendererParticipant* p)}
	{parameter:
		{name: p}
		{description: The VidyoVirtualRendererParticipant object.}
	}
	{return: Returns LMI_TRUE if participant is remote, LMI_FALSE otherwise.}
}
*/
LmiBool VidyoVirtualRendererParticipantIsRemote(const VidyoVirtualRendererParticipant* p);

#pragma mark - VidyoVirtualRendererParticipant private APIs declaration

void VidyoVirtualRendererParticipantSetUserData(VidyoVirtualRendererParticipant* p, LmiVoidPtr userData);
LmiVoidPtr VidyoVirtualRendererParticipantGetUserData(const VidyoVirtualRendererParticipant* p);
void VidyoVirtualRendererParticipantAddStream(VidyoVirtualRendererParticipant* p, const VidyoVirtualRendererStream* stream);
void VidyoVirtualRendererParticipantRemoveStream(VidyoVirtualRendererParticipant* p, LmiUint64 token);
LmiBool VidyoVirtualRendererParticipantGetStream(VidyoVirtualRendererParticipant* p, LmiVector(VidyoVirtualRendererStream)* streams);

LMI_END_EXTERN_C

#if LMI_INLINE_NEED_HEADER_FILE_DEFINITIONS
Define_LmiSharedPtrWrapper_NoCompare(VidyoVirtualRendererParticipant, VidyoVirtualRendererParticipantImpl)
Define_LmiWeakPtrWrapper(VidyoVirtualRendererParticipantHandle, VidyoVirtualRendererParticipant, VidyoVirtualRendererParticipantImpl)
#endif

#endif /* VIDYO_VIRTUAL_RENDERER_PARTICIPANT_H */

