// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// The videoconferencing API that handles all aspects of the media (audio/video) connection.
	/// </summary>
	public class Connector: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoConnector reference.
		private GCHandle objHandle; // weak VidyoConnector reference.
		private Dictionary<string, Participant> participantsMap = new Dictionary<string, Participant>();
		private Dictionary<string, RemoteCamera> remoteCamerasMap = new Dictionary<string, RemoteCamera>();
		private Dictionary<string, RemoteMicrophone> remoteMicrophonesMap = new Dictionary<string, RemoteMicrophone>();
		private Dictionary<string, RemoteWindowShare> remoteWindowSharesMap = new Dictionary<string, RemoteWindowShare>();
		private Dictionary<string, IRequestVideoForRemoteCamera> onRemoteCameraFirstFrameReceivedCallbacksMap = new Dictionary<string, IRequestVideoForRemoteCamera>();
		private Dictionary<string, IRequestVideoForRemoteWindowShare> onRemoteWindowShareFirstFrameReceivedCallbacksMap = new Dictionary<string, IRequestVideoForRemoteWindowShare>();
		private List<WeakReference> objects = new List<WeakReference>();

		private void DisposeWeakReferenceObjects() {
			foreach(var item in objects) {
				if (item == null || !item.IsAlive || item.Target == null) { continue; }
				switch (item.Target.GetType().Name) {
					case "LocalCamera": ((LocalCamera)item.Target).Dispose(false); break;
					case "LocalMicrophone": ((LocalMicrophone)item.Target).Dispose(false); break;
					case "LocalMonitor": ((LocalMonitor)item.Target).Dispose(false); break;
					case "LocalSpeaker": ((LocalSpeaker)item.Target).Dispose(false); break;
					case "LocalWindowShare": ((LocalWindowShare)item.Target).Dispose(false); break;
					case "NetworkInterface": ((NetworkInterface)item.Target).Dispose(false); break;
					case "Participant": ((Participant)item.Target).Dispose(false); break;
					case "RemoteCamera": ((RemoteCamera)item.Target).Dispose(false); break;
					case "RemoteMicrophone": ((RemoteMicrophone)item.Target).Dispose(false); break;
					case "RemoteRenderer": ((RemoteRenderer)item.Target).Dispose(false); break;
					case "RemoteSpeaker": ((RemoteSpeaker)item.Target).Dispose(false); break;
					case "RemoteWindowShare": ((RemoteWindowShare)item.Target).Dispose(false); break;
					case "VirtualAudioSource": ((VirtualAudioSource)item.Target).Dispose(false); break;
					case "VirtualVideoSource": ((VirtualVideoSource)item.Target).Dispose(false); break;
				}
			}
			objects.Clear();
		}
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		public Dictionary<string, Participant> GetParticipantsMap() {
			return participantsMap;
		}
		public Dictionary<string, RemoteCamera> GetRemoteCamerasMap() {
			return remoteCamerasMap;
		}
		public Dictionary<string, RemoteMicrophone> GetRemoteMicrophonesMap() {
			return remoteMicrophonesMap;
		}
		public Dictionary<string, RemoteWindowShare> GetRemoteWindowSharesMap() {
			return remoteWindowSharesMap;
		}
		public Dictionary<string, IRequestVideoForRemoteCamera> GetOnRemoteCameraFirstFrameReceivedCallbacksMap() {
			return onRemoteCameraFirstFrameReceivedCallbacksMap;
		}
		public Dictionary<string, IRequestVideoForRemoteWindowShare> GetOnRemoteWindowShareFirstFrameReceivedCallbacksMap() {
			return onRemoteWindowShareFirstFrameReceivedCallbacksMap;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAddAudioDeviceToWhitelistNative(IntPtr c, IntPtr deviceName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAddMessageClassNative(IntPtr c, IntPtr messageClass);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorApproveRaisedHandNative(IntPtr c, IntPtr participant, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAssignViewToCompositeRendererNative(IntPtr c, ref IntPtr viewId, [MarshalAs(UnmanagedType.I4)]ConnectorViewStyle viewStyle, uint remoteParticipants);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAssignViewToLocalCameraNative(IntPtr c, ref IntPtr viewId, IntPtr localCamera, Boolean displayCropped, Boolean allowZoom);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAssignViewToLocalMonitorNative(IntPtr c, ref IntPtr viewId, IntPtr localMonitor, Boolean displayCropped, Boolean allowZoom);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAssignViewToLocalWindowShareNative(IntPtr c, ref IntPtr viewId, IntPtr localWindowShare, Boolean displayCropped, Boolean allowZoom);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAssignViewToRemoteCameraNative(IntPtr c, ref IntPtr viewId, IntPtr remoteCamera, Boolean displayCropped, Boolean allowZoom);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAssignViewToRemoteWindowShareNative(IntPtr c, ref IntPtr viewId, IntPtr remoteWindowShare, Boolean displayCropped, Boolean allowZoom);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorAssignViewToVirtualVideoSourceNative(IntPtr c, ref IntPtr viewId, IntPtr virtualVideoSource, Boolean displayCropped, Boolean allowZoom);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorCancelInviteParticipantNative(IntPtr c, IntPtr contact);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectNative(IntPtr c, IntPtr host, IntPtr token, IntPtr displayName, IntPtr resourceId, OnSuccess onSuccess, OnFailure onFailure, OnDisconnected onDisconnected);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectToRoomAsGuestNative(IntPtr c, IntPtr host, IntPtr displayName, IntPtr roomKey, IntPtr roomPin, OnSuccess onSuccess, OnFailure onFailure, OnDisconnected onDisconnected);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectToRoomWithIdNative(IntPtr c, IntPtr host, IntPtr userName, IntPtr password, IntPtr roomId, IntPtr roomPin, OnSuccess onSuccess, OnFailure onFailure, OnDisconnected onDisconnected);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectToRoomWithKeyNative(IntPtr c, IntPtr host, IntPtr userName, IntPtr password, IntPtr roomKey, IntPtr roomPin, OnSuccess onSuccess, OnFailure onFailure, OnDisconnected onDisconnected);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectToRoomWithTokenAndIdNative(IntPtr c, IntPtr host, IntPtr userName, IntPtr token, IntPtr roomId, IntPtr roomPin, OnSuccess onSuccess, OnFailure onFailure, OnDisconnected onDisconnected);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorConnectToRoomWithTokenAndKeyNative(IntPtr c, IntPtr host, IntPtr userName, IntPtr token, IntPtr roomKey, IntPtr roomPin, OnSuccess onSuccess, OnFailure onFailure, OnDisconnected onDisconnected);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorConstructNative(ref IntPtr viewId, [MarshalAs(UnmanagedType.I4)]ConnectorViewStyle viewStyle, uint remoteParticipants, IntPtr logFileFilter, IntPtr logFileName, ulong userData);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorCreateVirtualAudioSourceNative(IntPtr c, IntPtr name, IntPtr id, IntPtr configuration);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorCreateVirtualVideoSourceNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]Endpoint.VirtualVideoSourceType type, IntPtr id, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorCycleCameraNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorCycleMicrophoneNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorCycleSpeakerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDestroyVirtualAudioSourceNative(IntPtr c, IntPtr virtualAudioSource);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDestroyVirtualVideoSourceNative(IntPtr c, IntPtr virtualVideoSource);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorDestructNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableAudioForAllNative(IntPtr c, Boolean disable, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableAudioForParticipantNative(IntPtr c, IntPtr participant, Boolean disable, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableAudioSilenceForAllNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableAudioSilenceForParticipantNative(IntPtr c, IntPtr participant, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableDebugNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableVideoForAllNative(IntPtr c, Boolean disable, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableVideoForParticipantNative(IntPtr c, IntPtr participant, Boolean disable, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableVideoSilenceForAllNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisableVideoSilenceForParticipantNative(IntPtr c, IntPtr participant, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDisconnectNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDismissAllRaisedHandsNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDismissRaisedHandNative(IntPtr c, IntPtr participants, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorDismissRaisedHandSetparticipantsArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorVectorVidyoParticipantAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorVectorVidyoParticipantDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDropAllParticipantsNative(IntPtr c, IntPtr reason);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorDropParticipantNative(IntPtr c, IntPtr participant, IntPtr reason);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorEnableDebugNative(IntPtr c, uint port, IntPtr logFilter);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetActiveNetworkInterfaceNative(IntPtr c, OnGetActiveNetworkInterface onGetActiveNetworkInterfaceCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoConnectorGetAudioBitrateMultiplierNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ConnectorAudioMode VidyoConnectorGetAudioModeNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoConnectorGetAudioPacketIntervalNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoConnectorGetAudioPacketLossPercentageNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetAutoReconnectNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetAutoReconnectAttemptBackOffNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetAutoReconnectMaxAttemptsNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetAutoReconnectSettingNative(IntPtr c, OnGetAutoReconnectSetting onGetAutoReconnectSettingCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetCameraBackgroundEffectNative(IntPtr c, OnGetCameraBackgroundEffectInfo onGetEffectInfo);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorGetConferenceNumberNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ConnectorTradeOffProfile VidyoConnectorGetCpuTradeOffProfileNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetDisableVideoOnLowBandwidthNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetDisableVideoOnLowBandwidthAudioStreamsNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetDisableVideoOnLowBandwidthRecoveryTimeNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetDisableVideoOnLowBandwidthResponseTimeNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetDisableVideoOnLowBandwidthSampleTimeNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetDisableVideoOnLowBandwidthThresholdNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetGoogleAnalyticsEventTableNative(IntPtr c, OnGetGoogleAnalyticsEventTable onGetGoogleAnalyticsEventTable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetGoogleAnalyticsOptionsNative(IntPtr c, OnGetGoogleAnalyticsOptions onGetGoogleAnalyticsOptions);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorGetInsightsServiceUrlNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ConnectorLogLevel VidyoConnectorGetLogLevelNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorLoggerType loggerType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetMaxReceiveBitRateNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorGetMaxSendBitRateNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern double VidyoConnectorGetMicrophoneMaxBoostLevelNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern short VidyoConnectorGetMinMicrophoneVolumeNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorGetOptionsNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ConnectorPreferredAudioCodec VidyoConnectorGetPreferredAudioCodecNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetRecordingServiceProfilesNative(IntPtr c, OnGetRecordingServiceProfiles onGetRecordingProfilesCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorGetRendererOptionsForViewIdNative(IntPtr c, ref IntPtr viewId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ConnectorState VidyoConnectorGetStateNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetStaticShareSvcStateNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoConnectorGetStatisticRateNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorGetStatsJsonNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorGetVersionNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorGetVersionWithoutBuildNumberNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGetWhitelistedAudioDevicesNative(IntPtr c, OnGetWhitelistedAudioDevices onGetCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorGoogleAnalyticsControlEventActionNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorGoogleAnalyticsEventCategory eventCategory, [MarshalAs(UnmanagedType.I4)]ConnectorGoogleAnalyticsEventAction eventAction, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorHideViewNative(IntPtr c, ref IntPtr viewId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorInsightsNotifyEventNative(IntPtr c, IntPtr eventName, IntPtr parameters);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorInsightsNotifyEventSetparametersArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorVectorLmiStringAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorVectorLmiStringDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorInviteParticipantNative(IntPtr c, IntPtr contact, IntPtr message, OnInviteResult onInviteResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorIsGoogleAnalyticsServiceEnabledNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorIsInsightsServiceEnabledNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorLockRoomNative(IntPtr c, OnLockRoomResult onLockRoomResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorPauseRecordingNative(IntPtr c, OnRecordingServicePauseResult onRecordingServicePauseResultCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorPinParticipantNative(IntPtr c, IntPtr participant, Boolean pin);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRaiseHandNative(IntPtr c, OnRaiseHandResponse raiseHandResponse, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterBotEventListenerNative(IntPtr c, OnBotJoined onJoined, OnBotLeft onLeft);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterCameraEffectErrorListenerNative(IntPtr c, OnCameraEffectError onError);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterConferenceModeEventListenerNative(IntPtr c, OnConferenceModeChanged conferenceModeChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterConnectionPropertiesEventListenerNative(IntPtr c, OnConnectionPropertiesChanged onConnectionPropertiesChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterErrorEventListenerNative(IntPtr c, OnError onErrorCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterHostEventListenerNative(IntPtr c, OnConferenceHostStatusChanged hostStatus);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterInCallEventListenerNative(IntPtr c, OnInCallEvents cb);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLectureModeEventListenerNative(IntPtr c, OnPresenterChanged presenterChanged, OnHandRaised handRaised);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalCameraEventListenerNative(IntPtr c, OnLocalCameraAdded onAdded, OnLocalCameraRemoved onRemoved, OnLocalCameraSelected onSelected, OnLocalCameraStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalCameraFrameListenerNative(IntPtr c, OnLocalCameraFrame onFrame, IntPtr localCamera, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalMicrophoneEnergyListenerNative(IntPtr c, OnLocalMicrophoneEnergy onEnergy);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalMicrophoneEventListenerNative(IntPtr c, OnLocalMicrophoneAdded onAdded, OnLocalMicrophoneRemoved onRemoved, OnLocalMicrophoneSelected onSelected, OnLocalMicrophoneStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalMicrophoneFrameListenerNative(IntPtr c, OnLocalMicrophoneFrame onFrame, IntPtr localMicrophone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalMonitorEventListenerNative(IntPtr c, OnLocalMonitorAdded onAdded, OnLocalMonitorRemoved onRemoved, OnLocalMonitorSelected onSelected, OnLocalMonitorStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalMonitorFrameListenerNative(IntPtr c, OnLocalMonitorFrame onFrame, IntPtr localMonitor, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalSpeakerEventListenerNative(IntPtr c, OnLocalSpeakerAdded onAdded, OnLocalSpeakerRemoved onRemoved, OnLocalSpeakerSelected onSelected, OnLocalSpeakerStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalWindowShareEventListenerNative(IntPtr c, OnLocalWindowShareAdded onAdded, OnLocalWindowShareRemoved onRemoved, OnLocalWindowShareSelected onSelected, OnLocalWindowShareStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLocalWindowShareFrameListenerNative(IntPtr c, OnLocalWindowShareFrame onFrame, IntPtr localWindowShare, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterLogEventListenerNative(IntPtr c, OnLog onLog, IntPtr filter);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterMessageEventListenerNative(IntPtr c, OnChatMessageReceived onChatMessageReceived);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterModerationCommandEventListenerNative(IntPtr c, OnModerationCommandReceived onModerationCommand);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterModerationResultEventListenerNative(IntPtr c, OnModerationResult onModerationResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterNGRResultEventListenerNative(IntPtr c, OnNGRResult onNGRResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterNetworkInterfaceEventListenerNative(IntPtr c, OnNetworkInterfaceAdded onAdded, OnNetworkInterfaceRemoved onRemoved, OnNetworkInterfaceSelected onSelected, OnNetworkInterfaceStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterParticipantEventListenerNative(IntPtr c, OnParticipantJoined onJoined, OnParticipantLeft onLeft, OnDynamicParticipantChanged onDynamicChanged, OnLoudestParticipantChanged onLoudestChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoConnectorRegisterPluginNative(IntPtr c, ulong plugin);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterReconnectEventListenerNative(IntPtr c, OnReconnecting onReconnecting, OnReconnected onReconnected, OnConferenceLost onConferenceLost);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRecorderInCallEventListenerNative(IntPtr c, RecorderInCall onRecorderInCallChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteCameraEventListenerNative(IntPtr c, OnRemoteCameraAdded onAdded, OnRemoteCameraRemoved onRemoved, OnRemoteCameraStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteCameraFrameListenerNative(IntPtr c, OnRemoteCameraFrame onFrame, IntPtr remoteCamera, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteMicrophoneEnergyListenerNative(IntPtr c, OnRemoteMicrophoneEnergy onEnergy);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteMicrophoneEventListenerNative(IntPtr c, OnRemoteMicrophoneAdded onAdded, OnRemoteMicrophoneRemoved onRemoved, OnRemoteMicrophoneStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteMicrophoneFrameListenerNative(IntPtr c, OnRemoteMicrophoneFrame onFrame, IntPtr remoteMicrophone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteRendererEventListenerNative(IntPtr c, OnRemoteRendererAdded onAdded, OnRemoteRendererRemoved onRemoved, OnRemoteRendererStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteSpeakerEventListenerNative(IntPtr c, OnRemoteSpeakerAdded onAdded, OnRemoteSpeakerRemoved onRemoved, OnRemoteSpeakerStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteWindowShareEventListenerNative(IntPtr c, OnRemoteWindowShareAdded onAdded, OnRemoteWindowShareRemoved onRemoved, OnRemoteWindowShareStateUpdated onStateUpdated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterRemoteWindowShareFrameListenerNative(IntPtr c, OnRemoteWindowShareFrame onFrame, IntPtr remoteWindowShare, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterResourceManagerEventListenerNative(IntPtr c, OnAvailableResourcesChanged onAvailableResourcesChanged, OnMaxRemoteSourcesChanged onMaxRemoteSourcesChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterTokenReceivedEventListenerNative(IntPtr c, OnTokenReceived onTokenReceived);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterVirtualAudioSourceEventListenerNative(IntPtr c, OnVirtualAudioSourceAdded onAdded, OnVirtualAudioSourceRemoved onRemoved, OnVirtualAudioSourceStateUpdated onStateUpdated, OnVirtualAudioSourceSelected onSelected, OnVirtualAudioSourceExternalMediaBufferReleased onExternalMediaBufferReleased);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterVirtualVideoSourceEventListenerNative(IntPtr c, OnVirtualVideoSourceAdded onAdded, OnVirtualVideoSourceRemoved onRemoved, OnVirtualVideoSourceStateUpdated onStateUpdated, OnVirtualVideoSourceExternalMediaBufferReleased onExternalMediaBufferReleased);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRegisterWebProxyEventListenerNative(IntPtr c, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRemoveAudioDeviceFromWhitelistNative(IntPtr c, IntPtr deviceName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRemoveModeratorPINNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRemoveModeratorRoleNative(IntPtr c, OnRemoveModeratorRoleResult onRemoveModeratorRoleResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRemovePresenterNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRemoveRoomPINNative(IntPtr c, OnRemoveRoomPINResult onRemoveRoomPinResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorReportLocalParticipantOnJoinedNative(IntPtr c, Boolean reportLocalParticipant);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRequestModeratorRoleNative(IntPtr c, IntPtr moderatorPIN, OnRequestModeratorRoleResult onRequestModeratorRoleResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRequestToResumeVideoNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRequestToSpeakNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRequestVideoForRemoteCameraNative(IntPtr c, IntPtr remoteCamera, uint width, uint height, ulong frameInterval, OnRemoteCameraFirstFrameReceived onFirstFrameReceived);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorRequestVideoForRemoteWindowShareNative(IntPtr c, IntPtr remoteWindowShare, uint width, uint height, ulong frameInterval, OnRemoteWindowShareFirstFrameReceived onFirstFrameReceived);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorResumeRecordingNative(IntPtr c, OnRecordingServiceResumeResult onRecordingServiceResumeResultCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSearchUsersNative(IntPtr c, IntPtr searchText, uint startIndex, uint maxRecords, OnUserSearchResults onUserSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectAudioContentShareNative(IntPtr c, IntPtr localMicrophone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectDefaultCameraNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectDefaultMicrophoneNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectDefaultNetworkInterfaceForMediaNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectDefaultNetworkInterfaceForSignalingNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectDefaultSpeakerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectLocalCameraNative(IntPtr c, IntPtr localCamera);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectLocalMicrophoneNative(IntPtr c, IntPtr localMicrophone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectLocalMonitorNative(IntPtr c, IntPtr localMonitor);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectLocalMonitorAdvancedNative(IntPtr c, IntPtr localMonitor, IntPtr options);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectLocalSpeakerNative(IntPtr c, IntPtr localSpeaker);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectLocalWindowShareNative(IntPtr c, IntPtr localWindowShare);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectLocalWindowShareAdvancedNative(IntPtr c, IntPtr localWindowShare, IntPtr options);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectNetworkInterfaceForMediaNative(IntPtr c, IntPtr networkInterface);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectNetworkInterfaceForSignalingNative(IntPtr c, IntPtr networkInterface);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectVideoContentShareNative(IntPtr c, IntPtr localCamera);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectVirtualAudioContentShareNative(IntPtr c, IntPtr virtualAudioSource);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectVirtualCameraNative(IntPtr c, IntPtr virtualCamera);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectVirtualMicrophoneNative(IntPtr c, IntPtr virtualAudioSource);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectVirtualRendererNative(IntPtr c, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSelectVirtualSourceWindowShareNative(IntPtr c, IntPtr virtualWindowShare);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSendChatMessageNative(IntPtr c, IntPtr message);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSendPrivateChatMessageNative(IntPtr c, IntPtr participant, IntPtr message);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSendVirtualAudioSourceFrameNative(IntPtr c, IntPtr virtualAudioSource, IntPtr audioFrame);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSendVirtualAudioSourceFrameWithExternalDataNative(IntPtr c, IntPtr virtualAudioSource, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT nbSamples, ulong elapsedTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAdvancedLogOptionsNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorLoggerType loggerType, IntPtr advancedLogFilter);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAdvancedOptionsNative(IntPtr c, IntPtr options);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAudioBitrateMultiplierNative(IntPtr c, uint bitrateMultiplier);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAudioModeNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorAudioMode audioMode);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAudioPacketIntervalNative(IntPtr c, uint packetInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAudioPacketLossPercentageNative(IntPtr c, uint lossPercentage);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAutoReconnectNative(IntPtr c, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAutoReconnectAttemptBackOffNative(IntPtr c, uint backOff);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetAutoReconnectMaxAttemptsNative(IntPtr c, uint maxAttempts);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetBlurIntensityNative(IntPtr c, uint intensity);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetCameraBackgroundEffectNative(IntPtr c, IntPtr effectInfo);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetCameraNudgeConfigurationNative(IntPtr c, IntPtr cameraNudgeConfig);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetCameraPrivacyNative(IntPtr c, Boolean privacy);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetCertificateAuthorityFileNative(IntPtr c, IntPtr certificateAuthorityFile);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetCertificateAuthorityListNative(IntPtr c, IntPtr certificateAuthorityList);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetConferenceNumberNative(IntPtr c, IntPtr conferenceNumber);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetCpuTradeOffProfileNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorTradeOffProfile profile);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetDisableVideoOnLowBandwidthNative(IntPtr c, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetDisableVideoOnLowBandwidthAudioStreamsNative(IntPtr c, uint audioStreams);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetDisableVideoOnLowBandwidthRecoveryTimeNative(IntPtr c, uint recoveryTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetDisableVideoOnLowBandwidthResponseTimeNative(IntPtr c, uint responseTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetDisableVideoOnLowBandwidthSampleTimeNative(IntPtr c, uint sampleTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetDisableVideoOnLowBandwidthThresholdNative(IntPtr c, uint kbps);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetFileLoggerRotationParametersNative(IntPtr c, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxSize, ulong wrapPeriod, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT wrapCount);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetFontFileNameNative(IntPtr c, IntPtr fontFileName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetLocationNative(IntPtr c, double latitude, double longitude);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetLogFilePathNative(IntPtr c, IntPtr filename);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetLogLevelNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorLoggerType loggerType, [MarshalAs(UnmanagedType.I4)]ConnectorLogLevel logLevel);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetMaxBitRateNative(IntPtr c, uint bitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetMaxReceiveBitRateNative(IntPtr c, uint bitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetMaxSendBitRateNative(IntPtr c, uint bitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetMicrophoneMaxBoostLevelNative(IntPtr c, double boostLevel);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetMicrophonePrivacyNative(IntPtr c, Boolean privacy);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetMinMicrophoneVolumeNative(IntPtr c, uint volumePercent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetModeNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorMode mode);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetModeratorPINNative(IntPtr c, IntPtr moderatorPIN, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetOptionsNative(IntPtr c, IntPtr options);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetPoolNative(IntPtr c, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetPreferredAudioCodecNative(IntPtr c, [MarshalAs(UnmanagedType.I4)]ConnectorPreferredAudioCodec preferredAudioCodec);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetPresenterNative(IntPtr c, IntPtr participant, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetProductInfoNative(IntPtr c, IntPtr productInfo);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorSetProductInfoSetproductInfoArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorVectorVidyoConnectorProductInformationAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorVectorVidyoConnectorProductInformationDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetRendererOptionsForViewIdNative(IntPtr c, ref IntPtr viewId, IntPtr options);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetRoomPINNative(IntPtr c, IntPtr roomPIN, OnSetRoomPINResult onSetRoomPinResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetSpeakerPrivacyNative(IntPtr c, Boolean privacy);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetStaticShareSvcStateNative(IntPtr c, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetStatisticRateNative(IntPtr c, uint statRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetTCPTransportNative(IntPtr c, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetTURNAddressCredentialsNative(IntPtr c, IntPtr turnAddress, uint port, IntPtr username, IntPtr password, [MarshalAs(UnmanagedType.I4)]ConnectorBaseTransportType baseTransport);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetTURNServerCertificateRequiredNative(IntPtr c, Boolean required);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetUDPTransportNative(IntPtr c, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetViewAnimationSpeedNative(IntPtr c, ref IntPtr viewId, uint speedPercentage);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetViewBackgroundColorNative(IntPtr c, ref IntPtr viewId, byte red, byte green, byte blue);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetVirtualBackgroundPictureNative(IntPtr c, IntPtr pathToPicture);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetWebProxyAddressCredentialsNative(IntPtr c, IntPtr proxyAddress, IntPtr username, IntPtr password);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetWebProxyTransportNative(IntPtr c, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSetWebProxyTransportAddressNative(IntPtr c, IntPtr name, uint port);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorShowAudioMetersNative(IntPtr c, ref IntPtr viewId, Boolean showMeters);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorShowPreviewNative(IntPtr c, Boolean preview);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorShowStatisticsDialogNative(IntPtr c, Boolean showStatisticsDialog);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorShowViewAtNative(IntPtr c, ref IntPtr viewId, int x, int y, uint width, uint height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorShowViewAtPointsNative(IntPtr c, ref IntPtr viewId, int x, int y, uint width, uint height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorShowViewLabelNative(IntPtr c, ref IntPtr viewId, Boolean showLabel);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorShowWindowSharePreviewNative(IntPtr c, Boolean preview);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStartGoogleAnalyticsServiceNative(IntPtr c, IntPtr options);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStartInsightsServiceNative(IntPtr c, IntPtr serverUrl);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStartLectureModeNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStartNextLogFileNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStartRecordingNative(IntPtr c, IntPtr recordingProfilePrefix, OnRecordingServiceStartResult onRecordingServiceStartCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStopGoogleAnalyticsServiceNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStopInsightsServiceNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStopLectureModeNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorStopRecordingNative(IntPtr c, OnRecordingServiceStopResult onRecordingServiceStopResultCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorSwapStreamsBetweenViewsNative(IntPtr c, ref IntPtr first, ref IntPtr second);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnlockRoomNative(IntPtr c, OnUnlockRoomResult onUnlockRoomResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnraiseHandNative(IntPtr c, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterBotEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterCameraEffectErrorListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterConferenceModeEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterConnectionPropertiesEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterErrorEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterHostEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterInCallEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLectureModeEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalCameraEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalCameraFrameListenerNative(IntPtr c, IntPtr localCamera);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalMicrophoneEnergyListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalMicrophoneEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalMicrophoneFrameListenerNative(IntPtr c, IntPtr localMicrophone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalMonitorEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalMonitorFrameListenerNative(IntPtr c, IntPtr localMonitor);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalSpeakerEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalWindowShareEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLocalWindowShareFrameListenerNative(IntPtr c, IntPtr localWindowShare);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterLogEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterMessageEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterModerationCommandEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterModerationResultEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterNGRResultEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterNetworkInterfaceEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterParticipantEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterPluginNative(IntPtr c, ulong plugin);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterReconnectEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRecorderInCallEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteCameraEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteCameraFrameListenerNative(IntPtr c, IntPtr remoteCamera);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteMicrophoneEnergyListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteMicrophoneEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteMicrophoneFrameListenerNative(IntPtr c, IntPtr remoteMicrophone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteRendererEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteSpeakerEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteWindowShareEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterRemoteWindowShareFrameListenerNative(IntPtr c, IntPtr remoteWindowShare);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterResourceManagerEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterTokenReceivedEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterVirtualAudioSourceEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterVirtualVideoSourceEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoConnectorUnregisterWebProxyEventListenerNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoConnectorGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoConnectorSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnAvailableResourcesChanged(IntPtr c, uint cpuEncode, uint cpuDecode, uint bandwidthSend, uint bandwidthReceive);
		private OnAvailableResourcesChanged _mOnAvailableResourcesChanged = OnAvailableResourcesChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnBotJoined(IntPtr c, IntPtr info);
		private OnBotJoined _mOnBotJoined = OnBotJoinedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnBotLeft(IntPtr c, IntPtr info);
		private OnBotLeft _mOnBotLeft = OnBotLeftDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnCameraEffectError(IntPtr c, ConnectorCameraEffectError error);
		private OnCameraEffectError _mOnCameraEffectError = OnCameraEffectErrorDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnChatMessageReceived(IntPtr c, IntPtr participant, IntPtr chatMessage);
		private OnChatMessageReceived _mOnChatMessageReceived = OnChatMessageReceivedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConferenceHostStatusChanged(IntPtr c, IntPtr host, ConnectorConferenceHostState hostState);
		private OnConferenceHostStatusChanged _mOnConferenceHostStatusChanged = OnConferenceHostStatusChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConferenceLost(IntPtr c, ConnectorFailReason reason);
		private OnConferenceLost _mOnConferenceLost = OnConferenceLostDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConferenceModeChanged(IntPtr c, ConnectorConferenceMode mode);
		private OnConferenceModeChanged _mOnConferenceModeChanged = OnConferenceModeChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConnectionPropertiesChanged(IntPtr c, IntPtr connectionProperties);
		private OnConnectionPropertiesChanged _mOnConnectionPropertiesChanged = OnConnectionPropertiesChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnDisconnected(IntPtr c, ConnectorDisconnectReason reason);
		private OnDisconnected _mOnDisconnected = OnDisconnectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnDynamicParticipantChanged(IntPtr c, IntPtr participants);
		private OnDynamicParticipantChanged _mOnDynamicParticipantChanged = OnDynamicParticipantChangedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnDynamicParticipantChangedGetparticipantsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnDynamicParticipantChangedFreeparticipantsArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnError(IntPtr c, ConnectorErrorCode error, IntPtr apiName);
		private OnError _mOnError = OnErrorDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnErrorGetapiNameCStr(IntPtr apiName);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnFailure(IntPtr c, ConnectorFailReason reason);
		private OnFailure _mOnFailure = OnFailureDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetActiveNetworkInterface(IntPtr c, IntPtr signalingInterface, IntPtr mediaInterface);
		private OnGetActiveNetworkInterface _mOnGetActiveNetworkInterface = OnGetActiveNetworkInterfaceDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetAutoReconnectSetting(IntPtr c, Boolean enableAutoReconnect, uint reconnectBackoff, uint maxReconnectAttempts);
		private OnGetAutoReconnectSetting _mOnGetAutoReconnectSetting = OnGetAutoReconnectSettingDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetCameraBackgroundEffectInfo(IntPtr c, IntPtr effectInfo);
		private OnGetCameraBackgroundEffectInfo _mOnGetCameraBackgroundEffectInfo = OnGetCameraBackgroundEffectInfoDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetGoogleAnalyticsEventTable(IntPtr c, IntPtr eventTable);
		private OnGetGoogleAnalyticsEventTable _mOnGetGoogleAnalyticsEventTable = OnGetGoogleAnalyticsEventTableDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetGoogleAnalyticsEventTableGeteventTableArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetGoogleAnalyticsEventTableFreeeventTableArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetGoogleAnalyticsOptions(IntPtr c, IntPtr options);
		private OnGetGoogleAnalyticsOptions _mOnGetGoogleAnalyticsOptions = OnGetGoogleAnalyticsOptionsDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetRecordingServiceProfiles(IntPtr c, IntPtr profiles, IntPtr prefixes, ConnectorRecordingServiceResult result);
		private OnGetRecordingServiceProfiles _mOnGetRecordingServiceProfiles = OnGetRecordingServiceProfilesDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetRecordingServiceProfilesGetprofilesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetRecordingServiceProfilesFreeprofilesArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetRecordingServiceProfilesGetprefixesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetRecordingServiceProfilesFreeprefixesArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetWhitelistedAudioDevices(IntPtr c, IntPtr audioDevices);
		private OnGetWhitelistedAudioDevices _mOnGetWhitelistedAudioDevices = OnGetWhitelistedAudioDevicesDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetWhitelistedAudioDevicesGetaudioDevicesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnGetWhitelistedAudioDevicesFreeaudioDevicesArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnHandRaised(IntPtr c, IntPtr participant);
		private OnHandRaised _mOnHandRaised = OnHandRaisedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnHandRaisedGetparticipantArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnHandRaisedFreeparticipantArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnInCallEvents(IntPtr c, IntPtr ev);
		private OnInCallEvents _mOnInCallEvents = OnInCallEventsDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnInviteResult(IntPtr c, IntPtr inviteeId, ConnectorModerationResult result);
		private OnInviteResult _mOnInviteResult = OnInviteResultDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnInviteResultGetinviteeIdCStr(IntPtr inviteeId);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalCameraAdded(IntPtr c, IntPtr localCamera);
		private OnLocalCameraAdded _mOnLocalCameraAdded = OnLocalCameraAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalCameraFrame(IntPtr c, IntPtr localCamera, IntPtr videoFrame);
		private OnLocalCameraFrame _mOnLocalCameraFrame = OnLocalCameraFrameDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalCameraRemoved(IntPtr c, IntPtr localCamera);
		private OnLocalCameraRemoved _mOnLocalCameraRemoved = OnLocalCameraRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalCameraSelected(IntPtr c, IntPtr localCamera);
		private OnLocalCameraSelected _mOnLocalCameraSelected = OnLocalCameraSelectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalCameraStateUpdated(IntPtr c, IntPtr localCamera, Device.DeviceState state);
		private OnLocalCameraStateUpdated _mOnLocalCameraStateUpdated = OnLocalCameraStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMicrophoneAdded(IntPtr c, IntPtr localMicrophone);
		private OnLocalMicrophoneAdded _mOnLocalMicrophoneAdded = OnLocalMicrophoneAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMicrophoneEnergy(IntPtr c, IntPtr localMicrophone, int audioEnergy);
		private OnLocalMicrophoneEnergy _mOnLocalMicrophoneEnergy = OnLocalMicrophoneEnergyDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMicrophoneFrame(IntPtr c, IntPtr localMicrophone, IntPtr audioFrame);
		private OnLocalMicrophoneFrame _mOnLocalMicrophoneFrame = OnLocalMicrophoneFrameDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMicrophoneRemoved(IntPtr c, IntPtr localMicrophone);
		private OnLocalMicrophoneRemoved _mOnLocalMicrophoneRemoved = OnLocalMicrophoneRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMicrophoneSelected(IntPtr c, IntPtr localMicrophone);
		private OnLocalMicrophoneSelected _mOnLocalMicrophoneSelected = OnLocalMicrophoneSelectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMicrophoneStateUpdated(IntPtr c, IntPtr localMicrophone, Device.DeviceState state);
		private OnLocalMicrophoneStateUpdated _mOnLocalMicrophoneStateUpdated = OnLocalMicrophoneStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMonitorAdded(IntPtr c, IntPtr localMonitor);
		private OnLocalMonitorAdded _mOnLocalMonitorAdded = OnLocalMonitorAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMonitorFrame(IntPtr c, IntPtr localMonitor, IntPtr videoFrame);
		private OnLocalMonitorFrame _mOnLocalMonitorFrame = OnLocalMonitorFrameDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMonitorRemoved(IntPtr c, IntPtr localMonitor);
		private OnLocalMonitorRemoved _mOnLocalMonitorRemoved = OnLocalMonitorRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMonitorSelected(IntPtr c, IntPtr localMonitor);
		private OnLocalMonitorSelected _mOnLocalMonitorSelected = OnLocalMonitorSelectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalMonitorStateUpdated(IntPtr c, IntPtr localMonitor, Device.DeviceState state);
		private OnLocalMonitorStateUpdated _mOnLocalMonitorStateUpdated = OnLocalMonitorStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalSpeakerAdded(IntPtr c, IntPtr localSpeaker);
		private OnLocalSpeakerAdded _mOnLocalSpeakerAdded = OnLocalSpeakerAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalSpeakerRemoved(IntPtr c, IntPtr localSpeaker);
		private OnLocalSpeakerRemoved _mOnLocalSpeakerRemoved = OnLocalSpeakerRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalSpeakerSelected(IntPtr c, IntPtr localSpeaker);
		private OnLocalSpeakerSelected _mOnLocalSpeakerSelected = OnLocalSpeakerSelectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalSpeakerStateUpdated(IntPtr c, IntPtr localSpeaker, Device.DeviceState state);
		private OnLocalSpeakerStateUpdated _mOnLocalSpeakerStateUpdated = OnLocalSpeakerStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalWindowShareAdded(IntPtr c, IntPtr localWindowShare);
		private OnLocalWindowShareAdded _mOnLocalWindowShareAdded = OnLocalWindowShareAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalWindowShareFrame(IntPtr c, IntPtr localWindowShare, IntPtr videoFrame);
		private OnLocalWindowShareFrame _mOnLocalWindowShareFrame = OnLocalWindowShareFrameDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalWindowShareRemoved(IntPtr c, IntPtr localWindowShare);
		private OnLocalWindowShareRemoved _mOnLocalWindowShareRemoved = OnLocalWindowShareRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalWindowShareSelected(IntPtr c, IntPtr localWindowShare);
		private OnLocalWindowShareSelected _mOnLocalWindowShareSelected = OnLocalWindowShareSelectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLocalWindowShareStateUpdated(IntPtr c, IntPtr localWindowShare, Device.DeviceState state);
		private OnLocalWindowShareStateUpdated _mOnLocalWindowShareStateUpdated = OnLocalWindowShareStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLockRoomResult(IntPtr c, ConnectorModerationResult result);
		private OnLockRoomResult _mOnLockRoomResult = OnLockRoomResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLog(IntPtr c, IntPtr logRecord);
		private OnLog _mOnLog = OnLogDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLoudestParticipantChanged(IntPtr c, IntPtr participant, Boolean audioOnly);
		private OnLoudestParticipantChanged _mOnLoudestParticipantChanged = OnLoudestParticipantChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMaxRemoteSourcesChanged(IntPtr c, uint maxRemoteSources);
		private OnMaxRemoteSourcesChanged _mOnMaxRemoteSourcesChanged = OnMaxRemoteSourcesChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnModerationCommandReceived(IntPtr c, Device.DeviceType deviceType, Room.RoomModerationType moderationType, Boolean state);
		private OnModerationCommandReceived _mOnModerationCommandReceived = OnModerationCommandReceivedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnModerationResult(IntPtr c, IntPtr participant, ConnectorModerationResult result, ConnectorModerationActionType action, IntPtr requestId);
		private OnModerationResult _mOnModerationResult = OnModerationResultDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnModerationResultGetrequestIdCStr(IntPtr requestId);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnNGRResult(IntPtr c, ConnectorNGRActionType type, Boolean success, IntPtr error);
		private OnNGRResult _mOnNGRResult = OnNGRResultDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnNGRResultGeterrorCStr(IntPtr error);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnNetworkInterfaceAdded(IntPtr c, IntPtr networkInterface);
		private OnNetworkInterfaceAdded _mOnNetworkInterfaceAdded = OnNetworkInterfaceAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnNetworkInterfaceRemoved(IntPtr c, IntPtr networkInterface);
		private OnNetworkInterfaceRemoved _mOnNetworkInterfaceRemoved = OnNetworkInterfaceRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnNetworkInterfaceSelected(IntPtr c, IntPtr networkInterface, NetworkInterface.NetworkInterfaceTransportType transportType);
		private OnNetworkInterfaceSelected _mOnNetworkInterfaceSelected = OnNetworkInterfaceSelectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnNetworkInterfaceStateUpdated(IntPtr c, IntPtr networkInterface, NetworkInterface.NetworkInterfaceState state);
		private OnNetworkInterfaceStateUpdated _mOnNetworkInterfaceStateUpdated = OnNetworkInterfaceStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnParticipantJoined(IntPtr c, IntPtr participant);
		private OnParticipantJoined _mOnParticipantJoined = OnParticipantJoinedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnParticipantLeft(IntPtr c, IntPtr participant);
		private OnParticipantLeft _mOnParticipantLeft = OnParticipantLeftDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnPresenterChanged(IntPtr c, IntPtr participant);
		private OnPresenterChanged _mOnPresenterChanged = OnPresenterChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRaiseHandResponse(IntPtr c, Participant.ParticipantHandState handState);
		private OnRaiseHandResponse _mOnRaiseHandResponse = OnRaiseHandResponseDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnReconnected(IntPtr c);
		private OnReconnected _mOnReconnected = OnReconnectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnReconnecting(IntPtr c, uint attempt, uint attemptTimeout, ConnectorFailReason reason);
		private OnReconnecting _mOnReconnecting = OnReconnectingDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServicePauseResult(IntPtr c, ConnectorModerationResult result);
		private OnRecordingServicePauseResult _mOnRecordingServicePauseResult = OnRecordingServicePauseResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServiceResumeResult(IntPtr c, ConnectorModerationResult result);
		private OnRecordingServiceResumeResult _mOnRecordingServiceResumeResult = OnRecordingServiceResumeResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServiceStartResult(IntPtr c, ConnectorModerationResult result);
		private OnRecordingServiceStartResult _mOnRecordingServiceStartResult = OnRecordingServiceStartResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServiceStopResult(IntPtr c, ConnectorModerationResult result);
		private OnRecordingServiceStopResult _mOnRecordingServiceStopResult = OnRecordingServiceStopResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteCameraAdded(IntPtr c, IntPtr remoteCamera, IntPtr participant);
		private OnRemoteCameraAdded _mOnRemoteCameraAdded = OnRemoteCameraAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteCameraFirstFrameReceived(IntPtr c, IntPtr remoteCamera);
		private OnRemoteCameraFirstFrameReceived _mOnRemoteCameraFirstFrameReceived = OnRemoteCameraFirstFrameReceivedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteCameraFrame(IntPtr c, IntPtr remoteCamera, IntPtr participant, IntPtr videoFrame);
		private OnRemoteCameraFrame _mOnRemoteCameraFrame = OnRemoteCameraFrameDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteCameraRemoved(IntPtr c, IntPtr remoteCamera, IntPtr participant);
		private OnRemoteCameraRemoved _mOnRemoteCameraRemoved = OnRemoteCameraRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteCameraStateUpdated(IntPtr c, IntPtr remoteCamera, IntPtr participant, Device.DeviceState state);
		private OnRemoteCameraStateUpdated _mOnRemoteCameraStateUpdated = OnRemoteCameraStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteMicrophoneAdded(IntPtr c, IntPtr remoteMicrophone, IntPtr participant);
		private OnRemoteMicrophoneAdded _mOnRemoteMicrophoneAdded = OnRemoteMicrophoneAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteMicrophoneEnergy(IntPtr c, IntPtr remoteMicrophone, IntPtr participant, int audioEnergy);
		private OnRemoteMicrophoneEnergy _mOnRemoteMicrophoneEnergy = OnRemoteMicrophoneEnergyDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteMicrophoneFrame(IntPtr c, IntPtr remoteMicrophone, IntPtr participant, IntPtr audioFrame);
		private OnRemoteMicrophoneFrame _mOnRemoteMicrophoneFrame = OnRemoteMicrophoneFrameDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteMicrophoneRemoved(IntPtr c, IntPtr remoteMicrophone, IntPtr participant);
		private OnRemoteMicrophoneRemoved _mOnRemoteMicrophoneRemoved = OnRemoteMicrophoneRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteMicrophoneStateUpdated(IntPtr c, IntPtr remoteMicrophone, IntPtr participant, Device.DeviceState state);
		private OnRemoteMicrophoneStateUpdated _mOnRemoteMicrophoneStateUpdated = OnRemoteMicrophoneStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteRendererAdded(IntPtr c, IntPtr remoteRenderer);
		private OnRemoteRendererAdded _mOnRemoteRendererAdded = OnRemoteRendererAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteRendererRemoved(IntPtr c, IntPtr remoteRenderer);
		private OnRemoteRendererRemoved _mOnRemoteRendererRemoved = OnRemoteRendererRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteRendererStateUpdated(IntPtr c, IntPtr remoteRenderer, Device.DeviceState state);
		private OnRemoteRendererStateUpdated _mOnRemoteRendererStateUpdated = OnRemoteRendererStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteSpeakerAdded(IntPtr c, IntPtr remoteSpeaker);
		private OnRemoteSpeakerAdded _mOnRemoteSpeakerAdded = OnRemoteSpeakerAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteSpeakerRemoved(IntPtr c, IntPtr remoteSpeaker);
		private OnRemoteSpeakerRemoved _mOnRemoteSpeakerRemoved = OnRemoteSpeakerRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteSpeakerStateUpdated(IntPtr c, IntPtr remoteSpeaker, Device.DeviceState state);
		private OnRemoteSpeakerStateUpdated _mOnRemoteSpeakerStateUpdated = OnRemoteSpeakerStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteWindowShareAdded(IntPtr c, IntPtr remoteWindowShare, IntPtr participant);
		private OnRemoteWindowShareAdded _mOnRemoteWindowShareAdded = OnRemoteWindowShareAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteWindowShareFirstFrameReceived(IntPtr c, IntPtr remoteWindowShare);
		private OnRemoteWindowShareFirstFrameReceived _mOnRemoteWindowShareFirstFrameReceived = OnRemoteWindowShareFirstFrameReceivedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteWindowShareFrame(IntPtr c, IntPtr remoteWindowShare, IntPtr participant, IntPtr videoFrame);
		private OnRemoteWindowShareFrame _mOnRemoteWindowShareFrame = OnRemoteWindowShareFrameDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteWindowShareRemoved(IntPtr c, IntPtr remoteWindowShare, IntPtr participant);
		private OnRemoteWindowShareRemoved _mOnRemoteWindowShareRemoved = OnRemoteWindowShareRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoteWindowShareStateUpdated(IntPtr c, IntPtr remoteWindowShare, IntPtr participant, Device.DeviceState state);
		private OnRemoteWindowShareStateUpdated _mOnRemoteWindowShareStateUpdated = OnRemoteWindowShareStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoveModeratorRoleResult(IntPtr c, ConnectorModerationResult result);
		private OnRemoveModeratorRoleResult _mOnRemoveModeratorRoleResult = OnRemoveModeratorRoleResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoveRoomPINResult(IntPtr c, ConnectorModerationResult result);
		private OnRemoveRoomPINResult _mOnRemoveRoomPINResult = OnRemoveRoomPINResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRequestModeratorRoleResult(IntPtr c, ConnectorModerationResult result);
		private OnRequestModeratorRoleResult _mOnRequestModeratorRoleResult = OnRequestModeratorRoleResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnSetRoomPINResult(IntPtr c, ConnectorModerationResult result);
		private OnSetRoomPINResult _mOnSetRoomPINResult = OnSetRoomPINResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnSuccess(IntPtr c);
		private OnSuccess _mOnSuccess = OnSuccessDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnTokenReceived(IntPtr c, IntPtr tokenInfo);
		private OnTokenReceived _mOnTokenReceived = OnTokenReceivedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnTokenReceivedGettokenInfoArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnTokenReceivedFreetokenInfoArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUnlockRoomResult(IntPtr c, ConnectorModerationResult result);
		private OnUnlockRoomResult _mOnUnlockRoomResult = OnUnlockRoomResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUserSearchResults(IntPtr c, IntPtr searchText, uint startIndex, ConnectorSearchResult searchResult, IntPtr contacts, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT numRecords);
		private OnUserSearchResults _mOnUserSearchResults = OnUserSearchResultsDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnUserSearchResultsGetsearchTextCStr(IntPtr searchText);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnUserSearchResultsGetcontactsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnUserSearchResultsFreecontactsArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualAudioSourceAdded(IntPtr c, IntPtr virtualAudioSource);
		private OnVirtualAudioSourceAdded _mOnVirtualAudioSourceAdded = OnVirtualAudioSourceAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualAudioSourceExternalMediaBufferReleased(IntPtr c, IntPtr virtualAudioSource, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size);
		private OnVirtualAudioSourceExternalMediaBufferReleased _mOnVirtualAudioSourceExternalMediaBufferReleased = OnVirtualAudioSourceExternalMediaBufferReleasedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualAudioSourceRemoved(IntPtr c, IntPtr virtualAudioSource);
		private OnVirtualAudioSourceRemoved _mOnVirtualAudioSourceRemoved = OnVirtualAudioSourceRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualAudioSourceSelected(IntPtr c, IntPtr virtualAudioSource);
		private OnVirtualAudioSourceSelected _mOnVirtualAudioSourceSelected = OnVirtualAudioSourceSelectedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualAudioSourceStateUpdated(IntPtr c, IntPtr virtualAudioSource, Device.DeviceState state);
		private OnVirtualAudioSourceStateUpdated _mOnVirtualAudioSourceStateUpdated = OnVirtualAudioSourceStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualVideoSourceAdded(IntPtr c, IntPtr virtualVideoSource);
		private OnVirtualVideoSourceAdded _mOnVirtualVideoSourceAdded = OnVirtualVideoSourceAddedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualVideoSourceExternalMediaBufferReleased(IntPtr c, IntPtr virtualVideoSource, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size);
		private OnVirtualVideoSourceExternalMediaBufferReleased _mOnVirtualVideoSourceExternalMediaBufferReleased = OnVirtualVideoSourceExternalMediaBufferReleasedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualVideoSourceRemoved(IntPtr c, IntPtr virtualVideoSource);
		private OnVirtualVideoSourceRemoved _mOnVirtualVideoSourceRemoved = OnVirtualVideoSourceRemovedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnVirtualVideoSourceStateUpdated(IntPtr c, IntPtr virtualVideoSource, Device.DeviceState state);
		private OnVirtualVideoSourceStateUpdated _mOnVirtualVideoSourceStateUpdated = OnVirtualVideoSourceStateUpdatedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnWebProxyCredentialsRequest(IntPtr c, IntPtr webProxyAddress);
		private OnWebProxyCredentialsRequest _mOnWebProxyCredentialsRequest = OnWebProxyCredentialsRequestDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorOnWebProxyCredentialsRequestGetwebProxyAddressCStr(IntPtr webProxyAddress);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void RecorderInCall(IntPtr c, Boolean hasRecorder, Boolean isPaused);
		private RecorderInCall _mRecorderInCall = RecorderInCallDelegate;
		/// <summary>
		/// Indicates the audio mode.
		/// </summary>
		public enum ConnectorAudioMode {
			/// <summary>Both audio devices (Speaker and Microphone) used in shared mode.</summary>
			ConnectoraudiomodeSharedModeBoth,
			/// <summary>Both audio devices (Speaker and Microphone) used in exclusive mode.</summary>
			ConnectoraudiomodeExclusiveModeBoth,
			/// <summary>Microphone is used in exclusive mode and speaker in shared mode.</summary>
			ConnectoraudiomodeExclusiveModeMicrophone,
			/// <summary>Unknown audio mode.</summary>
			ConnectoraudiomodeUnknown
		}
		/// <summary>
		/// Base transport type.
		/// </summary>
		public enum ConnectorBaseTransportType {
			/// <summary>Use TLS as base transport.</summary>
			ConnectorbasetransporttypeTLS,
			/// <summary>Use TCP as base transport.</summary>
			ConnectorbasetransporttypeTCP,
			/// <summary>Use UDP as base transport.</summary>
			ConnectorbasetransporttypeUDP
		}
		/// <summary>
		/// Provides the error codes for camera background effect.
		/// </summary>
		public enum ConnectorCameraEffectError {
			/// <summary>No errors.</summary>
			ConnectorcameraeffecterrorNone,
			/// <summary>The token is empty or expired.</summary>
			ConnectorcameraeffecterrorInvalidToken,
			/// <summary>The path to resources is empty or does not contain some files.</summary>
			ConnectorcameraeffecterrorInvalidResources,
			/// <summary>The path to effect is empty or does not contain some files.</summary>
			ConnectorcameraeffecterrorInvalidEffect,
			/// <summary>The blur intensity is out of allowed range.</summary>
			ConnectorcameraeffecterrorInvalidBlurIntensity,
			/// <summary>The path to background picture is empty or file doesn't exist or has unsupported format.</summary>
			ConnectorcameraeffecterrorInvalidBackgroundPicture,
			/// <summary>Failed to load effect.</summary>
			ConnectorcameraeffecterrorLoadEffectFailed,
			/// <summary>Effect was not started due to unsupported OpenGL version.</summary>
			ConnectorcameraeffecterrorUnsupportedOpenGLVersion,
			/// <summary>Effect was not started due to unsupported Banuba library version.</summary>
			ConnectorcameraeffecterrorUnsupportedLibraryVersion,
			/// <summary>Opperation is not allowed with the current effect.</summary>
			ConnectorcameraeffecterrorNotAllowedForCurrectEffect,
			/// <summary>Miscellaneous error.</summary>
			ConnectorcameraeffecterrorMiscError
		}
		/// <summary>
		/// Provides the supported camera background effects and used to enable or disable effect.
		/// </summary>
		public enum ConnectorCameraEffectType {
			/// <summary>Disables active effects.</summary>
			ConnectorcameraeffecttypeNone,
			/// <summary>Enables background blur effect.</summary>
			ConnectorcameraeffecttypeBlur,
			/// <summary>Enables virtual background effect.</summary>
			ConnectorcameraeffecttypeVirtualBackground
		}
		/// <summary>
		/// Tell us the joining status of the host or owner of the room hosting the conference.
		/// </summary>
		public enum ConnectorConferenceHostState {
			/// <summary>Tells us if the host has joined</summary>
			ConnectorconferencehoststateJOINED,
			/// <summary>Tells us if the host has left the conference</summary>
			ConnectorconferencehoststateLEFT
		}
		/// <summary>
		/// Sets the type of conference mode.
		/// </summary>
		public enum ConnectorConferenceMode {
			/// <summary>Indicate the user has joined the room which has Lobby Room property. The user is waiting in lobby because the host or presenter has not joined yet</summary>
			ConnectorconferencemodeLOBBY,
			/// <summary>Indicate the user has joined the room which has Lecture Mode property. The lecture mode features will be enforced on this room.</summary>
			ConnectorconferencemodeLECTURE,
			/// <summary>Indicate the user is in room with property Group mode, which is a regular conference room with no special property</summary>
			ConnectorconferencemodeGROUP
		}
		/// <summary>
		/// Reasons why an established connection was disconnected.
		/// </summary>
		public enum ConnectorDisconnectReason {
			/// <summary>The user disconnected gracefully.</summary>
			ConnectordisconnectreasonDisconnected,
			/// <summary>The transport connection was lost.</summary>
			ConnectordisconnectreasonConnectionLost,
			/// <summary>The signaling connection timed-out.</summary>
			ConnectordisconnectreasonConnectionTimeout,
			/// <summary>The service did not respond in a reasonable amount of time to a request by the user.</summary>
			ConnectordisconnectreasonNoResponse,
			/// <summary>The service closed the connection or otherwise terminated the login session.</summary>
			ConnectordisconnectreasonTerminated,
			/// <summary>The user was kicked out of the room. This could be the result of an administrator's action.</summary>
			ConnectordisconnectreasonBooted,
			/// <summary>A miscellaneous problem occurred with this client library.</summary>
			ConnectordisconnectreasonMiscLocalError,
			/// <summary>A miscellaneous problem occurred with the conferencing service.</summary>
			ConnectordisconnectreasonMiscRemoteError,
			/// <summary>The connection was closed for some other miscellaneous reason.</summary>
			ConnectordisconnectreasonMiscError
		}
		/// <summary>
		/// Provide the advanced error code to the application.
		/// </summary>
		public enum ConnectorErrorCode {
			/// <summary>Not allowed.</summary>
			ConnectorerrorcodeNotAllowed,
			/// <summary>Called in wrong state.</summary>
			ConnectorerrorcodeWrongState,
			/// <summary>Invalid input.</summary>
			ConnectorerrorcodeInvalidInput,
			/// <summary>Miscellaneous remote error.</summary>
			ConnectorerrorcodeMisc
		}
		/// <summary>
		/// Reasons why a connection attempt failed.
		/// </summary>
		public enum ConnectorFailReason {
			/// <summary>The destination could not be reached.</summary>
			ConnectorfailreasonConnectionFailed,
			/// <summary>The transport connection was lost prior to completing the login procedure.</summary>
			ConnectorfailreasonConnectionLost,
			/// <summary>The signaling connection timed-out prior to completing the login procedure.</summary>
			ConnectorfailreasonConnectionTimeout,
			/// <summary>The service was successfully contacted, but the service ignored the user's request to log in or it did not answer in a reasonable amount of time.</summary>
			ConnectorfailreasonNoResponse,
			/// <summary>The service was successfully contacted, but the service closed the connection or it refused to continue processing the login request.</summary>
			ConnectorfailreasonTerminated,
			/// <summary>The token that was provided is unknown to the service or unauthorized to log in.</summary>
			ConnectorfailreasonInvalidToken,
			/// <summary>The room pin that was provided is invalid or unauthorized.</summary>
			ConnectorfailreasonInvalidRoomPin,
			/// <summary>The server was unable to create the resource.</summary>
			ConnectorfailreasonUnableToCreateResource,
			/// <summary>The server did not respond in a reasonable amount of time to the request to connect to the resource.</summary>
			ConnectorfailreasonNoResponseFromResource,
			/// <summary>The resource ID was invalid.</summary>
			ConnectorfailreasonInvalidResourceId,
			/// <summary>The resource is at full capacity, and it cannot accept additional members.</summary>
			ConnectorfailreasonResourceFull,
			/// <summary>The resource allows only certain users to enter, and the current user is not one of them.</summary>
			ConnectorfailreasonNotMember,
			/// <summary>The user has been banned from entering the resource.</summary>
			ConnectorfailreasonBanned,
			/// <summary>The client could not enable media.</summary>
			ConnectorfailreasonMediaNotEnabled,
			/// <summary>An established media connection failed.</summary>
			ConnectorfailreasonMediaFailed,
			/// <summary>The server rejected the user's request to enter the resource, due to a miscellaneous problem with the request.</summary>
			ConnectorfailreasonMiscLocalError,
			/// <summary>The server rejected the user's request to enter the resource, due to a miscellaneous problem of its own.</summary>
			ConnectorfailreasonMiscRemoteError,
			/// <summary>The login failed for some other miscellaneous reason.</summary>
			ConnectorfailreasonMiscError,
			/// <summary>Length of the display name is longer than 256 characters.</summary>
			ConnectorfailreasonInvalidDisplayNameLength,
			/// <summary>An established media connection failed because the room is locked and it cannot accept additional members.</summary>
			ConnectorfailreasonRoomLocked,
			/// <summary>An established media connection failed because the room is disabled.</summary>
			ConnectorfailreasonRoomDisabled,
			/// <summary>An established media connection failed because all lines are in use.</summary>
			ConnectorfailreasonAllLinesInUse,
			/// <summary>An established media connection failed because the seat license has expired.</summary>
			ConnectorfailreasonSeatLicenseExpired,
			/// <summary>An established media connection failed because the endpoint is not licensed.</summary>
			ConnectorfailreasonNotLicensed,
			/// <summary>Attempt to enable media was rejected by the server.</summary>
			ConnectorfailreasonRejected,
			/// <summary>VidyoClient library does not support this browser versoin.</summary>
			ConnectorfailreasonBrowserVersionNotSupported
		}
		/// <summary>
		/// Represents the event action of google analytics service.
		/// </summary>
		public enum ConnectorGoogleAnalyticsEventAction {
			/// <summary>The event indicates that login was successful.</summary>
			ConnectorgoogleanalyticseventactionLoginSuccess,
			/// <summary>This event indicates a login attempt.</summary>
			ConnectorgoogleanalyticseventactionLoginAttempt,
			/// <summary>This event indicates that login failed due to authentication.</summary>
			ConnectorgoogleanalyticseventactionLoginFailedAuthentication,
			/// <summary>This event indicates that login failed due to connect.</summary>
			ConnectorgoogleanalyticseventactionLoginFailedConnect,
			/// <summary>This event indicates that login failed due to response timeout.</summary>
			ConnectorgoogleanalyticseventactionLoginFailedResponseTimeout,
			/// <summary>This event indicates that login failed due to miscellaneous error.</summary>
			ConnectorgoogleanalyticseventactionLoginFailedMiscError,
			/// <summary>This event indicates that login failed due to webproxy authentication.</summary>
			ConnectorgoogleanalyticseventactionLoginFailedWebProxyAuthRequired,
			/// <summary>This event indicates that login failed due to unsupported tenant version.</summary>
			ConnectorgoogleanalyticseventactionLoginFailedUnsupportedTenantVersion,
			/// <summary>This event indicates that user type is guest.</summary>
			ConnectorgoogleanalyticseventactionUserTypeGuest,
			/// <summary>This event indicates that user type is regular with token.</summary>
			ConnectorgoogleanalyticseventactionUserTypeRegularToken,
			/// <summary>This event indicates that user type is regular with password.</summary>
			ConnectorgoogleanalyticseventactionUserTypeRegularPassword,
			/// <summary>This event indicates that user type is regular with saml.</summary>
			ConnectorgoogleanalyticseventactionUserTypeRegularSaml,
			/// <summary>This event indicates that user type is regular with extended data.</summary>
			ConnectorgoogleanalyticseventactionUserTypeRegularExtdata,
			/// <summary>This event indicates that join conference is successful.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceSuccess,
			/// <summary>This event indicates that join conference attempt is made.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceAttempt,
			/// <summary>This event indicates that join conference with reconnect requested.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceReconnectRequests,
			/// <summary>This Event indicates that join conference is failed due to connection error.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceFailedConnectionError,
			/// <summary>This event indicates that join conference is failed due to wrong pin.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceFailedWrongPin,
			/// <summary>This event indicates that join conference is failed because room is full.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceFailedRoomFull,
			/// <summary>This event indicates that join conference is failed because room is disabled.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceFailedRoomDisabled,
			/// <summary>This event indicates that join conference is failed because conference room is locked.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceFailedConferenceLocked,
			/// <summary>This event indicates that join conference is failed due to unknown error.</summary>
			ConnectorgoogleanalyticseventactionJoinConferenceFailedUnknownError,
			/// <summary>This event indicates that conference is ended because user is left.</summary>
			ConnectorgoogleanalyticseventactionConferenceEndLeft,
			/// <summary>This event indicates that conference is ended because user is booted.</summary>
			ConnectorgoogleanalyticseventactionConferenceEndBooted,
			/// <summary>This event indicates that conference is ended because signaling connection is lost.</summary>
			ConnectorgoogleanalyticseventactionConferenceEndSignalingConnectionLost,
			/// <summary>This event indicates that conference is ended because media connection is lost.</summary>
			ConnectorgoogleanalyticseventactionConferenceEndMediaConnectionLost,
			/// <summary>This event indicates that conference is ended with unknown error.</summary>
			ConnectorgoogleanalyticseventactionConferenceEndUnknownError,
			/// <summary>This event indicates that H264 video codec is used in a conference call.</summary>
			ConnectorgoogleanalyticseventactionInCallCodecVideoH264,
			/// <summary>This event indicates that H264-SVC video codec is used in a conference call.</summary>
			ConnectorgoogleanalyticseventactionInCallCodecVideoH264SVC,
			/// <summary>This event indicates that SPEEX RED audio codec is used in a conference call.</summary>
			ConnectorgoogleanalyticseventactionInCallCodecAudioSPEEXRED,
			/// <summary>This event includes all the above mentioned events.</summary>
			ConnectorgoogleanalyticseventactionAll,
			/// <summary>Unknown event action.</summary>
			ConnectorgoogleanalyticseventactionUnknown
		}
		/// <summary>
		/// Represents the event category of google analytics service.
		/// </summary>
		public enum ConnectorGoogleAnalyticsEventCategory {
			/// <summary>The login event category.</summary>
			ConnectorgoogleanalyticseventcategoryLogin,
			/// <summary>The user type event category.</summary>
			ConnectorgoogleanalyticseventcategoryUserType,
			/// <summary>The join conference event category.</summary>
			ConnectorgoogleanalyticseventcategoryJoinConference,
			/// <summary>The conference end event category.</summary>
			ConnectorgoogleanalyticseventcategoryConferenceEnd,
			/// <summary>The in-call codec event category.</summary>
			ConnectorgoogleanalyticseventcategoryInCallCodec,
			/// <summary>Unknown event category.</summary>
			ConnectorgoogleanalyticseventcategoryNone
		}
		/// <summary>
		/// It identifies the class of in call event.
		/// </summary>
		public enum ConnectorInCallEventClass {
			/// <summary>It indicate event belongs to media transportation.</summary>
			ConnectorincalleventclassMediaTransport,
			/// <summary>It indicate event belongs to InCallCodec.</summary>
			ConnectorincalleventclassInCallCodec,
			/// <summary>It indicate event belongs to Dtls Encryption.</summary>
			ConnectorincalleventclassDtls,
			/// <summary>It indicate Unknown event.</summary>
			ConnectorincalleventclassUnKnown
		}
		/// <summary>
		/// It represents error code as call event.
		/// </summary>
		public enum ConnectorInCallEventCode {
			/// <summary>RTCP send fail.</summary>
			ConnectorincalleventcodeRTCPSendError,
			/// <summary>RTCP receive fail.</summary>
			ConnectorincalleventcodeRTCPReceiveError,
			/// <summary>RTP media packet send fail.</summary>
			ConnectorincalleventcodeRTPSendError,
			/// <summary>RTP media packet receive fail.</summary>
			ConnectorincalleventcodeRTPReceiveError,
			/// <summary>Event when encoder paused on low bandwidth condition.</summary>
			ConnectorincalleventcodeEncoderPausedOnLowBW,
			/// <summary>Event when encoder resumed after pause.</summary>
			ConnectorincalleventcodeEncoderResumed,
			/// <summary>Event when H264 video codec is used in a conference call.</summary>
			ConnectorincalleventcodeInCallCodecVideoH264,
			/// <summary>Event when H264-SVC video codec is used in a conference call.</summary>
			ConnectorincalleventcodeInCallCodecVideoH264SVC,
			/// <summary>Event when SPEEX RED audio codec is used in a conference call.</summary>
			ConnectorincalleventcodeInCallCodecAudioSPEEXRED,
			/// <summary>Event when there is an error encrypting srtp packet because DTLSSRTP session is not yet established.</summary>
			ConnectorincalleventcodeDtlsError,
			/// <summary>Unknown event code.</summary>
			ConnectorincalleventcodeUnKnown
		}
		/// <summary>
		/// Log levels of VidyoClient library.
		/// </summary>
		public enum ConnectorLogLevel {
			/// <summary>The production log mode.</summary>
			ConnectorloglevelPRODUCTION,
			/// <summary>The debug log mode.</summary>
			ConnectorloglevelDEBUG,
			/// <summary>The Invalid log level. This value should not be used when using VidyoConnectorSetLogLevel. It is used to indicate errors when VidyoConnectorGetLogLevel is used.</summary>
			ConnectorloglevelINVALID
		}
		/// <summary>
		/// Logger type of VidyoClient library.
		/// </summary>
		public enum ConnectorLoggerType {
			/// <summary>The console logger.</summary>
			ConnectorloggertypeCONSOLE,
			/// <summary>The file logger.</summary>
			ConnectorloggertypeFILE,
			/// <summary>The feedback logger.</summary>
			ConnectorloggertypeFEEDBACK,
			/// <summary>The http logger.</summary>
			ConnectorloggertypeHTTP
		}
		/// <summary>
		/// Operating modes of a VidyoConnector object.
		/// </summary>
		public enum ConnectorMode {
			/// <summary>The default operating mode.</summary>
			ConnectormodeDefault,
			/// <summary>Runs in the foreground.</summary>
			ConnectormodeForeground,
			/// <summary>Runs in the background.</summary>
			ConnectormodeBackground
		}
		/// <summary>
		/// This type indicates the action of moderation request.
		/// </summary>
		public enum ConnectorModerationActionType {
			/// <summary>Mute video or audio action.</summary>
			ConnectormoderationactiontypeMute,
			/// <summary>Unmute video or audio action.</summary>
			ConnectormoderationactiontypeUnmute,
			/// <summary>Start lecture mode action.</summary>
			ConnectormoderationactiontypeStartLectureMode,
			/// <summary>Stop lecture mode action.</summary>
			ConnectormoderationactiontypeStopLectureMode,
			/// <summary>Set presenter action.</summary>
			ConnectormoderationactiontypeSetPresenter,
			/// <summary>Remove presenter action.</summary>
			ConnectormoderationactiontypeRemovePresenter,
			/// <summary>Raise hand action.</summary>
			ConnectormoderationactiontypeRaiseHand,
			/// <summary>Unraise hand action.</summary>
			ConnectormoderationactiontypeUnraiseHand,
			/// <summary>Dismiss raised hand action.</summary>
			ConnectormoderationactiontypeDismissRaisedHand,
			/// <summary>Dismiss all raised hands action.</summary>
			ConnectormoderationactiontypeDismissAllRaisedHands,
			/// <summary>Set moderator pin.</summary>
			ConnectormoderationactiontypeSetModeratorPin,
			/// <summary>REmove moderator pin.</summary>
			ConnectormoderationactiontypeRemoveModeratorPin,
			/// <summary>Disconnect all participants.</summary>
			ConnectormoderationactiontypeDisconnectAll,
			/// <summary>Disconnect one participant.</summary>
			ConnectormoderationactiontypeDisconnectOne,
			/// <summary>Wrong action.</summary>
			ConnectormoderationactiontypeInvalid
		}
		/// <summary>
		/// This type indicates the result of moderation request.
		/// </summary>
		public enum ConnectorModerationResult {
			/// <summary>Request was successful.</summary>
			ConnectormoderationresultOK,
			/// <summary>The server did not respond in a reasonable amount of time for request.</summary>
			ConnectormoderationresultNoResponse,
			/// <summary>The user did not have permission for request.</summary>
			ConnectormoderationresultUnauthorized,
			/// <summary>The user is not owner of the room.</summary>
			ConnectormoderationresultNotOwnerOfRoom,
			/// <summary>Request is not acceptable.</summary>
			ConnectormoderationresultNotAcceptable,
			/// <summary>Request is not allowed.</summary>
			ConnectormoderationresultNotAllowed,
			/// <summary>Request has a conflict.</summary>
			ConnectormoderationresultConflict,
			/// <summary>Request parameter is invalid.</summary>
			ConnectormoderationresultInvalidInput,
			/// <summary>The request cannot completed at the current time because it is out of some resource.</summary>
			ConnectormoderationresultOutOfResources,
			/// <summary>Requested user is offline.</summary>
			ConnectormoderationresultUserIsOffline,
			/// <summary>Room is currently full.</summary>
			ConnectormoderationresultRoomFull,
			/// <summary>Request failed due to some miscellaneous problem with the request.</summary>
			ConnectormoderationresultMiscLocalError,
			/// <summary>The server is rejecting the request due to some miscellaneous problem of its own.</summary>
			ConnectormoderationresultMiscRemoteError
		}
		/// <summary>
		/// Lists available actions for next generation renderer library.
		/// </summary>
		public enum ConnectorNGRActionType {
			/// <summary>Sets the layout.</summary>
			ConnectorngractiontypeSetLayout,
			/// <summary>Sets the view size.</summary>
			ConnectorngractiontypeSetViewSize,
			/// <summary>Sets the visibility of debug information.</summary>
			ConnectorngractiontypeSetDebugInfoVisible,
			/// <summary>Sets the visibility of labels on renderer.</summary>
			ConnectorngractiontypeSetLabelVisible,
			/// <summary>Sets the visibility of audio meter on tiles.</summary>
			ConnectorngractiontypeSetAudioMeterVisible,
			/// <summary>Sets the background color.</summary>
			ConnectorngractiontypeSetBackgroundColor,
			/// <summary>Sets the density.</summary>
			ConnectorngractiontypeSetDensity,
			/// <summary>Sets the max remote participants.</summary>
			ConnectorngractiontypeSetMaxRemoteParticipants,
			/// <summary>Pin the participants.</summary>
			ConnectorngractiontypePinParticipant,
			/// <summary>Sets whether to show audio only tiles.</summary>
			ConnectorngractiontypeShowAudioTiles,
			/// <summary>Invalid action.</summary>
			ConnectorngractiontypeInvalid
		}
		/// <summary>
		/// Preferred audio codec to be set.
		/// </summary>
		public enum ConnectorPreferredAudioCodec {
			/// <summary>Preferred audio codec is OPUS RED.</summary>
			ConnectorpreferredaudiocodecOpusRed,
			/// <summary>Preferred audio codec is OPUS.</summary>
			ConnectorpreferredaudiocodecOpus,
			/// <summary>Preferred audio codec is SPEEX RED.</summary>
			ConnectorpreferredaudiocodecSpeexRed,
			/// <summary>Unknown preferred audio codec .</summary>
			ConnectorpreferredaudiocodecUnknown
		}
		/// <summary>
		/// VidyoConnector properties that can be set.
		/// </summary>
		public enum ConnectorProperty {
			/// <summary>Application name property.</summary>
			ConnectorpropertyApplicationName,
			/// <summary>Application version property.</summary>
			ConnectorpropertyApplicationVersion
		}
		/// <summary>
		/// Results of recording service requests.
		/// </summary>
		public enum ConnectorRecordingServiceResult {
			/// <summary>The request has succeeded.</summary>
			ConnectorrecordingserviceresultSuccess,
			/// <summary>One or more input arguments are invalid.</summary>
			ConnectorrecordingserviceresultInvalidArgument,
			/// <summary>Media support was disabled or there is an unknown fault on the portal.</summary>
			ConnectorrecordingserviceresultGeneralFailure,
			/// <summary>The seat license has expired.</summary>
			ConnectorrecordingserviceresultSeatLicenseExpired,
			/// <summary>The endpoint is not licensed.</summary>
			ConnectorrecordingserviceresultNotLicensed,
			/// <summary>There are no available resources of the portal or recording servers.</summary>
			ConnectorrecordingserviceresultResourceNotAvailable,
			/// <summary>Miscellaneous portal error occurred.</summary>
			ConnectorrecordingserviceresultControlMeetingFailure
		}
		/// <summary>
		/// Provide the status of recording.
		/// </summary>
		public enum ConnectorRecordingState {
			/// <summary>Recording is in stop state.</summary>
			ConnectorrecordingstateNotRecording,
			/// <summary>Recording is in pause state.</summary>
			ConnectorrecordingstateRecordingPaused,
			/// <summary>Recording is in start/resume state.</summary>
			ConnectorrecordingstateRecording
		}
		/// <summary>
		/// Provide the result of user search request.
		/// </summary>
		public enum ConnectorSearchResult {
			/// <summary>The user search concluded properly.</summary>
			ConnectorsearchresultOk,
			/// <summary>No record found for user search request.</summary>
			ConnectorsearchresultNoRecords,
			/// <summary>No response from server for user search request.</summary>
			ConnectorsearchresultNoResponse,
			/// <summary>Not able to search for some other miscellaneous local error.</summary>
			ConnectorsearchresultMiscLocalError,
			/// <summary>Not able to search for some other miscellaneous remote error.</summary>
			ConnectorsearchresultMiscRemoteError
		}
		/// <summary>
		/// States of a connection, mostly representing the progress of a connection attempt.
		/// </summary>
		public enum ConnectorState {
			/// <summary>Not ready to connect, no devices.</summary>
			ConnectorstateIdle,
			/// <summary>Ready to connect.</summary>
			ConnectorstateReady,
			/// <summary>Establishing a connection to the server.</summary>
			ConnectorstateEstablishingConnection,
			/// <summary>Finding a resource.</summary>
			ConnectorstateFindingResource,
			/// <summary>Connecting to a resource.</summary>
			ConnectorstateConnectingToResource,
			/// <summary>Enabling media.</summary>
			ConnectorstateEnablingMedia,
			/// <summary>Successfully connected.</summary>
			ConnectorstateConnected,
			/// <summary>Disconnecting.</summary>
			ConnectorstateDisconnecting,
			/// <summary>Disabling.</summary>
			ConnectorstateDisabling,
			/// <summary>VidyoConnector can't be used any more and must be destructed.</summary>
			ConnectorstateDead
		}
		/// <summary>
		/// An enumeration that represents the type of token.
		/// </summary>
		public enum ConnectorTokenType {
			/// <summary>Represents the associated token is a refresh token.</summary>
			ConnectortokentypeRefreshToken,
			/// <summary>Represents the associated token is a jwt token.</summary>
			ConnectortokentypeJwtToken,
			/// <summary>Represents the associated token is undefined.</summary>
			ConnectortokentypeUndefined
		}
		/// <summary>
		/// CPU tradeoff profile.
		/// </summary>
		public enum ConnectorTradeOffProfile {
			/// <summary>High CPU usage.</summary>
			ConnectortradeoffprofileHigh,
			/// <summary>Balanced CPU usage.</summary>
			ConnectortradeoffprofileMedium,
			/// <summary>Low CPU usage.</summary>
			ConnectortradeoffprofileLow
		}
		/// <summary>
		/// Styles of the composite renderer, which apply to its layout and behaviour.
		/// </summary>
		public enum ConnectorViewStyle {
			/// <summary>The default style.</summary>
			ConnectorviewstyleDefault,
			/// <summary>Participants are shown in sizes that best reflect their order of importance.</summary>
			ConnectorviewstyleTiles,
			/// <summary>Next generation renderer with grid layout.</summary>
			ConnectorviewstyleNGRGrid,
			/// <summary>Next generation renderer with speaker layout.</summary>
			ConnectorviewstyleNGRSpeaker
		}
		/// <summary>
		/// Provide the status of webcasting/broadcasting.
		/// </summary>
		public enum ConnectorWebcastingState {
			/// <summary>Room is not broadcast or webcasting is not going on.</summary>
			ConnectorwebcastingstateNotWebcasting,
			/// <summary>Room is being broadcast or webcasting is going on.</summary>
			ConnectorwebcastingstateWebcasting
		}
		public interface IConnect{

			void OnSuccess();
			void OnFailure(ConnectorFailReason reason);
			void OnDisconnected(ConnectorDisconnectReason reason);
		}
		public interface IGetActiveNetworkInterface{

			void OnGetActiveNetworkInterface(NetworkInterface signalingInterface, NetworkInterface mediaInterface);
		}
		public interface IGetAutoReconnectSetting{

			void OnGetAutoReconnectSetting(Boolean enableAutoReconnect, uint reconnectBackoff, uint maxReconnectAttempts);
		}
		public interface IGetCameraBackgroundEffect{

			void OnGetCameraBackgroundEffectInfo(ConnectorCameraEffectInfo effectInfo);
		}
		public interface IGetGoogleAnalyticsEventTable{

			void OnGetGoogleAnalyticsEventTable(List<ConnectorGoogleAnalyticsEventTable> eventTable);
		}
		public interface IGetGoogleAnalyticsOptions{

			void OnGetGoogleAnalyticsOptions(ConnectorGoogleAnalyticsOptions options);
		}
		public interface IGetRecordingServiceProfiles{

			void OnGetRecordingServiceProfiles(List<String> profiles, List<String> prefixes, ConnectorRecordingServiceResult result);
		}
		public interface IGetWhitelistedAudioDevices{

			void OnGetWhitelistedAudioDevices(List<String> audioDevices);
		}
		public interface IInviteParticipant{

			void OnInviteResult(String inviteeId, ConnectorModerationResult result);
		}
		public interface ILockRoom{

			void OnLockRoomResult(ConnectorModerationResult result);
		}
		public interface IPauseRecording{

			void OnRecordingServicePauseResult(ConnectorModerationResult result);
		}
		public interface IRaiseHand{

			void OnRaiseHandResponse(Participant.ParticipantHandState handState);
		}
		public interface IRegisterBotEventListener{

			void OnBotJoined(ConnectorBotInfo info);
			void OnBotLeft(ConnectorBotInfo info);
		}
		public interface IRegisterCameraEffectErrorListener{

			void OnCameraEffectError(ConnectorCameraEffectError error);
		}
		public interface IRegisterConferenceModeEventListener{

			void OnConferenceModeChanged(ConnectorConferenceMode mode);
		}
		public interface IRegisterConnectionPropertiesEventListener{

			void OnConnectionPropertiesChanged(ConnectorConnectionProperties connectionProperties);
		}
		public interface IRegisterErrorEventListener{

			void OnError(ConnectorErrorCode error, String apiName);
		}
		public interface IRegisterHostEventListener{

			void OnConferenceHostStatusChanged(Participant host, ConnectorConferenceHostState hostState);
		}
		public interface IRegisterInCallEventListener{

			void OnInCallEvents(ConnectorInCallEvent ev);
		}
		public interface IRegisterLectureModeEventListener{

			void OnPresenterChanged(Participant participant);
			void OnHandRaised(List<Participant> participant);
		}
		public interface IRegisterLocalCameraEventListener{

			void OnLocalCameraAdded(LocalCamera localCamera);
			void OnLocalCameraRemoved(LocalCamera localCamera);
			void OnLocalCameraSelected(LocalCamera localCamera);
			void OnLocalCameraStateUpdated(LocalCamera localCamera, Device.DeviceState state);
		}
		public interface IRegisterLocalCameraFrameListener{

			void OnLocalCameraFrame(LocalCamera localCamera, VideoFrame videoFrame);
		}
		public interface IRegisterLocalMicrophoneEnergyListener{

			void OnLocalMicrophoneEnergy(LocalMicrophone localMicrophone, int audioEnergy);
		}
		public interface IRegisterLocalMicrophoneEventListener{

			void OnLocalMicrophoneAdded(LocalMicrophone localMicrophone);
			void OnLocalMicrophoneRemoved(LocalMicrophone localMicrophone);
			void OnLocalMicrophoneSelected(LocalMicrophone localMicrophone);
			void OnLocalMicrophoneStateUpdated(LocalMicrophone localMicrophone, Device.DeviceState state);
		}
		public interface IRegisterLocalMicrophoneFrameListener{

			void OnLocalMicrophoneFrame(LocalMicrophone localMicrophone, AudioFrame audioFrame);
		}
		public interface IRegisterLocalMonitorEventListener{

			void OnLocalMonitorAdded(LocalMonitor localMonitor);
			void OnLocalMonitorRemoved(LocalMonitor localMonitor);
			void OnLocalMonitorSelected(LocalMonitor localMonitor);
			void OnLocalMonitorStateUpdated(LocalMonitor localMonitor, Device.DeviceState state);
		}
		public interface IRegisterLocalMonitorFrameListener{

			void OnLocalMonitorFrame(LocalMonitor localMonitor, VideoFrame videoFrame);
		}
		public interface IRegisterLocalSpeakerEventListener{

			void OnLocalSpeakerAdded(LocalSpeaker localSpeaker);
			void OnLocalSpeakerRemoved(LocalSpeaker localSpeaker);
			void OnLocalSpeakerSelected(LocalSpeaker localSpeaker);
			void OnLocalSpeakerStateUpdated(LocalSpeaker localSpeaker, Device.DeviceState state);
		}
		public interface IRegisterLocalWindowShareEventListener{

			void OnLocalWindowShareAdded(LocalWindowShare localWindowShare);
			void OnLocalWindowShareRemoved(LocalWindowShare localWindowShare);
			void OnLocalWindowShareSelected(LocalWindowShare localWindowShare);
			void OnLocalWindowShareStateUpdated(LocalWindowShare localWindowShare, Device.DeviceState state);
		}
		public interface IRegisterLocalWindowShareFrameListener{

			void OnLocalWindowShareFrame(LocalWindowShare localWindowShare, VideoFrame videoFrame);
		}
		public interface IRegisterLogEventListener{

			void OnLog(LogRecord logRecord);
		}
		public interface IRegisterMessageEventListener{

			void OnChatMessageReceived(Participant participant, ChatMessage chatMessage);
		}
		public interface IRegisterModerationCommandEventListener{

			void OnModerationCommandReceived(Device.DeviceType deviceType, Room.RoomModerationType moderationType, Boolean state);
		}
		public interface IRegisterModerationResultEventListener{

			void OnModerationResult(Participant participant, ConnectorModerationResult result, ConnectorModerationActionType action, String requestId);
		}
		public interface IRegisterNGRResultEventListener{

			void OnNGRResult(ConnectorNGRActionType type, Boolean success, String error);
		}
		public interface IRegisterNetworkInterfaceEventListener{

			void OnNetworkInterfaceAdded(NetworkInterface networkInterface);
			void OnNetworkInterfaceRemoved(NetworkInterface networkInterface);
			void OnNetworkInterfaceSelected(NetworkInterface networkInterface, NetworkInterface.NetworkInterfaceTransportType transportType);
			void OnNetworkInterfaceStateUpdated(NetworkInterface networkInterface, NetworkInterface.NetworkInterfaceState state);
		}
		public interface IRegisterParticipantEventListener{

			void OnParticipantJoined(Participant participant);
			void OnParticipantLeft(Participant participant);
			void OnDynamicParticipantChanged(List<Participant> participants);
			void OnLoudestParticipantChanged(Participant participant, Boolean audioOnly);
		}
		public interface IRegisterReconnectEventListener{

			void OnReconnecting(uint attempt, uint attemptTimeout, ConnectorFailReason reason);
			void OnReconnected();
			void OnConferenceLost(ConnectorFailReason reason);
		}
		public interface IRegisterRecorderInCallEventListener{

			void RecorderInCall(Boolean hasRecorder, Boolean isPaused);
		}
		public interface IRegisterRemoteCameraEventListener{

			void OnRemoteCameraAdded(RemoteCamera remoteCamera, Participant participant);
			void OnRemoteCameraRemoved(RemoteCamera remoteCamera, Participant participant);
			void OnRemoteCameraStateUpdated(RemoteCamera remoteCamera, Participant participant, Device.DeviceState state);
		}
		public interface IRegisterRemoteCameraFrameListener{

			void OnRemoteCameraFrame(RemoteCamera remoteCamera, Participant participant, VideoFrame videoFrame);
		}
		public interface IRegisterRemoteMicrophoneEnergyListener{

			void OnRemoteMicrophoneEnergy(RemoteMicrophone remoteMicrophone, Participant participant, int audioEnergy);
		}
		public interface IRegisterRemoteMicrophoneEventListener{

			void OnRemoteMicrophoneAdded(RemoteMicrophone remoteMicrophone, Participant participant);
			void OnRemoteMicrophoneRemoved(RemoteMicrophone remoteMicrophone, Participant participant);
			void OnRemoteMicrophoneStateUpdated(RemoteMicrophone remoteMicrophone, Participant participant, Device.DeviceState state);
		}
		public interface IRegisterRemoteMicrophoneFrameListener{

			void OnRemoteMicrophoneFrame(RemoteMicrophone remoteMicrophone, Participant participant, AudioFrame audioFrame);
		}
		public interface IRegisterRemoteRendererEventListener{

			void OnRemoteRendererAdded(RemoteRenderer remoteRenderer);
			void OnRemoteRendererRemoved(RemoteRenderer remoteRenderer);
			void OnRemoteRendererStateUpdated(RemoteRenderer remoteRenderer, Device.DeviceState state);
		}
		public interface IRegisterRemoteSpeakerEventListener{

			void OnRemoteSpeakerAdded(RemoteSpeaker remoteSpeaker);
			void OnRemoteSpeakerRemoved(RemoteSpeaker remoteSpeaker);
			void OnRemoteSpeakerStateUpdated(RemoteSpeaker remoteSpeaker, Device.DeviceState state);
		}
		public interface IRegisterRemoteWindowShareEventListener{

			void OnRemoteWindowShareAdded(RemoteWindowShare remoteWindowShare, Participant participant);
			void OnRemoteWindowShareRemoved(RemoteWindowShare remoteWindowShare, Participant participant);
			void OnRemoteWindowShareStateUpdated(RemoteWindowShare remoteWindowShare, Participant participant, Device.DeviceState state);
		}
		public interface IRegisterRemoteWindowShareFrameListener{

			void OnRemoteWindowShareFrame(RemoteWindowShare remoteWindowShare, Participant participant, VideoFrame videoFrame);
		}
		public interface IRegisterResourceManagerEventListener{

			void OnAvailableResourcesChanged(uint cpuEncode, uint cpuDecode, uint bandwidthSend, uint bandwidthReceive);
			void OnMaxRemoteSourcesChanged(uint maxRemoteSources);
		}
		public interface IRegisterTokenReceivedEventListener{

			void OnTokenReceived(List<ConnectorTokenInfo> tokenInfo);
		}
		public interface IRegisterVirtualAudioSourceEventListener{

			void OnVirtualAudioSourceAdded(VirtualAudioSource virtualAudioSource);
			void OnVirtualAudioSourceRemoved(VirtualAudioSource virtualAudioSource);
			void OnVirtualAudioSourceStateUpdated(VirtualAudioSource virtualAudioSource, Device.DeviceState state);
			void OnVirtualAudioSourceSelected(VirtualAudioSource virtualAudioSource);
			void OnVirtualAudioSourceExternalMediaBufferReleased(VirtualAudioSource virtualAudioSource, byte[] buffer, SizeT size);
		}
		public interface IRegisterVirtualVideoSourceEventListener{

			void OnVirtualVideoSourceAdded(VirtualVideoSource virtualVideoSource);
			void OnVirtualVideoSourceRemoved(VirtualVideoSource virtualVideoSource);
			void OnVirtualVideoSourceStateUpdated(VirtualVideoSource virtualVideoSource, Device.DeviceState state);
			void OnVirtualVideoSourceExternalMediaBufferReleased(VirtualVideoSource virtualVideoSource, byte[] buffer, SizeT size);
		}
		public interface IRegisterWebProxyEventListener{

			void OnWebProxyCredentialsRequest(String webProxyAddress);
		}
		public interface IRemoveModeratorRole{

			void OnRemoveModeratorRoleResult(ConnectorModerationResult result);
		}
		public interface IRemoveRoomPIN{

			void OnRemoveRoomPINResult(ConnectorModerationResult result);
		}
		public interface IRequestModeratorRole{

			void OnRequestModeratorRoleResult(ConnectorModerationResult result);
		}
		public interface IRequestVideoForRemoteCamera{

			void OnRemoteCameraFirstFrameReceived(RemoteCamera remoteCamera);
		}
		public interface IRequestVideoForRemoteWindowShare{

			void OnRemoteWindowShareFirstFrameReceived(RemoteWindowShare remoteWindowShare);
		}
		public interface IResumeRecording{

			void OnRecordingServiceResumeResult(ConnectorModerationResult result);
		}
		public interface ISearchUsers{

			void OnUserSearchResults(String searchText, uint startIndex, ConnectorSearchResult searchResult, List<ContactInfo> contacts, SizeT numRecords);
		}
		public interface ISetRoomPIN{

			void OnSetRoomPINResult(ConnectorModerationResult result);
		}
		public interface IStartRecording{

			void OnRecordingServiceStartResult(ConnectorModerationResult result);
		}
		public interface IStopRecording{

			void OnRecordingServiceStopResult(ConnectorModerationResult result);
		}
		public interface IUnlockRoom{

			void OnUnlockRoomResult(ConnectorModerationResult result);
		}
		public class ConnectorBotInfoFactory
		{
			public static ConnectorBotInfo Create()
			{
				return new ConnectorBotInfo(IntPtr.Zero);
			}
			public static void Destroy(ConnectorBotInfo obj)
			{
			}
		}
		/// <summary>
		/// Represents the bot info structure.
		/// </summary>
		public class ConnectorBotInfo {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoConnectorBotInfo reference.
			public IntPtr GetObjectPtr() {
				IntPtr nData = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(data ?? string.Empty);
				IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
				IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

				VidyoConnectorBotInfoSetdataNative(objPtr, nData);
				VidyoConnectorBotInfoSetidNative(objPtr, nId);
				VidyoConnectorBotInfoSetnameNative(objPtr, nName);

				Marshal.FreeHGlobal(nName);
				Marshal.FreeHGlobal(nId);
				Marshal.FreeHGlobal(nData);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoConnectorBotInfoGetdataNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoConnectorBotInfoSetdataNative(IntPtr obj, IntPtr data);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoConnectorBotInfoGetidNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoConnectorBotInfoSetidNative(IntPtr obj, IntPtr id);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoConnectorBotInfoGetnameNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoConnectorBotInfoSetnameNative(IntPtr obj, IntPtr name);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoConnectorBotInfoConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoConnectorBotInfoConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoConnectorBotInfoDestructNative(IntPtr obj);

			/// <summary>
			/// Represents the meta data associated with bot in json format string.
			/// </summary>
			public String data;
			/// <summary>
			/// Represents the id associated with bot.
			/// </summary>
			public String id;
			/// <summary>
			/// Represents the name associated with bot.
			/// </summary>
			public String name;
			public ConnectorBotInfo(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoConnectorBotInfoConstructDefaultNative();
				}
				else {
					objPtr = VidyoConnectorBotInfoConstructCopyNative(obj);
				}

				data = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorBotInfoGetdataNative(objPtr));
				id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorBotInfoGetidNative(objPtr));
				name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorBotInfoGetnameNative(objPtr));
			}
			~ConnectorBotInfo() {
				VidyoConnectorBotInfoDestructNative(objPtr);
			 }
		};
		private IConnect _mIConnect;
		private IGetActiveNetworkInterface _mIGetActiveNetworkInterface;
		private IGetAutoReconnectSetting _mIGetAutoReconnectSetting;
		private IGetCameraBackgroundEffect _mIGetCameraBackgroundEffect;
		private IGetGoogleAnalyticsEventTable _mIGetGoogleAnalyticsEventTable;
		private IGetGoogleAnalyticsOptions _mIGetGoogleAnalyticsOptions;
		private IGetRecordingServiceProfiles _mIGetRecordingServiceProfiles;
		private IGetWhitelistedAudioDevices _mIGetWhitelistedAudioDevices;
		private IInviteParticipant _mIInviteParticipant;
		private ILockRoom _mILockRoom;
		private IPauseRecording _mIPauseRecording;
		private IRaiseHand _mIRaiseHand;
		private IRegisterBotEventListener _mIRegisterBotEventListener;
		private IRegisterCameraEffectErrorListener _mIRegisterCameraEffectErrorListener;
		private IRegisterConferenceModeEventListener _mIRegisterConferenceModeEventListener;
		private IRegisterConnectionPropertiesEventListener _mIRegisterConnectionPropertiesEventListener;
		private IRegisterErrorEventListener _mIRegisterErrorEventListener;
		private IRegisterHostEventListener _mIRegisterHostEventListener;
		private IRegisterInCallEventListener _mIRegisterInCallEventListener;
		private IRegisterLectureModeEventListener _mIRegisterLectureModeEventListener;
		private IRegisterLocalCameraEventListener _mIRegisterLocalCameraEventListener;
		private IRegisterLocalCameraFrameListener _mIRegisterLocalCameraFrameListener;
		private IRegisterLocalMicrophoneEnergyListener _mIRegisterLocalMicrophoneEnergyListener;
		private IRegisterLocalMicrophoneEventListener _mIRegisterLocalMicrophoneEventListener;
		private IRegisterLocalMicrophoneFrameListener _mIRegisterLocalMicrophoneFrameListener;
		private IRegisterLocalMonitorEventListener _mIRegisterLocalMonitorEventListener;
		private IRegisterLocalMonitorFrameListener _mIRegisterLocalMonitorFrameListener;
		private IRegisterLocalSpeakerEventListener _mIRegisterLocalSpeakerEventListener;
		private IRegisterLocalWindowShareEventListener _mIRegisterLocalWindowShareEventListener;
		private IRegisterLocalWindowShareFrameListener _mIRegisterLocalWindowShareFrameListener;
		private IRegisterLogEventListener _mIRegisterLogEventListener;
		private IRegisterMessageEventListener _mIRegisterMessageEventListener;
		private IRegisterModerationCommandEventListener _mIRegisterModerationCommandEventListener;
		private IRegisterModerationResultEventListener _mIRegisterModerationResultEventListener;
		private IRegisterNGRResultEventListener _mIRegisterNGRResultEventListener;
		private IRegisterNetworkInterfaceEventListener _mIRegisterNetworkInterfaceEventListener;
		private IRegisterParticipantEventListener _mIRegisterParticipantEventListener;
		private IRegisterReconnectEventListener _mIRegisterReconnectEventListener;
		private IRegisterRecorderInCallEventListener _mIRegisterRecorderInCallEventListener;
		private IRegisterRemoteCameraEventListener _mIRegisterRemoteCameraEventListener;
		private IRegisterRemoteCameraFrameListener _mIRegisterRemoteCameraFrameListener;
		private IRegisterRemoteMicrophoneEnergyListener _mIRegisterRemoteMicrophoneEnergyListener;
		private IRegisterRemoteMicrophoneEventListener _mIRegisterRemoteMicrophoneEventListener;
		private IRegisterRemoteMicrophoneFrameListener _mIRegisterRemoteMicrophoneFrameListener;
		private IRegisterRemoteRendererEventListener _mIRegisterRemoteRendererEventListener;
		private IRegisterRemoteSpeakerEventListener _mIRegisterRemoteSpeakerEventListener;
		private IRegisterRemoteWindowShareEventListener _mIRegisterRemoteWindowShareEventListener;
		private IRegisterRemoteWindowShareFrameListener _mIRegisterRemoteWindowShareFrameListener;
		private IRegisterResourceManagerEventListener _mIRegisterResourceManagerEventListener;
		private IRegisterTokenReceivedEventListener _mIRegisterTokenReceivedEventListener;
		private IRegisterVirtualAudioSourceEventListener _mIRegisterVirtualAudioSourceEventListener;
		private IRegisterVirtualVideoSourceEventListener _mIRegisterVirtualVideoSourceEventListener;
		private IRegisterWebProxyEventListener _mIRegisterWebProxyEventListener;
		private IRemoveModeratorRole _mIRemoveModeratorRole;
		private IRemoveRoomPIN _mIRemoveRoomPIN;
		private IRequestModeratorRole _mIRequestModeratorRole;
		private IResumeRecording _mIResumeRecording;
		private ISearchUsers _mISearchUsers;
		private ISetRoomPIN _mISetRoomPIN;
		private IStartRecording _mIStartRecording;
		private IStopRecording _mIStopRecording;
		private IUnlockRoom _mIUnlockRoom;
		/// <summary>
		/// Constructs the VidyoConnector. On, iOS, this API must be called from main(UI) thread.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform-specific view ID where the VidyoConnector's rendering window will be added as a child window. It will be used to render the preview and composite remote participants. When running custom layout on macOS, the core animation layer should be disabled on this view.</param>
		/// <param name="viewStyle">Type of the composite renderer which represents the visual style and behaviour.</param>
		/// <param name="remoteParticipants">Number of remote participants to composite into the window. Setting the value to 0 (zero) will render the preview only.</param>
		/// <param name="logFileFilter"><p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p></param>
		/// <param name="logFileName">Full path to the file where the log should be stored; otherwise, NULL or empty string, in order to use the default OS-dependent writable path.</param>
		/// <param name="userData">Arbitrary user data that can be retrieved later.</param>
		public Connector(IntPtr viewId, ConnectorViewStyle viewStyle, uint remoteParticipants, String logFileFilter, String logFileName, ulong userData) {

			IntPtr nLogFileFilter = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(logFileFilter ?? string.Empty);
			IntPtr nLogFileName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(logFileName ?? string.Empty);
			objPtr = VidyoConnectorConstructNative(ref viewId, viewStyle, remoteParticipants, nLogFileFilter, nLogFileName, userData);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			Marshal.FreeHGlobal(nLogFileName);
			Marshal.FreeHGlobal(nLogFileFilter);
			VidyoConnectorSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
			VidyoConnectorRegisterParticipantEventListenerNative(objPtr, _mOnParticipantJoined, _mOnParticipantLeft, _mOnDynamicParticipantChanged, _mOnLoudestParticipantChanged);
			VidyoConnectorRegisterRemoteCameraEventListenerNative(objPtr, _mOnRemoteCameraAdded, _mOnRemoteCameraRemoved, _mOnRemoteCameraStateUpdated);
			VidyoConnectorRegisterRemoteMicrophoneEventListenerNative(objPtr, _mOnRemoteMicrophoneAdded, _mOnRemoteMicrophoneRemoved, _mOnRemoteMicrophoneStateUpdated);
			VidyoConnectorRegisterRemoteWindowShareEventListenerNative(objPtr, _mOnRemoteWindowShareAdded, _mOnRemoteWindowShareRemoved, _mOnRemoteWindowShareStateUpdated);
		}
		public Connector(IntPtr other){
			objPtr = VidyoConnectorConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoConnectorSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~Connector(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			DisposeWeakReferenceObjects();
			if(objPtr != IntPtr.Zero) {
				VidyoConnectorSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoConnectorDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// This is a synchronous interface. Adds audio device to whitelist. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="deviceName">The name of audio device that will be whitelisted.</param>
		public Boolean AddAudioDeviceToWhitelist(String deviceName) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nDeviceName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(deviceName ?? string.Empty);
			Boolean ret = VidyoConnectorAddAudioDeviceToWhitelistNative(objPtr, nDeviceName);
			Marshal.FreeHGlobal(nDeviceName);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Add message class that application should receive. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="messageClass">Name of message class. MSGCLASS_HUNTER is added by default so application will receive only these message class.</param>
		public Boolean AddMessageClass(String messageClass) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nMessageClass = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(messageClass ?? string.Empty);
			Boolean ret = VidyoConnectorAddMessageClassNative(objPtr, nMessageClass);
			Marshal.FreeHGlobal(nMessageClass);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. The Moderator can send a moderation request to approve a raised hand, in which case the participant whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="participant">Selected participant whose raised hand request is approved.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean ApproveRaisedHand(Participant participant, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorApproveRaisedHandNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Composites the preview and remote participants in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disconnecting. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID where the participant will be rendered.</param>
		/// <param name="viewStyle">Type of the composite renderer which represents the visual style and behaviour.</param>
		/// <param name="remoteParticipants">Number of remote participants to composite into the window. Setting the value to 0 will render preview only.</param>
		public Boolean AssignViewToCompositeRenderer(IntPtr viewId, ConnectorViewStyle viewStyle, uint remoteParticipants) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorAssignViewToCompositeRendererNative(objPtr, ref viewId, viewStyle, remoteParticipants);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Assigns the view in which to show the preview from a local camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID where the participant will be rendered.</param>
		/// <param name="localCamera">The VidyoLocalCamera that will be shown.</param>
		/// <param name="displayCropped">Render the image as cropped. Otherwise letterbox.</param>
		/// <param name="allowZoom">Allow zooming of the image with mouse or touch.</param>
		public Boolean AssignViewToLocalCamera(IntPtr viewId, LocalCamera localCamera, Boolean displayCropped, Boolean allowZoom) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorAssignViewToLocalCameraNative(objPtr, ref viewId, (localCamera != null) ? localCamera.GetObjectPtr():IntPtr.Zero, displayCropped, allowZoom);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Shows a VidyoLocalMonitor in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID where the VidyoLocalMonitor will be rendered.</param>
		/// <param name="localMonitor">The VidyoLocalMonitor that will be shown.</param>
		/// <param name="displayCropped">Render the image as cropped. Otherwise letterbox.</param>
		/// <param name="allowZoom">Allow zooming of the image with mouse or touch.</param>
		public Boolean AssignViewToLocalMonitor(IntPtr viewId, LocalMonitor localMonitor, Boolean displayCropped, Boolean allowZoom) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorAssignViewToLocalMonitorNative(objPtr, ref viewId, (localMonitor != null) ? localMonitor.GetObjectPtr():IntPtr.Zero, displayCropped, allowZoom);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Shows a VidyoLocalWindowShare in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID where the VidyoLocalWindowShare will be rendered.</param>
		/// <param name="localWindowShare">The VidyoLocalWindowShare that will be shown.</param>
		/// <param name="displayCropped">Render the image as cropped. Otherwise letterbox.</param>
		/// <param name="allowZoom">Allow zooming of the image with mouse or touch.</param>
		public Boolean AssignViewToLocalWindowShare(IntPtr viewId, LocalWindowShare localWindowShare, Boolean displayCropped, Boolean allowZoom) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorAssignViewToLocalWindowShareNative(objPtr, ref viewId, (localWindowShare != null) ? localWindowShare.GetObjectPtr():IntPtr.Zero, displayCropped, allowZoom);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Assigns the view in which to show the remote camera of one of the other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID where the participant will be rendered.</param>
		/// <param name="remoteCamera">The VidyoRemoteCamera that will be shown.</param>
		/// <param name="displayCropped">Render the image as cropped. Otherwise letterbox.</param>
		/// <param name="allowZoom">Allow zooming of the image with mouse or touch.</param>
		public Boolean AssignViewToRemoteCamera(IntPtr viewId, RemoteCamera remoteCamera, Boolean displayCropped, Boolean allowZoom) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorAssignViewToRemoteCameraNative(objPtr, ref viewId, (remoteCamera != null) ? remoteCamera.GetObjectPtr():IntPtr.Zero, displayCropped, allowZoom);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Shows a VidyoRemoteWindowShare in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID where the VidyoRemoteWindowShare will be rendered.</param>
		/// <param name="remoteWindowShare">The VidyoRemoteWindowShare that will be shown.</param>
		/// <param name="displayCropped">Render the image as cropped. Otherwise letterbox.</param>
		/// <param name="allowZoom">Allow zooming of the image with mouse or touch.</param>
		public Boolean AssignViewToRemoteWindowShare(IntPtr viewId, RemoteWindowShare remoteWindowShare, Boolean displayCropped, Boolean allowZoom) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorAssignViewToRemoteWindowShareNative(objPtr, ref viewId, (remoteWindowShare != null) ? remoteWindowShare.GetObjectPtr():IntPtr.Zero, displayCropped, allowZoom);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Shows a VidyoVirtualVideoSource in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID where the VidyoVirtualVideoSource will be rendered.</param>
		/// <param name="virtualVideoSource">The VidyoVirtualVideoSource that will be shown.</param>
		/// <param name="displayCropped">Render the image as cropped. Otherwise letterbox.</param>
		/// <param name="allowZoom">Allow zooming of the image with mouse or touch.</param>
		public Boolean AssignViewToVirtualVideoSource(IntPtr viewId, VirtualVideoSource virtualVideoSource, Boolean displayCropped, Boolean allowZoom) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorAssignViewToVirtualVideoSourceNative(objPtr, ref viewId, (virtualVideoSource != null) ? virtualVideoSource.GetObjectPtr():IntPtr.Zero, displayCropped, allowZoom);

			return ret;
		}
		/// <summary>
		/// This is an synchronous interface. This API provides the ability to cancels invitation of a participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="contact">VidyoContactInfo object.</param>
		public Boolean CancelInviteParticipant(ContactInfo contact) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorCancelInviteParticipantNative(objPtr, (contact != null) ? contact.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Connects to a live conference with the specified resourceId. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="host">Host to which the connection will be made.</param>
		/// <param name="token">Token generated by the backend that contains the user ID and other metadata that will be used for authentication.</param>
		/// <param name="displayName">A display name that will be used in the UI.</param>
		/// <param name="resourceId">An alphanumeric string. This resourceId does not need to be pre-provisioned but in order to create a connection between multiple participants, the same resourceId has to be specified.</param>
		/// <param name="onSuccess">Callback that is triggered when the connection is successfully established.</param>
		/// <param name="onFailure">Callback that is triggered when the connection establishemnt failed.</param>
		/// <param name="onDisconnected">Callback that is triggered when an established connection is disconnected.</param>
		public Boolean Connect(String host, String token, String displayName, String resourceId, IConnect _iIConnect) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIConnect = _iIConnect;

			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(token ?? string.Empty);
			IntPtr nDisplayName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(displayName ?? string.Empty);
			IntPtr nResourceId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(resourceId ?? string.Empty);
			Boolean ret = VidyoConnectorConnectNative(objPtr, nHost, nToken, nDisplayName, nResourceId, _mOnSuccess, _mOnFailure, _mOnDisconnected);
			Marshal.FreeHGlobal(nResourceId);
			Marshal.FreeHGlobal(nDisplayName);
			Marshal.FreeHGlobal(nToken);
			Marshal.FreeHGlobal(nHost);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Connects to a live conference as guest with the specified room key on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="host">Host to which the connection will be made.</param>
		/// <param name="displayName">A display name that will be used in the UI.</param>
		/// <param name="roomKey">Room key.</param>
		/// <param name="roomPin">Room Pin / Password to enter the room.</param>
		/// <param name="onSuccess">Callback that is triggered when the connection is successfully established.</param>
		/// <param name="onFailure">Callback that is triggered when the connection establishemnt failed.</param>
		/// <param name="onDisconnected">Callback that is triggered when an established connection is disconnected.</param>
		public Boolean ConnectToRoomAsGuest(String host, String displayName, String roomKey, String roomPin, IConnect _iIConnect) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIConnect = _iIConnect;

			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nDisplayName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(displayName ?? string.Empty);
			IntPtr nRoomKey = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomKey ?? string.Empty);
			IntPtr nRoomPin = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomPin ?? string.Empty);
			Boolean ret = VidyoConnectorConnectToRoomAsGuestNative(objPtr, nHost, nDisplayName, nRoomKey, nRoomPin, _mOnSuccess, _mOnFailure, _mOnDisconnected);
			Marshal.FreeHGlobal(nRoomPin);
			Marshal.FreeHGlobal(nRoomKey);
			Marshal.FreeHGlobal(nDisplayName);
			Marshal.FreeHGlobal(nHost);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Connects to a live conference with the specified room ID on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="host">Host to which the connection will be made.</param>
		/// <param name="userName">User name.</param>
		/// <param name="password">Password.</param>
		/// <param name="roomId">Room ID.</param>
		/// <param name="roomPin">Room Pin/Password to enter the room.</param>
		/// <param name="onSuccess">Callback that is triggered when the connection is successfully established.</param>
		/// <param name="onFailure">Callback that is triggered when the connection establishemnt failed.</param>
		/// <param name="onDisconnected">Callback that is triggered when an established connection is disconnected.</param>
		public Boolean ConnectToRoomWithId(String host, String userName, String password, String roomId, String roomPin, IConnect _iIConnect) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIConnect = _iIConnect;

			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nUserName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userName ?? string.Empty);
			IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
			IntPtr nRoomId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomId ?? string.Empty);
			IntPtr nRoomPin = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomPin ?? string.Empty);
			Boolean ret = VidyoConnectorConnectToRoomWithIdNative(objPtr, nHost, nUserName, nPassword, nRoomId, nRoomPin, _mOnSuccess, _mOnFailure, _mOnDisconnected);
			Marshal.FreeHGlobal(nRoomPin);
			Marshal.FreeHGlobal(nRoomId);
			Marshal.FreeHGlobal(nPassword);
			Marshal.FreeHGlobal(nUserName);
			Marshal.FreeHGlobal(nHost);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Connects to a live conference with the specified room key on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="host">Host to which the connection will be made.</param>
		/// <param name="userName">User name.</param>
		/// <param name="password">Password.</param>
		/// <param name="roomKey">Room key.</param>
		/// <param name="roomPin">Room Pin/Password to enter the room.</param>
		/// <param name="onSuccess">Callback that is triggered when the connection is successfully established.</param>
		/// <param name="onFailure">Callback that is triggered when the connection establishemnt failed.</param>
		/// <param name="onDisconnected">Callback that is triggered when an established connection is disconnected.</param>
		public Boolean ConnectToRoomWithKey(String host, String userName, String password, String roomKey, String roomPin, IConnect _iIConnect) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIConnect = _iIConnect;

			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nUserName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userName ?? string.Empty);
			IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
			IntPtr nRoomKey = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomKey ?? string.Empty);
			IntPtr nRoomPin = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomPin ?? string.Empty);
			Boolean ret = VidyoConnectorConnectToRoomWithKeyNative(objPtr, nHost, nUserName, nPassword, nRoomKey, nRoomPin, _mOnSuccess, _mOnFailure, _mOnDisconnected);
			Marshal.FreeHGlobal(nRoomPin);
			Marshal.FreeHGlobal(nRoomKey);
			Marshal.FreeHGlobal(nPassword);
			Marshal.FreeHGlobal(nUserName);
			Marshal.FreeHGlobal(nHost);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Connects to a live conference with the specified room ID on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="host">Host to which the connection will be made.</param>
		/// <param name="userName">User name.</param>
		/// <param name="token">Access Token.</param>
		/// <param name="roomId">Room ID.</param>
		/// <param name="roomPin">Room Pin/Password to enter the room.</param>
		/// <param name="onSuccess">Callback that is triggered when the connection is successfully established.</param>
		/// <param name="onFailure">Callback that is triggered when the connection establishemnt failed.</param>
		/// <param name="onDisconnected">Callback that is triggered when an established connection is disconnected.</param>
		public Boolean ConnectToRoomWithTokenAndId(String host, String userName, String token, String roomId, String roomPin, IConnect _iIConnect) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIConnect = _iIConnect;

			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nUserName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userName ?? string.Empty);
			IntPtr nToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(token ?? string.Empty);
			IntPtr nRoomId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomId ?? string.Empty);
			IntPtr nRoomPin = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomPin ?? string.Empty);
			Boolean ret = VidyoConnectorConnectToRoomWithTokenAndIdNative(objPtr, nHost, nUserName, nToken, nRoomId, nRoomPin, _mOnSuccess, _mOnFailure, _mOnDisconnected);
			Marshal.FreeHGlobal(nRoomPin);
			Marshal.FreeHGlobal(nRoomId);
			Marshal.FreeHGlobal(nToken);
			Marshal.FreeHGlobal(nUserName);
			Marshal.FreeHGlobal(nHost);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Connects to a live conference with the specified room key. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="host">Host to which the connection will be made.</param>
		/// <param name="userName">User name.</param>
		/// <param name="token">Access Token.</param>
		/// <param name="roomKey">Room Key.</param>
		/// <param name="roomPin">Room Pin/Password used to enter the room.</param>
		/// <param name="onSuccess">Callback that is triggered when the connection is successfully established.</param>
		/// <param name="onFailure">Callback that is triggered when the connection establishemnt failed.</param>
		/// <param name="onDisconnected">Callback that is triggered when an established connection is disconnected.</param>
		public Boolean ConnectToRoomWithTokenAndKey(String host, String userName, String token, String roomKey, String roomPin, IConnect _iIConnect) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIConnect = _iIConnect;

			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nUserName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userName ?? string.Empty);
			IntPtr nToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(token ?? string.Empty);
			IntPtr nRoomKey = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomKey ?? string.Empty);
			IntPtr nRoomPin = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomPin ?? string.Empty);
			Boolean ret = VidyoConnectorConnectToRoomWithTokenAndKeyNative(objPtr, nHost, nUserName, nToken, nRoomKey, nRoomPin, _mOnSuccess, _mOnFailure, _mOnDisconnected);
			Marshal.FreeHGlobal(nRoomPin);
			Marshal.FreeHGlobal(nRoomKey);
			Marshal.FreeHGlobal(nToken);
			Marshal.FreeHGlobal(nUserName);
			Marshal.FreeHGlobal(nHost);

			return ret;
		}
		/// <summary>
		/// Create virtual audio source. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceAdded will trigger.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="name">The name for the virtual audio source.</param>
		/// <param name="id">The id for the virtual audio source.</param>
		/// <param name="configuration">The string in JSON format that contain audio configuration that will be used for virtual audio source. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p></param>
		public Boolean CreateVirtualAudioSource(String name, String id, String configuration) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nConfiguration = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(configuration ?? string.Empty);
			Boolean ret = VidyoConnectorCreateVirtualAudioSourceNative(objPtr, nName, nId, nConfiguration);
			Marshal.FreeHGlobal(nConfiguration);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nName);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Create virtual video source. The user can create a maximum of 10 virtual video sources. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="type">Type of the virtual video source.</param>
		/// <param name="id">Unique ID.</param>
		/// <param name="name">Name of the virtual video source.</param>
		public Boolean CreateVirtualVideoSource(Endpoint.VirtualVideoSourceType type, String id, String name) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			Boolean ret = VidyoConnectorCreateVirtualVideoSourceNative(objPtr, type, nId, nName);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Cycles camera selection to the next available camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean CycleCamera() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorCycleCameraNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Cycles microphone selection to the next available microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean CycleMicrophone() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorCycleMicrophoneNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Cycles speaker selection to the next available speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean CycleSpeaker() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorCycleSpeakerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Destroy virtual audio source. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceRemoved will trigger.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualAudioSource">The virtual audio source that will be destroyed.</param>
		public Boolean DestroyVirtualAudioSource(VirtualAudioSource virtualAudioSource) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorDestroyVirtualAudioSourceNative(objPtr, (virtualAudioSource != null) ? virtualAudioSource.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Destroy virtual video source. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualVideoSource">The virtual video source that will be destroyed.</param>
		public Boolean DestroyVirtualVideoSource(VirtualVideoSource virtualVideoSource) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorDestroyVirtualVideoSourceNative(objPtr, (virtualVideoSource != null) ? virtualVideoSource.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Disables connector object, releases all devices as precursor to destruct. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disconnecting. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean Disable() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorDisableNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set disable audio state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="disable">Set to LMI_TRUE to stop all participants' audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableAudioForAll(Boolean disable, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableAudioForAllNative(objPtr, disable, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set disable audio state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="participant">VidyoParticipant Object whose audio is revoked/resumed.</param>
		/// <param name="disable">Set to LMI_TRUE to stop the participant's audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableAudioForParticipant(Participant participant, Boolean disable, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableAudioForParticipantNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, disable, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set disable audio silence state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableAudioSilenceForAll(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableAudioSilenceForAllNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set disable audio silence state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="participant">VidyoParticipant object whose audio is revoked/resumed.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableAudioSilenceForParticipant(Participant participant, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableAudioSilenceForParticipantNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Disable debug mode. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean DisableDebug() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorDisableDebugNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set video disable state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="disable">Set to LMI_TRUE to stop all participants' video. Video cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableVideoForAll(Boolean disable, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableVideoForAllNative(objPtr, disable, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set video disable state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="participant">VidyoParticipant object whose audio is revoked/resumed.</param>
		/// <param name="disable">Set to LMI_TRUE to stop the participant's video. Video cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableVideoForParticipant(Participant participant, Boolean disable, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableVideoForParticipantNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, disable, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set disable video silence state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableVideoSilenceForAll(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableVideoSilenceForAllNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set disable video silence state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="participant">VidyoParticipant Object whose video is revoked/resumed.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DisableVideoSilenceForParticipant(Participant participant, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDisableVideoSilenceForParticipantNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Disconnects a live conference. The onDisconnected callback will be called on successful execution. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean Disconnect() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorDisconnectNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. The Moderator or the Presenter can send a moderation request to reject all hands raised, in which case all participants whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DismissAllRaisedHands(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorDismissAllRaisedHandsNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. The Moderator or the Presenter can send a moderation request to decline a raised hands, in which case the participant whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="participants">List of selected participants whose raised hand request is going to dismiss.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DismissRaisedHand(List<Participant> participants, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nListParticipants = VidyoConnectorVectorVidyoParticipantAllocateNative();

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			IntPtr nParticipants = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * participants.Count);
			int nParticipantsSize = 0;
			foreach (Participant iter in participants) {
				Marshal.WriteIntPtr(nParticipants + (nParticipantsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nParticipantsSize++;
			}
			VidyoConnectorDismissRaisedHandSetparticipantsArrayNative(nListParticipants, nParticipants, nParticipantsSize);
			Marshal.FreeHGlobal(nParticipants);
			Boolean ret = VidyoConnectorDismissRaisedHandNative(objPtr, nListParticipants, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			VidyoConnectorVectorVidyoParticipantDeallocateNative(nListParticipants);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Drop all participant out of a room, including the moderator used this API. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="reason">A message explaining the reason for the dropping. This can be NULL if no message is desired.</param>
		public Boolean DropAllParticipants(String reason) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nReason = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(reason ?? string.Empty);
			Boolean ret = VidyoConnectorDropAllParticipantsNative(objPtr, nReason);
			Marshal.FreeHGlobal(nReason);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Drop one participant out of a room. Application needs to register VidyoConnectorRegisterModerationResultEventListener to get the result. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="participant">VidyoParticipant Object.</param>
		/// <param name="reason">A message explaining the reason for the booting. This can be NULL if no message is desired.</param>
		public Boolean DropParticipant(Participant participant, String reason) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nReason = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(reason ?? string.Empty);
			Boolean ret = VidyoConnectorDropParticipantNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nReason);
			Marshal.FreeHGlobal(nReason);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enabled debug mode which will start debug logging and enable statistics. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="port">Local listening port for debugging.</param>
		/// <param name="logFilter">Log filter to use on the debug port. Default log filter will be use if null or empty string is passed. <p>Example: warning debug@VidyoClient debug@VidyoConnector all@LmiPortalSession all@LmiPortalMembership debug@LmiResourceManager all@LmiIce all@LmiSignaling.</p></param>
		public Boolean EnableDebug(uint port, String logFilter) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nLogFilter = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(logFilter ?? string.Empty);
			Boolean ret = VidyoConnectorEnableDebugNative(objPtr, port, nLogFilter);
			Marshal.FreeHGlobal(nLogFilter);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Get the NetworkInterface for media and signaling. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onGetActiveNetworkInterfaceCallback">Callback called upon completion.</param>
		public Boolean GetActiveNetworkInterface(IGetActiveNetworkInterface _iIGetActiveNetworkInterface) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetActiveNetworkInterface = _iIGetActiveNetworkInterface;

			Boolean ret = VidyoConnectorGetActiveNetworkInterfaceNative(objPtr, _mOnGetActiveNetworkInterface);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets audio bitrate multiplier which is used when calculating the audio bitrate. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public int GetAudioBitrateMultiplier() {
			if (objPtr == IntPtr.Zero) { return default; }

			int ret = VidyoConnectorGetAudioBitrateMultiplierNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets the audio mode for both the audio devices (speaker and microphone). This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORAUDIOMODE_Unknown.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public ConnectorAudioMode GetAudioMode() {
			if (objPtr == IntPtr.Zero) { return default; }

			ConnectorAudioMode ret = VidyoConnectorGetAudioModeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets time interval between two packet of audio in miliseconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public int GetAudioPacketInterval() {
			if (objPtr == IntPtr.Zero) { return default; }

			int ret = VidyoConnectorGetAudioPacketIntervalNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets audio loss percantage - value that is used to configure encoder. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public int GetAudioPacketLossPercentage() {
			if (objPtr == IntPtr.Zero) { return default; }

			int ret = VidyoConnectorGetAudioPacketLossPercentageNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets state of auto-reconnect. It's either enabled or disabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean GetAutoReconnect() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorGetAutoReconnectNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets back off for next reconnect attempt. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetAutoReconnectAttemptBackOff() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetAutoReconnectAttemptBackOffNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets maximum attempts to be done for reconnecting. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetAutoReconnectMaxAttempts() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetAutoReconnectMaxAttemptsNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Gets the auto-reconnect settings. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onGetAutoReconnectSettingCallback">Callback called upon completion.</param>
		public Boolean GetAutoReconnectSetting(IGetAutoReconnectSetting _iIGetAutoReconnectSetting) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetAutoReconnectSetting = _iIGetAutoReconnectSetting;

			Boolean ret = VidyoConnectorGetAutoReconnectSettingNative(objPtr, _mOnGetAutoReconnectSetting);

			return ret;
		}
		/// <summary>
		/// This is a asynchronous interface. Gets the current configuration of camera background effect. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onGetEffectInfo">Callback that reports the current configuration of camera background effect to the application. In case some error occurs NULL will be reported.</param>
		public Boolean GetCameraBackgroundEffect(IGetCameraBackgroundEffect _iIGetCameraBackgroundEffect) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetCameraBackgroundEffect = _iIGetCameraBackgroundEffect;

			Boolean ret = VidyoConnectorGetCameraBackgroundEffectNative(objPtr, _mOnGetCameraBackgroundEffectInfo);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets conference number - a special identifier that is showed up in the Portal CDR record for the conference. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and empty string returned.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public String GetConferenceNumber() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoConnectorGetConferenceNumberNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// This is a synchronous interface. Get current CPU tradeoff profile setting. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public ConnectorTradeOffProfile GetCpuTradeOffProfile() {
			if (objPtr == IntPtr.Zero) { return default; }

			ConnectorTradeOffProfile ret = VidyoConnectorGetCpuTradeOffProfileNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets state of video on low bandwidth. It's either enabled or disabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean GetDisableVideoOnLowBandwidth() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorGetDisableVideoOnLowBandwidthNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets number of audio streams requested while video is shut off. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetDisableVideoOnLowBandwidthAudioStreams() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetDisableVideoOnLowBandwidthAudioStreamsNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets time it takes to recover when video is shut off. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetDisableVideoOnLowBandwidthRecoveryTime() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetDisableVideoOnLowBandwidthRecoveryTimeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets time it takes to shut off video due to low bandwidth. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetDisableVideoOnLowBandwidthResponseTime() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetDisableVideoOnLowBandwidthResponseTimeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets how often checking for low bandwidth happens. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetDisableVideoOnLowBandwidthSampleTime() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetDisableVideoOnLowBandwidthSampleTimeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets low bandwidth threshold. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetDisableVideoOnLowBandwidthThreshold() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetDisableVideoOnLowBandwidthThresholdNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Get the analytics event table. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onGetGoogleAnalyticsEventTable">Callback called upon completion.</param>
		public Boolean GetGoogleAnalyticsEventTable(IGetGoogleAnalyticsEventTable _iIGetGoogleAnalyticsEventTable) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetGoogleAnalyticsEventTable = _iIGetGoogleAnalyticsEventTable;

			Boolean ret = VidyoConnectorGetGoogleAnalyticsEventTableNative(objPtr, _mOnGetGoogleAnalyticsEventTable);

			return ret;
		}
		/// <summary>
		/// This is a asynchronous interface. It returns google analytics configured options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onGetGoogleAnalyticsOptions">Callback called upon completion.</param>
		public Boolean GetGoogleAnalyticsOptions(IGetGoogleAnalyticsOptions _iIGetGoogleAnalyticsOptions) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetGoogleAnalyticsOptions = _iIGetGoogleAnalyticsOptions;

			Boolean ret = VidyoConnectorGetGoogleAnalyticsOptionsNative(objPtr, _mOnGetGoogleAnalyticsOptions);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. It returns Insights Url if service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public String GetInsightsServiceUrl() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoConnectorGetInsightsServiceUrlNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// This is a synchronous interface. Allow application to get log level i.e production or debug. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORLOGLEVEL_INVALID.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="loggerType">logger type ( console, file, feedback, http).</param>
		public ConnectorLogLevel GetLogLevel(ConnectorLoggerType loggerType) {
			if (objPtr == IntPtr.Zero) { return default; }

			ConnectorLogLevel ret = VidyoConnectorGetLogLevelNative(objPtr, loggerType);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Return the max receive bit rate configured by application. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetMaxReceiveBitRate() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetMaxReceiveBitRateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Return the max send bit rate configured by application. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public uint GetMaxSendBitRate() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoConnectorGetMaxSendBitRateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets maximum microphone boost level that is applied only in the conference for the selected microphone in case the system is set to the higher value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public double GetMicrophoneMaxBoostLevel() {
			if (objPtr == IntPtr.Zero) { return default; }

			double ret = VidyoConnectorGetMicrophoneMaxBoostLevelNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets minimum microphone value that is applied only in the conference for the selected microphone in case the system is set to the lower value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public short GetMinMicrophoneVolume() {
			if (objPtr == IntPtr.Zero) { return default; }

			short ret = VidyoConnectorGetMinMicrophoneVolumeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Retrieves VidyoConnector options in JSON format. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public String GetOptions() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoConnectorGetOptionsNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// This is a synchronous interface. Gets preferred audio codec name. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORPREFERREDAUDIOCODEC_Unknown.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public ConnectorPreferredAudioCodec GetPreferredAudioCodec() {
			if (objPtr == IntPtr.Zero) { return default; }

			ConnectorPreferredAudioCodec ret = VidyoConnectorGetPreferredAudioCodecNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Asynchronously retrieves a vector of available recording profiles. Each element of this vector is a LmiString that contains a description of a recording profile as provided by the active recording server. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE. For example, STANDARD-QUALITY, HIGH-QUALITY, VOICE-ONLY. Calls a callback upon completion.
		/// </summary>
		/// <param name="c">Pointer to the VidyoConnector object.</param>
		/// <param name="onGetRecordingProfilesCallback">Callback called upon completion.</param>
		public Boolean GetRecordingServiceProfiles(IGetRecordingServiceProfiles _iIGetRecordingServiceProfiles) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetRecordingServiceProfiles = _iIGetRecordingServiceProfiles;

			Boolean ret = VidyoConnectorGetRecordingServiceProfilesNative(objPtr, _mOnGetRecordingServiceProfiles);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Get the local renderer and conference tiles displaying options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform-specific view ID.</param>
		public String GetRendererOptionsForViewId(IntPtr viewId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoConnectorGetRendererOptionsForViewIdNative(objPtr, ref viewId);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// This is a synchronous interface. Retrieves the state of the VidyoConnector.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public ConnectorState GetState() {
			if (objPtr == IntPtr.Zero) { return default; }

			ConnectorState ret = VidyoConnectorGetStateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets whether SVC is enabled. The default is false. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean GetStaticShareSvcState() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorGetStaticShareSvcStateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Gets conference room statistics gather interval in seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public int GetStatisticRate() {
			if (objPtr == IntPtr.Zero) { return default; }

			int ret = VidyoConnectorGetStatisticRateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Retrieves VidyoConnector statistics in JSON format. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public String GetStatsJson() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoConnectorGetStatsJsonNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// This is a synchronous interface. Retrieves version of the VidyoConnector library.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public String GetVersion() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoConnectorGetVersionNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// This is a synchronous interface. Retrieves version of the VidyoConnector library wihtout the build number.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public String GetVersionWithoutBuildNumber() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoConnectorGetVersionWithoutBuildNumberNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// This is an asynchronous interface. Gets the names of the audio devices that are whitelisted. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onGetCallback">Callback that will report an array with the names of audio devices that are whitelisted.</param>
		public Boolean GetWhitelistedAudioDevices(IGetWhitelistedAudioDevices _iIGetWhitelistedAudioDevices) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetWhitelistedAudioDevices = _iIGetWhitelistedAudioDevices;

			Boolean ret = VidyoConnectorGetWhitelistedAudioDevicesNative(objPtr, _mOnGetWhitelistedAudioDevices);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Control type of event action and categories of google analytics. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="eventCategory">Type of event category. refer VidyoConnectorGoogleAnalyticsEventCategory.</param>
		/// <param name="eventAction">Type of event action. refer VidyoConnectorGoogleAnalyticsEventAction.</param>
		/// <param name="enable">Event action state flag.</param>
		public Boolean GoogleAnalyticsControlEventAction(ConnectorGoogleAnalyticsEventCategory eventCategory, ConnectorGoogleAnalyticsEventAction eventAction, Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorGoogleAnalyticsControlEventActionNative(objPtr, eventCategory, eventAction, enable);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Hides a view which is used for custom layout of sources. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">The view ID of the view to hide.</param>
		public Boolean HideView(IntPtr viewId) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorHideViewNative(objPtr, ref viewId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Notify the events as a part of analytics service. The event data will be sent to Loki analytics server if analytics service is started with VIDYO_CONNECTORANALYTICSSERVICETYPE_VidyoInsights. Event is automatically timestamped. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="eventName">Event name.</param>
		/// <param name="parameters">Pointer to string vector event parameters. Can be NULL if no parameters are needed.</param>
		public Boolean InsightsNotifyEvent(String eventName, List<String> parameters) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nEventName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(eventName ?? string.Empty);
			IntPtr nListParameters = VidyoConnectorVectorLmiStringAllocateNative();

			IntPtr nParameters = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * parameters.Count);
			int nParametersSize = 0;
			foreach (String iter in parameters) {
				Marshal.WriteIntPtr(nParameters + (nParametersSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nParametersSize++;
			}
			VidyoConnectorInsightsNotifyEventSetparametersArrayNative(nListParameters, nParameters, nParametersSize);
			Marshal.FreeHGlobal(nParameters);
			Boolean ret = VidyoConnectorInsightsNotifyEventNative(objPtr, nEventName, nListParameters);
			VidyoConnectorVectorLmiStringDeallocateNative(nListParameters);
			Marshal.FreeHGlobal(nEventName);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This API provides the ability to the room owner, admin or moderators to invite other users to join this room for conference. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="contact">VidyoContactInfo Object.</param>
		/// <param name="message">Invitation Message.</param>
		/// <param name="onInviteResult">Callback to be triggered for invitation result.</param>
		public Boolean InviteParticipant(ContactInfo contact, String message, IInviteParticipant _iIInviteParticipant) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIInviteParticipant = _iIInviteParticipant;

			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			Boolean ret = VidyoConnectorInviteParticipantNative(objPtr, (contact != null) ? contact.GetObjectPtr():IntPtr.Zero, nMessage, _mOnInviteResult);
			Marshal.FreeHGlobal(nMessage);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Checks whether Google Analytics service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean IsGoogleAnalyticsServiceEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorIsGoogleAnalyticsServiceEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Checks whether Insights service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean IsInsightsServiceEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorIsInsightsServiceEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This api provides the ability lock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="onLockRoomResult">Callback to be triggered for lock room result.</param>
		public Boolean LockRoom(ILockRoom _iILockRoom) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILockRoom = _iILockRoom;

			Boolean ret = VidyoConnectorLockRoomNative(objPtr, _mOnLockRoomResult);

			return ret;
		}
		/// <summary>
		/// Asynchronously pauses recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or already paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">Pointer to the VidyoConnector object.</param>
		/// <param name="onRecordingServicePauseResultCallback">Callback called upon completion.</param>
		public Boolean PauseRecording(IPauseRecording _iIPauseRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIPauseRecording = _iIPauseRecording;

			Boolean ret = VidyoConnectorPauseRecordingNative(objPtr, _mOnRecordingServicePauseResult);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Pin a participant's video. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="participant">A participant that will pinned/unpinned.</param>
		/// <param name="pin">LMI_TRUE to pin participant, LMI_FALSE to unpin.</param>
		public Boolean PinParticipant(Participant participant, Boolean pin) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorPinParticipantNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, pin);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Each participant can send a moderation request to raise their hand to request to be unmuted. The Moderator and Presenter will be notified.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="raiseHandResponse">Callback that is triggered each time when response of hand raise request.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RaiseHand(IRaiseHand _iIRaiseHand, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRaiseHand = _iIRaiseHand;

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorRaiseHandNative(objPtr, _mOnRaiseHandResponse, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Application can register a callback to get notified about bot participants. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onJoined">Callback that is triggered when bot participant joins a conference.</param>
		/// <param name="onLeft">Callback that is triggered when an existing bot participant leaves a conference.</param>
		public Boolean RegisterBotEventListener(IRegisterBotEventListener _iIRegisterBotEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterBotEventListener = _iIRegisterBotEventListener;

			Boolean ret = VidyoConnectorRegisterBotEventListenerNative(objPtr, _mOnBotJoined, _mOnBotLeft);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers callback to notify the user in case of any errors occur during enabling camera effect.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onError">The callback that will reports camera effect errors.</param>
		public Boolean RegisterCameraEffectErrorListener(IRegisterCameraEffectErrorListener _iIRegisterCameraEffectErrorListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterCameraEffectErrorListener = _iIRegisterCameraEffectErrorListener;

			Boolean ret = VidyoConnectorRegisterCameraEffectErrorListenerNative(objPtr, _mOnCameraEffectError);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers the conference mode event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="conferenceModeChanged">The VidyoConnectorOnConferenceModeChanged status as lecture,lobby or group.</param>
		public Boolean RegisterConferenceModeEventListener(IRegisterConferenceModeEventListener _iIRegisterConferenceModeEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterConferenceModeEventListener = _iIRegisterConferenceModeEventListener;

			Boolean ret = VidyoConnectorRegisterConferenceModeEventListenerNative(objPtr, _mOnConferenceModeChanged);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified when a connection properties is changed. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onConnectionPropertiesChanged">Callback that is triggered when a connection properties is changed.</param>
		public Boolean RegisterConnectionPropertiesEventListener(IRegisterConnectionPropertiesEventListener _iIRegisterConnectionPropertiesEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterConnectionPropertiesEventListener = _iIRegisterConnectionPropertiesEventListener;

			Boolean ret = VidyoConnectorRegisterConnectionPropertiesEventListenerNative(objPtr, _mOnConnectionPropertiesChanged);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers the advanced error event listeners.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onErrorCallback">Callback that is triggered when an error occurs.</param>
		public Boolean RegisterErrorEventListener(IRegisterErrorEventListener _iIRegisterErrorEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterErrorEventListener = _iIRegisterErrorEventListener;

			Boolean ret = VidyoConnectorRegisterErrorEventListenerNative(objPtr, _mOnError);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers the host event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="hostStatus">The VidyoConnectorOnConferenceHostStatusChanged status i..e host joined or left</param>
		public Boolean RegisterHostEventListener(IRegisterHostEventListener _iIRegisterHostEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterHostEventListener = _iIRegisterHostEventListener;

			Boolean ret = VidyoConnectorRegisterHostEventListenerNative(objPtr, _mOnConferenceHostStatusChanged);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the callback which will be triggered during a conference, these events may not stop the conferece but may degrade quality of call. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="cb">The callback which will be triggered when error occur in conference.</param>
		public Boolean RegisterInCallEventListener(IRegisterInCallEventListener _iIRegisterInCallEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterInCallEventListener = _iIRegisterInCallEventListener;

			Boolean ret = VidyoConnectorRegisterInCallEventListenerNative(objPtr, _mOnInCallEvents);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers the Lecture mode feature callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="presenterChanged">Callback that is triggered when presenter changed.</param>
		/// <param name="handRaised">Callback that is triggered for Moderator when some hand raised.</param>
		public Boolean RegisterLectureModeEventListener(IRegisterLectureModeEventListener _iIRegisterLectureModeEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLectureModeEventListener = _iIRegisterLectureModeEventListener;

			Boolean ret = VidyoConnectorRegisterLectureModeEventListenerNative(objPtr, _mOnPresenterChanged, _mOnHandRaised);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about local camera events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered for every new or existing camera added.</param>
		/// <param name="onRemoved">Callback that is triggered when the camera is removed.</param>
		/// <param name="onSelected">Callback that is triggered when a camera is selected for use.</param>
		/// <param name="onStateUpdated">Callback that is triggered when a camera state is updated.</param>
		public Boolean RegisterLocalCameraEventListener(IRegisterLocalCameraEventListener _iIRegisterLocalCameraEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalCameraEventListener = _iIRegisterLocalCameraEventListener;

			Boolean ret = VidyoConnectorRegisterLocalCameraEventListenerNative(objPtr, _mOnLocalCameraAdded, _mOnLocalCameraRemoved, _mOnLocalCameraSelected, _mOnLocalCameraStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about camera frames. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onFrame">Callback that is triggered for every frame from a remote camera.</param>
		/// <param name="localCamera">The VidyoLocalCamera for which to receive the frames.</param>
		/// <param name="width">Approximate width of the requested frame.</param>
		/// <param name="height">Approximate height of the requested frame.</param>
		/// <param name="frameInterval">Approximate frame interval of the requested frame.</param>
		public Boolean RegisterLocalCameraFrameListener(IRegisterLocalCameraFrameListener _iIRegisterLocalCameraFrameListener, LocalCamera localCamera, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalCameraFrameListener = _iIRegisterLocalCameraFrameListener;

			Boolean ret = VidyoConnectorRegisterLocalCameraFrameListenerNative(objPtr, _mOnLocalCameraFrame, (localCamera != null) ? localCamera.GetObjectPtr():IntPtr.Zero, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about microphone energies. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onEnergy">Callback that is triggered for every frame from a microphone that has energy.</param>
		public Boolean RegisterLocalMicrophoneEnergyListener(IRegisterLocalMicrophoneEnergyListener _iIRegisterLocalMicrophoneEnergyListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalMicrophoneEnergyListener = _iIRegisterLocalMicrophoneEnergyListener;

			Boolean ret = VidyoConnectorRegisterLocalMicrophoneEnergyListenerNative(objPtr, _mOnLocalMicrophoneEnergy);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about local microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered for every new or existing microphone added.</param>
		/// <param name="onRemoved">Callback that is triggered when the microphone is removed.</param>
		/// <param name="onSelected">Callback that is triggered when a microphone is selected for use.</param>
		/// <param name="onStateUpdated">Callback that is triggered when a microphone state is updated.</param>
		public Boolean RegisterLocalMicrophoneEventListener(IRegisterLocalMicrophoneEventListener _iIRegisterLocalMicrophoneEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalMicrophoneEventListener = _iIRegisterLocalMicrophoneEventListener;

			Boolean ret = VidyoConnectorRegisterLocalMicrophoneEventListenerNative(objPtr, _mOnLocalMicrophoneAdded, _mOnLocalMicrophoneRemoved, _mOnLocalMicrophoneSelected, _mOnLocalMicrophoneStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about microphone frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onFrame">Callback that is triggered for every frame from a microphone.</param>
		/// <param name="localMicrophone">The VidyoLocalMicrophone for which to receive the frames.</param>
		public Boolean RegisterLocalMicrophoneFrameListener(IRegisterLocalMicrophoneFrameListener _iIRegisterLocalMicrophoneFrameListener, LocalMicrophone localMicrophone) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalMicrophoneFrameListener = _iIRegisterLocalMicrophoneFrameListener;

			Boolean ret = VidyoConnectorRegisterLocalMicrophoneFrameListenerNative(objPtr, _mOnLocalMicrophoneFrame, (localMicrophone != null) ? localMicrophone.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about local monitor events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered for every new or existing monitor added.</param>
		/// <param name="onRemoved">Callback that is triggered when the monitor is removed.</param>
		/// <param name="onSelected">Callback that is triggered when a monitor is selected for use.</param>
		/// <param name="onStateUpdated">Callback that is triggered when a monitor state is updated.</param>
		public Boolean RegisterLocalMonitorEventListener(IRegisterLocalMonitorEventListener _iIRegisterLocalMonitorEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalMonitorEventListener = _iIRegisterLocalMonitorEventListener;

			Boolean ret = VidyoConnectorRegisterLocalMonitorEventListenerNative(objPtr, _mOnLocalMonitorAdded, _mOnLocalMonitorRemoved, _mOnLocalMonitorSelected, _mOnLocalMonitorStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about monitor frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onFrame">Callback that is triggered for every frame from a monitor.</param>
		/// <param name="localMonitor">The VidyoLocalMonitor for which to receive the frames.</param>
		/// <param name="width">Approximate width of the requested frame.</param>
		/// <param name="height">Approximate height of the requested frame.</param>
		/// <param name="frameInterval">Approximate frame interval of the requested frame.</param>
		public Boolean RegisterLocalMonitorFrameListener(IRegisterLocalMonitorFrameListener _iIRegisterLocalMonitorFrameListener, LocalMonitor localMonitor, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalMonitorFrameListener = _iIRegisterLocalMonitorFrameListener;

			Boolean ret = VidyoConnectorRegisterLocalMonitorFrameListenerNative(objPtr, _mOnLocalMonitorFrame, (localMonitor != null) ? localMonitor.GetObjectPtr():IntPtr.Zero, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about local speaker events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered for every new or existing speaker added.</param>
		/// <param name="onRemoved">Callback that is triggered when the speaker is removed.</param>
		/// <param name="onSelected">Callback that is triggered when a speaker is selected for use.</param>
		/// <param name="onStateUpdated">Callback that is triggered when a speaker state is updated.</param>
		public Boolean RegisterLocalSpeakerEventListener(IRegisterLocalSpeakerEventListener _iIRegisterLocalSpeakerEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalSpeakerEventListener = _iIRegisterLocalSpeakerEventListener;

			Boolean ret = VidyoConnectorRegisterLocalSpeakerEventListenerNative(objPtr, _mOnLocalSpeakerAdded, _mOnLocalSpeakerRemoved, _mOnLocalSpeakerSelected, _mOnLocalSpeakerStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about local shareable-window events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered for every new or existing window added.</param>
		/// <param name="onRemoved">Callback that is triggered when the window is removed.</param>
		/// <param name="onSelected">Callback that is triggered when a window is selected for use.</param>
		/// <param name="onStateUpdated">Callback that is triggered when a window state is updated.</param>
		public Boolean RegisterLocalWindowShareEventListener(IRegisterLocalWindowShareEventListener _iIRegisterLocalWindowShareEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalWindowShareEventListener = _iIRegisterLocalWindowShareEventListener;

			Boolean ret = VidyoConnectorRegisterLocalWindowShareEventListenerNative(objPtr, _mOnLocalWindowShareAdded, _mOnLocalWindowShareRemoved, _mOnLocalWindowShareSelected, _mOnLocalWindowShareStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about window frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onFrame">Callback that is triggered for every frame from a window.</param>
		/// <param name="localWindowShare">The VidyoLocalWindowShare for which to receive the frames.</param>
		/// <param name="width">Approximate width of the requested frame.</param>
		/// <param name="height">Approximate height of the requested frame.</param>
		/// <param name="frameInterval">Approximate frame interval of the requested frame.</param>
		public Boolean RegisterLocalWindowShareFrameListener(IRegisterLocalWindowShareFrameListener _iIRegisterLocalWindowShareFrameListener, LocalWindowShare localWindowShare, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLocalWindowShareFrameListener = _iIRegisterLocalWindowShareFrameListener;

			Boolean ret = VidyoConnectorRegisterLocalWindowShareFrameListenerNative(objPtr, _mOnLocalWindowShareFrame, (localWindowShare != null) ? localWindowShare.GetObjectPtr():IntPtr.Zero, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about log events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onLog">Callback that is triggered for every new log record.</param>
		/// <param name="filter"><p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and 45categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p></param>
		public Boolean RegisterLogEventListener(IRegisterLogEventListener _iIRegisterLogEventListener, String filter) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLogEventListener = _iIRegisterLogEventListener;

			IntPtr nFilter = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(filter ?? string.Empty);
			Boolean ret = VidyoConnectorRegisterLogEventListenerNative(objPtr, _mOnLog, nFilter);
			Marshal.FreeHGlobal(nFilter);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about message events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onChatMessageReceived">Callback that is triggered when a chat message is received from a participant.</param>
		public Boolean RegisterMessageEventListener(IRegisterMessageEventListener _iIRegisterMessageEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterMessageEventListener = _iIRegisterMessageEventListener;

			Boolean ret = VidyoConnectorRegisterMessageEventListenerNative(objPtr, _mOnChatMessageReceived);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Register a callback to receive moderation commands sent from the server. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="onModerationCommand">Callback to be triggered upon receive moderation command from the server.</param>
		public Boolean RegisterModerationCommandEventListener(IRegisterModerationCommandEventListener _iIRegisterModerationCommandEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterModerationCommandEventListener = _iIRegisterModerationCommandEventListener;

			Boolean ret = VidyoConnectorRegisterModerationCommandEventListenerNative(objPtr, _mOnModerationCommandReceived);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about result of moderation APIs. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onModerationResult">Callback that is triggered when the moderation API is complete.</param>
		public Boolean RegisterModerationResultEventListener(IRegisterModerationResultEventListener _iIRegisterModerationResultEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterModerationResultEventListener = _iIRegisterModerationResultEventListener;

			Boolean ret = VidyoConnectorRegisterModerationResultEventListenerNative(objPtr, _mOnModerationResult);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Register a callback to receive the final response for the Next Generation Renderer action. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="onNGRResult">Callback to be triggered upon receive the final response from next generation renderer library.</param>
		public Boolean RegisterNGRResultEventListener(IRegisterNGRResultEventListener _iIRegisterNGRResultEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterNGRResultEventListener = _iIRegisterNGRResultEventListener;

			Boolean ret = VidyoConnectorRegisterNGRResultEventListenerNative(objPtr, _mOnNGRResult);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about network interface events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered for every new or existing network interface added.</param>
		/// <param name="onRemoved">Callback that is triggered when the network interface is removed.</param>
		/// <param name="onSelected">Callback that is triggered when a network interface is selected for use.</param>
		/// <param name="onStateUpdated">Callback that is triggered when a network interface state changes.</param>
		public Boolean RegisterNetworkInterfaceEventListener(IRegisterNetworkInterfaceEventListener _iIRegisterNetworkInterfaceEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterNetworkInterfaceEventListener = _iIRegisterNetworkInterfaceEventListener;

			Boolean ret = VidyoConnectorRegisterNetworkInterfaceEventListenerNative(objPtr, _mOnNetworkInterfaceAdded, _mOnNetworkInterfaceRemoved, _mOnNetworkInterfaceSelected, _mOnNetworkInterfaceStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about participant events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onJoined">Callback that is triggered when another participant joins a conference.</param>
		/// <param name="onLeft">Callback that is triggered when an existing participant leaves a conference.</param>
		/// <param name="onDynamicChanged">Callback that is triggered when the order of participants has changed, based on their importance according to active speech detection.</param>
		/// <param name="onLoudestChanged">Callback that is triggered when a new participant becomes the loudest, based on active speech detection.</param>
		public Boolean RegisterParticipantEventListener(IRegisterParticipantEventListener _iIRegisterParticipantEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterParticipantEventListener = _iIRegisterParticipantEventListener;

			Boolean ret = VidyoConnectorRegisterParticipantEventListenerNative(objPtr, _mOnParticipantJoined, _mOnParticipantLeft, _mOnDynamicParticipantChanged, _mOnLoudestParticipantChanged);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers plugin. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return NULL.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="plugin">Plugin to register.</param>
		public ulong RegisterPlugin(ulong plugin) {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoConnectorRegisterPluginNative(objPtr, plugin);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about reconnecting events. Note: You should not perform long action in the callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onReconnecting">Callback that is triggered each time the new attempt to reconnect will be started.</param>
		/// <param name="onReconnected">Callback that is triggered when reconnecting was successful.</param>
		/// <param name="onConferenceLost">Callback that is triggered when reconnecting failed.</param>
		public Boolean RegisterReconnectEventListener(IRegisterReconnectEventListener _iIRegisterReconnectEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterReconnectEventListener = _iIRegisterReconnectEventListener;

			Boolean ret = VidyoConnectorRegisterReconnectEventListenerNative(objPtr, _mOnReconnecting, _mOnReconnected, _mOnConferenceLost);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified when a recorder joins or leaves the call. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onRecorderInCallChanged">Callback that is triggered when a recorder joins or leaves the call.</param>
		public Boolean RegisterRecorderInCallEventListener(IRegisterRecorderInCallEventListener _iIRegisterRecorderInCallEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRecorderInCallEventListener = _iIRegisterRecorderInCallEventListener;

			Boolean ret = VidyoConnectorRegisterRecorderInCallEventListenerNative(objPtr, _mRecorderInCall);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about remote camera events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered each time one of the other participants adds a remote camera into a conference.</param>
		/// <param name="onRemoved">Callback that is triggered each time one of the other participants removes a remote camera from a conference.</param>
		/// <param name="onStateUpdated">Callback that is triggered each time one of the other participants remote camera chagnes state in a conference.</param>
		public Boolean RegisterRemoteCameraEventListener(IRegisterRemoteCameraEventListener _iIRegisterRemoteCameraEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteCameraEventListener = _iIRegisterRemoteCameraEventListener;

			Boolean ret = VidyoConnectorRegisterRemoteCameraEventListenerNative(objPtr, _mOnRemoteCameraAdded, _mOnRemoteCameraRemoved, _mOnRemoteCameraStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about camera frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onFrame">Callback that is triggered for every frame from a remote camera.</param>
		/// <param name="remoteCamera">The VidyoRemoteCamera for which to receive the frames.</param>
		/// <param name="width">Approximate width of the requested frame.</param>
		/// <param name="height">Approximate height of the requested frame.</param>
		/// <param name="frameInterval">Approximate frame interval of the requested frame.</param>
		public Boolean RegisterRemoteCameraFrameListener(IRegisterRemoteCameraFrameListener _iIRegisterRemoteCameraFrameListener, RemoteCamera remoteCamera, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteCameraFrameListener = _iIRegisterRemoteCameraFrameListener;

			Boolean ret = VidyoConnectorRegisterRemoteCameraFrameListenerNative(objPtr, _mOnRemoteCameraFrame, (remoteCamera != null) ? remoteCamera.GetObjectPtr():IntPtr.Zero, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about microphone energies from other participants. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onEnergy">Callback that is triggered for every frame with energy from a remote microphone.</param>
		public Boolean RegisterRemoteMicrophoneEnergyListener(IRegisterRemoteMicrophoneEnergyListener _iIRegisterRemoteMicrophoneEnergyListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteMicrophoneEnergyListener = _iIRegisterRemoteMicrophoneEnergyListener;

			Boolean ret = VidyoConnectorRegisterRemoteMicrophoneEnergyListenerNative(objPtr, _mOnRemoteMicrophoneEnergy);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about remote microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered when another participant adds a microphone into a conference.</param>
		/// <param name="onRemoved">Callback that is triggered when another participant removes a microphone from a conference.</param>
		/// <param name="onStateUpdated">Callback that is triggered when another participant microphone changes state in a conference.</param>
		public Boolean RegisterRemoteMicrophoneEventListener(IRegisterRemoteMicrophoneEventListener _iIRegisterRemoteMicrophoneEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteMicrophoneEventListener = _iIRegisterRemoteMicrophoneEventListener;

			Boolean ret = VidyoConnectorRegisterRemoteMicrophoneEventListenerNative(objPtr, _mOnRemoteMicrophoneAdded, _mOnRemoteMicrophoneRemoved, _mOnRemoteMicrophoneStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about microphone frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onFrame">Callback that is triggered for every frame from a remote microphone.</param>
		/// <param name="remoteMicrophone">The VidyoRemoteMicrophone for which to receive the frames.</param>
		public Boolean RegisterRemoteMicrophoneFrameListener(IRegisterRemoteMicrophoneFrameListener _iIRegisterRemoteMicrophoneFrameListener, RemoteMicrophone remoteMicrophone) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteMicrophoneFrameListener = _iIRegisterRemoteMicrophoneFrameListener;

			Boolean ret = VidyoConnectorRegisterRemoteMicrophoneFrameListenerNative(objPtr, _mOnRemoteMicrophoneFrame, (remoteMicrophone != null) ? remoteMicrophone.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about remote renderer events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered when server is ready to accept video stream from local camera.</param>
		/// <param name="onRemoved">Callback that is triggered when server stops receiving video stream from local camera.</param>
		/// <param name="onStateUpdated">Callback that is triggered when server makes a state change on accepting video stream.</param>
		public Boolean RegisterRemoteRendererEventListener(IRegisterRemoteRendererEventListener _iIRegisterRemoteRendererEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteRendererEventListener = _iIRegisterRemoteRendererEventListener;

			Boolean ret = VidyoConnectorRegisterRemoteRendererEventListenerNative(objPtr, _mOnRemoteRendererAdded, _mOnRemoteRendererRemoved, _mOnRemoteRendererStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about remote speaker events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered when server is ready to accept audio stream from local microphone.</param>
		/// <param name="onRemoved">Callback that is triggered when server stops receiving audio stream from local microphone.</param>
		/// <param name="onStateUpdated">Callback that is triggered when server makes a state change on accepting audio stream.</param>
		public Boolean RegisterRemoteSpeakerEventListener(IRegisterRemoteSpeakerEventListener _iIRegisterRemoteSpeakerEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteSpeakerEventListener = _iIRegisterRemoteSpeakerEventListener;

			Boolean ret = VidyoConnectorRegisterRemoteSpeakerEventListenerNative(objPtr, _mOnRemoteSpeakerAdded, _mOnRemoteSpeakerRemoved, _mOnRemoteSpeakerStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about remote shreable-window events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered when another participant adds a window-share into a conference.</param>
		/// <param name="onRemoved">Callback that is triggered when another participant removes a window-share from a conference.</param>
		/// <param name="onStateUpdated">Callback that is triggered when another participant window-share changes state in a conference.</param>
		public Boolean RegisterRemoteWindowShareEventListener(IRegisterRemoteWindowShareEventListener _iIRegisterRemoteWindowShareEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteWindowShareEventListener = _iIRegisterRemoteWindowShareEventListener;

			Boolean ret = VidyoConnectorRegisterRemoteWindowShareEventListenerNative(objPtr, _mOnRemoteWindowShareAdded, _mOnRemoteWindowShareRemoved, _mOnRemoteWindowShareStateUpdated);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about window-share frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onFrame">Callback that is triggered for every frame from a remote window share.</param>
		/// <param name="remoteWindowShare">The VidyoRemoteWindowShare for which to receive the frames.</param>
		/// <param name="width">Approximate width of the requested frame.</param>
		/// <param name="height">Approximate height of the requested frame.</param>
		/// <param name="frameInterval">Approximate frame interval of the requested frame.</param>
		public Boolean RegisterRemoteWindowShareFrameListener(IRegisterRemoteWindowShareFrameListener _iIRegisterRemoteWindowShareFrameListener, RemoteWindowShare remoteWindowShare, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRemoteWindowShareFrameListener = _iIRegisterRemoteWindowShareFrameListener;

			Boolean ret = VidyoConnectorRegisterRemoteWindowShareFrameListenerNative(objPtr, _mOnRemoteWindowShareFrame, (remoteWindowShare != null) ? remoteWindowShare.GetObjectPtr():IntPtr.Zero, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about resource-management events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAvailableResourcesChanged">Callback that is triggered when local resource availability changes.</param>
		/// <param name="onMaxRemoteSourcesChanged">Callback that is triggered when the maximum number of decoded sources changes.</param>
		public Boolean RegisterResourceManagerEventListener(IRegisterResourceManagerEventListener _iIRegisterResourceManagerEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterResourceManagerEventListener = _iIRegisterResourceManagerEventListener;

			Boolean ret = VidyoConnectorRegisterResourceManagerEventListenerNative(objPtr, _mOnAvailableResourcesChanged, _mOnMaxRemoteSourcesChanged);

			return ret;
		}
		/// <summary>
		/// This is a synchronous and private interface, for usage please contact vidyo api support team. Application can register a private callback to receive tokens from the vidyo portal. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the tokens are received from the vidyo portal.</param>
		public Boolean RegisterTokenReceivedEventListener(IRegisterTokenReceivedEventListener _iIRegisterTokenReceivedEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterTokenReceivedEventListener = _iIRegisterTokenReceivedEventListener;

			Boolean ret = VidyoConnectorRegisterTokenReceivedEventListenerNative(objPtr, _mOnTokenReceived);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about virtual audio source events. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered each time when virtual audio source is created.</param>
		/// <param name="onRemoved">Callback that is triggered each time when virtual audio source is removed.</param>
		/// <param name="onStateUpdated">Callback that is triggered each time when virtual audio source chagnes state.</param>
		/// <param name="onSelected">Callback that is triggered each time when virtual audio source is selected.</param>
		/// <param name="onExternalMediaBufferReleased">Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw audio frame data.</param>
		public Boolean RegisterVirtualAudioSourceEventListener(IRegisterVirtualAudioSourceEventListener _iIRegisterVirtualAudioSourceEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterVirtualAudioSourceEventListener = _iIRegisterVirtualAudioSourceEventListener;

			Boolean ret = VidyoConnectorRegisterVirtualAudioSourceEventListenerNative(objPtr, _mOnVirtualAudioSourceAdded, _mOnVirtualAudioSourceRemoved, _mOnVirtualAudioSourceStateUpdated, _mOnVirtualAudioSourceSelected, _mOnVirtualAudioSourceExternalMediaBufferReleased);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about virtual video source events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onAdded">Callback that is triggered each time when virtual video source is added into a conference.</param>
		/// <param name="onRemoved">Callback that is triggered each time when virtual video source is added from a conference.</param>
		/// <param name="onStateUpdated">Callback that is triggered each time when virtual video source chagnes state in a conference.</param>
		/// <param name="onExternalMediaBufferReleased">Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw video frame.</param>
		public Boolean RegisterVirtualVideoSourceEventListener(IRegisterVirtualVideoSourceEventListener _iIRegisterVirtualVideoSourceEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterVirtualVideoSourceEventListener = _iIRegisterVirtualVideoSourceEventListener;

			Boolean ret = VidyoConnectorRegisterVirtualVideoSourceEventListenerNative(objPtr, _mOnVirtualVideoSourceAdded, _mOnVirtualVideoSourceRemoved, _mOnVirtualVideoSourceStateUpdated, _mOnVirtualVideoSourceExternalMediaBufferReleased);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Registers to get notified about web proxy events. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when web proxy credentials are requested.</param>
		public Boolean RegisterWebProxyEventListener(IRegisterWebProxyEventListener _iIRegisterWebProxyEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterWebProxyEventListener = _iIRegisterWebProxyEventListener;

			Boolean ret = VidyoConnectorRegisterWebProxyEventListenerNative(objPtr, _mOnWebProxyCredentialsRequest);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Removes audio device from whitelist. This interface is allowed to be called in all VidyoConnector states except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="deviceName">The name of audio device that will be removed from whitelist.</param>
		public Boolean RemoveAudioDeviceFromWhitelist(String deviceName) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nDeviceName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(deviceName ?? string.Empty);
			Boolean ret = VidyoConnectorRemoveAudioDeviceFromWhitelistNative(objPtr, nDeviceName);
			Marshal.FreeHGlobal(nDeviceName);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This API provides the ability for the room owner to remove authentication scheme for moderator functionality. Once moderator pin is removed, other users will not be able to moderate call on that room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RemoveModeratorPIN(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorRemoveModeratorPINNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This API provides the ability to remove moderator privilege. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="onRemoveModeratorRoleResult">Callback to be triggered when remove of moderator role is completed</param>
		public Boolean RemoveModeratorRole(IRemoveModeratorRole _iIRemoveModeratorRole) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRemoveModeratorRole = _iIRemoveModeratorRole;

			Boolean ret = VidyoConnectorRemoveModeratorRoleNative(objPtr, _mOnRemoveModeratorRoleResult);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Remove presenter rights from a specific participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RemovePresenter(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorRemovePresenterNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This api provides the ability to remove the room pin. Once room pin is remove, all other users are not required to enter room pin to join conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="onRemoveRoomPinResult">Callback to be triggered for remove room pin result.</param>
		public Boolean RemoveRoomPIN(IRemoveRoomPIN _iIRemoveRoomPIN) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRemoveRoomPIN = _iIRemoveRoomPIN;

			Boolean ret = VidyoConnectorRemoveRoomPINNative(objPtr, _mOnRemoveRoomPINResult);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. By default, local participant joining/leaving are not reported to applicaiotn. Use this function to report those events. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="reportLocalParticipant">Set to LMI_TRUE if application is interested in local participant to be included in participant event callbacks. Otherwise set to LMI_FALSE. Default is LMI_FALSE</param>
		public Boolean ReportLocalParticipantOnJoined(Boolean reportLocalParticipant) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorReportLocalParticipantOnJoinedNative(objPtr, reportLocalParticipant);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This API provides the ability to request moderator privilege for the regular user. If the room is owned by this user or user is Admin/operator moderator pin can be empty string. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="moderatorPIN">set authentication scheme (moderator pIN) to get the moderatore role functionality. Empty string for admin/host.</param>
		/// <param name="onRequestModeratorRoleResult">Callback to be triggered when request of moderator role is completed</param>
		public Boolean RequestModeratorRole(String moderatorPIN, IRequestModeratorRole _iIRequestModeratorRole) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRequestModeratorRole = _iIRequestModeratorRole;

			IntPtr nModeratorPIN = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(moderatorPIN ?? string.Empty);
			Boolean ret = VidyoConnectorRequestModeratorRoleNative(objPtr, nModeratorPIN, _mOnRequestModeratorRoleResult);
			Marshal.FreeHGlobal(nModeratorPIN);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Request to resume sending video after sever paused video stream from selected local camera. Will resume both local and remote streams and show preview in case it is on. Allowed only in case of soft mute. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean RequestToResumeVideo() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorRequestToResumeVideoNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Request to speak after sever paused audio stream from selected local microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean RequestToSpeak() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorRequestToSpeakNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Requests video for remote camera before assign. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="remoteCamera">The VidyoRemoteCamera for which to receive the video.</param>
		/// <param name="width">Approximate width of the requested video.</param>
		/// <param name="height">Approximate height of the requested video.</param>
		/// <param name="frameInterval">Approximate frame interval of the requested video.</param>
		/// <param name="onFirstFrameReceived">Callback that is triggered when first frame from a remote camera received.</param>
		public Boolean RequestVideoForRemoteCamera(RemoteCamera remoteCamera, uint width, uint height, ulong frameInterval, IRequestVideoForRemoteCamera _iIRequestVideoForRemoteCamera) {
			if (objPtr == IntPtr.Zero) { return default; }
			if(remoteCamera != null)
				onRemoteCameraFirstFrameReceivedCallbacksMap[remoteCamera.GetId()] =_iIRequestVideoForRemoteCamera;

			Boolean ret = VidyoConnectorRequestVideoForRemoteCameraNative(objPtr, (remoteCamera != null) ? remoteCamera.GetObjectPtr():IntPtr.Zero, width, height, frameInterval, _mOnRemoteCameraFirstFrameReceived);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Requests video for remote window share before assign. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="remoteWindowShare">The VidyoRemoteWindowShare for which to receive the video.</param>
		/// <param name="width">Approximate width of the requested video.</param>
		/// <param name="height">Approximate height of the requested video.</param>
		/// <param name="frameInterval">Approximate frame interval of the requested video.</param>
		/// <param name="onFirstFrameReceived">Callback that is triggered when first frame from a remote window share received.</param>
		public Boolean RequestVideoForRemoteWindowShare(RemoteWindowShare remoteWindowShare, uint width, uint height, ulong frameInterval, IRequestVideoForRemoteWindowShare _iIRequestVideoForRemoteWindowShare) {
			if (objPtr == IntPtr.Zero) { return default; }
			if(remoteWindowShare != null)
				onRemoteWindowShareFirstFrameReceivedCallbacksMap[remoteWindowShare.GetId()] =_iIRequestVideoForRemoteWindowShare;

			Boolean ret = VidyoConnectorRequestVideoForRemoteWindowShareNative(objPtr, (remoteWindowShare != null) ? remoteWindowShare.GetObjectPtr():IntPtr.Zero, width, height, frameInterval, _mOnRemoteWindowShareFirstFrameReceived);

			return ret;
		}
		/// <summary>
		/// Asynchronously resumes recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or not paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">Pointer to the VidyoConnector object.</param>
		/// <param name="onRecordingServiceResumeResultCallback">Callback called upon completion.</param>
		public Boolean ResumeRecording(IResumeRecording _iIResumeRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIResumeRecording = _iIResumeRecording;

			Boolean ret = VidyoConnectorResumeRecordingNative(objPtr, _mOnRecordingServiceResumeResult);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Search for users in conference mode.
		/// </summary>
		/// <param name="c">The VidyoConnector object pointer.</param>
		/// <param name="searchText">The search text to search users.</param>
		/// <param name="startIndex">The starting index from where the result should be retrieved.</param>
		/// <param name="maxRecords">The max number of records in the result.</param>
		/// <param name="onUserSearchResults">The callback which will receive the results.</param>
		public Boolean SearchUsers(String searchText, uint startIndex, uint maxRecords, ISearchUsers _iISearchUsers) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mISearchUsers = _iISearchUsers;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoConnectorSearchUsersNative(objPtr, nSearchText, startIndex, maxRecords, _mOnUserSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local microphone to use for audio content share. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localMicrophone">Local microphone to select for audio content share. NULL if none of them should be selected.</param>
		public Boolean SelectAudioContentShare(LocalMicrophone localMicrophone) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectAudioContentShareNative(objPtr, (localMicrophone != null) ? localMicrophone.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Resets the camera selection to pick the Default camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean SelectDefaultCamera() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectDefaultCameraNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Resets the microphone selection to pick the Default microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean SelectDefaultMicrophone() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectDefaultMicrophoneNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Selects the default ANY network interface to be used for Media. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean SelectDefaultNetworkInterfaceForMedia() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectDefaultNetworkInterfaceForMediaNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Selects the default ANY network interface to be used for Signaling. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean SelectDefaultNetworkInterfaceForSignaling() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectDefaultNetworkInterfaceForSignalingNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Resets the speaker selection to pick the Default speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean SelectDefaultSpeaker() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectDefaultSpeakerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local camera to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localCamera">Local camera to select. NULL if none of them should be selected.</param>
		public Boolean SelectLocalCamera(LocalCamera localCamera) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectLocalCameraNative(objPtr, (localCamera != null) ? localCamera.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local microphone to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localMicrophone">Local microphone to select. NULL if none of them should be selected.</param>
		public Boolean SelectLocalMicrophone(LocalMicrophone localMicrophone) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectLocalMicrophoneNative(objPtr, (localMicrophone != null) ? localMicrophone.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local monitor to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localMonitor">Local monitor to share in a conference. NULL if none of them should be shared.</param>
		public Boolean SelectLocalMonitor(LocalMonitor localMonitor) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectLocalMonitorNative(objPtr, (localMonitor != null) ? localMonitor.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local monitor to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localMonitor">Local monitor to share in a conference. NULL if none of them should be shared.</param>
		/// <param name="options">A structure that represent the sharing options.</param>
		public Boolean SelectLocalMonitorAdvanced(LocalMonitor localMonitor, ConnectorShareOptions options) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectLocalMonitorAdvancedNative(objPtr, (localMonitor != null) ? localMonitor.GetObjectPtr():IntPtr.Zero, (options != null) ? options.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local speaker to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localSpeaker">Local speaker to select. NULL if none of them should be selected.</param>
		public Boolean SelectLocalSpeaker(LocalSpeaker localSpeaker) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectLocalSpeakerNative(objPtr, (localSpeaker != null) ? localSpeaker.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local window to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localWindowShare">Local window to share in a conference. NULL if none of them should be shared.</param>
		public Boolean SelectLocalWindowShare(LocalWindowShare localWindowShare) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectLocalWindowShareNative(objPtr, (localWindowShare != null) ? localWindowShare.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local window to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localWindowShare">Local window to share in a conference. NULL if none of them should be shared.</param>
		/// <param name="options">A structure that represent the sharing options.</param>
		public Boolean SelectLocalWindowShareAdvanced(LocalWindowShare localWindowShare, ConnectorShareOptions options) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectLocalWindowShareAdvancedNative(objPtr, (localWindowShare != null) ? localWindowShare.GetObjectPtr():IntPtr.Zero, (options != null) ? options.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Selects the network interface to be used for Media. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="networkInterface">Network interface to be selected.</param>
		public Boolean SelectNetworkInterfaceForMedia(NetworkInterface networkInterface) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectNetworkInterfaceForMediaNative(objPtr, (networkInterface != null) ? networkInterface.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Selects the network interface to be used for Signaling. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="networkInterface">Network interface to be selected.</param>
		public Boolean SelectNetworkInterfaceForSignaling(NetworkInterface networkInterface) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectNetworkInterfaceForSignalingNative(objPtr, (networkInterface != null) ? networkInterface.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Selects the local camera to use for video content share. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localCamera">Local camera to select. NULL if none of them should be selected.</param>
		public Boolean SelectVideoContentShare(LocalCamera localCamera) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectVideoContentShareNative(objPtr, (localCamera != null) ? localCamera.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Selects the virtual audio source which will be used for content share. The selected microphone which currently using for content share will be unselected. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceStateUpdated will trigger.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualAudioSource">The virtual audio source that will be used for content share.</param>
		public Boolean SelectVirtualAudioContentShare(VirtualAudioSource virtualAudioSource) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectVirtualAudioContentShareNative(objPtr, (virtualAudioSource != null) ? virtualAudioSource.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Selects the virtual video source which is camera that will be shown to remote participants. The real camera will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualCamera">The virtual video source that will be shown to remote participants.</param>
		public Boolean SelectVirtualCamera(VirtualVideoSource virtualCamera) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectVirtualCameraNative(objPtr, (virtualCamera != null) ? virtualCamera.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Selects the virtual audio source which will be used as microphone. The real miicrophone will be unselected if it's selected. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceStateUpdated will trigger.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualAudioSource">The virtual audio source that will be used as microphone.</param>
		public Boolean SelectVirtualMicrophone(VirtualAudioSource virtualAudioSource) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectVirtualMicrophoneNative(objPtr, (virtualAudioSource != null) ? virtualAudioSource.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Selects the virtual renderer to receive all events required for rendering. On, iOS, this API must be called from main(UI) thread. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="renderer">The virtual renderer object to select, NULL to unselect.</param>
		public Boolean SelectVirtualRenderer(VirtualRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectVirtualRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Selects the virtual video source which is window share that will be shown to remote participants. The local window share will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualWindowShare">The virtual video source that will be shown to remote participants.</param>
		public Boolean SelectVirtualSourceWindowShare(VirtualVideoSource virtualWindowShare) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSelectVirtualSourceWindowShareNative(objPtr, (virtualWindowShare != null) ? virtualWindowShare.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sends a message to all the other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="message">A message to send to all the other participants.</param>
		public Boolean SendChatMessage(String message) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			Boolean ret = VidyoConnectorSendChatMessageNative(objPtr, nMessage);
			Marshal.FreeHGlobal(nMessage);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sends a message to the specific participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="participant">A participant that will receive message.</param>
		/// <param name="message">A message to send to the specific participants.</param>
		public Boolean SendPrivateChatMessage(Participant participant, String message) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			Boolean ret = VidyoConnectorSendPrivateChatMessageNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nMessage);
			Marshal.FreeHGlobal(nMessage);

			return ret;
		}
		/// <summary>
		/// Sends already constructed audio frame to selected virtual audio source and then send it to local and/or remote streams. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualAudioSource">The virtual audio source.</param>
		/// <param name="audioFrame">The audio frame to be sent.</param>
		public Boolean SendVirtualAudioSourceFrame(VirtualAudioSource virtualAudioSource, AudioFrame audioFrame) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSendVirtualAudioSourceFrameNative(objPtr, (virtualAudioSource != null) ? virtualAudioSource.GetObjectPtr():IntPtr.Zero, (audioFrame != null) ? audioFrame.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Pass raw buffer to selected virtual audio source, based on which the audio frame will be constructed and then send it to local and/or remote streams. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceExternalMediaBufferReleased will trigger when buffer is not needed anymore.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="virtualAudioSource">The virtual audio source.</param>
		/// <param name="buffer">The buffer with audio data to be sent.</param>
		/// <param name="nbSamples">The number of sample frames that will be represented in the audio data.</param>
		/// <param name="elapsedTime">The elapsed time.</param>
		public Boolean SendVirtualAudioSourceFrameWithExternalData(VirtualAudioSource virtualAudioSource, byte[] buffer, SizeT nbSamples, ulong elapsedTime) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr pointer = ByteArrayHelperSingleton.ByteArrayToRawPointer(buffer);
			Boolean ret = VidyoConnectorSendVirtualAudioSourceFrameWithExternalDataNative(objPtr, (virtualAudioSource != null) ? virtualAudioSource.GetObjectPtr():IntPtr.Zero, pointer, nbSamples, elapsedTime);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Allow application to set advanced log options in addition to standard ones. The given log levels and categories string will be added to current log level the application is running with. The string should be valid for this API to work correctly. e.g debug@VidyoConnector debug@VidyoClient.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="loggerType">The loggerType console, file, feedback, http.</param>
		/// <param name="advancedLogFilter">advanced log options in addition to standard ones. <p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p></param>
		public Boolean SetAdvancedLogOptions(ConnectorLoggerType loggerType, String advancedLogFilter) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nAdvancedLogFilter = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(advancedLogFilter ?? string.Empty);
			Boolean ret = VidyoConnectorSetAdvancedLogOptionsNative(objPtr, loggerType, nAdvancedLogFilter);
			Marshal.FreeHGlobal(nAdvancedLogFilter);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets up advanced options on the VidyoConnector API. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="options">The experimental optons in JSON format.</param>
		public Boolean SetAdvancedOptions(String options) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nOptions = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(options ?? string.Empty);
			Boolean ret = VidyoConnectorSetAdvancedOptionsNative(objPtr, nOptions);
			Marshal.FreeHGlobal(nOptions);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets multiplier value to be used when calculating the audio bitrate. Default is 2. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="bitrateMultiplier">Bitrate multiplier for which possible values are 0, 1 and 2.</param>
		public Boolean SetAudioBitrateMultiplier(uint bitrateMultiplier) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetAudioBitrateMultiplierNative(objPtr, bitrateMultiplier);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enables or disables usage of audio devices (speaker and microphone) in different audio modes. By default SharedModeBoth is enabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="audioMode">Indicates which audio mode is enabled/disabled for both audio devices. For possible values of the audio mode, refer VidyoConnectorAudioMode.</param>
		public Boolean SetAudioMode(ConnectorAudioMode audioMode) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetAudioModeNative(objPtr, audioMode);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets time interval between two packet of audio in miliseconds. Default is 40 ms. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="packetInterval">Packet interval for which possible values are 20, and 40 ms.</param>
		public Boolean SetAudioPacketInterval(uint packetInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetAudioPacketIntervalNative(objPtr, packetInterval);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets value that is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Default is 10%. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="lossPercentage">Loss percantage for which possible values are [0, 10, 20, 30] in percentage.</param>
		public Boolean SetAudioPacketLossPercentage(uint lossPercentage) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetAudioPacketLossPercentageNative(objPtr, lossPercentage);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enables or disables auto-reconnect. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="enable">Indicates whether auto-reconnect is enabled or not.</param>
		public Boolean SetAutoReconnect(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetAutoReconnectNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets back off for next reconnect attempt. By default, it is set to 5 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="backOff">Time in seconds before next reconnect attempt. Min value is 2 and the max is 20 seconds.</param>
		public Boolean SetAutoReconnectAttemptBackOff(uint backOff) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetAutoReconnectAttemptBackOffNative(objPtr, backOff);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets maximum attempts to be done for reconnecting. By default, it is set to 3. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="maxAttempts">Number of maximum attempts to be done for reconnecting. Min value is 1 and the max is 4.</param>
		public Boolean SetAutoReconnectMaxAttempts(uint maxAttempts) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetAutoReconnectMaxAttemptsNative(objPtr, maxAttempts);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the intensity of the background blur effect. It is allowed to change blur intensity while the effect is enabled. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="intensity">The intensity of the background blur effect. Valid valies is [3-8]. Default value is 5.</param>
		public Boolean SetBlurIntensity(uint intensity) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetBlurIntensityNative(objPtr, intensity);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enables the specified by VidyoConnectorCameraEffectType camera background effect or disables active effect if VIDYO_CONNECTORCAMERAEFFECTTYPE_None passed. The application must provide token to enable this feature as part of VidyoConnectorCameraEffectInfo structure. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="effectInfo">Represents the configuration of camera background effect.</param>
		public Boolean SetCameraBackgroundEffect(ConnectorCameraEffectInfo effectInfo) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetCameraBackgroundEffectNative(objPtr, (effectInfo != null) ? effectInfo.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets camera PTZ nudge configuration. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="cameraNudgeConfig">Camera PTZ nudge configuration in JSON format.</param>
		public Boolean SetCameraNudgeConfiguration(String cameraNudgeConfig) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nCameraNudgeConfig = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(cameraNudgeConfig ?? string.Empty);
			Boolean ret = VidyoConnectorSetCameraNudgeConfigurationNative(objPtr, nCameraNudgeConfig);
			Marshal.FreeHGlobal(nCameraNudgeConfig);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Sets the flag to show/hide the local camera for remote participants for composite/custom layout and local camera preview for composite layout only. Will also unmute a soft mute(Hunter only). On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="privacy">Flag to show/hide the local camera.</param>
		public Boolean SetCameraPrivacy(Boolean privacy) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetCameraPrivacyNative(objPtr, privacy);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the file that contains certificate authority's certificates used to authenticate a TLS connection. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="certificateAuthorityFile">The string representing Certificate Authority file. Note: The string must containt full path and name of file.</param>
		public Boolean SetCertificateAuthorityFile(String certificateAuthorityFile) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nCertificateAuthorityFile = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(certificateAuthorityFile ?? string.Empty);
			Boolean ret = VidyoConnectorSetCertificateAuthorityFileNative(objPtr, nCertificateAuthorityFile);
			Marshal.FreeHGlobal(nCertificateAuthorityFile);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the list of certificate authority's certificates used to authenticate a TLS connection. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="certificateAuthorityList">The string representing Certificate Authority lists. Note: If the string 'default' is passed here, VidyoConnector will use a built-in Certificate Authority list.</param>
		public Boolean SetCertificateAuthorityList(String certificateAuthorityList) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nCertificateAuthorityList = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(certificateAuthorityList ?? string.Empty);
			Boolean ret = VidyoConnectorSetCertificateAuthorityListNative(objPtr, nCertificateAuthorityList);
			Marshal.FreeHGlobal(nCertificateAuthorityList);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets conference number - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="conferenceNumber">Conference number to be set.</param>
		public Boolean SetConferenceNumber(String conferenceNumber) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nConferenceNumber = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(conferenceNumber ?? string.Empty);
			Boolean ret = VidyoConnectorSetConferenceNumberNative(objPtr, nConferenceNumber);
			Marshal.FreeHGlobal(nConferenceNumber);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Set CPU tradeoff profile. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="profile">The tradeoff profile.</param>
		public Boolean SetCpuTradeOffProfile(ConnectorTradeOffProfile profile) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetCpuTradeOffProfileNative(objPtr, profile);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. When enabled, all video feeds (video and content share) will be shut off to the client when the user experiences prolonged low network bandwidth. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="enable">Indicates whether disable video on low bandwidth is enabled or not.</param>
		public Boolean SetDisableVideoOnLowBandwidth(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetDisableVideoOnLowBandwidthNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets number of audio streams requested while video is shut off. By default, it is set to 3. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="audioStreams">Number of audio streams requested while video is shut off. Min value is 1 and max is 3.</param>
		public Boolean SetDisableVideoOnLowBandwidthAudioStreams(uint audioStreams) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetDisableVideoOnLowBandwidthAudioStreamsNative(objPtr, audioStreams);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets time it takes to recover when video is shut off. By default, it is set to 0 seconds which means never. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="recoveryTime">Time it takes to recover when video is shut off. Recovery can only happen when there are no available video sources.</param>
		public Boolean SetDisableVideoOnLowBandwidthRecoveryTime(uint recoveryTime) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetDisableVideoOnLowBandwidthRecoveryTimeNative(objPtr, recoveryTime);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets time it takes to shut off video due to low bandwidth. By default, it is set to 30 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="responseTime">Time it takes to shut off video due to low bandwidth.</param>
		public Boolean SetDisableVideoOnLowBandwidthResponseTime(uint responseTime) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetDisableVideoOnLowBandwidthResponseTimeNative(objPtr, responseTime);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets how often to check for low bandwidth. By default, it is set to 5 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="sampleTime">How often to check for low bandwidth. Must divide evenly into responseTime.</param>
		public Boolean SetDisableVideoOnLowBandwidthSampleTime(uint sampleTime) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetDisableVideoOnLowBandwidthSampleTimeNative(objPtr, sampleTime);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets low bandwidth threshold. By default, it is set to 100kpbs. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="kbps">Threshold for low bandwidth in kilobits/sec.</param>
		public Boolean SetDisableVideoOnLowBandwidthThreshold(uint kbps) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetDisableVideoOnLowBandwidthThresholdNative(objPtr, kbps);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets log file size limit, how often to initiate the wrap, and number of log files. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="maxSize">The number of bytes of logged messages to save.</param>
		/// <param name="wrapPeriod">How often to initiate the wrap in nanoseconds. If this value is LMI_TIME_INFINITE, the log file will not be wrapped based on time.</param>
		/// <param name="wrapCount">The maximum number of files to keep.</param>
		public Boolean SetFileLoggerRotationParameters(SizeT maxSize, ulong wrapPeriod, SizeT wrapCount) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetFileLoggerRotationParametersNative(objPtr, maxSize, wrapPeriod, wrapCount);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Set font file name. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="fontFileName">Pointer to char array that contains font file name. Note: on Windows this must be the name of a system TrueType font. For example "Microsoft YaHei"</param>
		public Boolean SetFontFileName(String fontFileName) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nFontFileName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(fontFileName ?? string.Empty);
			Boolean ret = VidyoConnectorSetFontFileNameNative(objPtr, nFontFileName);
			Marshal.FreeHGlobal(nFontFileName);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the geographic location of the endpoint using the VidyoConnector. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="latitude">Latitude of the geographic coordinate.</param>
		/// <param name="longitude">Longitude of the geographic coordinate.</param>
		public Boolean SetLocation(double latitude, double longitude) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetLocationNative(objPtr, latitude, longitude);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets new path to log file. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="filename">The name of the file to log to. Note: Can be passed just filename or with full path so that location will be changed.</param>
		public Boolean SetLogFilePath(String filename) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nFilename = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(filename ?? string.Empty);
			Boolean ret = VidyoConnectorSetLogFilePathNative(objPtr, nFilename);
			Marshal.FreeHGlobal(nFilename);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Allow application to replace log level of logger(console, file, feedback, http) as production or debug. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="loggerType">loggerType console, file, feedback, http.</param>
		/// <param name="logLevel">log level production or debug.</param>
		public Boolean SetLogLevel(ConnectorLoggerType loggerType, ConnectorLogLevel logLevel) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetLogLevelNative(objPtr, loggerType, logLevel);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the max send bit rate for all sources. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="bitRate">The max send bit rate for all sources.</param>
		public Boolean SetMaxBitRate(uint bitRate) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetMaxBitRateNative(objPtr, bitRate);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Request server to limit bit rate sent to this client. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CNNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="bitRate">The maximum receiving bit rate request sent to server, in bps.</param>
		public Boolean SetMaxReceiveBitRate(uint bitRate) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetMaxReceiveBitRateNative(objPtr, bitRate);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the max send bit rate for all sources. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="bitRate">The max send bit rate for all sources, in bps.</param>
		public Boolean SetMaxSendBitRate(uint bitRate) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetMaxSendBitRateNative(objPtr, bitRate);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="boostLevel">Boost level for which possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.</param>
		public Boolean SetMicrophoneMaxBoostLevel(double boostLevel) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetMicrophoneMaxBoostLevelNative(objPtr, boostLevel);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Sets the flag to mute/unmute the microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="privacy">Flag to mute/unmute the microphone.</param>
		public Boolean SetMicrophonePrivacy(Boolean privacy) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetMicrophonePrivacyNative(objPtr, privacy);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="volumePercent">Volume percent for which possible values are 0 - 100 percentage. Default is 50 percent.</param>
		public Boolean SetMinMicrophoneVolume(uint volumePercent) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetMinMicrophoneVolumeNative(objPtr, volumePercent);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the operating mode of the VidyoConnector. This API have to be called before renderer is destructed: i.e. VidyoConnectorHideView will be called in case VIDYO_CONNECTORMODE_Background and after renderer is constructed: i.e. VidyoConnectorAssignViewToCompositeRenderer, VidyoConnectorAssignViewToLocalCamera, VidyoConnectorAssignViewToRemoteCamera will be called in case VIDYO_CONNECTORMODE_Foreground. This API is required only when user in the conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector. It won't do anything in VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead states of VidyoConnector but it will still return LMI_TRUE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="mode">Desired operating mode.</param>
		public Boolean SetMode(ConnectorMode mode) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetModeNative(objPtr, mode);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This API provides the ability to allow a room owner to set an authentication scheme (moderator pin) for moderator functionality. The same authentication scheme must be used by other users by calling VidyoConnectorRequestModeratorRole to get moderator privilege. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="moderatorPIN">authentication scheme (moderator pin) for moderator functionality.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean SetModeratorPIN(String moderatorPIN, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nModeratorPIN = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(moderatorPIN ?? string.Empty);
			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorSetModeratorPINNative(objPtr, nModeratorPIN, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			Marshal.FreeHGlobal(nModeratorPIN);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets up options on the VidyoConnector API. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="options">The options in JSON format. <p>conferenceReferenceNumber - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference.</p> <p>Example: {'conferenceReferenceNumber' : 'reference number'}.</p> <p>microphoneMaxBoostLevel - sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value. Possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.</p> <p>Example: {'microphoneMaxBoostLevel' : 10}.</p> <p>minMicrophoneVolume - sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value. Possible values are 0 - 100 percentage. Default is 50 per cent.</p> <p>Example: {'minMicrophoneVolume' : 70}.</p> <p>Possible values for audio device modes are : audioSharedModeBoth - use both audio devices (Speaker and Microphone) in shared mode. audioExclusiveModeBoth - use both audio devices (Speaker and Microphone) in exclusive mode. audioExclusiveModeMic - use microphone in exclusive mode and speaker in shared mode. By default VidyoClient is working with audioSharedModeBoth. A new mode will be applied only for the next conference or in case another device is selected.</p> <p>Example: {'audioSharedModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeMic' : true}.</p> <p>preferredAudioCodec - sets VidyoClient to use preferred audio codec. Possible value are OPUS RED, OPUS and SPEEX RED. Default is OPUS RED.</p> <p>Example: {'preferredAudioCodec' : 'SPEEX RED'}.</p> <p>AudioBitrateMultiplier - A multiplier to be used when calculating the audio bitrate. Possible values are 0, 1 and 2. Default is 2.</p> <p>Example: {'AudioBitrateMultiplier':1}.</p> <p>AudioPacketInterval - It decies audio frame duration to encoder. It sets time interval between two packet of audio in miliseconds Possible values are 20, and 40 ms. Default is 40 ms.</p> <p>Example: {'AudioPacketInterval':40}.</p> <p>AudioPacketLossPercentage - it values is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Possible values are [0, 10, 20, 30] in percentage. Default is 10%.</p> <p>Example: {'AudioPacketLossPercentage':20}.</p> <p>statRate - sets VidyoRoom statistics gather interval in seconds. Possible values are 2, 5, 10, 20 and 30. Default is 10.</p> <p>Example: {'statRate':10}.</p> <p>enableStaticShareSvc - Specifies whether SVC will be enabled or disabled for static sharing. Possible values are true or false. The default is false. Note: SVC is enabled by default for interactive video and high frame rate sharing.</p> <p>Example: {'enableStaticShareSvc' : true}.</p></param>
		public Boolean SetOptions(String options) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nOptions = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(options ?? string.Empty);
			Boolean ret = VidyoConnectorSetOptionsNative(objPtr, nOptions);
			Marshal.FreeHGlobal(nOptions);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets a specific media pool to use for audio and video. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="name">Name of the pool.</param>
		public Boolean SetPool(String name) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			Boolean ret = VidyoConnectorSetPoolNative(objPtr, nName);
			Marshal.FreeHGlobal(nName);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets VidyoClient to use preferred audio codec. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="preferredAudioCodec">Preferred audio codec to be set. For possible values of the audio codec, refer VidyoConnectorPreferredAudioCodec.</param>
		public Boolean SetPreferredAudioCodec(ConnectorPreferredAudioCodec preferredAudioCodec) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetPreferredAudioCodecNative(objPtr, preferredAudioCodec);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Set a specific participant as a presenter. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="participant">The VidyoParticipant object who will be a new presenter.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean SetPresenter(Participant participant, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorSetPresenterNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the product information. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="productInfo">Sets the product information. Supported Properties- ApplicationName, ApplicationVersion</param>
		public Boolean SetProductInfo(List<ConnectorProductInformation> productInfo) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nListProductInfo = VidyoConnectorVectorVidyoConnectorProductInformationAllocateNative();

			IntPtr nProductInfo = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * productInfo.Count);
			int nProductInfoSize = 0;
			foreach (ConnectorProductInformation iter in productInfo) {
				Marshal.WriteIntPtr(nProductInfo + (nProductInfoSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nProductInfoSize++;
			}
			VidyoConnectorSetProductInfoSetproductInfoArrayNative(nListProductInfo, nProductInfo, nProductInfoSize);
			Marshal.FreeHGlobal(nProductInfo);
			Boolean ret = VidyoConnectorSetProductInfoNative(objPtr, nListProductInfo);
			VidyoConnectorVectorVidyoConnectorProductInformationDeallocateNative(nListProductInfo);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets up the local renderer and conference tiles displaying options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform-specific view ID.</param>
		/// <param name="options">A char array that contains options in the JSON format. <p>EnableVerticalVideoCentering - Enable or disable the vertical centering of the video screen. Default is true.</p> <p>Example: {'EnableVerticalVideoCentering':true}.</p> <p>EnableFECCIconCustomLayout - Enable or disable the displaying of custom FECC icon in the right bottom corner. Default is false.</p> <p>Example: {'EnableFECCIconCustomLayout':false}.</p> <p>ViewingDistance - Sets viewing distance in feet. Default is 2.5. Minimum and Maximum values are 1f & 15f respectively.</p> <p>Example: {'ViewingDistance':2.5}.</p> <p>ShowAudioTiles - Enable or disable the showing of audio tiles. Default is true.</p> <p>Example: {'ShowAudioTiles':false}.</p> <p>SetPipPosition - Sets the position of the preview when it is displayed using picture-in-picture mode. Possible values for x: "PipPositionLeft", "PipPositionCenter", "PipPositionRight". Possible values for y: "PipPositionBottom", "PipPositionCenter", "PipPositionTop". lockPip is a boolean indicating whether to lock the preview in this position (by default is false). When false, the user may drag the preview to another location using the mouse or a touch. setPipSize - Sets the size of the preview in picture-in-picture mode. The value is a positive integer representing the percentage of the screen size (1 to 50). Default value is 1. setPipToTileAfterNTiles - Sets the number of tiles after which the preview will be displayed as a tile instead of picture-in-picture. (default value is 2) A value of 0 means the preview will always be visible in picture-in-picture mode whereas N means that the preview will be visible as tile if the number of tiles is greater than N (where N is a positive integer).</p> <p>Example: {'SetPipPosition':{'x':'PipPositionRight', 'y': 'PipPositionTop', 'lockPip':true, 'setPipSize':1, 'setPipToTileAfterNTiles':2}}.</p> <p>SetPixelDensity - Sets the rendering environment's pixel density.</p> <p>Example: {'SetPixelDensity':326.0f. However for latest rendering environment, being released for iOS only, this option is used to choose surface density with possible values as 0.5 (everything will be smaller) / 1.0 (default) / 2.0 (everything will be larger).}</p> <p>SetTouchAsInputDevice - Enable or disable touch as a input device. Default is false.</p> <p>Example: {'SetTouchAsInputDevice':false}.</p> <p>EnableExpandedCameraControl - Enable or disable expanded camera control. Default is true for mobile devices and false for non-mobile devices.</p> <p>Example: {'EnableExpandedCameraControl':false}.</p> <p>BorderStyle - Sets the border style of the preview. None: Do not put a border on any tiles. Same: Put the same colored border on each tile. Highlight: Put a border on each tile, but tiles associated with the highest ranked participant will have a different colored border than the others. Flash: Tiles associated with the highest ranked participant have a different colored border than the others, When the highest ranked participant changes, the border of the new highest ranked participant flashes momentarily. Possible values for BorderStyle: "None", "Same", "Highlight", "Flash"</p> <p>Example: {'BorderStyle':'Same'</p>} <p>enablePreviewMirroring - Specifies whether mirroring will be enabled or disabled for local cameras. Possible values are true or false. The default is true.</p> <p>Example: {'EnablePreviewMirroring' : true}.</p></param>
		public Boolean SetRendererOptionsForViewId(IntPtr viewId, String options) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nOptions = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(options ?? string.Empty);
			Boolean ret = VidyoConnectorSetRendererOptionsForViewIdNative(objPtr, ref viewId, nOptions);
			Marshal.FreeHGlobal(nOptions);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This api provides the ability to set the room pin. Once room pin is set, all other users are required to enter this room pin to join this conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="roomPIN">Pin to be set as room PIN or set NULL to remove existing room PIN</param>
		/// <param name="onSetRoomPinResult">Callback to be triggered for set room pin result.</param>
		public Boolean SetRoomPIN(String roomPIN, ISetRoomPIN _iISetRoomPIN) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mISetRoomPIN = _iISetRoomPIN;

			IntPtr nRoomPIN = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomPIN ?? string.Empty);
			Boolean ret = VidyoConnectorSetRoomPINNative(objPtr, nRoomPIN, _mOnSetRoomPINResult);
			Marshal.FreeHGlobal(nRoomPIN);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Sets the flag to mute/unmute the speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="privacy">Flag to mute/unmute the speaker.</param>
		public Boolean SetSpeakerPrivacy(Boolean privacy) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetSpeakerPrivacyNative(objPtr, privacy);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enables or disables SVC. By default SVC is disabled. Note: For interactive video and high frame rate sharing SVC is enabled by default. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="enable">Indicates whether enable SVC or not.</param>
		public Boolean SetStaticShareSvcState(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetStaticShareSvcStateNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets conference room statistics gather interval in seconds. Default is 10. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="statRate">Statistics gather interval for which possible values are 2, 5, 10, 20 and 30.</param>
		public Boolean SetStatisticRate(uint statRate) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetStatisticRateNative(objPtr, statRate);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enable the use of TCP Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="enable">Enable the tranport.</param>
		public Boolean SetTCPTransport(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetTCPTransportNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Set TURN server and credentials information. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="turnAddress">TURN server FQDN or IP address.</param>
		/// <param name="port">TURN server port.</param>
		/// <param name="username">TURN server user name.</param>
		/// <param name="password">TURN server password.</param>
		/// <param name="baseTransport">Base transport type.</param>
		public Boolean SetTURNAddressCredentials(String turnAddress, uint port, String username, String password, ConnectorBaseTransportType baseTransport) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nTurnAddress = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(turnAddress ?? string.Empty);
			IntPtr nUsername = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(username ?? string.Empty);
			IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
			Boolean ret = VidyoConnectorSetTURNAddressCredentialsNative(objPtr, nTurnAddress, port, nUsername, nPassword, baseTransport);
			Marshal.FreeHGlobal(nPassword);
			Marshal.FreeHGlobal(nUsername);
			Marshal.FreeHGlobal(nTurnAddress);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Set TURN server certificate requirement. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="required">LMI_TRUE if TURN server certificate is required.</param>
		public Boolean SetTURNServerCertificateRequired(Boolean required) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetTURNServerCertificateRequiredNative(objPtr, required);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enable the use of UDP Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="enable">Enable the tranport.</param>
		public Boolean SetUDPTransport(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetUDPTransportNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the speed of transition animation for windows moving around inside the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID to be positioned.</param>
		/// <param name="speedPercentage">Percentage of animation speed with default of 50, 100 for slowest and 0 for instant.</param>
		public Boolean SetViewAnimationSpeed(IntPtr viewId, uint speedPercentage) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetViewAnimationSpeedNative(objPtr, ref viewId, speedPercentage);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Set the background color of the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID to be positioned.</param>
		/// <param name="red">Red component of the color 0-255.</param>
		/// <param name="green">Green component of the color 0-255.</param>
		/// <param name="blue">Blue component of the color 0-255.</param>
		public Boolean SetViewBackgroundColor(IntPtr viewId, byte red, byte green, byte blue) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetViewBackgroundColorNative(objPtr, ref viewId, red, green, blue);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets path and file name to the picture that will be used for the virtual background effect. It is allowed to change picture while the effect is enabled. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="pathToPicture">Path and file name to the picture. Currently, only PNG and JPG is supported.</param>
		public Boolean SetVirtualBackgroundPicture(String pathToPicture) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nPathToPicture = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(pathToPicture ?? string.Empty);
			Boolean ret = VidyoConnectorSetVirtualBackgroundPictureNative(objPtr, nPathToPicture);
			Marshal.FreeHGlobal(nPathToPicture);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets web proxy server address and credentials. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="proxyAddress">The web proxy server address.</param>
		/// <param name="username">The web proxy server user name.</param>
		/// <param name="password">The web proxy server password.</param>
		public Boolean SetWebProxyAddressCredentials(String proxyAddress, String username, String password) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nProxyAddress = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(proxyAddress ?? string.Empty);
			IntPtr nUsername = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(username ?? string.Empty);
			IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
			Boolean ret = VidyoConnectorSetWebProxyAddressCredentialsNative(objPtr, nProxyAddress, nUsername, nPassword);
			Marshal.FreeHGlobal(nPassword);
			Marshal.FreeHGlobal(nUsername);
			Marshal.FreeHGlobal(nProxyAddress);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enable the use of WebProxy Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="enable">Enable the tranport.</param>
		public Boolean SetWebProxyTransport(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSetWebProxyTransportNative(objPtr, enable);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Enable the use of WebProxy Transport with provided web proxy server address. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="name">The name of web proxy server, it may also may be prefixed by a scheme ('http://proxy.company.com')</param>
		/// <param name="port">The port that web proxy server is running on</param>
		public Boolean SetWebProxyTransportAddress(String name, uint port) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			Boolean ret = VidyoConnectorSetWebProxyTransportAddressNative(objPtr, nName, port);
			Marshal.FreeHGlobal(nName);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Shows or hides the audio meters in the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID to be positioned.</param>
		/// <param name="showMeters">Boolean to show or hide the audio meters.</param>
		public Boolean ShowAudioMeters(IntPtr viewId, Boolean showMeters) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorShowAudioMetersNative(objPtr, ref viewId, showMeters);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the flag to show/hide the local camera preview for composite layout only. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="preview">Flag to show/hide the local camera preview.</param>
		public Boolean ShowPreview(Boolean preview) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorShowPreviewNative(objPtr, preview);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface to display statistics dialog box for a conference on desktop devices. It is not applicable for handheld devices. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="showStatisticsDialog">Boolean value that indicate to show or hide the statistics dialog.</param>
		public Boolean ShowStatisticsDialog(Boolean showStatisticsDialog) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorShowStatisticsDialogNative(objPtr, showStatisticsDialog);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID to be positioned.</param>
		/// <param name="x">X coordinate.</param>
		/// <param name="y">Y coordinate.</param>
		/// <param name="width">Width of the view.</param>
		/// <param name="height">Height of the view.</param>
		public Boolean ShowViewAt(IntPtr viewId, int x, int y, uint width, uint height) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorShowViewAtNative(objPtr, ref viewId, x, y, width, height);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID to be positioned.</param>
		/// <param name="x">X coordinate (in points).</param>
		/// <param name="y">Y coordinate (in points).</param>
		/// <param name="width">Width of the view (in points).</param>
		/// <param name="height">Height of the view (in points).</param>
		public Boolean ShowViewAtPoints(IntPtr viewId, int x, int y, uint width, uint height) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorShowViewAtPointsNative(objPtr, ref viewId, x, y, width, height);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Shows or hides the label on the view which displays the participant name or preview. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="viewId">A platform specific view ID to be positioned.</param>
		/// <param name="showLabel">Boolean to show or hide the label.</param>
		public Boolean ShowViewLabel(IntPtr viewId, Boolean showLabel) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorShowViewLabelNative(objPtr, ref viewId, showLabel);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Sets the flag to show/hide the window share preview. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="preview">Flag to show/hide the window share preview.</param>
		public Boolean ShowWindowSharePreview(Boolean preview) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorShowWindowSharePreviewNative(objPtr, preview);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Start google analytics service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="options">A structure that represent the google analytics options, plz refer VidyoConnectorGoogleAnalyticsOptions. If the user set to NULL, Vidyo Client will use default option to use google analytics.</param>
		public Boolean StartGoogleAnalyticsService(ConnectorGoogleAnalyticsOptions options) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorStartGoogleAnalyticsServiceNative(objPtr, (options != null) ? options.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Start insights service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="serverUrl">Url of Insights server.</param>
		public Boolean StartInsightsService(String serverUrl) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nServerUrl = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serverUrl ?? string.Empty);
			Boolean ret = VidyoConnectorStartInsightsServiceNative(objPtr, nServerUrl);
			Marshal.FreeHGlobal(nServerUrl);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Switch room mode to the Lecture mode. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean StartLectureMode(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorStartLectureModeNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Stops logging into current file and start logging to the next one. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean StartNextLogFile() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorStartNextLogFileNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Asynchronously starts recording a conference using the specified recording profile. Must be called on behalf of a moderator. Fails in case another recording is in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">Pointer to the VidyoConnector object.</param>
		/// <param name="recordingProfilePrefix">Recording profile prefix to start the recording with. Can be one of those provided by VidyoConnectorGetRecordingServiceProfiles or NULL - a default profile will be used.</param>
		/// <param name="onRecordingServiceStartCallback">Callback called upon completion.</param>
		public Boolean StartRecording(String recordingProfilePrefix, IStartRecording _iIStartRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIStartRecording = _iIStartRecording;

			IntPtr nRecordingProfilePrefix = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(recordingProfilePrefix ?? string.Empty);
			Boolean ret = VidyoConnectorStartRecordingNative(objPtr, nRecordingProfilePrefix, _mOnRecordingServiceStartResult);
			Marshal.FreeHGlobal(nRecordingProfilePrefix);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Stop google analytics service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean StopGoogleAnalyticsService() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorStopGoogleAnalyticsServiceNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Stop insights service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean StopInsightsService() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorStopInsightsServiceNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Switch room mode to the Group mode. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean StopLectureMode(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorStopLectureModeNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Asynchronously stops recording a conference. Must be called on behalf of a moderator. Fails in case there is no recording in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">Pointer to the VidyoConnector object.</param>
		/// <param name="onRecordingServiceStopResultCallback">Callback called upon completion.</param>
		public Boolean StopRecording(IStopRecording _iIStopRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIStopRecording = _iIStopRecording;

			Boolean ret = VidyoConnectorStopRecordingNative(objPtr, _mOnRecordingServiceStopResult);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Swap streams of the remote video sources between views. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="first">A platform specific view ID where the first remote video sources is displayed.</param>
		/// <param name="second">A platform specific view ID where the second remote video sources is displayed.</param>
		public Boolean SwapStreamsBetweenViews(IntPtr first, IntPtr second) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorSwapStreamsBetweenViewsNative(objPtr, ref first, ref second);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. This api provides the ability unlock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		/// <param name="onUnlockRoomResult">Callback to be triggered for UnlockRoom Result.</param>
		public Boolean UnlockRoom(IUnlockRoom _iIUnlockRoom) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIUnlockRoom = _iIUnlockRoom;

			Boolean ret = VidyoConnectorUnlockRoomNative(objPtr, _mOnUnlockRoomResult);

			return ret;
		}
		/// <summary>
		/// This is an asynchronous interface. Each participant can send a moderation request to remove his raised hand to cancel the request to be unmuted. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean UnraiseHand(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoConnectorUnraiseHandNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Application can unregister callback to stop bot participant event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterBotEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterBotEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters callback to notify the user in case of any errors occur during enabling camera effect.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterCameraEffectErrorListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterCameraEffectErrorListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Un-Registers the conference mode event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterConferenceModeEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterConferenceModeEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters event listener, application will not receive an event about connection properties changes. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterConnectionPropertiesEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterConnectionPropertiesEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters advanced error event notifications.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterErrorEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterErrorEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Un-Registers the host event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterHostEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterHostEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Resets the callback for in call event. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterInCallEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterInCallEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters the Lecture mode part callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLectureModeEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLectureModeEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local camera event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLocalCameraEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalCameraEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local camera frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localCamera">The VidyoLocalCamera for which to stop notifications.</param>
		public Boolean UnregisterLocalCameraFrameListener(LocalCamera localCamera) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalCameraFrameListenerNative(objPtr, (localCamera != null) ? localCamera.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local microphone energy notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLocalMicrophoneEnergyListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalMicrophoneEnergyListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local microphone event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLocalMicrophoneEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalMicrophoneEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local microphone frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localMicrophone">The VidyoLocalMicrophone for which to stop notifications.</param>
		public Boolean UnregisterLocalMicrophoneFrameListener(LocalMicrophone localMicrophone) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalMicrophoneFrameListenerNative(objPtr, (localMicrophone != null) ? localMicrophone.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local monitor event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLocalMonitorEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalMonitorEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local monitor frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localMonitor">The VidyoLocalMonitor for which to stop notifications.</param>
		public Boolean UnregisterLocalMonitorFrameListener(LocalMonitor localMonitor) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalMonitorFrameListenerNative(objPtr, (localMonitor != null) ? localMonitor.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local speaker event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLocalSpeakerEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalSpeakerEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local window share event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLocalWindowShareEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalWindowShareEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters local window share frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="localWindowShare">The VidyoLocalWindowShare for which to stop notifications.</param>
		public Boolean UnregisterLocalWindowShareFrameListener(LocalWindowShare localWindowShare) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLocalWindowShareFrameListenerNative(objPtr, (localWindowShare != null) ? localWindowShare.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters log event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterLogEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterLogEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters message event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterMessageEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterMessageEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregister a callback to do not receive moderation commands sent from the server. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		public Boolean UnregisterModerationCommandEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterModerationCommandEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregistering notifications about moderation result events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterModerationResultEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterModerationResultEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregister the callback to stop receiving the final response for the next generation renderer action. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">VidyoConnector object.</param>
		public Boolean UnregisterNGRResultEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterNGRResultEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters network interface event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterNetworkInterfaceEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterNetworkInterfaceEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters participant event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterParticipantEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterParticipantEventListenerNative(objPtr);
			_mIRegisterParticipantEventListener = null;

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters plugin. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="plugin">Plugin to unregister.</param>
		public Boolean UnregisterPlugin(ulong plugin) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterPluginNative(objPtr, plugin);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters reconnecting event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterReconnectEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterReconnectEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters recorder in call event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterRecorderInCallEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRecorderInCallEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote camera event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterRemoteCameraEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteCameraEventListenerNative(objPtr);
			_mIRegisterRemoteCameraEventListener = null;

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote camera frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="remoteCamera">The VidyoRemoteCamera for which to stop notifications.</param>
		public Boolean UnregisterRemoteCameraFrameListener(RemoteCamera remoteCamera) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteCameraFrameListenerNative(objPtr, (remoteCamera != null) ? remoteCamera.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote microphone frame notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterRemoteMicrophoneEnergyListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteMicrophoneEnergyListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote microphone event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterRemoteMicrophoneEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteMicrophoneEventListenerNative(objPtr);
			_mIRegisterRemoteMicrophoneEventListener = null;

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote microphone frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="remoteMicrophone">The VidyoRemoteMicrophone for which to stop notifications.</param>
		public Boolean UnregisterRemoteMicrophoneFrameListener(RemoteMicrophone remoteMicrophone) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteMicrophoneFrameListenerNative(objPtr, (remoteMicrophone != null) ? remoteMicrophone.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote renderer event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterRemoteRendererEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteRendererEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote speaker event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterRemoteSpeakerEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteSpeakerEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote window share event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterRemoteWindowShareEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteWindowShareEventListenerNative(objPtr);
			_mIRegisterRemoteWindowShareEventListener = null;

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters remote window share frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		/// <param name="remoteWindowShare">The VidyoRemoteWindowShare for which to stop notifications.</param>
		public Boolean UnregisterRemoteWindowShareFrameListener(RemoteWindowShare remoteWindowShare) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterRemoteWindowShareFrameListenerNative(objPtr, (remoteWindowShare != null) ? remoteWindowShare.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters resource manager event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterResourceManagerEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterResourceManagerEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous and private interface, for usage please contact vidyo api support team. Application can unregister private callback to stop receiving tokens from the vidyo portal. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterTokenReceivedEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterTokenReceivedEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters virtual audio source event notifications. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterVirtualAudioSourceEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterVirtualAudioSourceEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters virtual video source event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterVirtualVideoSourceEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterVirtualVideoSourceEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Unregisters web proxy event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
		/// </summary>
		/// <param name="c">The VidyoConnector object.</param>
		public Boolean UnregisterWebProxyEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoConnectorUnregisterWebProxyEventListenerNative(objPtr);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnAvailableResourcesChanged))]
#endif
		private static void OnAvailableResourcesChangedDelegate(IntPtr c, uint cpuEncode, uint cpuDecode, uint bandwidthSend, uint bandwidthReceive){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterResourceManagerEventListener?.OnAvailableResourcesChanged(cpuEncode, cpuDecode, bandwidthSend, bandwidthReceive);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnBotJoined))]
#endif
		private static void OnBotJoinedDelegate(IntPtr c, IntPtr info){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			ConnectorBotInfo csInfo = new ConnectorBotInfo(info);
			csC?._mIRegisterBotEventListener?.OnBotJoined(csInfo);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnBotLeft))]
#endif
		private static void OnBotLeftDelegate(IntPtr c, IntPtr info){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			ConnectorBotInfo csInfo = new ConnectorBotInfo(info);
			csC?._mIRegisterBotEventListener?.OnBotLeft(csInfo);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnCameraEffectError))]
#endif
		private static void OnCameraEffectErrorDelegate(IntPtr c, ConnectorCameraEffectError error){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterCameraEffectErrorListener?.OnCameraEffectError(error);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnChatMessageReceived))]
#endif
		private static void OnChatMessageReceivedDelegate(IntPtr c, IntPtr participant, IntPtr chatMessage){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			ChatMessage csChatMessage = new ChatMessage(chatMessage);
			csC?._mIRegisterMessageEventListener?.OnChatMessageReceived(csParticipant, csChatMessage);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConferenceHostStatusChanged))]
#endif
		private static void OnConferenceHostStatusChangedDelegate(IntPtr c, IntPtr host, ConnectorConferenceHostState hostState){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			Participant csHost = null;
			if(host != IntPtr.Zero) {
				var csHostPtr = Participant.VidyoParticipantGetUserDataNative(host);
				if (csHostPtr == IntPtr.Zero) {
					csHost = new Participant(host);
					if (csHost != null) {
						csC?.objects?.Add(new WeakReference(csHost));
					}
				} else {
					csHost = (Participant)GCHandle.FromIntPtr(csHostPtr).Target;
				}
			}

			csC?._mIRegisterHostEventListener?.OnConferenceHostStatusChanged(csHost, hostState);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConferenceLost))]
#endif
		private static void OnConferenceLostDelegate(IntPtr c, ConnectorFailReason reason){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterReconnectEventListener?.OnConferenceLost(reason);
			csC?.objects?.RemoveAll(item => (!item.IsAlive || item.Target == null));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConferenceModeChanged))]
#endif
		private static void OnConferenceModeChangedDelegate(IntPtr c, ConnectorConferenceMode mode){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterConferenceModeEventListener?.OnConferenceModeChanged(mode);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConnectionPropertiesChanged))]
#endif
		private static void OnConnectionPropertiesChangedDelegate(IntPtr c, IntPtr connectionProperties){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			ConnectorConnectionProperties csConnectionProperties = new ConnectorConnectionProperties(connectionProperties);
			csC?._mIRegisterConnectionPropertiesEventListener?.OnConnectionPropertiesChanged(csConnectionProperties);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnDisconnected))]
#endif
		private static void OnDisconnectedDelegate(IntPtr c, ConnectorDisconnectReason reason){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIConnect?.OnDisconnected(reason);
			csC?.objects?.RemoveAll(item => (!item.IsAlive || item.Target == null));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnDynamicParticipantChanged))]
#endif
		private static void OnDynamicParticipantChangedDelegate(IntPtr c, IntPtr participants){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			List<Participant> csParticipants = new List<Participant>();
			var nParticipantsSize = 0;
			var nParticipants = VidyoConnectorOnDynamicParticipantChangedGetparticipantsArrayNative(participants, ref nParticipantsSize);
			var nParticipantsIndex = 0;
			while (nParticipantsIndex < nParticipantsSize) {
				Participant csTparticipants = null;
				if(Marshal.ReadIntPtr(nParticipants + (nParticipantsIndex * Marshal.SizeOf(nParticipants))) != IntPtr.Zero) {
					var csTparticipantsPtr = Participant.VidyoParticipantGetUserDataNative(Marshal.ReadIntPtr(nParticipants + (nParticipantsIndex * Marshal.SizeOf(nParticipants))));
					if (csTparticipantsPtr == IntPtr.Zero) {
						csTparticipants = new Participant(Marshal.ReadIntPtr(nParticipants + (nParticipantsIndex * Marshal.SizeOf(nParticipants))));
						if (csTparticipants != null) {
							csC?.objects?.Add(new WeakReference(csTparticipants));
						}
					} else {
						csTparticipants = (Participant)GCHandle.FromIntPtr(csTparticipantsPtr).Target;
					}
				}

				csParticipants.Add(csTparticipants);
				nParticipantsIndex++;
			}

			csC?._mIRegisterParticipantEventListener?.OnDynamicParticipantChanged(csParticipants);
			VidyoConnectorOnDynamicParticipantChangedFreeparticipantsArrayNative(nParticipants, nParticipantsSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnError))]
#endif
		private static void OnErrorDelegate(IntPtr c, ConnectorErrorCode error, IntPtr apiName){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			var n_apiName = VidyoConnectorOnErrorGetapiNameCStr(apiName);

			csC?._mIRegisterErrorEventListener?.OnError(error, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_apiName));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnFailure))]
#endif
		private static void OnFailureDelegate(IntPtr c, ConnectorFailReason reason){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIConnect?.OnFailure(reason);
			csC?.objects?.RemoveAll(item => (!item.IsAlive || item.Target == null));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetActiveNetworkInterface))]
#endif
		private static void OnGetActiveNetworkInterfaceDelegate(IntPtr c, IntPtr signalingInterface, IntPtr mediaInterface){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			NetworkInterface csSignalingInterface = null;
			if(signalingInterface != IntPtr.Zero) {
				var csSignalingInterfacePtr = NetworkInterface.VidyoNetworkInterfaceGetUserDataNative(signalingInterface);
				if (csSignalingInterfacePtr == IntPtr.Zero) {
					csSignalingInterface = new NetworkInterface(signalingInterface);
					if (csSignalingInterface != null) {
						csC?.objects?.Add(new WeakReference(csSignalingInterface));
					}
				} else {
					csSignalingInterface = (NetworkInterface)GCHandle.FromIntPtr(csSignalingInterfacePtr).Target;
				}
			}

			NetworkInterface csMediaInterface = null;
			if(mediaInterface != IntPtr.Zero) {
				var csMediaInterfacePtr = NetworkInterface.VidyoNetworkInterfaceGetUserDataNative(mediaInterface);
				if (csMediaInterfacePtr == IntPtr.Zero) {
					csMediaInterface = new NetworkInterface(mediaInterface);
					if (csMediaInterface != null) {
						csC?.objects?.Add(new WeakReference(csMediaInterface));
					}
				} else {
					csMediaInterface = (NetworkInterface)GCHandle.FromIntPtr(csMediaInterfacePtr).Target;
				}
			}

			csC?._mIGetActiveNetworkInterface?.OnGetActiveNetworkInterface(csSignalingInterface, csMediaInterface);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetAutoReconnectSetting))]
#endif
		private static void OnGetAutoReconnectSettingDelegate(IntPtr c, Boolean enableAutoReconnect, uint reconnectBackoff, uint maxReconnectAttempts){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIGetAutoReconnectSetting?.OnGetAutoReconnectSetting(enableAutoReconnect, reconnectBackoff, maxReconnectAttempts);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetCameraBackgroundEffectInfo))]
#endif
		private static void OnGetCameraBackgroundEffectInfoDelegate(IntPtr c, IntPtr effectInfo){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			ConnectorCameraEffectInfo csEffectInfo = new ConnectorCameraEffectInfo(effectInfo);
			csC?._mIGetCameraBackgroundEffect?.OnGetCameraBackgroundEffectInfo(csEffectInfo);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetGoogleAnalyticsEventTable))]
#endif
		private static void OnGetGoogleAnalyticsEventTableDelegate(IntPtr c, IntPtr eventTable){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			List<ConnectorGoogleAnalyticsEventTable> csEventTable = new List<ConnectorGoogleAnalyticsEventTable>();
			var nEventTableSize = 0;
			var nEventTable = VidyoConnectorOnGetGoogleAnalyticsEventTableGeteventTableArrayNative(eventTable, ref nEventTableSize);
			var nEventTableIndex = 0;
			while (nEventTableIndex < nEventTableSize) {
				ConnectorGoogleAnalyticsEventTable csTeventTable = new ConnectorGoogleAnalyticsEventTable(Marshal.ReadIntPtr(nEventTable + (nEventTableIndex * Marshal.SizeOf(nEventTable))));
				csEventTable.Add(csTeventTable);
				nEventTableIndex++;
			}

			csC?._mIGetGoogleAnalyticsEventTable?.OnGetGoogleAnalyticsEventTable(csEventTable);
			VidyoConnectorOnGetGoogleAnalyticsEventTableFreeeventTableArrayNative(nEventTable, nEventTableSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetGoogleAnalyticsOptions))]
#endif
		private static void OnGetGoogleAnalyticsOptionsDelegate(IntPtr c, IntPtr options){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			ConnectorGoogleAnalyticsOptions csOptions = new ConnectorGoogleAnalyticsOptions(options);
			csC?._mIGetGoogleAnalyticsOptions?.OnGetGoogleAnalyticsOptions(csOptions);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetRecordingServiceProfiles))]
#endif
		private static void OnGetRecordingServiceProfilesDelegate(IntPtr c, IntPtr profiles, IntPtr prefixes, ConnectorRecordingServiceResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			List<String> csProfiles = new List<String>();
			var nProfilesSize = 0;
			var nProfiles = VidyoConnectorOnGetRecordingServiceProfilesGetprofilesArrayNative(profiles, ref nProfilesSize);
			var nProfilesIndex = 0;
			while (nProfilesIndex < nProfilesSize) {
				csProfiles.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nProfiles + (nProfilesIndex * Marshal.SizeOf(nProfiles)))));
				nProfilesIndex++;
			}

			List<String> csPrefixes = new List<String>();
			var nPrefixesSize = 0;
			var nPrefixes = VidyoConnectorOnGetRecordingServiceProfilesGetprefixesArrayNative(prefixes, ref nPrefixesSize);
			var nPrefixesIndex = 0;
			while (nPrefixesIndex < nPrefixesSize) {
				csPrefixes.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nPrefixes + (nPrefixesIndex * Marshal.SizeOf(nPrefixes)))));
				nPrefixesIndex++;
			}

			csC?._mIGetRecordingServiceProfiles?.OnGetRecordingServiceProfiles(csProfiles, csPrefixes, result);
			VidyoConnectorOnGetRecordingServiceProfilesFreeprefixesArrayNative(nPrefixes, nPrefixesSize);
			VidyoConnectorOnGetRecordingServiceProfilesFreeprofilesArrayNative(nProfiles, nProfilesSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetWhitelistedAudioDevices))]
#endif
		private static void OnGetWhitelistedAudioDevicesDelegate(IntPtr c, IntPtr audioDevices){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			List<String> csAudioDevices = new List<String>();
			var nAudioDevicesSize = 0;
			var nAudioDevices = VidyoConnectorOnGetWhitelistedAudioDevicesGetaudioDevicesArrayNative(audioDevices, ref nAudioDevicesSize);
			var nAudioDevicesIndex = 0;
			while (nAudioDevicesIndex < nAudioDevicesSize) {
				csAudioDevices.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nAudioDevices + (nAudioDevicesIndex * Marshal.SizeOf(nAudioDevices)))));
				nAudioDevicesIndex++;
			}

			csC?._mIGetWhitelistedAudioDevices?.OnGetWhitelistedAudioDevices(csAudioDevices);
			VidyoConnectorOnGetWhitelistedAudioDevicesFreeaudioDevicesArrayNative(nAudioDevices, nAudioDevicesSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnHandRaised))]
#endif
		private static void OnHandRaisedDelegate(IntPtr c, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			List<Participant> csParticipant = new List<Participant>();
			var nParticipantSize = 0;
			var nParticipant = VidyoConnectorOnHandRaisedGetparticipantArrayNative(participant, ref nParticipantSize);
			var nParticipantIndex = 0;
			while (nParticipantIndex < nParticipantSize) {
				Participant csTparticipant = null;
				if(Marshal.ReadIntPtr(nParticipant + (nParticipantIndex * Marshal.SizeOf(nParticipant))) != IntPtr.Zero) {
					var csTparticipantPtr = Participant.VidyoParticipantGetUserDataNative(Marshal.ReadIntPtr(nParticipant + (nParticipantIndex * Marshal.SizeOf(nParticipant))));
					if (csTparticipantPtr == IntPtr.Zero) {
						csTparticipant = new Participant(Marshal.ReadIntPtr(nParticipant + (nParticipantIndex * Marshal.SizeOf(nParticipant))));
						if (csTparticipant != null) {
							csC?.objects?.Add(new WeakReference(csTparticipant));
						}
					} else {
						csTparticipant = (Participant)GCHandle.FromIntPtr(csTparticipantPtr).Target;
					}
				}

				csParticipant.Add(csTparticipant);
				nParticipantIndex++;
			}

			csC?._mIRegisterLectureModeEventListener?.OnHandRaised(csParticipant);
			VidyoConnectorOnHandRaisedFreeparticipantArrayNative(nParticipant, nParticipantSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnInCallEvents))]
#endif
		private static void OnInCallEventsDelegate(IntPtr c, IntPtr ev){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			ConnectorInCallEvent csEv = new ConnectorInCallEvent(ev);
			csC?._mIRegisterInCallEventListener?.OnInCallEvents(csEv);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnInviteResult))]
#endif
		private static void OnInviteResultDelegate(IntPtr c, IntPtr inviteeId, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			var n_inviteeId = VidyoConnectorOnInviteResultGetinviteeIdCStr(inviteeId);

			csC?._mIInviteParticipant?.OnInviteResult((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_inviteeId), result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalCameraAdded))]
#endif
		private static void OnLocalCameraAddedDelegate(IntPtr c, IntPtr localCamera){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalCamera csLocalCamera = null;
			if(localCamera != IntPtr.Zero) {
				var csLocalCameraPtr = LocalCamera.VidyoLocalCameraGetUserDataNative(localCamera);
				if (csLocalCameraPtr == IntPtr.Zero) {
					csLocalCamera = new LocalCamera(localCamera);
					if (csLocalCamera != null) {
						csC?.objects?.Add(new WeakReference(csLocalCamera));
					}
				} else {
					csLocalCamera = (LocalCamera)GCHandle.FromIntPtr(csLocalCameraPtr).Target;
				}
			}

			csC?._mIRegisterLocalCameraEventListener?.OnLocalCameraAdded(csLocalCamera);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalCameraFrame))]
#endif
		private static void OnLocalCameraFrameDelegate(IntPtr c, IntPtr localCamera, IntPtr videoFrame){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalCamera csLocalCamera = null;
			if(localCamera != IntPtr.Zero) {
				var csLocalCameraPtr = LocalCamera.VidyoLocalCameraGetUserDataNative(localCamera);
				if (csLocalCameraPtr == IntPtr.Zero) {
					csLocalCamera = new LocalCamera(localCamera);
					if (csLocalCamera != null) {
						csC?.objects?.Add(new WeakReference(csLocalCamera));
					}
				} else {
					csLocalCamera = (LocalCamera)GCHandle.FromIntPtr(csLocalCameraPtr).Target;
				}
			}

			VideoFrame csVideoFrame = null;
			if(videoFrame != IntPtr.Zero) {
				var csVideoFramePtr = VideoFrame.VidyoVideoFrameGetUserDataNative(videoFrame);
				csVideoFrame = csVideoFramePtr == IntPtr.Zero ? new VideoFrame(videoFrame) : (VideoFrame)GCHandle.FromIntPtr(csVideoFramePtr).Target;
			}

			csC?._mIRegisterLocalCameraFrameListener?.OnLocalCameraFrame(csLocalCamera, csVideoFrame);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalCameraRemoved))]
#endif
		private static void OnLocalCameraRemovedDelegate(IntPtr c, IntPtr localCamera){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalCamera csLocalCamera = null;
			if(localCamera != IntPtr.Zero) {
				var csLocalCameraPtr = LocalCamera.VidyoLocalCameraGetUserDataNative(localCamera);
				if (csLocalCameraPtr == IntPtr.Zero) {
					csLocalCamera = new LocalCamera(localCamera);
					if (csLocalCamera != null) {
						csC?.objects?.Add(new WeakReference(csLocalCamera));
					}
				} else {
					csLocalCamera = (LocalCamera)GCHandle.FromIntPtr(csLocalCameraPtr).Target;
				}
			}

			csC?._mIRegisterLocalCameraEventListener?.OnLocalCameraRemoved(csLocalCamera);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalCameraSelected))]
#endif
		private static void OnLocalCameraSelectedDelegate(IntPtr c, IntPtr localCamera){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalCamera csLocalCamera = null;
			if(localCamera != IntPtr.Zero) {
				var csLocalCameraPtr = LocalCamera.VidyoLocalCameraGetUserDataNative(localCamera);
				if (csLocalCameraPtr == IntPtr.Zero) {
					csLocalCamera = new LocalCamera(localCamera);
					if (csLocalCamera != null) {
						csC?.objects?.Add(new WeakReference(csLocalCamera));
					}
				} else {
					csLocalCamera = (LocalCamera)GCHandle.FromIntPtr(csLocalCameraPtr).Target;
				}
			}

			csC?._mIRegisterLocalCameraEventListener?.OnLocalCameraSelected(csLocalCamera);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalCameraStateUpdated))]
#endif
		private static void OnLocalCameraStateUpdatedDelegate(IntPtr c, IntPtr localCamera, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalCamera csLocalCamera = null;
			if(localCamera != IntPtr.Zero) {
				var csLocalCameraPtr = LocalCamera.VidyoLocalCameraGetUserDataNative(localCamera);
				if (csLocalCameraPtr == IntPtr.Zero) {
					csLocalCamera = new LocalCamera(localCamera);
					if (csLocalCamera != null) {
						csC?.objects?.Add(new WeakReference(csLocalCamera));
					}
				} else {
					csLocalCamera = (LocalCamera)GCHandle.FromIntPtr(csLocalCameraPtr).Target;
				}
			}

			csC?._mIRegisterLocalCameraEventListener?.OnLocalCameraStateUpdated(csLocalCamera, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMicrophoneAdded))]
#endif
		private static void OnLocalMicrophoneAddedDelegate(IntPtr c, IntPtr localMicrophone){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMicrophone csLocalMicrophone = null;
			if(localMicrophone != IntPtr.Zero) {
				var csLocalMicrophonePtr = LocalMicrophone.VidyoLocalMicrophoneGetUserDataNative(localMicrophone);
				if (csLocalMicrophonePtr == IntPtr.Zero) {
					csLocalMicrophone = new LocalMicrophone(localMicrophone);
					if (csLocalMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csLocalMicrophone));
					}
				} else {
					csLocalMicrophone = (LocalMicrophone)GCHandle.FromIntPtr(csLocalMicrophonePtr).Target;
				}
			}

			csC?._mIRegisterLocalMicrophoneEventListener?.OnLocalMicrophoneAdded(csLocalMicrophone);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMicrophoneEnergy))]
#endif
		private static void OnLocalMicrophoneEnergyDelegate(IntPtr c, IntPtr localMicrophone, int audioEnergy){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMicrophone csLocalMicrophone = null;
			if(localMicrophone != IntPtr.Zero) {
				var csLocalMicrophonePtr = LocalMicrophone.VidyoLocalMicrophoneGetUserDataNative(localMicrophone);
				if (csLocalMicrophonePtr == IntPtr.Zero) {
					csLocalMicrophone = new LocalMicrophone(localMicrophone);
					if (csLocalMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csLocalMicrophone));
					}
				} else {
					csLocalMicrophone = (LocalMicrophone)GCHandle.FromIntPtr(csLocalMicrophonePtr).Target;
				}
			}

			csC?._mIRegisterLocalMicrophoneEnergyListener?.OnLocalMicrophoneEnergy(csLocalMicrophone, audioEnergy);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMicrophoneFrame))]
#endif
		private static void OnLocalMicrophoneFrameDelegate(IntPtr c, IntPtr localMicrophone, IntPtr audioFrame){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMicrophone csLocalMicrophone = null;
			if(localMicrophone != IntPtr.Zero) {
				var csLocalMicrophonePtr = LocalMicrophone.VidyoLocalMicrophoneGetUserDataNative(localMicrophone);
				if (csLocalMicrophonePtr == IntPtr.Zero) {
					csLocalMicrophone = new LocalMicrophone(localMicrophone);
					if (csLocalMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csLocalMicrophone));
					}
				} else {
					csLocalMicrophone = (LocalMicrophone)GCHandle.FromIntPtr(csLocalMicrophonePtr).Target;
				}
			}

			AudioFrame csAudioFrame = null;
			if(audioFrame != IntPtr.Zero) {
				var csAudioFramePtr = AudioFrame.VidyoAudioFrameGetUserDataNative(audioFrame);
				csAudioFrame = csAudioFramePtr == IntPtr.Zero ? new AudioFrame(audioFrame) : (AudioFrame)GCHandle.FromIntPtr(csAudioFramePtr).Target;
			}

			csC?._mIRegisterLocalMicrophoneFrameListener?.OnLocalMicrophoneFrame(csLocalMicrophone, csAudioFrame);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMicrophoneRemoved))]
#endif
		private static void OnLocalMicrophoneRemovedDelegate(IntPtr c, IntPtr localMicrophone){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMicrophone csLocalMicrophone = null;
			if(localMicrophone != IntPtr.Zero) {
				var csLocalMicrophonePtr = LocalMicrophone.VidyoLocalMicrophoneGetUserDataNative(localMicrophone);
				if (csLocalMicrophonePtr == IntPtr.Zero) {
					csLocalMicrophone = new LocalMicrophone(localMicrophone);
					if (csLocalMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csLocalMicrophone));
					}
				} else {
					csLocalMicrophone = (LocalMicrophone)GCHandle.FromIntPtr(csLocalMicrophonePtr).Target;
				}
			}

			csC?._mIRegisterLocalMicrophoneEventListener?.OnLocalMicrophoneRemoved(csLocalMicrophone);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMicrophoneSelected))]
#endif
		private static void OnLocalMicrophoneSelectedDelegate(IntPtr c, IntPtr localMicrophone){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMicrophone csLocalMicrophone = null;
			if(localMicrophone != IntPtr.Zero) {
				var csLocalMicrophonePtr = LocalMicrophone.VidyoLocalMicrophoneGetUserDataNative(localMicrophone);
				if (csLocalMicrophonePtr == IntPtr.Zero) {
					csLocalMicrophone = new LocalMicrophone(localMicrophone);
					if (csLocalMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csLocalMicrophone));
					}
				} else {
					csLocalMicrophone = (LocalMicrophone)GCHandle.FromIntPtr(csLocalMicrophonePtr).Target;
				}
			}

			csC?._mIRegisterLocalMicrophoneEventListener?.OnLocalMicrophoneSelected(csLocalMicrophone);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMicrophoneStateUpdated))]
#endif
		private static void OnLocalMicrophoneStateUpdatedDelegate(IntPtr c, IntPtr localMicrophone, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMicrophone csLocalMicrophone = null;
			if(localMicrophone != IntPtr.Zero) {
				var csLocalMicrophonePtr = LocalMicrophone.VidyoLocalMicrophoneGetUserDataNative(localMicrophone);
				if (csLocalMicrophonePtr == IntPtr.Zero) {
					csLocalMicrophone = new LocalMicrophone(localMicrophone);
					if (csLocalMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csLocalMicrophone));
					}
				} else {
					csLocalMicrophone = (LocalMicrophone)GCHandle.FromIntPtr(csLocalMicrophonePtr).Target;
				}
			}

			csC?._mIRegisterLocalMicrophoneEventListener?.OnLocalMicrophoneStateUpdated(csLocalMicrophone, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMonitorAdded))]
#endif
		private static void OnLocalMonitorAddedDelegate(IntPtr c, IntPtr localMonitor){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMonitor csLocalMonitor = null;
			if(localMonitor != IntPtr.Zero) {
				var csLocalMonitorPtr = LocalMonitor.VidyoLocalMonitorGetUserDataNative(localMonitor);
				if (csLocalMonitorPtr == IntPtr.Zero) {
					csLocalMonitor = new LocalMonitor(localMonitor);
					if (csLocalMonitor != null) {
						csC?.objects?.Add(new WeakReference(csLocalMonitor));
					}
				} else {
					csLocalMonitor = (LocalMonitor)GCHandle.FromIntPtr(csLocalMonitorPtr).Target;
				}
			}

			csC?._mIRegisterLocalMonitorEventListener?.OnLocalMonitorAdded(csLocalMonitor);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMonitorFrame))]
#endif
		private static void OnLocalMonitorFrameDelegate(IntPtr c, IntPtr localMonitor, IntPtr videoFrame){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMonitor csLocalMonitor = null;
			if(localMonitor != IntPtr.Zero) {
				var csLocalMonitorPtr = LocalMonitor.VidyoLocalMonitorGetUserDataNative(localMonitor);
				if (csLocalMonitorPtr == IntPtr.Zero) {
					csLocalMonitor = new LocalMonitor(localMonitor);
					if (csLocalMonitor != null) {
						csC?.objects?.Add(new WeakReference(csLocalMonitor));
					}
				} else {
					csLocalMonitor = (LocalMonitor)GCHandle.FromIntPtr(csLocalMonitorPtr).Target;
				}
			}

			VideoFrame csVideoFrame = null;
			if(videoFrame != IntPtr.Zero) {
				var csVideoFramePtr = VideoFrame.VidyoVideoFrameGetUserDataNative(videoFrame);
				csVideoFrame = csVideoFramePtr == IntPtr.Zero ? new VideoFrame(videoFrame) : (VideoFrame)GCHandle.FromIntPtr(csVideoFramePtr).Target;
			}

			csC?._mIRegisterLocalMonitorFrameListener?.OnLocalMonitorFrame(csLocalMonitor, csVideoFrame);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMonitorRemoved))]
#endif
		private static void OnLocalMonitorRemovedDelegate(IntPtr c, IntPtr localMonitor){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMonitor csLocalMonitor = null;
			if(localMonitor != IntPtr.Zero) {
				var csLocalMonitorPtr = LocalMonitor.VidyoLocalMonitorGetUserDataNative(localMonitor);
				if (csLocalMonitorPtr == IntPtr.Zero) {
					csLocalMonitor = new LocalMonitor(localMonitor);
					if (csLocalMonitor != null) {
						csC?.objects?.Add(new WeakReference(csLocalMonitor));
					}
				} else {
					csLocalMonitor = (LocalMonitor)GCHandle.FromIntPtr(csLocalMonitorPtr).Target;
				}
			}

			csC?._mIRegisterLocalMonitorEventListener?.OnLocalMonitorRemoved(csLocalMonitor);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMonitorSelected))]
#endif
		private static void OnLocalMonitorSelectedDelegate(IntPtr c, IntPtr localMonitor){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMonitor csLocalMonitor = null;
			if(localMonitor != IntPtr.Zero) {
				var csLocalMonitorPtr = LocalMonitor.VidyoLocalMonitorGetUserDataNative(localMonitor);
				if (csLocalMonitorPtr == IntPtr.Zero) {
					csLocalMonitor = new LocalMonitor(localMonitor);
					if (csLocalMonitor != null) {
						csC?.objects?.Add(new WeakReference(csLocalMonitor));
					}
				} else {
					csLocalMonitor = (LocalMonitor)GCHandle.FromIntPtr(csLocalMonitorPtr).Target;
				}
			}

			csC?._mIRegisterLocalMonitorEventListener?.OnLocalMonitorSelected(csLocalMonitor);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalMonitorStateUpdated))]
#endif
		private static void OnLocalMonitorStateUpdatedDelegate(IntPtr c, IntPtr localMonitor, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalMonitor csLocalMonitor = null;
			if(localMonitor != IntPtr.Zero) {
				var csLocalMonitorPtr = LocalMonitor.VidyoLocalMonitorGetUserDataNative(localMonitor);
				if (csLocalMonitorPtr == IntPtr.Zero) {
					csLocalMonitor = new LocalMonitor(localMonitor);
					if (csLocalMonitor != null) {
						csC?.objects?.Add(new WeakReference(csLocalMonitor));
					}
				} else {
					csLocalMonitor = (LocalMonitor)GCHandle.FromIntPtr(csLocalMonitorPtr).Target;
				}
			}

			csC?._mIRegisterLocalMonitorEventListener?.OnLocalMonitorStateUpdated(csLocalMonitor, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalSpeakerAdded))]
#endif
		private static void OnLocalSpeakerAddedDelegate(IntPtr c, IntPtr localSpeaker){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalSpeaker csLocalSpeaker = null;
			if(localSpeaker != IntPtr.Zero) {
				var csLocalSpeakerPtr = LocalSpeaker.VidyoLocalSpeakerGetUserDataNative(localSpeaker);
				if (csLocalSpeakerPtr == IntPtr.Zero) {
					csLocalSpeaker = new LocalSpeaker(localSpeaker);
					if (csLocalSpeaker != null) {
						csC?.objects?.Add(new WeakReference(csLocalSpeaker));
					}
				} else {
					csLocalSpeaker = (LocalSpeaker)GCHandle.FromIntPtr(csLocalSpeakerPtr).Target;
				}
			}

			csC?._mIRegisterLocalSpeakerEventListener?.OnLocalSpeakerAdded(csLocalSpeaker);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalSpeakerRemoved))]
#endif
		private static void OnLocalSpeakerRemovedDelegate(IntPtr c, IntPtr localSpeaker){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalSpeaker csLocalSpeaker = null;
			if(localSpeaker != IntPtr.Zero) {
				var csLocalSpeakerPtr = LocalSpeaker.VidyoLocalSpeakerGetUserDataNative(localSpeaker);
				if (csLocalSpeakerPtr == IntPtr.Zero) {
					csLocalSpeaker = new LocalSpeaker(localSpeaker);
					if (csLocalSpeaker != null) {
						csC?.objects?.Add(new WeakReference(csLocalSpeaker));
					}
				} else {
					csLocalSpeaker = (LocalSpeaker)GCHandle.FromIntPtr(csLocalSpeakerPtr).Target;
				}
			}

			csC?._mIRegisterLocalSpeakerEventListener?.OnLocalSpeakerRemoved(csLocalSpeaker);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalSpeakerSelected))]
#endif
		private static void OnLocalSpeakerSelectedDelegate(IntPtr c, IntPtr localSpeaker){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalSpeaker csLocalSpeaker = null;
			if(localSpeaker != IntPtr.Zero) {
				var csLocalSpeakerPtr = LocalSpeaker.VidyoLocalSpeakerGetUserDataNative(localSpeaker);
				if (csLocalSpeakerPtr == IntPtr.Zero) {
					csLocalSpeaker = new LocalSpeaker(localSpeaker);
					if (csLocalSpeaker != null) {
						csC?.objects?.Add(new WeakReference(csLocalSpeaker));
					}
				} else {
					csLocalSpeaker = (LocalSpeaker)GCHandle.FromIntPtr(csLocalSpeakerPtr).Target;
				}
			}

			csC?._mIRegisterLocalSpeakerEventListener?.OnLocalSpeakerSelected(csLocalSpeaker);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalSpeakerStateUpdated))]
#endif
		private static void OnLocalSpeakerStateUpdatedDelegate(IntPtr c, IntPtr localSpeaker, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalSpeaker csLocalSpeaker = null;
			if(localSpeaker != IntPtr.Zero) {
				var csLocalSpeakerPtr = LocalSpeaker.VidyoLocalSpeakerGetUserDataNative(localSpeaker);
				if (csLocalSpeakerPtr == IntPtr.Zero) {
					csLocalSpeaker = new LocalSpeaker(localSpeaker);
					if (csLocalSpeaker != null) {
						csC?.objects?.Add(new WeakReference(csLocalSpeaker));
					}
				} else {
					csLocalSpeaker = (LocalSpeaker)GCHandle.FromIntPtr(csLocalSpeakerPtr).Target;
				}
			}

			csC?._mIRegisterLocalSpeakerEventListener?.OnLocalSpeakerStateUpdated(csLocalSpeaker, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalWindowShareAdded))]
#endif
		private static void OnLocalWindowShareAddedDelegate(IntPtr c, IntPtr localWindowShare){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalWindowShare csLocalWindowShare = null;
			if(localWindowShare != IntPtr.Zero) {
				var csLocalWindowSharePtr = LocalWindowShare.VidyoLocalWindowShareGetUserDataNative(localWindowShare);
				if (csLocalWindowSharePtr == IntPtr.Zero) {
					csLocalWindowShare = new LocalWindowShare(localWindowShare);
					if (csLocalWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csLocalWindowShare));
					}
				} else {
					csLocalWindowShare = (LocalWindowShare)GCHandle.FromIntPtr(csLocalWindowSharePtr).Target;
				}
			}

			csC?._mIRegisterLocalWindowShareEventListener?.OnLocalWindowShareAdded(csLocalWindowShare);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalWindowShareFrame))]
#endif
		private static void OnLocalWindowShareFrameDelegate(IntPtr c, IntPtr localWindowShare, IntPtr videoFrame){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalWindowShare csLocalWindowShare = null;
			if(localWindowShare != IntPtr.Zero) {
				var csLocalWindowSharePtr = LocalWindowShare.VidyoLocalWindowShareGetUserDataNative(localWindowShare);
				if (csLocalWindowSharePtr == IntPtr.Zero) {
					csLocalWindowShare = new LocalWindowShare(localWindowShare);
					if (csLocalWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csLocalWindowShare));
					}
				} else {
					csLocalWindowShare = (LocalWindowShare)GCHandle.FromIntPtr(csLocalWindowSharePtr).Target;
				}
			}

			VideoFrame csVideoFrame = null;
			if(videoFrame != IntPtr.Zero) {
				var csVideoFramePtr = VideoFrame.VidyoVideoFrameGetUserDataNative(videoFrame);
				csVideoFrame = csVideoFramePtr == IntPtr.Zero ? new VideoFrame(videoFrame) : (VideoFrame)GCHandle.FromIntPtr(csVideoFramePtr).Target;
			}

			csC?._mIRegisterLocalWindowShareFrameListener?.OnLocalWindowShareFrame(csLocalWindowShare, csVideoFrame);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalWindowShareRemoved))]
#endif
		private static void OnLocalWindowShareRemovedDelegate(IntPtr c, IntPtr localWindowShare){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalWindowShare csLocalWindowShare = null;
			if(localWindowShare != IntPtr.Zero) {
				var csLocalWindowSharePtr = LocalWindowShare.VidyoLocalWindowShareGetUserDataNative(localWindowShare);
				if (csLocalWindowSharePtr == IntPtr.Zero) {
					csLocalWindowShare = new LocalWindowShare(localWindowShare);
					if (csLocalWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csLocalWindowShare));
					}
				} else {
					csLocalWindowShare = (LocalWindowShare)GCHandle.FromIntPtr(csLocalWindowSharePtr).Target;
				}
			}

			csC?._mIRegisterLocalWindowShareEventListener?.OnLocalWindowShareRemoved(csLocalWindowShare);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalWindowShareSelected))]
#endif
		private static void OnLocalWindowShareSelectedDelegate(IntPtr c, IntPtr localWindowShare){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalWindowShare csLocalWindowShare = null;
			if(localWindowShare != IntPtr.Zero) {
				var csLocalWindowSharePtr = LocalWindowShare.VidyoLocalWindowShareGetUserDataNative(localWindowShare);
				if (csLocalWindowSharePtr == IntPtr.Zero) {
					csLocalWindowShare = new LocalWindowShare(localWindowShare);
					if (csLocalWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csLocalWindowShare));
					}
				} else {
					csLocalWindowShare = (LocalWindowShare)GCHandle.FromIntPtr(csLocalWindowSharePtr).Target;
				}
			}

			csC?._mIRegisterLocalWindowShareEventListener?.OnLocalWindowShareSelected(csLocalWindowShare);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLocalWindowShareStateUpdated))]
#endif
		private static void OnLocalWindowShareStateUpdatedDelegate(IntPtr c, IntPtr localWindowShare, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LocalWindowShare csLocalWindowShare = null;
			if(localWindowShare != IntPtr.Zero) {
				var csLocalWindowSharePtr = LocalWindowShare.VidyoLocalWindowShareGetUserDataNative(localWindowShare);
				if (csLocalWindowSharePtr == IntPtr.Zero) {
					csLocalWindowShare = new LocalWindowShare(localWindowShare);
					if (csLocalWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csLocalWindowShare));
					}
				} else {
					csLocalWindowShare = (LocalWindowShare)GCHandle.FromIntPtr(csLocalWindowSharePtr).Target;
				}
			}

			csC?._mIRegisterLocalWindowShareEventListener?.OnLocalWindowShareStateUpdated(csLocalWindowShare, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLockRoomResult))]
#endif
		private static void OnLockRoomResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mILockRoom?.OnLockRoomResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLog))]
#endif
		private static void OnLogDelegate(IntPtr c, IntPtr logRecord){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			LogRecord csLogRecord = new LogRecord(logRecord);
			csC?._mIRegisterLogEventListener?.OnLog(csLogRecord);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLoudestParticipantChanged))]
#endif
		private static void OnLoudestParticipantChangedDelegate(IntPtr c, IntPtr participant, Boolean audioOnly){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterParticipantEventListener?.OnLoudestParticipantChanged(csParticipant, audioOnly);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMaxRemoteSourcesChanged))]
#endif
		private static void OnMaxRemoteSourcesChangedDelegate(IntPtr c, uint maxRemoteSources){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterResourceManagerEventListener?.OnMaxRemoteSourcesChanged(maxRemoteSources);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnModerationCommandReceived))]
#endif
		private static void OnModerationCommandReceivedDelegate(IntPtr c, Device.DeviceType deviceType, Room.RoomModerationType moderationType, Boolean state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterModerationCommandEventListener?.OnModerationCommandReceived(deviceType, moderationType, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnModerationResult))]
#endif
		private static void OnModerationResultDelegate(IntPtr c, IntPtr participant, ConnectorModerationResult result, ConnectorModerationActionType action, IntPtr requestId){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			var n_requestId = VidyoConnectorOnModerationResultGetrequestIdCStr(requestId);

			csC?._mIRegisterModerationResultEventListener?.OnModerationResult(csParticipant, result, action, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_requestId));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnNGRResult))]
#endif
		private static void OnNGRResultDelegate(IntPtr c, ConnectorNGRActionType type, Boolean success, IntPtr error){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			var n_error = VidyoConnectorOnNGRResultGeterrorCStr(error);

			csC?._mIRegisterNGRResultEventListener?.OnNGRResult(type, success, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_error));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnNetworkInterfaceAdded))]
#endif
		private static void OnNetworkInterfaceAddedDelegate(IntPtr c, IntPtr networkInterface){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			NetworkInterface csNetworkInterface = null;
			if(networkInterface != IntPtr.Zero) {
				var csNetworkInterfacePtr = NetworkInterface.VidyoNetworkInterfaceGetUserDataNative(networkInterface);
				if (csNetworkInterfacePtr == IntPtr.Zero) {
					csNetworkInterface = new NetworkInterface(networkInterface);
					if (csNetworkInterface != null) {
						csC?.objects?.Add(new WeakReference(csNetworkInterface));
					}
				} else {
					csNetworkInterface = (NetworkInterface)GCHandle.FromIntPtr(csNetworkInterfacePtr).Target;
				}
			}

			csC?._mIRegisterNetworkInterfaceEventListener?.OnNetworkInterfaceAdded(csNetworkInterface);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnNetworkInterfaceRemoved))]
#endif
		private static void OnNetworkInterfaceRemovedDelegate(IntPtr c, IntPtr networkInterface){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			NetworkInterface csNetworkInterface = null;
			if(networkInterface != IntPtr.Zero) {
				var csNetworkInterfacePtr = NetworkInterface.VidyoNetworkInterfaceGetUserDataNative(networkInterface);
				if (csNetworkInterfacePtr == IntPtr.Zero) {
					csNetworkInterface = new NetworkInterface(networkInterface);
					if (csNetworkInterface != null) {
						csC?.objects?.Add(new WeakReference(csNetworkInterface));
					}
				} else {
					csNetworkInterface = (NetworkInterface)GCHandle.FromIntPtr(csNetworkInterfacePtr).Target;
				}
			}

			csC?._mIRegisterNetworkInterfaceEventListener?.OnNetworkInterfaceRemoved(csNetworkInterface);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnNetworkInterfaceSelected))]
#endif
		private static void OnNetworkInterfaceSelectedDelegate(IntPtr c, IntPtr networkInterface, NetworkInterface.NetworkInterfaceTransportType transportType){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			NetworkInterface csNetworkInterface = null;
			if(networkInterface != IntPtr.Zero) {
				var csNetworkInterfacePtr = NetworkInterface.VidyoNetworkInterfaceGetUserDataNative(networkInterface);
				if (csNetworkInterfacePtr == IntPtr.Zero) {
					csNetworkInterface = new NetworkInterface(networkInterface);
					if (csNetworkInterface != null) {
						csC?.objects?.Add(new WeakReference(csNetworkInterface));
					}
				} else {
					csNetworkInterface = (NetworkInterface)GCHandle.FromIntPtr(csNetworkInterfacePtr).Target;
				}
			}

			csC?._mIRegisterNetworkInterfaceEventListener?.OnNetworkInterfaceSelected(csNetworkInterface, transportType);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnNetworkInterfaceStateUpdated))]
#endif
		private static void OnNetworkInterfaceStateUpdatedDelegate(IntPtr c, IntPtr networkInterface, NetworkInterface.NetworkInterfaceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			NetworkInterface csNetworkInterface = null;
			if(networkInterface != IntPtr.Zero) {
				var csNetworkInterfacePtr = NetworkInterface.VidyoNetworkInterfaceGetUserDataNative(networkInterface);
				if (csNetworkInterfacePtr == IntPtr.Zero) {
					csNetworkInterface = new NetworkInterface(networkInterface);
					if (csNetworkInterface != null) {
						csC?.objects?.Add(new WeakReference(csNetworkInterface));
					}
				} else {
					csNetworkInterface = (NetworkInterface)GCHandle.FromIntPtr(csNetworkInterfacePtr).Target;
				}
			}

			csC?._mIRegisterNetworkInterfaceEventListener?.OnNetworkInterfaceStateUpdated(csNetworkInterface, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnParticipantJoined))]
#endif
		private static void OnParticipantJoinedDelegate(IntPtr c, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}
			if(csC != null && csParticipant != null)
				csC.GetParticipantsMap()[csParticipant.GetId()] = csParticipant;

			csC?._mIRegisterParticipantEventListener?.OnParticipantJoined(csParticipant);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnParticipantLeft))]
#endif
		private static void OnParticipantLeftDelegate(IntPtr c, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}
			csC?.GetParticipantsMap()?.Remove(csParticipant?.GetId() ?? string.Empty);

			csC?._mIRegisterParticipantEventListener?.OnParticipantLeft(csParticipant);
			if(csC?._mIRegisterParticipantEventListener == null) csParticipant?.Dispose();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnPresenterChanged))]
#endif
		private static void OnPresenterChangedDelegate(IntPtr c, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterLectureModeEventListener?.OnPresenterChanged(csParticipant);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRaiseHandResponse))]
#endif
		private static void OnRaiseHandResponseDelegate(IntPtr c, Participant.ParticipantHandState handState){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRaiseHand?.OnRaiseHandResponse(handState);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnReconnected))]
#endif
		private static void OnReconnectedDelegate(IntPtr c){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterReconnectEventListener?.OnReconnected();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnReconnecting))]
#endif
		private static void OnReconnectingDelegate(IntPtr c, uint attempt, uint attemptTimeout, ConnectorFailReason reason){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterReconnectEventListener?.OnReconnecting(attempt, attemptTimeout, reason);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServicePauseResult))]
#endif
		private static void OnRecordingServicePauseResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIPauseRecording?.OnRecordingServicePauseResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServiceResumeResult))]
#endif
		private static void OnRecordingServiceResumeResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIResumeRecording?.OnRecordingServiceResumeResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServiceStartResult))]
#endif
		private static void OnRecordingServiceStartResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIStartRecording?.OnRecordingServiceStartResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServiceStopResult))]
#endif
		private static void OnRecordingServiceStopResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIStopRecording?.OnRecordingServiceStopResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteCameraAdded))]
#endif
		private static void OnRemoteCameraAddedDelegate(IntPtr c, IntPtr remoteCamera, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteCamera csRemoteCamera = null;
			if(remoteCamera != IntPtr.Zero) {
				var csRemoteCameraPtr = RemoteCamera.VidyoRemoteCameraGetUserDataNative(remoteCamera);
				if (csRemoteCameraPtr == IntPtr.Zero) {
					csRemoteCamera = new RemoteCamera(remoteCamera);
					if (csRemoteCamera != null) {
						csC?.objects?.Add(new WeakReference(csRemoteCamera));
					}
				} else {
					csRemoteCamera = (RemoteCamera)GCHandle.FromIntPtr(csRemoteCameraPtr).Target;
				}
			}
			if(csC != null && csRemoteCamera != null)
				csC.GetRemoteCamerasMap()[csRemoteCamera.GetId()] = csRemoteCamera;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteCameraEventListener?.OnRemoteCameraAdded(csRemoteCamera, csParticipant);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteCameraFirstFrameReceived))]
#endif
		private static void OnRemoteCameraFirstFrameReceivedDelegate(IntPtr c, IntPtr remoteCamera){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteCamera csRemoteCamera = null;
			if(remoteCamera != IntPtr.Zero) {
				var csRemoteCameraPtr = RemoteCamera.VidyoRemoteCameraGetUserDataNative(remoteCamera);
				if (csRemoteCameraPtr == IntPtr.Zero) {
					csRemoteCamera = new RemoteCamera(remoteCamera);
					if (csRemoteCamera != null) {
						csC?.objects?.Add(new WeakReference(csRemoteCamera));
					}
				} else {
					csRemoteCamera = (RemoteCamera)GCHandle.FromIntPtr(csRemoteCameraPtr).Target;
				}
			}

			IRequestVideoForRemoteCamera cb = csC?.GetOnRemoteCameraFirstFrameReceivedCallbacksMap()?[csRemoteCamera?.GetId() ?? string.Empty];
			csC?.GetOnRemoteCameraFirstFrameReceivedCallbacksMap()?.Remove(csRemoteCamera?.GetId() ?? string.Empty);
			cb?.OnRemoteCameraFirstFrameReceived(csRemoteCamera);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteCameraFrame))]
#endif
		private static void OnRemoteCameraFrameDelegate(IntPtr c, IntPtr remoteCamera, IntPtr participant, IntPtr videoFrame){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteCamera csRemoteCamera = null;
			if(remoteCamera != IntPtr.Zero) {
				var csRemoteCameraPtr = RemoteCamera.VidyoRemoteCameraGetUserDataNative(remoteCamera);
				if (csRemoteCameraPtr == IntPtr.Zero) {
					csRemoteCamera = new RemoteCamera(remoteCamera);
					if (csRemoteCamera != null) {
						csC?.objects?.Add(new WeakReference(csRemoteCamera));
					}
				} else {
					csRemoteCamera = (RemoteCamera)GCHandle.FromIntPtr(csRemoteCameraPtr).Target;
				}
			}

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			VideoFrame csVideoFrame = null;
			if(videoFrame != IntPtr.Zero) {
				var csVideoFramePtr = VideoFrame.VidyoVideoFrameGetUserDataNative(videoFrame);
				csVideoFrame = csVideoFramePtr == IntPtr.Zero ? new VideoFrame(videoFrame) : (VideoFrame)GCHandle.FromIntPtr(csVideoFramePtr).Target;
			}

			csC?._mIRegisterRemoteCameraFrameListener?.OnRemoteCameraFrame(csRemoteCamera, csParticipant, csVideoFrame);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteCameraRemoved))]
#endif
		private static void OnRemoteCameraRemovedDelegate(IntPtr c, IntPtr remoteCamera, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteCamera csRemoteCamera = null;
			if(remoteCamera != IntPtr.Zero) {
				var csRemoteCameraPtr = RemoteCamera.VidyoRemoteCameraGetUserDataNative(remoteCamera);
				if (csRemoteCameraPtr == IntPtr.Zero) {
					csRemoteCamera = new RemoteCamera(remoteCamera);
					if (csRemoteCamera != null) {
						csC?.objects?.Add(new WeakReference(csRemoteCamera));
					}
				} else {
					csRemoteCamera = (RemoteCamera)GCHandle.FromIntPtr(csRemoteCameraPtr).Target;
				}
			}
			csC?.GetRemoteCamerasMap()?.Remove(csRemoteCamera?.GetId() ?? string.Empty);

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteCameraEventListener?.OnRemoteCameraRemoved(csRemoteCamera, csParticipant);
			if(csC?._mIRegisterRemoteCameraEventListener == null) csRemoteCamera?.Dispose();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteCameraStateUpdated))]
#endif
		private static void OnRemoteCameraStateUpdatedDelegate(IntPtr c, IntPtr remoteCamera, IntPtr participant, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteCamera csRemoteCamera = null;
			if(remoteCamera != IntPtr.Zero) {
				var csRemoteCameraPtr = RemoteCamera.VidyoRemoteCameraGetUserDataNative(remoteCamera);
				if (csRemoteCameraPtr == IntPtr.Zero) {
					csRemoteCamera = new RemoteCamera(remoteCamera);
					if (csRemoteCamera != null) {
						csC?.objects?.Add(new WeakReference(csRemoteCamera));
					}
				} else {
					csRemoteCamera = (RemoteCamera)GCHandle.FromIntPtr(csRemoteCameraPtr).Target;
				}
			}

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteCameraEventListener?.OnRemoteCameraStateUpdated(csRemoteCamera, csParticipant, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteMicrophoneAdded))]
#endif
		private static void OnRemoteMicrophoneAddedDelegate(IntPtr c, IntPtr remoteMicrophone, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteMicrophone csRemoteMicrophone = null;
			if(remoteMicrophone != IntPtr.Zero) {
				var csRemoteMicrophonePtr = RemoteMicrophone.VidyoRemoteMicrophoneGetUserDataNative(remoteMicrophone);
				if (csRemoteMicrophonePtr == IntPtr.Zero) {
					csRemoteMicrophone = new RemoteMicrophone(remoteMicrophone);
					if (csRemoteMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csRemoteMicrophone));
					}
				} else {
					csRemoteMicrophone = (RemoteMicrophone)GCHandle.FromIntPtr(csRemoteMicrophonePtr).Target;
				}
			}
			if(csC != null && csRemoteMicrophone != null)
				csC.GetRemoteMicrophonesMap()[csRemoteMicrophone.GetId()] = csRemoteMicrophone;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteMicrophoneEventListener?.OnRemoteMicrophoneAdded(csRemoteMicrophone, csParticipant);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteMicrophoneEnergy))]
#endif
		private static void OnRemoteMicrophoneEnergyDelegate(IntPtr c, IntPtr remoteMicrophone, IntPtr participant, int audioEnergy){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteMicrophone csRemoteMicrophone = null;
			if(remoteMicrophone != IntPtr.Zero) {
				var csRemoteMicrophonePtr = RemoteMicrophone.VidyoRemoteMicrophoneGetUserDataNative(remoteMicrophone);
				if (csRemoteMicrophonePtr == IntPtr.Zero) {
					csRemoteMicrophone = new RemoteMicrophone(remoteMicrophone);
					if (csRemoteMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csRemoteMicrophone));
					}
				} else {
					csRemoteMicrophone = (RemoteMicrophone)GCHandle.FromIntPtr(csRemoteMicrophonePtr).Target;
				}
			}

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteMicrophoneEnergyListener?.OnRemoteMicrophoneEnergy(csRemoteMicrophone, csParticipant, audioEnergy);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteMicrophoneFrame))]
#endif
		private static void OnRemoteMicrophoneFrameDelegate(IntPtr c, IntPtr remoteMicrophone, IntPtr participant, IntPtr audioFrame){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteMicrophone csRemoteMicrophone = null;
			if(remoteMicrophone != IntPtr.Zero) {
				var csRemoteMicrophonePtr = RemoteMicrophone.VidyoRemoteMicrophoneGetUserDataNative(remoteMicrophone);
				if (csRemoteMicrophonePtr == IntPtr.Zero) {
					csRemoteMicrophone = new RemoteMicrophone(remoteMicrophone);
					if (csRemoteMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csRemoteMicrophone));
					}
				} else {
					csRemoteMicrophone = (RemoteMicrophone)GCHandle.FromIntPtr(csRemoteMicrophonePtr).Target;
				}
			}

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			AudioFrame csAudioFrame = null;
			if(audioFrame != IntPtr.Zero) {
				var csAudioFramePtr = AudioFrame.VidyoAudioFrameGetUserDataNative(audioFrame);
				csAudioFrame = csAudioFramePtr == IntPtr.Zero ? new AudioFrame(audioFrame) : (AudioFrame)GCHandle.FromIntPtr(csAudioFramePtr).Target;
			}

			csC?._mIRegisterRemoteMicrophoneFrameListener?.OnRemoteMicrophoneFrame(csRemoteMicrophone, csParticipant, csAudioFrame);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteMicrophoneRemoved))]
#endif
		private static void OnRemoteMicrophoneRemovedDelegate(IntPtr c, IntPtr remoteMicrophone, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteMicrophone csRemoteMicrophone = null;
			if(remoteMicrophone != IntPtr.Zero) {
				var csRemoteMicrophonePtr = RemoteMicrophone.VidyoRemoteMicrophoneGetUserDataNative(remoteMicrophone);
				if (csRemoteMicrophonePtr == IntPtr.Zero) {
					csRemoteMicrophone = new RemoteMicrophone(remoteMicrophone);
					if (csRemoteMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csRemoteMicrophone));
					}
				} else {
					csRemoteMicrophone = (RemoteMicrophone)GCHandle.FromIntPtr(csRemoteMicrophonePtr).Target;
				}
			}
			csC?.GetRemoteMicrophonesMap()?.Remove(csRemoteMicrophone?.GetId() ?? string.Empty);

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteMicrophoneEventListener?.OnRemoteMicrophoneRemoved(csRemoteMicrophone, csParticipant);
			if(csC?._mIRegisterRemoteMicrophoneEventListener == null) csRemoteMicrophone?.Dispose();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteMicrophoneStateUpdated))]
#endif
		private static void OnRemoteMicrophoneStateUpdatedDelegate(IntPtr c, IntPtr remoteMicrophone, IntPtr participant, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteMicrophone csRemoteMicrophone = null;
			if(remoteMicrophone != IntPtr.Zero) {
				var csRemoteMicrophonePtr = RemoteMicrophone.VidyoRemoteMicrophoneGetUserDataNative(remoteMicrophone);
				if (csRemoteMicrophonePtr == IntPtr.Zero) {
					csRemoteMicrophone = new RemoteMicrophone(remoteMicrophone);
					if (csRemoteMicrophone != null) {
						csC?.objects?.Add(new WeakReference(csRemoteMicrophone));
					}
				} else {
					csRemoteMicrophone = (RemoteMicrophone)GCHandle.FromIntPtr(csRemoteMicrophonePtr).Target;
				}
			}

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteMicrophoneEventListener?.OnRemoteMicrophoneStateUpdated(csRemoteMicrophone, csParticipant, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteRendererAdded))]
#endif
		private static void OnRemoteRendererAddedDelegate(IntPtr c, IntPtr remoteRenderer){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteRenderer csRemoteRenderer = null;
			if(remoteRenderer != IntPtr.Zero) {
				var csRemoteRendererPtr = RemoteRenderer.VidyoRemoteRendererGetUserDataNative(remoteRenderer);
				if (csRemoteRendererPtr == IntPtr.Zero) {
					csRemoteRenderer = new RemoteRenderer(remoteRenderer);
					if (csRemoteRenderer != null) {
						csC?.objects?.Add(new WeakReference(csRemoteRenderer));
					}
				} else {
					csRemoteRenderer = (RemoteRenderer)GCHandle.FromIntPtr(csRemoteRendererPtr).Target;
				}
			}

			csC?._mIRegisterRemoteRendererEventListener?.OnRemoteRendererAdded(csRemoteRenderer);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteRendererRemoved))]
#endif
		private static void OnRemoteRendererRemovedDelegate(IntPtr c, IntPtr remoteRenderer){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteRenderer csRemoteRenderer = null;
			if(remoteRenderer != IntPtr.Zero) {
				var csRemoteRendererPtr = RemoteRenderer.VidyoRemoteRendererGetUserDataNative(remoteRenderer);
				if (csRemoteRendererPtr == IntPtr.Zero) {
					csRemoteRenderer = new RemoteRenderer(remoteRenderer);
					if (csRemoteRenderer != null) {
						csC?.objects?.Add(new WeakReference(csRemoteRenderer));
					}
				} else {
					csRemoteRenderer = (RemoteRenderer)GCHandle.FromIntPtr(csRemoteRendererPtr).Target;
				}
			}

			csC?._mIRegisterRemoteRendererEventListener?.OnRemoteRendererRemoved(csRemoteRenderer);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteRendererStateUpdated))]
#endif
		private static void OnRemoteRendererStateUpdatedDelegate(IntPtr c, IntPtr remoteRenderer, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteRenderer csRemoteRenderer = null;
			if(remoteRenderer != IntPtr.Zero) {
				var csRemoteRendererPtr = RemoteRenderer.VidyoRemoteRendererGetUserDataNative(remoteRenderer);
				if (csRemoteRendererPtr == IntPtr.Zero) {
					csRemoteRenderer = new RemoteRenderer(remoteRenderer);
					if (csRemoteRenderer != null) {
						csC?.objects?.Add(new WeakReference(csRemoteRenderer));
					}
				} else {
					csRemoteRenderer = (RemoteRenderer)GCHandle.FromIntPtr(csRemoteRendererPtr).Target;
				}
			}

			csC?._mIRegisterRemoteRendererEventListener?.OnRemoteRendererStateUpdated(csRemoteRenderer, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteSpeakerAdded))]
#endif
		private static void OnRemoteSpeakerAddedDelegate(IntPtr c, IntPtr remoteSpeaker){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteSpeaker csRemoteSpeaker = null;
			if(remoteSpeaker != IntPtr.Zero) {
				var csRemoteSpeakerPtr = RemoteSpeaker.VidyoRemoteSpeakerGetUserDataNative(remoteSpeaker);
				if (csRemoteSpeakerPtr == IntPtr.Zero) {
					csRemoteSpeaker = new RemoteSpeaker(remoteSpeaker);
					if (csRemoteSpeaker != null) {
						csC?.objects?.Add(new WeakReference(csRemoteSpeaker));
					}
				} else {
					csRemoteSpeaker = (RemoteSpeaker)GCHandle.FromIntPtr(csRemoteSpeakerPtr).Target;
				}
			}

			csC?._mIRegisterRemoteSpeakerEventListener?.OnRemoteSpeakerAdded(csRemoteSpeaker);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteSpeakerRemoved))]
#endif
		private static void OnRemoteSpeakerRemovedDelegate(IntPtr c, IntPtr remoteSpeaker){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteSpeaker csRemoteSpeaker = null;
			if(remoteSpeaker != IntPtr.Zero) {
				var csRemoteSpeakerPtr = RemoteSpeaker.VidyoRemoteSpeakerGetUserDataNative(remoteSpeaker);
				if (csRemoteSpeakerPtr == IntPtr.Zero) {
					csRemoteSpeaker = new RemoteSpeaker(remoteSpeaker);
					if (csRemoteSpeaker != null) {
						csC?.objects?.Add(new WeakReference(csRemoteSpeaker));
					}
				} else {
					csRemoteSpeaker = (RemoteSpeaker)GCHandle.FromIntPtr(csRemoteSpeakerPtr).Target;
				}
			}

			csC?._mIRegisterRemoteSpeakerEventListener?.OnRemoteSpeakerRemoved(csRemoteSpeaker);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteSpeakerStateUpdated))]
#endif
		private static void OnRemoteSpeakerStateUpdatedDelegate(IntPtr c, IntPtr remoteSpeaker, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteSpeaker csRemoteSpeaker = null;
			if(remoteSpeaker != IntPtr.Zero) {
				var csRemoteSpeakerPtr = RemoteSpeaker.VidyoRemoteSpeakerGetUserDataNative(remoteSpeaker);
				if (csRemoteSpeakerPtr == IntPtr.Zero) {
					csRemoteSpeaker = new RemoteSpeaker(remoteSpeaker);
					if (csRemoteSpeaker != null) {
						csC?.objects?.Add(new WeakReference(csRemoteSpeaker));
					}
				} else {
					csRemoteSpeaker = (RemoteSpeaker)GCHandle.FromIntPtr(csRemoteSpeakerPtr).Target;
				}
			}

			csC?._mIRegisterRemoteSpeakerEventListener?.OnRemoteSpeakerStateUpdated(csRemoteSpeaker, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteWindowShareAdded))]
#endif
		private static void OnRemoteWindowShareAddedDelegate(IntPtr c, IntPtr remoteWindowShare, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteWindowShare csRemoteWindowShare = null;
			if(remoteWindowShare != IntPtr.Zero) {
				var csRemoteWindowSharePtr = RemoteWindowShare.VidyoRemoteWindowShareGetUserDataNative(remoteWindowShare);
				if (csRemoteWindowSharePtr == IntPtr.Zero) {
					csRemoteWindowShare = new RemoteWindowShare(remoteWindowShare);
					if (csRemoteWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csRemoteWindowShare));
					}
				} else {
					csRemoteWindowShare = (RemoteWindowShare)GCHandle.FromIntPtr(csRemoteWindowSharePtr).Target;
				}
			}
			if(csC != null && csRemoteWindowShare != null)
				csC.GetRemoteWindowSharesMap()[csRemoteWindowShare.GetId()] = csRemoteWindowShare;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteWindowShareEventListener?.OnRemoteWindowShareAdded(csRemoteWindowShare, csParticipant);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteWindowShareFirstFrameReceived))]
#endif
		private static void OnRemoteWindowShareFirstFrameReceivedDelegate(IntPtr c, IntPtr remoteWindowShare){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteWindowShare csRemoteWindowShare = null;
			if(remoteWindowShare != IntPtr.Zero) {
				var csRemoteWindowSharePtr = RemoteWindowShare.VidyoRemoteWindowShareGetUserDataNative(remoteWindowShare);
				if (csRemoteWindowSharePtr == IntPtr.Zero) {
					csRemoteWindowShare = new RemoteWindowShare(remoteWindowShare);
					if (csRemoteWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csRemoteWindowShare));
					}
				} else {
					csRemoteWindowShare = (RemoteWindowShare)GCHandle.FromIntPtr(csRemoteWindowSharePtr).Target;
				}
			}

			IRequestVideoForRemoteWindowShare cb = csC?.GetOnRemoteWindowShareFirstFrameReceivedCallbacksMap()?[csRemoteWindowShare?.GetId() ?? string.Empty];
			csC?.GetOnRemoteWindowShareFirstFrameReceivedCallbacksMap()?.Remove(csRemoteWindowShare?.GetId() ?? string.Empty);
			cb?.OnRemoteWindowShareFirstFrameReceived(csRemoteWindowShare);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteWindowShareFrame))]
#endif
		private static void OnRemoteWindowShareFrameDelegate(IntPtr c, IntPtr remoteWindowShare, IntPtr participant, IntPtr videoFrame){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteWindowShare csRemoteWindowShare = null;
			if(remoteWindowShare != IntPtr.Zero) {
				var csRemoteWindowSharePtr = RemoteWindowShare.VidyoRemoteWindowShareGetUserDataNative(remoteWindowShare);
				if (csRemoteWindowSharePtr == IntPtr.Zero) {
					csRemoteWindowShare = new RemoteWindowShare(remoteWindowShare);
					if (csRemoteWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csRemoteWindowShare));
					}
				} else {
					csRemoteWindowShare = (RemoteWindowShare)GCHandle.FromIntPtr(csRemoteWindowSharePtr).Target;
				}
			}

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			VideoFrame csVideoFrame = null;
			if(videoFrame != IntPtr.Zero) {
				var csVideoFramePtr = VideoFrame.VidyoVideoFrameGetUserDataNative(videoFrame);
				csVideoFrame = csVideoFramePtr == IntPtr.Zero ? new VideoFrame(videoFrame) : (VideoFrame)GCHandle.FromIntPtr(csVideoFramePtr).Target;
			}

			csC?._mIRegisterRemoteWindowShareFrameListener?.OnRemoteWindowShareFrame(csRemoteWindowShare, csParticipant, csVideoFrame);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteWindowShareRemoved))]
#endif
		private static void OnRemoteWindowShareRemovedDelegate(IntPtr c, IntPtr remoteWindowShare, IntPtr participant){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteWindowShare csRemoteWindowShare = null;
			if(remoteWindowShare != IntPtr.Zero) {
				var csRemoteWindowSharePtr = RemoteWindowShare.VidyoRemoteWindowShareGetUserDataNative(remoteWindowShare);
				if (csRemoteWindowSharePtr == IntPtr.Zero) {
					csRemoteWindowShare = new RemoteWindowShare(remoteWindowShare);
					if (csRemoteWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csRemoteWindowShare));
					}
				} else {
					csRemoteWindowShare = (RemoteWindowShare)GCHandle.FromIntPtr(csRemoteWindowSharePtr).Target;
				}
			}
			csC?.GetRemoteWindowSharesMap()?.Remove(csRemoteWindowShare?.GetId() ?? string.Empty);

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteWindowShareEventListener?.OnRemoteWindowShareRemoved(csRemoteWindowShare, csParticipant);
			if(csC?._mIRegisterRemoteWindowShareEventListener == null) csRemoteWindowShare?.Dispose();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoteWindowShareStateUpdated))]
#endif
		private static void OnRemoteWindowShareStateUpdatedDelegate(IntPtr c, IntPtr remoteWindowShare, IntPtr participant, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			RemoteWindowShare csRemoteWindowShare = null;
			if(remoteWindowShare != IntPtr.Zero) {
				var csRemoteWindowSharePtr = RemoteWindowShare.VidyoRemoteWindowShareGetUserDataNative(remoteWindowShare);
				if (csRemoteWindowSharePtr == IntPtr.Zero) {
					csRemoteWindowShare = new RemoteWindowShare(remoteWindowShare);
					if (csRemoteWindowShare != null) {
						csC?.objects?.Add(new WeakReference(csRemoteWindowShare));
					}
				} else {
					csRemoteWindowShare = (RemoteWindowShare)GCHandle.FromIntPtr(csRemoteWindowSharePtr).Target;
				}
			}

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csC?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csC?._mIRegisterRemoteWindowShareEventListener?.OnRemoteWindowShareStateUpdated(csRemoteWindowShare, csParticipant, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoveModeratorRoleResult))]
#endif
		private static void OnRemoveModeratorRoleResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRemoveModeratorRole?.OnRemoveModeratorRoleResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoveRoomPINResult))]
#endif
		private static void OnRemoveRoomPINResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRemoveRoomPIN?.OnRemoveRoomPINResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRequestModeratorRoleResult))]
#endif
		private static void OnRequestModeratorRoleResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRequestModeratorRole?.OnRequestModeratorRoleResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnSetRoomPINResult))]
#endif
		private static void OnSetRoomPINResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mISetRoomPIN?.OnSetRoomPINResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnSuccess))]
#endif
		private static void OnSuccessDelegate(IntPtr c){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIConnect?.OnSuccess();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnTokenReceived))]
#endif
		private static void OnTokenReceivedDelegate(IntPtr c, IntPtr tokenInfo){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			List<ConnectorTokenInfo> csTokenInfo = new List<ConnectorTokenInfo>();
			var nTokenInfoSize = 0;
			var nTokenInfo = VidyoConnectorOnTokenReceivedGettokenInfoArrayNative(tokenInfo, ref nTokenInfoSize);
			var nTokenInfoIndex = 0;
			while (nTokenInfoIndex < nTokenInfoSize) {
				ConnectorTokenInfo csTtokenInfo = new ConnectorTokenInfo(Marshal.ReadIntPtr(nTokenInfo + (nTokenInfoIndex * Marshal.SizeOf(nTokenInfo))));
				csTokenInfo.Add(csTtokenInfo);
				nTokenInfoIndex++;
			}

			csC?._mIRegisterTokenReceivedEventListener?.OnTokenReceived(csTokenInfo);
			VidyoConnectorOnTokenReceivedFreetokenInfoArrayNative(nTokenInfo, nTokenInfoSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUnlockRoomResult))]
#endif
		private static void OnUnlockRoomResultDelegate(IntPtr c, ConnectorModerationResult result){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIUnlockRoom?.OnUnlockRoomResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUserSearchResults))]
#endif
		private static void OnUserSearchResultsDelegate(IntPtr c, IntPtr searchText, uint startIndex, ConnectorSearchResult searchResult, IntPtr contacts, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT numRecords){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			var n_searchText = VidyoConnectorOnUserSearchResultsGetsearchTextCStr(searchText);

			List<ContactInfo> csContacts = new List<ContactInfo>();
			var nContactsSize = 0;
			var nContacts = VidyoConnectorOnUserSearchResultsGetcontactsArrayNative(contacts, ref nContactsSize);
			var nContactsIndex = 0;
			while (nContactsIndex < nContactsSize) {
				ContactInfo csTcontacts = new ContactInfo(Marshal.ReadIntPtr(nContacts + (nContactsIndex * Marshal.SizeOf(nContacts))));
				csContacts.Add(csTcontacts);
				nContactsIndex++;
			}

			csC?._mISearchUsers?.OnUserSearchResults((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_searchText), startIndex, searchResult, csContacts, numRecords);
			VidyoConnectorOnUserSearchResultsFreecontactsArrayNative(nContacts, nContactsSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualAudioSourceAdded))]
#endif
		private static void OnVirtualAudioSourceAddedDelegate(IntPtr c, IntPtr virtualAudioSource){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualAudioSource csVirtualAudioSource = null;
			if(virtualAudioSource != IntPtr.Zero) {
				var csVirtualAudioSourcePtr = VirtualAudioSource.VidyoVirtualAudioSourceGetUserDataNative(virtualAudioSource);
				if (csVirtualAudioSourcePtr == IntPtr.Zero) {
					csVirtualAudioSource = new VirtualAudioSource(virtualAudioSource);
					if (csVirtualAudioSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualAudioSource));
					}
				} else {
					csVirtualAudioSource = (VirtualAudioSource)GCHandle.FromIntPtr(csVirtualAudioSourcePtr).Target;
				}
			}

			csC?._mIRegisterVirtualAudioSourceEventListener?.OnVirtualAudioSourceAdded(csVirtualAudioSource);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualAudioSourceExternalMediaBufferReleased))]
#endif
		private static void OnVirtualAudioSourceExternalMediaBufferReleasedDelegate(IntPtr c, IntPtr virtualAudioSource, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualAudioSource csVirtualAudioSource = null;
			if(virtualAudioSource != IntPtr.Zero) {
				var csVirtualAudioSourcePtr = VirtualAudioSource.VidyoVirtualAudioSourceGetUserDataNative(virtualAudioSource);
				if (csVirtualAudioSourcePtr == IntPtr.Zero) {
					csVirtualAudioSource = new VirtualAudioSource(virtualAudioSource);
					if (csVirtualAudioSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualAudioSource));
					}
				} else {
					csVirtualAudioSource = (VirtualAudioSource)GCHandle.FromIntPtr(csVirtualAudioSourcePtr).Target;
				}
			}

			var pointer = ByteArrayHelperSingleton.RawPointerToByteArray(buffer);
			csC?._mIRegisterVirtualAudioSourceEventListener?.OnVirtualAudioSourceExternalMediaBufferReleased(csVirtualAudioSource, pointer, size);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualAudioSourceRemoved))]
#endif
		private static void OnVirtualAudioSourceRemovedDelegate(IntPtr c, IntPtr virtualAudioSource){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualAudioSource csVirtualAudioSource = null;
			if(virtualAudioSource != IntPtr.Zero) {
				var csVirtualAudioSourcePtr = VirtualAudioSource.VidyoVirtualAudioSourceGetUserDataNative(virtualAudioSource);
				if (csVirtualAudioSourcePtr == IntPtr.Zero) {
					csVirtualAudioSource = new VirtualAudioSource(virtualAudioSource);
					if (csVirtualAudioSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualAudioSource));
					}
				} else {
					csVirtualAudioSource = (VirtualAudioSource)GCHandle.FromIntPtr(csVirtualAudioSourcePtr).Target;
				}
			}

			csC?._mIRegisterVirtualAudioSourceEventListener?.OnVirtualAudioSourceRemoved(csVirtualAudioSource);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualAudioSourceSelected))]
#endif
		private static void OnVirtualAudioSourceSelectedDelegate(IntPtr c, IntPtr virtualAudioSource){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualAudioSource csVirtualAudioSource = null;
			if(virtualAudioSource != IntPtr.Zero) {
				var csVirtualAudioSourcePtr = VirtualAudioSource.VidyoVirtualAudioSourceGetUserDataNative(virtualAudioSource);
				if (csVirtualAudioSourcePtr == IntPtr.Zero) {
					csVirtualAudioSource = new VirtualAudioSource(virtualAudioSource);
					if (csVirtualAudioSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualAudioSource));
					}
				} else {
					csVirtualAudioSource = (VirtualAudioSource)GCHandle.FromIntPtr(csVirtualAudioSourcePtr).Target;
				}
			}

			csC?._mIRegisterVirtualAudioSourceEventListener?.OnVirtualAudioSourceSelected(csVirtualAudioSource);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualAudioSourceStateUpdated))]
#endif
		private static void OnVirtualAudioSourceStateUpdatedDelegate(IntPtr c, IntPtr virtualAudioSource, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualAudioSource csVirtualAudioSource = null;
			if(virtualAudioSource != IntPtr.Zero) {
				var csVirtualAudioSourcePtr = VirtualAudioSource.VidyoVirtualAudioSourceGetUserDataNative(virtualAudioSource);
				if (csVirtualAudioSourcePtr == IntPtr.Zero) {
					csVirtualAudioSource = new VirtualAudioSource(virtualAudioSource);
					if (csVirtualAudioSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualAudioSource));
					}
				} else {
					csVirtualAudioSource = (VirtualAudioSource)GCHandle.FromIntPtr(csVirtualAudioSourcePtr).Target;
				}
			}

			csC?._mIRegisterVirtualAudioSourceEventListener?.OnVirtualAudioSourceStateUpdated(csVirtualAudioSource, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualVideoSourceAdded))]
#endif
		private static void OnVirtualVideoSourceAddedDelegate(IntPtr c, IntPtr virtualVideoSource){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualVideoSource csVirtualVideoSource = null;
			if(virtualVideoSource != IntPtr.Zero) {
				var csVirtualVideoSourcePtr = VirtualVideoSource.VidyoVirtualVideoSourceGetUserDataNative(virtualVideoSource);
				if (csVirtualVideoSourcePtr == IntPtr.Zero) {
					csVirtualVideoSource = new VirtualVideoSource(virtualVideoSource);
					if (csVirtualVideoSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualVideoSource));
					}
				} else {
					csVirtualVideoSource = (VirtualVideoSource)GCHandle.FromIntPtr(csVirtualVideoSourcePtr).Target;
				}
			}

			csC?._mIRegisterVirtualVideoSourceEventListener?.OnVirtualVideoSourceAdded(csVirtualVideoSource);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualVideoSourceExternalMediaBufferReleased))]
#endif
		private static void OnVirtualVideoSourceExternalMediaBufferReleasedDelegate(IntPtr c, IntPtr virtualVideoSource, IntPtr buffer, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT size){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualVideoSource csVirtualVideoSource = null;
			if(virtualVideoSource != IntPtr.Zero) {
				var csVirtualVideoSourcePtr = VirtualVideoSource.VidyoVirtualVideoSourceGetUserDataNative(virtualVideoSource);
				if (csVirtualVideoSourcePtr == IntPtr.Zero) {
					csVirtualVideoSource = new VirtualVideoSource(virtualVideoSource);
					if (csVirtualVideoSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualVideoSource));
					}
				} else {
					csVirtualVideoSource = (VirtualVideoSource)GCHandle.FromIntPtr(csVirtualVideoSourcePtr).Target;
				}
			}

			var pointer = ByteArrayHelperSingleton.RawPointerToByteArray(buffer);
			csC?._mIRegisterVirtualVideoSourceEventListener?.OnVirtualVideoSourceExternalMediaBufferReleased(csVirtualVideoSource, pointer, size);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualVideoSourceRemoved))]
#endif
		private static void OnVirtualVideoSourceRemovedDelegate(IntPtr c, IntPtr virtualVideoSource){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualVideoSource csVirtualVideoSource = null;
			if(virtualVideoSource != IntPtr.Zero) {
				var csVirtualVideoSourcePtr = VirtualVideoSource.VidyoVirtualVideoSourceGetUserDataNative(virtualVideoSource);
				if (csVirtualVideoSourcePtr == IntPtr.Zero) {
					csVirtualVideoSource = new VirtualVideoSource(virtualVideoSource);
					if (csVirtualVideoSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualVideoSource));
					}
				} else {
					csVirtualVideoSource = (VirtualVideoSource)GCHandle.FromIntPtr(csVirtualVideoSourcePtr).Target;
				}
			}

			csC?._mIRegisterVirtualVideoSourceEventListener?.OnVirtualVideoSourceRemoved(csVirtualVideoSource);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnVirtualVideoSourceStateUpdated))]
#endif
		private static void OnVirtualVideoSourceStateUpdatedDelegate(IntPtr c, IntPtr virtualVideoSource, Device.DeviceState state){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			VirtualVideoSource csVirtualVideoSource = null;
			if(virtualVideoSource != IntPtr.Zero) {
				var csVirtualVideoSourcePtr = VirtualVideoSource.VidyoVirtualVideoSourceGetUserDataNative(virtualVideoSource);
				if (csVirtualVideoSourcePtr == IntPtr.Zero) {
					csVirtualVideoSource = new VirtualVideoSource(virtualVideoSource);
					if (csVirtualVideoSource != null) {
						csC?.objects?.Add(new WeakReference(csVirtualVideoSource));
					}
				} else {
					csVirtualVideoSource = (VirtualVideoSource)GCHandle.FromIntPtr(csVirtualVideoSourcePtr).Target;
				}
			}

			csC?._mIRegisterVirtualVideoSourceEventListener?.OnVirtualVideoSourceStateUpdated(csVirtualVideoSource, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnWebProxyCredentialsRequest))]
#endif
		private static void OnWebProxyCredentialsRequestDelegate(IntPtr c, IntPtr webProxyAddress){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			var n_webProxyAddress = VidyoConnectorOnWebProxyCredentialsRequestGetwebProxyAddressCStr(webProxyAddress);

			csC?._mIRegisterWebProxyEventListener?.OnWebProxyCredentialsRequest((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_webProxyAddress));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(RecorderInCall))]
#endif
		private static void RecorderInCallDelegate(IntPtr c, Boolean hasRecorder, Boolean isPaused){
			var csCPtr = c != IntPtr.Zero ? VidyoConnectorGetUserDataNative(c) : IntPtr.Zero;
			if(csCPtr == IntPtr.Zero) return;
			var csC = (Connector)GCHandle.FromIntPtr(csCPtr).Target;

			csC?._mIRegisterRecorderInCallEventListener?.RecorderInCall(hasRecorder, isPaused);
		}
	};
}
