// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class EndpointStatsFactory
	{
		public static EndpointStats Create()
		{
			return new EndpointStats(IntPtr.Zero);
		}
		public static void Destroy(EndpointStats obj)
		{
		}
	}
	/// <summary>
	/// Statistics for an endpoint.
	/// </summary>
	public class EndpointStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoEndpointStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nApplicationName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(applicationName ?? string.Empty);
			IntPtr nApplicationTag = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(applicationTag ?? string.Empty);
			IntPtr nApplicationVersion = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(applicationVersion ?? string.Empty);
			IntPtr nBuildTag = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(buildTag ?? string.Empty);
			IntPtr nConnectTime = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(connectTime ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nLibraryVersion = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(libraryVersion ?? string.Empty);
			IntPtr nLocalCameraStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localCameraStats.Count);
			int nLocalCameraStatsSize = 0;
			IntPtr nLocalMicrophoneStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localMicrophoneStats.Count);
			int nLocalMicrophoneStatsSize = 0;
			IntPtr nLocalMonitorStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localMonitorStats.Count);
			int nLocalMonitorStatsSize = 0;
			IntPtr nLocalRendererStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localRendererStats.Count);
			int nLocalRendererStatsSize = 0;
			IntPtr nLocalSpeakerStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localSpeakerStats.Count);
			int nLocalSpeakerStatsSize = 0;
			IntPtr nLocalWindowShareStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localWindowShareStats.Count);
			int nLocalWindowShareStatsSize = 0;
			IntPtr nNetworkInterfaceStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * networkInterfaceStats.Count);
			int nNetworkInterfaceStatsSize = 0;
			IntPtr nOsName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(osName ?? string.Empty);
			IntPtr nOsVersion = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(osVersion ?? string.Empty);
			IntPtr nProcessorBrand = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(processorBrand ?? string.Empty);
			IntPtr nProcessorModel = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(processorModel ?? string.Empty);
			IntPtr nTimeStamp = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(timeStamp ?? string.Empty);
			IntPtr nUserStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * userStats.Count);
			int nUserStatsSize = 0;
			IntPtr nVirtualAudioSourceStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * virtualAudioSourceStats.Count);
			int nVirtualAudioSourceStatsSize = 0;
			IntPtr nVirtualVideoSourceStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * virtualVideoSourceStats.Count);
			int nVirtualVideoSourceStatsSize = 0;

			foreach (LocalVideoSourceStats iter in localCameraStats) {
				Marshal.WriteIntPtr(nLocalCameraStats + (nLocalCameraStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalCameraStatsSize++;
			}
			foreach (LocalMicrophoneStats iter in localMicrophoneStats) {
				Marshal.WriteIntPtr(nLocalMicrophoneStats + (nLocalMicrophoneStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalMicrophoneStatsSize++;
			}
			foreach (LocalVideoSourceStats iter in localMonitorStats) {
				Marshal.WriteIntPtr(nLocalMonitorStats + (nLocalMonitorStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalMonitorStatsSize++;
			}
			foreach (LocalRendererStats iter in localRendererStats) {
				Marshal.WriteIntPtr(nLocalRendererStats + (nLocalRendererStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalRendererStatsSize++;
			}
			foreach (LocalSpeakerStats iter in localSpeakerStats) {
				Marshal.WriteIntPtr(nLocalSpeakerStats + (nLocalSpeakerStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalSpeakerStatsSize++;
			}
			foreach (LocalVideoSourceStats iter in localWindowShareStats) {
				Marshal.WriteIntPtr(nLocalWindowShareStats + (nLocalWindowShareStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalWindowShareStatsSize++;
			}
			foreach (NetworkInterfaceStats iter in networkInterfaceStats) {
				Marshal.WriteIntPtr(nNetworkInterfaceStats + (nNetworkInterfaceStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nNetworkInterfaceStatsSize++;
			}
			foreach (UserStats iter in userStats) {
				Marshal.WriteIntPtr(nUserStats + (nUserStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nUserStatsSize++;
			}
			foreach (LocalMicrophoneStats iter in virtualAudioSourceStats) {
				Marshal.WriteIntPtr(nVirtualAudioSourceStats + (nVirtualAudioSourceStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nVirtualAudioSourceStatsSize++;
			}
			foreach (LocalVideoSourceStats iter in virtualVideoSourceStats) {
				Marshal.WriteIntPtr(nVirtualVideoSourceStats + (nVirtualVideoSourceStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nVirtualVideoSourceStatsSize++;
			}

			VidyoEndpointStatsSetapplicationNameNative(objPtr, nApplicationName);
			VidyoEndpointStatsSetapplicationTagNative(objPtr, nApplicationTag);
			VidyoEndpointStatsSetapplicationVersionNative(objPtr, nApplicationVersion);
			VidyoEndpointStatsSetbuildTagNative(objPtr, nBuildTag);
			VidyoEndpointStatsSetbytesReceivedTcpNative(objPtr, bytesReceivedTcp);
			VidyoEndpointStatsSetbytesReceivedUdpNative(objPtr, bytesReceivedUdp);
			VidyoEndpointStatsSetbytesSentTcpNative(objPtr, bytesSentTcp);
			VidyoEndpointStatsSetbytesSentUdpNative(objPtr, bytesSentUdp);
			VidyoEndpointStatsSetconnectTimeNative(objPtr, nConnectTime);
			VidyoEndpointStatsSetidNative(objPtr, nId);
			VidyoEndpointStatsSetlibraryVersionNative(objPtr, nLibraryVersion);
			VidyoEndpointStatsSetlocalCameraStatsNative(objPtr, nLocalCameraStats, nLocalCameraStatsSize);
			VidyoEndpointStatsSetlocalMicrophoneStatsNative(objPtr, nLocalMicrophoneStats, nLocalMicrophoneStatsSize);
			VidyoEndpointStatsSetlocalMonitorStatsNative(objPtr, nLocalMonitorStats, nLocalMonitorStatsSize);
			VidyoEndpointStatsSetlocalRendererStatsNative(objPtr, nLocalRendererStats, nLocalRendererStatsSize);
			VidyoEndpointStatsSetlocalSpeakerStatsNative(objPtr, nLocalSpeakerStats, nLocalSpeakerStatsSize);
			VidyoEndpointStatsSetlocalWindowShareStatsNative(objPtr, nLocalWindowShareStats, nLocalWindowShareStatsSize);
			VidyoEndpointStatsSetlogStatsNative(objPtr, logStats.GetObjectPtr());
			VidyoEndpointStatsSetloginTimeConsumedMsNative(objPtr, loginTimeConsumedMs);
			VidyoEndpointStatsSetmaxBitRateNative(objPtr, maxBitRate);
			VidyoEndpointStatsSetmaxEncodePixelRateInitialNative(objPtr, maxEncodePixelRateInitial);
			VidyoEndpointStatsSetmediaEnableTimeConsumedMsNative(objPtr, mediaEnableTimeConsumedMs);
			VidyoEndpointStatsSetmediaRouteAcquireTimeConsumedMsNative(objPtr, mediaRouteAcquireTimeConsumedMs);
			VidyoEndpointStatsSetnetworkInterfaceStatsNative(objPtr, nNetworkInterfaceStats, nNetworkInterfaceStatsSize);
			VidyoEndpointStatsSetosNameNative(objPtr, nOsName);
			VidyoEndpointStatsSetosVersionNative(objPtr, nOsVersion);
			VidyoEndpointStatsSetprocessorBrandNative(objPtr, nProcessorBrand);
			VidyoEndpointStatsSetprocessorLogicalCoresNative(objPtr, processorLogicalCores);
			VidyoEndpointStatsSetprocessorModelNative(objPtr, nProcessorModel);
			VidyoEndpointStatsSetprocessorPhysicalCoresNative(objPtr, processorPhysicalCores);
			VidyoEndpointStatsSetprocessorSpeedNative(objPtr, processorSpeed);
			VidyoEndpointStatsSetroomEnterTimeConsumedMsNative(objPtr, roomEnterTimeConsumedMs);
			VidyoEndpointStatsSettimeStampNative(objPtr, nTimeStamp);
			VidyoEndpointStatsSetuserStatsNative(objPtr, nUserStats, nUserStatsSize);
			VidyoEndpointStatsSetvirtualAudioSourceStatsNative(objPtr, nVirtualAudioSourceStats, nVirtualAudioSourceStatsSize);
			VidyoEndpointStatsSetvirtualVideoSourceStatsNative(objPtr, nVirtualVideoSourceStats, nVirtualVideoSourceStatsSize);

			Marshal.FreeHGlobal(nVirtualVideoSourceStats);
			Marshal.FreeHGlobal(nVirtualAudioSourceStats);
			Marshal.FreeHGlobal(nUserStats);
			Marshal.FreeHGlobal(nTimeStamp);
			Marshal.FreeHGlobal(nProcessorModel);
			Marshal.FreeHGlobal(nProcessorBrand);
			Marshal.FreeHGlobal(nOsVersion);
			Marshal.FreeHGlobal(nOsName);
			Marshal.FreeHGlobal(nNetworkInterfaceStats);
			Marshal.FreeHGlobal(nLocalWindowShareStats);
			Marshal.FreeHGlobal(nLocalSpeakerStats);
			Marshal.FreeHGlobal(nLocalRendererStats);
			Marshal.FreeHGlobal(nLocalMonitorStats);
			Marshal.FreeHGlobal(nLocalMicrophoneStats);
			Marshal.FreeHGlobal(nLocalCameraStats);
			Marshal.FreeHGlobal(nLibraryVersion);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nConnectTime);
			Marshal.FreeHGlobal(nBuildTag);
			Marshal.FreeHGlobal(nApplicationVersion);
			Marshal.FreeHGlobal(nApplicationTag);
			Marshal.FreeHGlobal(nApplicationName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetapplicationNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetapplicationNameNative(IntPtr obj, IntPtr applicationName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetapplicationTagNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetapplicationTagNative(IntPtr obj, IntPtr applicationTag);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetapplicationVersionNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetapplicationVersionNative(IntPtr obj, IntPtr applicationVersion);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetbuildTagNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetbuildTagNative(IntPtr obj, IntPtr buildTag);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetbytesReceivedTcpNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetbytesReceivedTcpNative(IntPtr obj, ulong bytesReceivedTcp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetbytesReceivedUdpNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetbytesReceivedUdpNative(IntPtr obj, ulong bytesReceivedUdp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetbytesSentTcpNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetbytesSentTcpNative(IntPtr obj, ulong bytesSentTcp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetbytesSentUdpNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetbytesSentUdpNative(IntPtr obj, ulong bytesSentUdp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetconnectTimeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetconnectTimeNative(IntPtr obj, IntPtr connectTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlibraryVersionNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlibraryVersionNative(IntPtr obj, IntPtr libraryVersion);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalCameraStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlocalCameraStatsNative(IntPtr obj, IntPtr localCameraStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalCameraStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreelocalCameraStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalMicrophoneStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlocalMicrophoneStatsNative(IntPtr obj, IntPtr localMicrophoneStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalMicrophoneStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreelocalMicrophoneStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalMonitorStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlocalMonitorStatsNative(IntPtr obj, IntPtr localMonitorStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalMonitorStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreelocalMonitorStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalRendererStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlocalRendererStatsNative(IntPtr obj, IntPtr localRendererStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalRendererStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreelocalRendererStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalSpeakerStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlocalSpeakerStatsNative(IntPtr obj, IntPtr localSpeakerStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalSpeakerStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreelocalSpeakerStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalWindowShareStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlocalWindowShareStatsNative(IntPtr obj, IntPtr localWindowShareStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlocalWindowShareStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreelocalWindowShareStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetlogStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetlogStatsNative(IntPtr obj, IntPtr logStats);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetloginTimeConsumedMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetloginTimeConsumedMsNative(IntPtr obj, ulong loginTimeConsumedMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetmaxBitRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetmaxBitRateNative(IntPtr obj, ulong maxBitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetmaxEncodePixelRateInitialNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetmaxEncodePixelRateInitialNative(IntPtr obj, ulong maxEncodePixelRateInitial);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetmediaEnableTimeConsumedMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetmediaEnableTimeConsumedMsNative(IntPtr obj, ulong mediaEnableTimeConsumedMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetmediaRouteAcquireTimeConsumedMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetmediaRouteAcquireTimeConsumedMsNative(IntPtr obj, ulong mediaRouteAcquireTimeConsumedMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetnetworkInterfaceStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetnetworkInterfaceStatsNative(IntPtr obj, IntPtr networkInterfaceStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetnetworkInterfaceStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreenetworkInterfaceStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetosNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetosNameNative(IntPtr obj, IntPtr osName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetosVersionNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetosVersionNative(IntPtr obj, IntPtr osVersion);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetprocessorBrandNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetprocessorBrandNative(IntPtr obj, IntPtr processorBrand);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoEndpointStatsGetprocessorLogicalCoresNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetprocessorLogicalCoresNative(IntPtr obj, uint processorLogicalCores);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetprocessorModelNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetprocessorModelNative(IntPtr obj, IntPtr processorModel);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoEndpointStatsGetprocessorPhysicalCoresNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetprocessorPhysicalCoresNative(IntPtr obj, uint processorPhysicalCores);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoEndpointStatsGetprocessorSpeedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetprocessorSpeedNative(IntPtr obj, uint processorSpeed);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoEndpointStatsGetroomEnterTimeConsumedMsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetroomEnterTimeConsumedMsNative(IntPtr obj, ulong roomEnterTimeConsumedMs);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGettimeStampNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSettimeStampNative(IntPtr obj, IntPtr timeStamp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetuserStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetuserStatsNative(IntPtr obj, IntPtr userStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetuserStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreeuserStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetvirtualAudioSourceStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetvirtualAudioSourceStatsNative(IntPtr obj, IntPtr virtualAudioSourceStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetvirtualAudioSourceStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreevirtualAudioSourceStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetvirtualVideoSourceStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsSetvirtualVideoSourceStatsNative(IntPtr obj, IntPtr virtualVideoSourceStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoEndpointStatsGetvirtualVideoSourceStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoEndpointStatsFreevirtualVideoSourceStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoEndpointStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoEndpointStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoEndpointStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Application name which is set by application through SetProductInfo. Unless set, it remains empty.
		/// </summary>
		public String applicationName;
		/// <summary>
		/// Tag set by the application using public API. Unless set, it remains empty.
		/// </summary>
		public String applicationTag;
		/// <summary>
		/// Application version which is set by application through SetProductInfo. Unless set, it remains empty.
		/// </summary>
		public String applicationVersion;
		/// <summary>
		/// Tag from the build system.
		/// </summary>
		public String buildTag;
		/// <summary>
		/// Total number of bytes received over TCP.
		/// </summary>
		public ulong bytesReceivedTcp;
		/// <summary>
		/// Total number of bytes received over UDP.
		/// </summary>
		public ulong bytesReceivedUdp;
		/// <summary>
		/// Total number of bytes sent over TCP.
		/// </summary>
		public ulong bytesSentTcp;
		/// <summary>
		/// Total number of bytes sent over UDP.
		/// </summary>
		public ulong bytesSentUdp;
		/// <summary>
		/// Gregorian Time stamp when user calls the Connect API.
		/// </summary>
		public String connectTime;
		/// <summary>
		/// Endpoint ID.
		/// </summary>
		public String id;
		/// <summary>
		/// Version of the library.
		/// </summary>
		public String libraryVersion;
		/// <summary>
		/// Vector of stats of cameras.
		/// </summary>
		public List<LocalVideoSourceStats> localCameraStats;
		/// <summary>
		/// Vector of stats of microphones.
		/// </summary>
		public List<LocalMicrophoneStats> localMicrophoneStats;
		/// <summary>
		/// Vector of stats of monitors.
		/// </summary>
		public List<LocalVideoSourceStats> localMonitorStats;
		/// <summary>
		/// Vector of stats of renderers.
		/// </summary>
		public List<LocalRendererStats> localRendererStats;
		/// <summary>
		/// Vector of stats of speakers.
		/// </summary>
		public List<LocalSpeakerStats> localSpeakerStats;
		/// <summary>
		/// Vector of stats of window shares.
		/// </summary>
		public List<LocalVideoSourceStats> localWindowShareStats;
		/// <summary>
		/// Stats of the log.
		/// </summary>
		public LogStats logStats;
		/// <summary>
		/// Time taken up to login Complete callback.
		/// </summary>
		public ulong loginTimeConsumedMs;
		/// <summary>
		/// Max send bit rate for all srouces.
		/// </summary>
		public ulong maxBitRate;
		/// <summary>
		/// Calculated according to CPU profile, CPU cores etc. Remains same through-out the call for stats perspective.
		/// </summary>
		public ulong maxEncodePixelRateInitial;
		/// <summary>
		/// Time between media enable request and media route acquired.
		/// </summary>
		public ulong mediaEnableTimeConsumedMs;
		/// <summary>
		/// Time between room entered callback and media route acquired callback.
		/// </summary>
		public ulong mediaRouteAcquireTimeConsumedMs;
		/// <summary>
		/// Network interfaces on the endpoint.
		/// </summary>
		public List<NetworkInterfaceStats> networkInterfaceStats;
		/// <summary>
		/// Name of the operating system.
		/// </summary>
		public String osName;
		/// <summary>
		/// Version of the operating system.
		/// </summary>
		public String osVersion;
		/// <summary>
		/// CPU brand.
		/// </summary>
		public String processorBrand;
		/// <summary>
		/// Number of logical cores in the CPU (including hyperthreading).
		/// </summary>
		public uint processorLogicalCores;
		/// <summary>
		/// CPU Model.
		/// </summary>
		public String processorModel;
		/// <summary>
		/// Number of physical cores in the CPU (ignoring hyperthreading).
		/// </summary>
		public uint processorPhysicalCores;
		/// <summary>
		/// CPU frequency, in MHz.
		/// </summary>
		public uint processorSpeed;
		/// <summary>
		/// Number of milliseconds consumed in room entering process.
		/// </summary>
		public ulong roomEnterTimeConsumedMs;
		/// <summary>
		/// Gregorian Timestamp when the stats were measured.
		/// </summary>
		public String timeStamp;
		/// <summary>
		/// Vector of stats of users.
		/// </summary>
		public List<UserStats> userStats;
		/// <summary>
		/// Vector of stats of the virtual microphones.
		/// </summary>
		public List<LocalMicrophoneStats> virtualAudioSourceStats;
		/// <summary>
		/// Vector of stats of virtual window shares.
		/// </summary>
		public List<LocalVideoSourceStats> virtualVideoSourceStats;
		public EndpointStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoEndpointStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoEndpointStatsConstructCopyNative(obj);
			}

			List<LocalVideoSourceStats> csLocalCameraStats = new List<LocalVideoSourceStats>();
			var nLocalCameraStatsSize = 0;
			var nLocalCameraStats = VidyoEndpointStatsGetlocalCameraStatsArrayNative(VidyoEndpointStatsGetlocalCameraStatsNative(objPtr), ref nLocalCameraStatsSize);
			var nLocalCameraStatsIndex = 0;
			while (nLocalCameraStatsIndex < nLocalCameraStatsSize) {
				LocalVideoSourceStats csTlocalCameraStats = new LocalVideoSourceStats(Marshal.ReadIntPtr(nLocalCameraStats + (nLocalCameraStatsIndex * Marshal.SizeOf(nLocalCameraStats))));
				csLocalCameraStats.Add(csTlocalCameraStats);
				nLocalCameraStatsIndex++;
			}

			List<LocalMicrophoneStats> csLocalMicrophoneStats = new List<LocalMicrophoneStats>();
			var nLocalMicrophoneStatsSize = 0;
			var nLocalMicrophoneStats = VidyoEndpointStatsGetlocalMicrophoneStatsArrayNative(VidyoEndpointStatsGetlocalMicrophoneStatsNative(objPtr), ref nLocalMicrophoneStatsSize);
			var nLocalMicrophoneStatsIndex = 0;
			while (nLocalMicrophoneStatsIndex < nLocalMicrophoneStatsSize) {
				LocalMicrophoneStats csTlocalMicrophoneStats = new LocalMicrophoneStats(Marshal.ReadIntPtr(nLocalMicrophoneStats + (nLocalMicrophoneStatsIndex * Marshal.SizeOf(nLocalMicrophoneStats))));
				csLocalMicrophoneStats.Add(csTlocalMicrophoneStats);
				nLocalMicrophoneStatsIndex++;
			}

			List<LocalVideoSourceStats> csLocalMonitorStats = new List<LocalVideoSourceStats>();
			var nLocalMonitorStatsSize = 0;
			var nLocalMonitorStats = VidyoEndpointStatsGetlocalMonitorStatsArrayNative(VidyoEndpointStatsGetlocalMonitorStatsNative(objPtr), ref nLocalMonitorStatsSize);
			var nLocalMonitorStatsIndex = 0;
			while (nLocalMonitorStatsIndex < nLocalMonitorStatsSize) {
				LocalVideoSourceStats csTlocalMonitorStats = new LocalVideoSourceStats(Marshal.ReadIntPtr(nLocalMonitorStats + (nLocalMonitorStatsIndex * Marshal.SizeOf(nLocalMonitorStats))));
				csLocalMonitorStats.Add(csTlocalMonitorStats);
				nLocalMonitorStatsIndex++;
			}

			List<LocalRendererStats> csLocalRendererStats = new List<LocalRendererStats>();
			var nLocalRendererStatsSize = 0;
			var nLocalRendererStats = VidyoEndpointStatsGetlocalRendererStatsArrayNative(VidyoEndpointStatsGetlocalRendererStatsNative(objPtr), ref nLocalRendererStatsSize);
			var nLocalRendererStatsIndex = 0;
			while (nLocalRendererStatsIndex < nLocalRendererStatsSize) {
				LocalRendererStats csTlocalRendererStats = new LocalRendererStats(Marshal.ReadIntPtr(nLocalRendererStats + (nLocalRendererStatsIndex * Marshal.SizeOf(nLocalRendererStats))));
				csLocalRendererStats.Add(csTlocalRendererStats);
				nLocalRendererStatsIndex++;
			}

			List<LocalSpeakerStats> csLocalSpeakerStats = new List<LocalSpeakerStats>();
			var nLocalSpeakerStatsSize = 0;
			var nLocalSpeakerStats = VidyoEndpointStatsGetlocalSpeakerStatsArrayNative(VidyoEndpointStatsGetlocalSpeakerStatsNative(objPtr), ref nLocalSpeakerStatsSize);
			var nLocalSpeakerStatsIndex = 0;
			while (nLocalSpeakerStatsIndex < nLocalSpeakerStatsSize) {
				LocalSpeakerStats csTlocalSpeakerStats = new LocalSpeakerStats(Marshal.ReadIntPtr(nLocalSpeakerStats + (nLocalSpeakerStatsIndex * Marshal.SizeOf(nLocalSpeakerStats))));
				csLocalSpeakerStats.Add(csTlocalSpeakerStats);
				nLocalSpeakerStatsIndex++;
			}

			List<LocalVideoSourceStats> csLocalWindowShareStats = new List<LocalVideoSourceStats>();
			var nLocalWindowShareStatsSize = 0;
			var nLocalWindowShareStats = VidyoEndpointStatsGetlocalWindowShareStatsArrayNative(VidyoEndpointStatsGetlocalWindowShareStatsNative(objPtr), ref nLocalWindowShareStatsSize);
			var nLocalWindowShareStatsIndex = 0;
			while (nLocalWindowShareStatsIndex < nLocalWindowShareStatsSize) {
				LocalVideoSourceStats csTlocalWindowShareStats = new LocalVideoSourceStats(Marshal.ReadIntPtr(nLocalWindowShareStats + (nLocalWindowShareStatsIndex * Marshal.SizeOf(nLocalWindowShareStats))));
				csLocalWindowShareStats.Add(csTlocalWindowShareStats);
				nLocalWindowShareStatsIndex++;
			}

			LogStats csLogStats = new LogStats(VidyoEndpointStatsGetlogStatsNative(objPtr));
			List<NetworkInterfaceStats> csNetworkInterfaceStats = new List<NetworkInterfaceStats>();
			var nNetworkInterfaceStatsSize = 0;
			var nNetworkInterfaceStats = VidyoEndpointStatsGetnetworkInterfaceStatsArrayNative(VidyoEndpointStatsGetnetworkInterfaceStatsNative(objPtr), ref nNetworkInterfaceStatsSize);
			var nNetworkInterfaceStatsIndex = 0;
			while (nNetworkInterfaceStatsIndex < nNetworkInterfaceStatsSize) {
				NetworkInterfaceStats csTnetworkInterfaceStats = new NetworkInterfaceStats(Marshal.ReadIntPtr(nNetworkInterfaceStats + (nNetworkInterfaceStatsIndex * Marshal.SizeOf(nNetworkInterfaceStats))));
				csNetworkInterfaceStats.Add(csTnetworkInterfaceStats);
				nNetworkInterfaceStatsIndex++;
			}

			List<UserStats> csUserStats = new List<UserStats>();
			var nUserStatsSize = 0;
			var nUserStats = VidyoEndpointStatsGetuserStatsArrayNative(VidyoEndpointStatsGetuserStatsNative(objPtr), ref nUserStatsSize);
			var nUserStatsIndex = 0;
			while (nUserStatsIndex < nUserStatsSize) {
				UserStats csTuserStats = new UserStats(Marshal.ReadIntPtr(nUserStats + (nUserStatsIndex * Marshal.SizeOf(nUserStats))));
				csUserStats.Add(csTuserStats);
				nUserStatsIndex++;
			}

			List<LocalMicrophoneStats> csVirtualAudioSourceStats = new List<LocalMicrophoneStats>();
			var nVirtualAudioSourceStatsSize = 0;
			var nVirtualAudioSourceStats = VidyoEndpointStatsGetvirtualAudioSourceStatsArrayNative(VidyoEndpointStatsGetvirtualAudioSourceStatsNative(objPtr), ref nVirtualAudioSourceStatsSize);
			var nVirtualAudioSourceStatsIndex = 0;
			while (nVirtualAudioSourceStatsIndex < nVirtualAudioSourceStatsSize) {
				LocalMicrophoneStats csTvirtualAudioSourceStats = new LocalMicrophoneStats(Marshal.ReadIntPtr(nVirtualAudioSourceStats + (nVirtualAudioSourceStatsIndex * Marshal.SizeOf(nVirtualAudioSourceStats))));
				csVirtualAudioSourceStats.Add(csTvirtualAudioSourceStats);
				nVirtualAudioSourceStatsIndex++;
			}

			List<LocalVideoSourceStats> csVirtualVideoSourceStats = new List<LocalVideoSourceStats>();
			var nVirtualVideoSourceStatsSize = 0;
			var nVirtualVideoSourceStats = VidyoEndpointStatsGetvirtualVideoSourceStatsArrayNative(VidyoEndpointStatsGetvirtualVideoSourceStatsNative(objPtr), ref nVirtualVideoSourceStatsSize);
			var nVirtualVideoSourceStatsIndex = 0;
			while (nVirtualVideoSourceStatsIndex < nVirtualVideoSourceStatsSize) {
				LocalVideoSourceStats csTvirtualVideoSourceStats = new LocalVideoSourceStats(Marshal.ReadIntPtr(nVirtualVideoSourceStats + (nVirtualVideoSourceStatsIndex * Marshal.SizeOf(nVirtualVideoSourceStats))));
				csVirtualVideoSourceStats.Add(csTvirtualVideoSourceStats);
				nVirtualVideoSourceStatsIndex++;
			}

			applicationName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetapplicationNameNative(objPtr));
			applicationTag = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetapplicationTagNative(objPtr));
			applicationVersion = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetapplicationVersionNative(objPtr));
			buildTag = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetbuildTagNative(objPtr));
			bytesReceivedTcp = VidyoEndpointStatsGetbytesReceivedTcpNative(objPtr);
			bytesReceivedUdp = VidyoEndpointStatsGetbytesReceivedUdpNative(objPtr);
			bytesSentTcp = VidyoEndpointStatsGetbytesSentTcpNative(objPtr);
			bytesSentUdp = VidyoEndpointStatsGetbytesSentUdpNative(objPtr);
			connectTime = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetconnectTimeNative(objPtr));
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetidNative(objPtr));
			libraryVersion = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetlibraryVersionNative(objPtr));
			localCameraStats = csLocalCameraStats;
			localMicrophoneStats = csLocalMicrophoneStats;
			localMonitorStats = csLocalMonitorStats;
			localRendererStats = csLocalRendererStats;
			localSpeakerStats = csLocalSpeakerStats;
			localWindowShareStats = csLocalWindowShareStats;
			logStats = csLogStats;
			loginTimeConsumedMs = VidyoEndpointStatsGetloginTimeConsumedMsNative(objPtr);
			maxBitRate = VidyoEndpointStatsGetmaxBitRateNative(objPtr);
			maxEncodePixelRateInitial = VidyoEndpointStatsGetmaxEncodePixelRateInitialNative(objPtr);
			mediaEnableTimeConsumedMs = VidyoEndpointStatsGetmediaEnableTimeConsumedMsNative(objPtr);
			mediaRouteAcquireTimeConsumedMs = VidyoEndpointStatsGetmediaRouteAcquireTimeConsumedMsNative(objPtr);
			networkInterfaceStats = csNetworkInterfaceStats;
			osName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetosNameNative(objPtr));
			osVersion = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetosVersionNative(objPtr));
			processorBrand = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetprocessorBrandNative(objPtr));
			processorLogicalCores = VidyoEndpointStatsGetprocessorLogicalCoresNative(objPtr);
			processorModel = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGetprocessorModelNative(objPtr));
			processorPhysicalCores = VidyoEndpointStatsGetprocessorPhysicalCoresNative(objPtr);
			processorSpeed = VidyoEndpointStatsGetprocessorSpeedNative(objPtr);
			roomEnterTimeConsumedMs = VidyoEndpointStatsGetroomEnterTimeConsumedMsNative(objPtr);
			timeStamp = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoEndpointStatsGettimeStampNative(objPtr));
			userStats = csUserStats;
			virtualAudioSourceStats = csVirtualAudioSourceStats;
			virtualVideoSourceStats = csVirtualVideoSourceStats;
			VidyoEndpointStatsFreevirtualVideoSourceStatsArrayNative(nVirtualVideoSourceStats, nVirtualVideoSourceStatsSize);
			VidyoEndpointStatsFreevirtualAudioSourceStatsArrayNative(nVirtualAudioSourceStats, nVirtualAudioSourceStatsSize);
			VidyoEndpointStatsFreeuserStatsArrayNative(nUserStats, nUserStatsSize);
			VidyoEndpointStatsFreenetworkInterfaceStatsArrayNative(nNetworkInterfaceStats, nNetworkInterfaceStatsSize);
			VidyoEndpointStatsFreelocalWindowShareStatsArrayNative(nLocalWindowShareStats, nLocalWindowShareStatsSize);
			VidyoEndpointStatsFreelocalSpeakerStatsArrayNative(nLocalSpeakerStats, nLocalSpeakerStatsSize);
			VidyoEndpointStatsFreelocalRendererStatsArrayNative(nLocalRendererStats, nLocalRendererStatsSize);
			VidyoEndpointStatsFreelocalMonitorStatsArrayNative(nLocalMonitorStats, nLocalMonitorStatsSize);
			VidyoEndpointStatsFreelocalMicrophoneStatsArrayNative(nLocalMicrophoneStats, nLocalMicrophoneStatsSize);
			VidyoEndpointStatsFreelocalCameraStatsArrayNative(nLocalCameraStats, nLocalCameraStatsSize);
		}
		~EndpointStats() {
			VidyoEndpointStatsDestructNative(objPtr);
		 }
	};
}
