// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class ParticipantStatsFactory
	{
		public static ParticipantStats Create()
		{
			return new ParticipantStats(IntPtr.Zero);
		}
		public static void Destroy(ParticipantStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a room.
	/// </summary>
	public class ParticipantStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoParticipantStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nRemoteCameraStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * remoteCameraStats.Count);
			int nRemoteCameraStatsSize = 0;
			IntPtr nRemoteMicrophoneStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * remoteMicrophoneStats.Count);
			int nRemoteMicrophoneStatsSize = 0;
			IntPtr nRemoteWindowShareStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * remoteWindowShareStats.Count);
			int nRemoteWindowShareStatsSize = 0;
			IntPtr nScipId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(scipId ?? string.Empty);
			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);

			foreach (RemoteVideoSourceStats iter in remoteCameraStats) {
				Marshal.WriteIntPtr(nRemoteCameraStats + (nRemoteCameraStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nRemoteCameraStatsSize++;
			}
			foreach (RemoteMicrophoneStats iter in remoteMicrophoneStats) {
				Marshal.WriteIntPtr(nRemoteMicrophoneStats + (nRemoteMicrophoneStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nRemoteMicrophoneStatsSize++;
			}
			foreach (RemoteVideoSourceStats iter in remoteWindowShareStats) {
				Marshal.WriteIntPtr(nRemoteWindowShareStats + (nRemoteWindowShareStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nRemoteWindowShareStatsSize++;
			}

			VidyoParticipantStatsSetidNative(objPtr, nId);
			VidyoParticipantStatsSetnameNative(objPtr, nName);
			VidyoParticipantStatsSetremoteCameraStatsNative(objPtr, nRemoteCameraStats, nRemoteCameraStatsSize);
			VidyoParticipantStatsSetremoteMicrophoneStatsNative(objPtr, nRemoteMicrophoneStats, nRemoteMicrophoneStatsSize);
			VidyoParticipantStatsSetremoteWindowShareStatsNative(objPtr, nRemoteWindowShareStats, nRemoteWindowShareStatsSize);
			VidyoParticipantStatsSetscipIdNative(objPtr, nScipId);
			VidyoParticipantStatsSetuserIdNative(objPtr, nUserId);

			Marshal.FreeHGlobal(nUserId);
			Marshal.FreeHGlobal(nScipId);
			Marshal.FreeHGlobal(nRemoteWindowShareStats);
			Marshal.FreeHGlobal(nRemoteMicrophoneStats);
			Marshal.FreeHGlobal(nRemoteCameraStats);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetremoteCameraStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsSetremoteCameraStatsNative(IntPtr obj, IntPtr remoteCameraStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetremoteCameraStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsFreeremoteCameraStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetremoteMicrophoneStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsSetremoteMicrophoneStatsNative(IntPtr obj, IntPtr remoteMicrophoneStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetremoteMicrophoneStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsFreeremoteMicrophoneStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetremoteWindowShareStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsSetremoteWindowShareStatsNative(IntPtr obj, IntPtr remoteWindowShareStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetremoteWindowShareStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsFreeremoteWindowShareStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetscipIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsSetscipIdNative(IntPtr obj, IntPtr scipId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoParticipantStatsGetuserIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoParticipantStatsSetuserIdNative(IntPtr obj, IntPtr userId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoParticipantStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoParticipantStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoParticipantStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Participant ID.
		/// </summary>
		public String id;
		/// <summary>
		/// Current CPU usage.
		/// </summary>
		public String name;
		/// <summary>
		/// Vector of stats of cameras.
		/// </summary>
		public List<RemoteVideoSourceStats> remoteCameraStats;
		/// <summary>
		/// Vector of stats of microphones.
		/// </summary>
		public List<RemoteMicrophoneStats> remoteMicrophoneStats;
		/// <summary>
		/// Vector of stats of speakers.
		/// </summary>
		public List<RemoteVideoSourceStats> remoteWindowShareStats;
		/// <summary>
		/// SCIP ID unique to the room or call only.
		/// </summary>
		public String scipId;
		/// <summary>
		/// ID assosicated with the VidyoUser of that participant.
		/// </summary>
		public String userId;
		public ParticipantStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoParticipantStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoParticipantStatsConstructCopyNative(obj);
			}

			List<RemoteVideoSourceStats> csRemoteCameraStats = new List<RemoteVideoSourceStats>();
			var nRemoteCameraStatsSize = 0;
			var nRemoteCameraStats = VidyoParticipantStatsGetremoteCameraStatsArrayNative(VidyoParticipantStatsGetremoteCameraStatsNative(objPtr), ref nRemoteCameraStatsSize);
			var nRemoteCameraStatsIndex = 0;
			while (nRemoteCameraStatsIndex < nRemoteCameraStatsSize) {
				RemoteVideoSourceStats csTremoteCameraStats = new RemoteVideoSourceStats(Marshal.ReadIntPtr(nRemoteCameraStats + (nRemoteCameraStatsIndex * Marshal.SizeOf(nRemoteCameraStats))));
				csRemoteCameraStats.Add(csTremoteCameraStats);
				nRemoteCameraStatsIndex++;
			}

			List<RemoteMicrophoneStats> csRemoteMicrophoneStats = new List<RemoteMicrophoneStats>();
			var nRemoteMicrophoneStatsSize = 0;
			var nRemoteMicrophoneStats = VidyoParticipantStatsGetremoteMicrophoneStatsArrayNative(VidyoParticipantStatsGetremoteMicrophoneStatsNative(objPtr), ref nRemoteMicrophoneStatsSize);
			var nRemoteMicrophoneStatsIndex = 0;
			while (nRemoteMicrophoneStatsIndex < nRemoteMicrophoneStatsSize) {
				RemoteMicrophoneStats csTremoteMicrophoneStats = new RemoteMicrophoneStats(Marshal.ReadIntPtr(nRemoteMicrophoneStats + (nRemoteMicrophoneStatsIndex * Marshal.SizeOf(nRemoteMicrophoneStats))));
				csRemoteMicrophoneStats.Add(csTremoteMicrophoneStats);
				nRemoteMicrophoneStatsIndex++;
			}

			List<RemoteVideoSourceStats> csRemoteWindowShareStats = new List<RemoteVideoSourceStats>();
			var nRemoteWindowShareStatsSize = 0;
			var nRemoteWindowShareStats = VidyoParticipantStatsGetremoteWindowShareStatsArrayNative(VidyoParticipantStatsGetremoteWindowShareStatsNative(objPtr), ref nRemoteWindowShareStatsSize);
			var nRemoteWindowShareStatsIndex = 0;
			while (nRemoteWindowShareStatsIndex < nRemoteWindowShareStatsSize) {
				RemoteVideoSourceStats csTremoteWindowShareStats = new RemoteVideoSourceStats(Marshal.ReadIntPtr(nRemoteWindowShareStats + (nRemoteWindowShareStatsIndex * Marshal.SizeOf(nRemoteWindowShareStats))));
				csRemoteWindowShareStats.Add(csTremoteWindowShareStats);
				nRemoteWindowShareStatsIndex++;
			}

			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantStatsGetidNative(objPtr));
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantStatsGetnameNative(objPtr));
			remoteCameraStats = csRemoteCameraStats;
			remoteMicrophoneStats = csRemoteMicrophoneStats;
			remoteWindowShareStats = csRemoteWindowShareStats;
			scipId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantStatsGetscipIdNative(objPtr));
			userId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoParticipantStatsGetuserIdNative(objPtr));
			VidyoParticipantStatsFreeremoteWindowShareStatsArrayNative(nRemoteWindowShareStats, nRemoteWindowShareStatsSize);
			VidyoParticipantStatsFreeremoteMicrophoneStatsArrayNative(nRemoteMicrophoneStats, nRemoteMicrophoneStatsSize);
			VidyoParticipantStatsFreeremoteCameraStatsArrayNative(nRemoteCameraStats, nRemoteCameraStatsSize);
		}
		~ParticipantStats() {
			VidyoParticipantStatsDestructNative(objPtr);
		 }
	};
}
