// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class RemoteSpeakerStreamStatsFactory
	{
		public static RemoteSpeakerStreamStats Create()
		{
			return new RemoteSpeakerStreamStats(IntPtr.Zero);
		}
		public static void Destroy(RemoteSpeakerStreamStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a remote speaker.
	/// </summary>
	public class RemoteSpeakerStreamStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRemoteSpeakerStreamStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nCodecName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(codecName ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoRemoteSpeakerStreamStatsSetbitsPerSampleNative(objPtr, bitsPerSample);
			VidyoRemoteSpeakerStreamStatsSetcodecDtxNative(objPtr, codecDtx);
			VidyoRemoteSpeakerStreamStatsSetcodecNameNative(objPtr, nCodecName);
			VidyoRemoteSpeakerStreamStatsSetcodecQualitySettingNative(objPtr, codecQualitySetting);
			VidyoRemoteSpeakerStreamStatsSetnameNative(objPtr, nName);
			VidyoRemoteSpeakerStreamStatsSetnumberOfChannelsNative(objPtr, numberOfChannels);
			VidyoRemoteSpeakerStreamStatsSetsampleRateNative(objPtr, sampleRate);
			VidyoRemoteSpeakerStreamStatsSetsendNetworkBitRateNative(objPtr, sendNetworkBitRate);
			VidyoRemoteSpeakerStreamStatsSetsendNetworkRttNative(objPtr, sendNetworkRtt);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nCodecName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteSpeakerStreamStatsGetbitsPerSampleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetbitsPerSampleNative(IntPtr obj, uint bitsPerSample);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteSpeakerStreamStatsGetcodecDtxNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetcodecDtxNative(IntPtr obj, uint codecDtx);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteSpeakerStreamStatsGetcodecNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetcodecNameNative(IntPtr obj, IntPtr codecName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteSpeakerStreamStatsGetcodecQualitySettingNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetcodecQualitySettingNative(IntPtr obj, uint codecQualitySetting);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteSpeakerStreamStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteSpeakerStreamStatsGetnumberOfChannelsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetnumberOfChannelsNative(IntPtr obj, uint numberOfChannels);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteSpeakerStreamStatsGetsampleRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetsampleRateNative(IntPtr obj, uint sampleRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteSpeakerStreamStatsGetsendNetworkBitRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetsendNetworkBitRateNative(IntPtr obj, uint sendNetworkBitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRemoteSpeakerStreamStatsGetsendNetworkRttNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteSpeakerStreamStatsSetsendNetworkRttNative(IntPtr obj, ulong sendNetworkRtt);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteSpeakerStreamStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteSpeakerStreamStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRemoteSpeakerStreamStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Bits per sample.
		/// </summary>
		public uint bitsPerSample;
		/// <summary>
		/// Codec DTX.
		/// </summary>
		public uint codecDtx;
		/// <summary>
		/// Codec name.
		/// </summary>
		public String codecName;
		/// <summary>
		/// Codec quality setting.
		/// </summary>
		public uint codecQualitySetting;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Number of channels.
		/// </summary>
		public uint numberOfChannels;
		/// <summary>
		/// Sample rate.
		/// </summary>
		public uint sampleRate;
		/// <summary>
		/// Send bitrate.
		/// </summary>
		public uint sendNetworkBitRate;
		/// <summary>
		/// Round trip time of send network.
		/// </summary>
		public ulong sendNetworkRtt;
		public RemoteSpeakerStreamStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoRemoteSpeakerStreamStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoRemoteSpeakerStreamStatsConstructCopyNative(obj);
			}

			bitsPerSample = VidyoRemoteSpeakerStreamStatsGetbitsPerSampleNative(objPtr);
			codecDtx = VidyoRemoteSpeakerStreamStatsGetcodecDtxNative(objPtr);
			codecName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteSpeakerStreamStatsGetcodecNameNative(objPtr));
			codecQualitySetting = VidyoRemoteSpeakerStreamStatsGetcodecQualitySettingNative(objPtr);
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteSpeakerStreamStatsGetnameNative(objPtr));
			numberOfChannels = VidyoRemoteSpeakerStreamStatsGetnumberOfChannelsNative(objPtr);
			sampleRate = VidyoRemoteSpeakerStreamStatsGetsampleRateNative(objPtr);
			sendNetworkBitRate = VidyoRemoteSpeakerStreamStatsGetsendNetworkBitRateNative(objPtr);
			sendNetworkRtt = VidyoRemoteSpeakerStreamStatsGetsendNetworkRttNative(objPtr);
		}
		~RemoteSpeakerStreamStats() {
			VidyoRemoteSpeakerStreamStatsDestructNative(objPtr);
		 }
	};
}
