// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class VideoCapabilityFactory
	{
		public static VideoCapability Create()
		{
			return new VideoCapability(IntPtr.Zero);
		}
		public static void Destroy(VideoCapability obj)
		{
		}
	}
	/// <summary>
	/// Represents the capability of a Video Source.
	/// </summary>
	public class VideoCapability {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoVideoCapability reference.
		public IntPtr GetObjectPtr() {
			IntPtr nRanges = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * ranges.Count);
			int nRangesSize = 0;

			foreach (VideoFrameIntervalRange iter in ranges) {
				Marshal.WriteIntPtr(nRanges + (nRangesSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nRangesSize++;
			}

			VidyoVideoCapabilitySetheightNative(objPtr, height);
			VidyoVideoCapabilitySetrangesNative(objPtr, nRanges, nRangesSize);
			VidyoVideoCapabilitySetwidthNative(objPtr, width);

			Marshal.FreeHGlobal(nRanges);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoVideoCapabilityGetheightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoCapabilitySetheightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVideoCapabilityGetrangesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoCapabilitySetrangesNative(IntPtr obj, IntPtr ranges, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoVideoCapabilityGetrangesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoCapabilityFreerangesArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoVideoCapabilityGetwidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoVideoCapabilitySetwidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoVideoCapabilityConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoVideoCapabilityConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoVideoCapabilityDestructNative(IntPtr obj);

		public class VideoFrameIntervalRangeFactory
		{
			public static VideoFrameIntervalRange Create()
			{
				return new VideoFrameIntervalRange(IntPtr.Zero);
			}
			public static void Destroy(VideoFrameIntervalRange obj)
			{
			}
		}
		/// <summary>
		/// Represents frame interval range and media formats supported by that range.
		/// </summary>
		public class VideoFrameIntervalRange {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoVideoFrameIntervalRange reference.
			public IntPtr GetObjectPtr() {
				IntPtr nFormats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * formats.Count);
				int nFormatsSize = 0;

				foreach (MediaFormat iter in formats) {
					Marshal.WriteInt32(nFormats + (nFormatsSize * Marshal.SizeOf<Int32>()), (int)iter);
					nFormatsSize++;
				}

				VidyoVideoFrameIntervalRangeSetformatsNative(objPtr, nFormats, nFormatsSize);
				VidyoVideoFrameIntervalRangeSetrangeNative(objPtr, range.GetObjectPtr());
				VidyoVideoFrameIntervalRangeSetstepNative(objPtr, step);

				Marshal.FreeHGlobal(nFormats);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoVideoFrameIntervalRangeGetformatsNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoVideoFrameIntervalRangeSetformatsNative(IntPtr obj, IntPtr formats, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoVideoFrameIntervalRangeGetformatsArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoVideoFrameIntervalRangeFreeformatsArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoVideoFrameIntervalRangeGetrangeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoVideoFrameIntervalRangeSetrangeNative(IntPtr obj, IntPtr range);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern ulong VidyoVideoFrameIntervalRangeGetstepNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoVideoFrameIntervalRangeSetstepNative(IntPtr obj, ulong step);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoVideoFrameIntervalRangeConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoVideoFrameIntervalRangeConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoVideoFrameIntervalRangeDestructNative(IntPtr obj);

			public class TimeRangeFactory
			{
				public static TimeRange Create()
				{
					return new TimeRange(IntPtr.Zero);
				}
				public static void Destroy(TimeRange obj)
				{
				}
			}
			/// <summary>
			/// A time range class used to represent a range of time intervals.
			/// </summary>
			public class TimeRange {
#if __IOS__
				const string importLib = "__Internal";
#else
				const string importLib = "libVidyoClient";
#endif
				private IntPtr objPtr; // opaque VidyoTimeRange reference.
				public IntPtr GetObjectPtr() {

					VidyoTimeRangeSetbeginNative(objPtr, begin);
					VidyoTimeRangeSetendNative(objPtr, end);

					return objPtr;
				}
				[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
				private static extern ulong VidyoTimeRangeGetbeginNative(IntPtr obj);

				[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
				private static extern void VidyoTimeRangeSetbeginNative(IntPtr obj, ulong begin);

				[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
				private static extern ulong VidyoTimeRangeGetendNative(IntPtr obj);

				[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
				private static extern void VidyoTimeRangeSetendNative(IntPtr obj, ulong end);

				[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
				public static extern IntPtr VidyoTimeRangeConstructCopyNative(IntPtr obj);

				[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
				public static extern IntPtr VidyoTimeRangeConstructDefaultNative();

				[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
				public static extern void VidyoTimeRangeDestructNative(IntPtr obj);

				/// <summary>
				/// The first time interval of the range.
				/// </summary>
				public ulong begin;
				/// <summary>
				/// The last time interval of the range.
				/// </summary>
				public ulong end;
				public TimeRange(IntPtr obj){
					if(obj == IntPtr.Zero) {
						objPtr = VidyoTimeRangeConstructDefaultNative();
					}
					else {
						objPtr = VidyoTimeRangeConstructCopyNative(obj);
					}

					begin = VidyoTimeRangeGetbeginNative(objPtr);
					end = VidyoTimeRangeGetendNative(objPtr);
				}
				~TimeRange() {
					VidyoTimeRangeDestructNative(objPtr);
				 }
			};
			/// <summary>
			/// 
			/// </summary>
			public List<MediaFormat> formats;
			/// <summary>
			/// 
			/// </summary>
			public TimeRange range;
			/// <summary>
			/// 
			/// </summary>
			public ulong step;
			public VideoFrameIntervalRange(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoVideoFrameIntervalRangeConstructDefaultNative();
				}
				else {
					objPtr = VidyoVideoFrameIntervalRangeConstructCopyNative(obj);
				}

				List<MediaFormat> csFormats = new List<MediaFormat>();
				var nFormatsSize = 0;
				var nFormats = VidyoVideoFrameIntervalRangeGetformatsArrayNative(VidyoVideoFrameIntervalRangeGetformatsNative(objPtr), ref nFormatsSize);
				var nFormatsIndex = 0;
				while (nFormatsIndex < nFormatsSize) {
					csFormats.Add((MediaFormat)Marshal.ReadInt32(Marshal.ReadIntPtr(nFormats + (nFormatsIndex * Marshal.SizeOf(nFormats)))));
					nFormatsIndex++;
				}

				TimeRange csRange = new TimeRange(VidyoVideoFrameIntervalRangeGetrangeNative(objPtr));
				formats = csFormats;
				range = csRange;
				step = VidyoVideoFrameIntervalRangeGetstepNative(objPtr);
				VidyoVideoFrameIntervalRangeFreeformatsArrayNative(nFormats, nFormatsSize);
			}
			~VideoFrameIntervalRange() {
				VidyoVideoFrameIntervalRangeDestructNative(objPtr);
			 }
		};
		/// <summary>
		/// 
		/// </summary>
		public SizeT height;
		/// <summary>
		/// 
		/// </summary>
		public List<VideoFrameIntervalRange> ranges;
		/// <summary>
		/// 
		/// </summary>
		public SizeT width;
		public VideoCapability(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoVideoCapabilityConstructDefaultNative();
			}
			else {
				objPtr = VidyoVideoCapabilityConstructCopyNative(obj);
			}

			List<VideoFrameIntervalRange> csRanges = new List<VideoFrameIntervalRange>();
			var nRangesSize = 0;
			var nRanges = VidyoVideoCapabilityGetrangesArrayNative(VidyoVideoCapabilityGetrangesNative(objPtr), ref nRangesSize);
			var nRangesIndex = 0;
			while (nRangesIndex < nRangesSize) {
				VideoFrameIntervalRange csTranges = new VideoFrameIntervalRange(Marshal.ReadIntPtr(nRanges + (nRangesIndex * Marshal.SizeOf(nRanges))));
				csRanges.Add(csTranges);
				nRangesIndex++;
			}

			height = VidyoVideoCapabilityGetheightNative(objPtr);
			ranges = csRanges;
			width = VidyoVideoCapabilityGetwidthNative(objPtr);
			VidyoVideoCapabilityFreerangesArrayNative(nRanges, nRangesSize);
		}
		~VideoCapability() {
			VidyoVideoCapabilityDestructNative(objPtr);
		 }
	};
}
